/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public final class CodecPool {
    private static final Log LOG = LogFactory.getLog(CodecPool.class);
    private static final Map<Class<Compressor>, List<Compressor>> COMPRESSOR_POOL = new HashMap<Class<Compressor>, List<Compressor>>();
    private static final Map<Class<Decompressor>, List<Decompressor>> DECOMPRESSOR_POOL = new HashMap<Class<Decompressor>, List<Decompressor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T borrow(Map<Class<T>, List<T>> pool, Class<? extends T> codecClass) {
        T codec = null;
        Map<Class<T>, List<T>> map = pool;
        synchronized (map) {
            List<T> codecList;
            if (pool.containsKey(codecClass) && (codecList = pool.get(codecClass)) != null) {
                List<T> list = codecList;
                synchronized (list) {
                    if (!codecList.isEmpty()) {
                        codec = codecList.remove(codecList.size() - 1);
                    }
                }
            }
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void payback(Map<Class<T>, List<T>> pool, T codec) {
        if (codec != null) {
            Class<?> codecClass = codec.getClass();
            Map<Class<T>, List<T>> map = pool;
            synchronized (map) {
                List<T> codecList;
                if (!pool.containsKey(codecClass)) {
                    pool.put(codecClass, new ArrayList());
                }
                List<T> list = codecList = pool.get(codecClass);
                synchronized (list) {
                    codecList.add(codec);
                }
            }
        }
    }

    public static Compressor getCompressor(CompressionCodec codec) {
        Compressor compressor = (Compressor)CodecPool.borrow(COMPRESSOR_POOL, codec.getCompressorType());
        if (compressor == null) {
            compressor = codec.createCompressor();
            LOG.info((Object)"Got brand-new compressor");
        } else {
            LOG.debug((Object)"Got recycled compressor");
        }
        return compressor;
    }

    public static Decompressor getDecompressor(CompressionCodec codec) {
        Decompressor decompressor = (Decompressor)CodecPool.borrow(DECOMPRESSOR_POOL, codec.getDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createDecompressor();
            LOG.info((Object)"Got brand-new decompressor");
        } else {
            LOG.debug((Object)"Got recycled decompressor");
        }
        return decompressor;
    }

    public static void returnCompressor(Compressor compressor) {
        if (compressor == null) {
            return;
        }
        compressor.reset();
        CodecPool.payback(COMPRESSOR_POOL, compressor);
    }

    public static void returnDecompressor(Decompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        decompressor.reset();
        CodecPool.payback(DECOMPRESSOR_POOL, decompressor);
    }

    private CodecPool() {
    }
}

