/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapred.AccumuloOutputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.accumulo.AccumuloConnectionParameters;
import org.apache.hadoop.hive.accumulo.HiveAccumuloHelper;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;

public class HiveAccumuloTableOutputFormat
extends AccumuloOutputFormat {
    protected final HiveAccumuloHelper helper = new HiveAccumuloHelper();

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.configureAccumuloOutputFormat(job);
        super.checkOutputSpecs(ignored, job);
    }

    public RecordWriter<Text, Mutation> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        this.configureAccumuloOutputFormat(job);
        return super.getRecordWriter(ignored, job, name, progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void configureAccumuloOutputFormat(JobConf job) throws IOException {
        AccumuloConnectionParameters cnxnParams = new AccumuloConnectionParameters((Configuration)job);
        String tableName = job.get("accumulo.table.name");
        Preconditions.checkNotNull((Object)tableName, (Object)"Expected Accumulo table name to be provided in job configuration");
        try {
            block9: {
                block10: {
                    if (cnxnParams.useMockInstance()) {
                        this.setAccumuloMockInstance(job, cnxnParams.getAccumuloInstanceName());
                    } else {
                        this.setAccumuloZooKeeperInstance(job, cnxnParams.getAccumuloInstanceName(), cnxnParams.getZooKeepers(), cnxnParams.useSasl());
                    }
                    if (!cnxnParams.useSasl()) break block10;
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    if (!ugi.hasKerberosCredentials()) {
                        this.helper.addTokenFromUserToJobConf(ugi, job);
                        break block9;
                    } else {
                        try {
                            Connector connector = cnxnParams.getConnector();
                            AuthenticationToken token = this.helper.getDelegationToken(connector);
                            HiveAccumuloTableOutputFormat.setConnectorInfo((JobConf)job, (String)cnxnParams.getAccumuloUserName(), (AuthenticationToken)token);
                            Token<? extends TokenIdentifier> accumuloToken = this.helper.getHadoopToken(token);
                            log.info((Object)"Adding Hadoop Token for Accumulo to Job's Credentials");
                            this.helper.mergeTokenIntoJobConf(job, accumuloToken);
                            if (!ugi.addToken(accumuloToken)) {
                                throw new IOException("Failed to add Accumulo Token to UGI");
                            }
                            break block9;
                        }
                        catch (AccumuloException | AccumuloSecurityException e) {
                            throw new IOException("Failed to acquire Accumulo DelegationToken", e);
                        }
                    }
                }
                this.setAccumuloConnectorInfo(job, cnxnParams.getAccumuloUserName(), (AuthenticationToken)new PasswordToken((CharSequence)cnxnParams.getAccumuloPassword()));
            }
            this.setDefaultAccumuloTableName(job, tableName);
            return;
        }
        catch (AccumuloSecurityException e) {
            log.error((Object)"Could not connect to Accumulo with provided credentials", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected void setAccumuloConnectorInfo(JobConf conf, String username, AuthenticationToken token) throws AccumuloSecurityException {
        try {
            AccumuloOutputFormat.setConnectorInfo((JobConf)conf, (String)username, (AuthenticationToken)token);
        }
        catch (IllegalStateException e) {
            log.debug((Object)("Ignoring exception setting Accumulo Connector instance for user " + username), (Throwable)e);
        }
    }

    protected void setAccumuloZooKeeperInstance(JobConf conf, String instanceName, String zookeepers, boolean isSasl) throws IOException {
        try {
            if (isSasl) {
                this.helper.setZooKeeperInstance(conf, AccumuloOutputFormat.class, zookeepers, instanceName, isSasl);
            } else {
                AccumuloOutputFormat.setZooKeeperInstance((JobConf)conf, (String)instanceName, (String)zookeepers);
            }
        }
        catch (IllegalStateException ise) {
            log.debug((Object)("Ignoring exception setting ZooKeeper instance of " + instanceName + " at " + zookeepers), (Throwable)ise);
        }
    }

    protected void setAccumuloMockInstance(JobConf conf, String instanceName) {
        try {
            AccumuloOutputFormat.setMockInstance((JobConf)conf, (String)instanceName);
        }
        catch (IllegalStateException e) {
            log.debug((Object)("Ignoring exception setting mock instance of " + instanceName), (Throwable)e);
        }
    }

    protected void setDefaultAccumuloTableName(JobConf conf, String tableName) {
        AccumuloOutputFormat.setDefaultTableName((JobConf)conf, (String)tableName);
    }
}

