/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public interface HadoopShims {
    public String getTaskAttemptLogUrl(JobConf var1, String var2, String var3) throws MalformedURLException;

    public MiniMrShim getMiniMrCluster(Configuration var1, int var2, String var3, int var4) throws IOException;

    public MiniMrShim getMiniTezCluster(Configuration var1, int var2, String var3, int var4) throws IOException;

    public MiniMrShim getMiniSparkCluster(Configuration var1, int var2, String var3, int var4) throws IOException;

    public MiniDFSShim getMiniDfs(Configuration var1, int var2, boolean var3, String[] var4) throws IOException;

    public CombineFileInputFormatShim getCombineFileInputFormat();

    public boolean isSecurityEnabled();

    public JobTrackerState getJobTrackerState(ClusterStatus var1) throws Exception;

    public TaskAttemptContext newTaskAttemptContext(Configuration var1, Progressable var2);

    public org.apache.hadoop.mapreduce.TaskAttemptID newTaskAttemptID(org.apache.hadoop.mapreduce.JobID var1, boolean var2, int var3, int var4);

    public org.apache.hadoop.mapreduce.JobContext newJobContext(Job var1);

    public void startPauseMonitor(Configuration var1);

    public boolean isLocalMode(Configuration var1);

    public String getJobLauncherRpcAddress(Configuration var1);

    public void setJobLauncherRpcAddress(Configuration var1, String var2);

    public String getJobLauncherHttpAddress(Configuration var1);

    public boolean moveToAppropriateTrash(FileSystem var1, Path var2, Configuration var3) throws IOException;

    public long getDefaultBlockSize(FileSystem var1, Path var2);

    public short getDefaultReplication(FileSystem var1, Path var2);

    public void refreshDefaultQueue(Configuration var1, String var2) throws IOException;

    public void setTotalOrderPartitionFile(JobConf var1, Path var2);

    public Comparator<LongWritable> getLongComparator();

    public List<FileStatus> listLocatedStatus(FileSystem var1, Path var2, PathFilter var3) throws IOException;

    public BlockLocation[] getLocations(FileSystem var1, FileStatus var2) throws IOException;

    public TreeMap<Long, BlockLocation> getLocationsWithOffset(FileSystem var1, FileStatus var2) throws IOException;

    public void hflush(FSDataOutputStream var1) throws IOException;

    public HdfsFileStatus getFullFileStatus(Configuration var1, FileSystem var2, Path var3) throws IOException;

    public void setFullFileStatus(Configuration var1, HdfsFileStatus var2, FileSystem var3, Path var4) throws IOException;

    public HCatHadoopShims getHCatShim();

    public WebHCatJTShim getWebHCatShim(Configuration var1, UserGroupInformation var2) throws IOException;

    public FileSystem createProxyFileSystem(FileSystem var1, URI var2);

    public Map<String, String> getHadoopConfNames();

    public StoragePolicyShim getStoragePolicyShim(FileSystem var1);

    public ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream var1, ByteBufferPoolShim var2) throws IOException;

    public DirectDecompressorShim getDirectDecompressor(DirectCompressionType var1);

    public Configuration getConfiguration(org.apache.hadoop.mapreduce.JobContext var1);

    public JobConf getJobConf(JobContext var1);

    public FileSystem getNonCachedFileSystem(URI var1, Configuration var2) throws IOException;

    public void getMergedCredentials(JobConf var1) throws IOException;

    public void mergeCredentials(JobConf var1, JobConf var2) throws IOException;

    public void checkFileAccess(FileSystem var1, FileStatus var2, FsAction var3) throws IOException, AccessControlException, Exception;

    public String getPassword(Configuration var1, String var2) throws IOException;

    public boolean supportStickyBit();

    public boolean hasStickyBit(FsPermission var1);

    public boolean supportTrashFeature();

    public Path getCurrentTrashPath(Configuration var1, FileSystem var2);

    public boolean isDirectory(FileStatus var1);

    public KerberosNameShim getKerberosNameShim(String var1) throws IOException;

    public boolean runDistCp(Path var1, Path var2, Configuration var3) throws IOException;

    public HdfsEncryptionShim createHdfsEncryptionShim(FileSystem var1, Configuration var2) throws IOException;

    public Path getPathWithoutSchemeAndAuthority(Path var1);

    public int readByteBuffer(FSDataInputStream var1, ByteBuffer var2) throws IOException;

    public void addDelegationTokens(FileSystem var1, Credentials var2, String var3) throws IOException;

    public static class NoopHdfsEncryptionShim
    implements HdfsEncryptionShim {
        @Override
        public boolean isPathEncrypted(Path path) throws IOException {
            return false;
        }

        @Override
        public boolean arePathsOnSameEncryptionZone(Path path1, Path path2) throws IOException {
            return true;
        }

        @Override
        public int comparePathKeyStrength(Path path1, Path path2) throws IOException {
            return 0;
        }

        @Override
        public void createEncryptionZone(Path path, String keyName) {
        }

        @Override
        public void createKey(String keyName, int bitLength) {
        }

        @Override
        public void deleteKey(String keyName) throws IOException {
        }

        @Override
        public List<String> getKeys() throws IOException {
            return null;
        }
    }

    public static interface HdfsEncryptionShim {
        public boolean isPathEncrypted(Path var1) throws IOException;

        public boolean arePathsOnSameEncryptionZone(Path var1, Path var2) throws IOException;

        public int comparePathKeyStrength(Path var1, Path var2) throws IOException;

        @VisibleForTesting
        public void createEncryptionZone(Path var1, String var2) throws IOException;

        @VisibleForTesting
        public void createKey(String var1, int var2) throws IOException, NoSuchAlgorithmException;

        @VisibleForTesting
        public void deleteKey(String var1) throws IOException;

        @VisibleForTesting
        public List<String> getKeys() throws IOException;
    }

    public static interface KerberosNameShim {
        public String getDefaultRealm();

        public String getServiceName();

        public String getHostName();

        public String getRealm();

        public String getShortName() throws IOException;
    }

    public static interface DirectDecompressorShim {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;
    }

    public static enum DirectCompressionType {
        NONE,
        ZLIB_NOHEADER,
        ZLIB,
        SNAPPY;

    }

    public static interface ZeroCopyReaderShim {
        public ByteBuffer readBuffer(int var1, boolean var2) throws IOException;

        public void releaseBuffer(ByteBuffer var1);
    }

    public static interface ByteBufferPoolShim {
        public ByteBuffer getBuffer(boolean var1, int var2);

        public void putBuffer(ByteBuffer var1);
    }

    public static interface StoragePolicyShim {
        public void setStoragePolicy(Path var1, StoragePolicyValue var2) throws IOException;
    }

    public static enum StoragePolicyValue {
        MEMORY,
        SSD,
        DEFAULT;


        public static StoragePolicyValue lookup(String name) {
            if (name == null) {
                return DEFAULT;
            }
            return StoragePolicyValue.valueOf(name.toUpperCase().trim());
        }
    }

    public static interface WebHCatJTShim {
        public JobProfile getJobProfile(JobID var1) throws IOException;

        public JobStatus getJobStatus(JobID var1) throws IOException;

        public void killJob(JobID var1) throws IOException;

        public JobStatus[] getAllJobs() throws IOException;

        public void close();

        public void addCacheFile(URI var1, Job var2);

        public void killJobs(String var1, long var2);

        public Set<String> getJobs(String var1, long var2);
    }

    public static interface HCatHadoopShims {
        public TaskID createTaskID();

        public org.apache.hadoop.mapreduce.TaskAttemptID createTaskAttemptID();

        public TaskAttemptContext createTaskAttemptContext(Configuration var1, org.apache.hadoop.mapreduce.TaskAttemptID var2);

        public org.apache.hadoop.mapred.TaskAttemptContext createTaskAttemptContext(JobConf var1, TaskAttemptID var2, Progressable var3);

        public org.apache.hadoop.mapreduce.JobContext createJobContext(Configuration var1, org.apache.hadoop.mapreduce.JobID var2);

        public JobContext createJobContext(JobConf var1, org.apache.hadoop.mapreduce.JobID var2, Progressable var3);

        public void commitJob(OutputFormat var1, Job var2) throws IOException;

        public void abortJob(OutputFormat var1, Job var2) throws IOException;

        public InetSocketAddress getResourceManagerAddress(Configuration var1);

        public String getPropertyName(PropertyName var1);

        public boolean isFileInHDFS(FileSystem var1, Path var2) throws IOException;

        public static enum PropertyName {
            CACHE_ARCHIVES,
            CACHE_FILES,
            CACHE_SYMLINK,
            CLASSPATH_ARCHIVES,
            CLASSPATH_FILES;

        }
    }

    public static interface HdfsFileStatus {
        public FileStatus getFileStatus();

        public void debugLog();
    }

    public static interface CombineFileInputFormatShim<K, V> {
        public Path[] getInputPathsShim(JobConf var1);

        public void createPool(JobConf var1, PathFilter ... var2);

        public CombineFileSplit[] getSplits(JobConf var1, int var2) throws IOException;

        public CombineFileSplit getInputSplitShim() throws IOException;

        public RecordReader getRecordReader(JobConf var1, CombineFileSplit var2, Reporter var3, Class<RecordReader<K, V>> var4) throws IOException;
    }

    public static enum JobTrackerState {
        INITIALIZING,
        RUNNING;

    }

    public static interface MiniDFSShim {
        public FileSystem getFileSystem() throws IOException;

        public void shutdown() throws IOException;
    }

    public static interface MiniMrShim {
        public int getJobTrackerPort() throws UnsupportedOperationException;

        public void shutdown() throws IOException;

        public void setupConfiguration(Configuration var1);
    }
}

