/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class HBaseRowSerializer {
    private final HBaseKeyFactory keyFactory;
    private final HBaseSerDeParameters hbaseParam;
    private final LazySerDeParameters serdeParam;
    private final int keyIndex;
    private final int timestampIndex;
    private final ColumnMappings.ColumnMapping keyMapping;
    private final ColumnMappings.ColumnMapping timestampMapping;
    private final ColumnMappings.ColumnMapping[] columnMappings;
    private final byte[] separators;
    private final boolean escaped;
    private final byte escapeChar;
    private final boolean[] needsEscape;
    private final long putTimestamp;
    private final ByteStream.Output output = new ByteStream.Output();

    public HBaseRowSerializer(HBaseSerDeParameters hbaseParam) {
        this.hbaseParam = hbaseParam;
        this.keyFactory = hbaseParam.getKeyFactory();
        this.serdeParam = hbaseParam.getSerdeParams();
        this.separators = this.serdeParam.getSeparators();
        this.escaped = this.serdeParam.isEscaped();
        this.escapeChar = this.serdeParam.getEscapeChar();
        this.needsEscape = this.serdeParam.getNeedsEscape();
        this.keyIndex = hbaseParam.getKeyIndex();
        this.timestampIndex = hbaseParam.getTimestampIndex();
        this.columnMappings = hbaseParam.getColumnMappings().getColumnsMapping();
        this.keyMapping = hbaseParam.getColumnMappings().getKeyMapping();
        this.timestampMapping = hbaseParam.getColumnMappings().getTimestampMapping();
        this.putTimestamp = hbaseParam.getPutTimestamp();
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws Exception {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(obj);
        StructField field = (StructField)fields.get(this.keyIndex);
        Object value = values.get(this.keyIndex);
        byte[] key = this.keyFactory.serializeKey(value, field);
        if (key == null) {
            throw new SerDeException("HBase row key cannot be NULL");
        }
        long timestamp = this.putTimestamp;
        if (timestamp < 0L && this.timestampIndex >= 0) {
            ObjectInspector inspector = ((StructField)fields.get(this.timestampIndex)).getFieldObjectInspector();
            value = values.get(this.timestampIndex);
            if (inspector instanceof LongObjectInspector) {
                timestamp = ((LongObjectInspector)inspector).get(value);
            } else {
                PrimitiveObjectInspector primitive = (PrimitiveObjectInspector)inspector;
                timestamp = PrimitiveObjectInspectorUtils.getTimestamp(value, (PrimitiveObjectInspector)primitive).getTime();
            }
        }
        Put put = timestamp >= 0L ? new Put(key, timestamp) : new Put(key);
        for (int i = 0; i < fields.size(); ++i) {
            if (i == this.keyIndex || i == this.timestampIndex) continue;
            field = (StructField)fields.get(i);
            value = values.get(i);
            this.serializeField(value, field, this.columnMappings[i], put);
        }
        return new PutWritable(put);
    }

    byte[] serializeKeyField(Object keyValue, StructField keyField, ColumnMappings.ColumnMapping keyMapping) throws IOException {
        if (keyValue == null) {
            throw new IOException("HBase row key cannot be NULL");
        }
        ObjectInspector keyFieldOI = keyField.getFieldObjectInspector();
        if (!keyFieldOI.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && keyMapping.isCategory(ObjectInspector.Category.PRIMITIVE)) {
            return this.serialize((Object)SerDeUtils.getJSONString((Object)keyValue, (ObjectInspector)keyFieldOI), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1, false);
        }
        boolean writeBinary = keyMapping.binaryStorage.get(0);
        return this.serialize(keyValue, keyFieldOI, 1, writeBinary);
    }

    private void serializeField(Object value, StructField field, ColumnMappings.ColumnMapping colMap, Put put) throws IOException {
        if (value == null) {
            return;
        }
        ObjectInspector foi = field.getFieldObjectInspector();
        if (colMap.qualifierName == null) {
            MapObjectInspector moi = (MapObjectInspector)foi;
            Map map = moi.getMap(value);
            if (map == null) {
                return;
            }
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            for (Map.Entry entry : map.entrySet()) {
                byte[] bytes;
                byte[] columnQualifierBytes = this.serialize(entry.getKey(), koi, 3, colMap.binaryStorage.get(0));
                if (columnQualifierBytes == null || (bytes = this.serialize(entry.getValue(), voi, 3, colMap.binaryStorage.get(1))) == null) continue;
                put.add(colMap.familyNameBytes, columnQualifierBytes, bytes);
            }
        } else {
            byte[] bytes = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && colMap.isCategory(ObjectInspector.Category.PRIMITIVE) ? this.serialize((Object)SerDeUtils.getJSONString((Object)value, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1, false) : this.serialize(value, foi, 1, colMap.binaryStorage.get(0));
            if (bytes == null) {
                return;
            }
            put.add(colMap.familyNameBytes, colMap.qualifierNameBytes, bytes);
        }
    }

    private byte[] serialize(Object obj, ObjectInspector objInspector, int level, boolean writeBinary) throws IOException {
        this.output.reset();
        if (objInspector.getCategory() == ObjectInspector.Category.PRIMITIVE && writeBinary) {
            LazyUtils.writePrimitive((OutputStream)this.output, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector));
        } else if (!this.serialize(obj, objInspector, level, this.output)) {
            return null;
        }
        return this.output.toByteArray();
    }

    private boolean serialize(Object obj, ObjectInspector objInspector, int level, ByteStream.Output ss) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)ss, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)this.escaped, (byte)this.escapeChar, (boolean[])this.needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        ss.write((int)separator);
                    }
                    if (list.get(i) == null) continue;
                    this.serialize(list.get(i), eoi, level + 1, ss);
                }
                return true;
            }
            case MAP: {
                char sep = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        ss.write((int)sep);
                    }
                    this.serialize(entry.getKey(), koi, level + 2, ss);
                    ss.write((int)keyValueSeparator);
                    this.serialize(entry.getValue(), voi, level + 2, ss);
                }
                return true;
            }
            case STRUCT: {
                char sep = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        ss.write((int)sep);
                    }
                    if (list.get(i) == null) continue;
                    this.serialize(list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), level + 1, ss);
                }
                return true;
            }
            case UNION: {
                return false;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }
}

