/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.tempusfugit.concurrency;

import com.google.code.tempusfugit.concurrency.annotations.Intermittent;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class IntermittentTestRunner
extends BlockJUnit4ClassRunner {
    private final Class<?> type;

    public IntermittentTestRunner(Class<?> type) throws InitializationError {
        super(type);
        this.type = type;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        for (int i = 0; i < this.repeatCount(method); ++i) {
            super.runChild(method, notifier);
        }
    }

    private int repeatCount(FrameworkMethod method) {
        if (IntermittentTestRunner.intermittent(this.type)) {
            return IntermittentTestRunner.repetition(this.type);
        }
        if (IntermittentTestRunner.intermittent(method)) {
            return IntermittentTestRunner.repetition(method);
        }
        return 1;
    }

    private static boolean intermittent(FrameworkMethod method) {
        return method.getAnnotation(Intermittent.class) != null;
    }

    private static boolean intermittent(Class<?> type) {
        return type.getAnnotation(Intermittent.class) != null;
    }

    private static int repetition(FrameworkMethod method) {
        return ((Intermittent)method.getAnnotation(Intermittent.class)).repetition();
    }

    private static int repetition(Class<?> type) {
        return type.getAnnotation(Intermittent.class).repetition();
    }
}

