/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.start.classloader.AccumuloClassLoader;
import org.apache.accumulo.start.classloader.vfs.AccumuloReloadingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.start.classloader.vfs.FinalCloseDefaultFileSystemManager;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.accumulo.start.classloader.vfs.UniqueFileReplicator;
import org.apache.accumulo.start.classloader.vfs.providers.HdfsFileProvider;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.FileContentInfoFilenameFactory;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.gzip.GzipFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.https.HttpsFileProvider;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.res.ResourceFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.log4j.Logger;

public class AccumuloVFSClassLoader {
    private static List<WeakReference<DefaultFileSystemManager>> vfsInstances = Collections.synchronizedList(new ArrayList());
    public static final String DYNAMIC_CLASSPATH_PROPERTY_NAME = "general.dynamic.classpaths";
    public static final String DEFAULT_DYNAMIC_CLASSPATH_VALUE = "$ACCUMULO_HOME/lib/ext/[^.].*.jar";
    public static final String VFS_CLASSLOADER_SYSTEM_CLASSPATH_PROPERTY = "general.vfs.classpaths";
    public static final String VFS_CONTEXT_CLASSPATH_PROPERTY = "general.vfs.context.classpath.";
    public static final String VFS_CACHE_DIR = "general.vfs.cache.dir";
    private static ClassLoader parent = null;
    private static volatile ReloadingClassLoader loader = null;
    private static final Object lock = new Object();
    private static ContextManager contextManager;
    private static Logger log;

    public static synchronized <U> Class<? extends U> loadClass(String classname, Class<U> extension) throws ClassNotFoundException {
        try {
            return AccumuloVFSClassLoader.getClassLoader().loadClass(classname).asSubclass(extension);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("IO Error loading class " + classname, e);
        }
    }

    public static Class<?> loadClass(String classname) throws ClassNotFoundException {
        return AccumuloVFSClassLoader.loadClass(classname, Object.class).asSubclass(Object.class);
    }

    static FileObject[] resolve(FileSystemManager vfs, String uris) throws FileSystemException {
        return AccumuloVFSClassLoader.resolve(vfs, uris, new ArrayList<FileObject>());
    }

    static FileObject[] resolve(FileSystemManager vfs, String uris, ArrayList<FileObject> pathsToMonitor) throws FileSystemException {
        if (uris == null) {
            return new FileObject[0];
        }
        ArrayList<FileObject> classpath = new ArrayList<FileObject>();
        pathsToMonitor.clear();
        block4: for (String path : uris.split(",")) {
            if ((path = path.trim()).equals("")) continue;
            path = AccumuloClassLoader.replaceEnvVars(path, System.getenv());
            FileObject fo = vfs.resolveFile(path);
            switch (fo.getType()) {
                case FILE: 
                case FOLDER: {
                    classpath.add(fo);
                    pathsToMonitor.add(fo);
                    continue block4;
                }
                case IMAGINARY: {
                    String pattern = fo.getName().getBaseName();
                    if (fo.getParent() != null && fo.getParent().getType() == FileType.FOLDER) {
                        FileObject[] children;
                        pathsToMonitor.add(fo.getParent());
                        for (FileObject child : children = fo.getParent().getChildren()) {
                            if (child.getType() != FileType.FILE || !child.getName().getBaseName().matches(pattern)) continue;
                            classpath.add(child);
                        }
                        continue block4;
                    }
                    log.warn((Object)("ignoring classpath entry " + fo));
                    continue block4;
                }
                default: {
                    log.warn((Object)("ignoring classpath entry " + fo));
                }
            }
        }
        return classpath.toArray(new FileObject[classpath.size()]);
    }

    private static ReloadingClassLoader createDynamicClassloader(final ClassLoader parent) throws FileSystemException, IOException {
        String dynamicCPath = AccumuloClassLoader.getAccumuloString(DYNAMIC_CLASSPATH_PROPERTY_NAME, DEFAULT_DYNAMIC_CLASSPATH_VALUE);
        String envJars = System.getenv("ACCUMULO_XTRAJARS");
        if (null != envJars && !envJars.equals("")) {
            dynamicCPath = dynamicCPath != null && !dynamicCPath.equals("") ? dynamicCPath + "," + envJars : envJars;
        }
        ReloadingClassLoader wrapper = new ReloadingClassLoader(){

            @Override
            public ClassLoader getClassLoader() {
                return parent;
            }
        };
        if (dynamicCPath == null || dynamicCPath.equals("")) {
            return wrapper;
        }
        return new AccumuloReloadingVFSClassLoader(dynamicCPath, AccumuloVFSClassLoader.generateVfs(), wrapper, 1000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader() throws IOException {
        ReloadingClassLoader localLoader = loader;
        while (null == localLoader) {
            Object object = lock;
            synchronized (object) {
                if (null == loader) {
                    FileObject[] vfsCP;
                    FileSystemManager vfs = AccumuloVFSClassLoader.generateVfs();
                    if (null == parent) {
                        parent = AccumuloClassLoader.getClassLoader();
                    }
                    if ((vfsCP = AccumuloVFSClassLoader.resolve(vfs, AccumuloClassLoader.getAccumuloString(VFS_CLASSLOADER_SYSTEM_CLASSPATH_PROPERTY, ""))).length == 0) {
                        loader = localLoader = AccumuloVFSClassLoader.createDynamicClassloader(parent);
                        return localLoader.getClassLoader();
                    }
                    loader = localLoader = AccumuloVFSClassLoader.createDynamicClassloader((ClassLoader)new VFSClassLoader(vfsCP, vfs, parent));
                }
            }
        }
        return localLoader.getClassLoader();
    }

    public static FileSystemManager generateVfs() throws FileSystemException {
        FinalCloseDefaultFileSystemManager vfs = new FinalCloseDefaultFileSystemManager();
        vfs.addProvider("res", (FileProvider)new ResourceFileProvider());
        vfs.addProvider("zip", (FileProvider)new ZipFileProvider());
        vfs.addProvider("gz", (FileProvider)new GzipFileProvider());
        vfs.addProvider("ram", (FileProvider)new RamFileProvider());
        vfs.addProvider("file", (FileProvider)new DefaultLocalFileProvider());
        vfs.addProvider("jar", (FileProvider)new JarFileProvider());
        vfs.addProvider("http", (FileProvider)new HttpFileProvider());
        vfs.addProvider("https", (FileProvider)new HttpsFileProvider());
        vfs.addProvider("ftp", (FileProvider)new FtpFileProvider());
        vfs.addProvider("ftps", (FileProvider)new FtpsFileProvider());
        vfs.addProvider("war", (FileProvider)new JarFileProvider());
        vfs.addProvider("par", (FileProvider)new JarFileProvider());
        vfs.addProvider("ear", (FileProvider)new JarFileProvider());
        vfs.addProvider("sar", (FileProvider)new JarFileProvider());
        vfs.addProvider("ejb3", (FileProvider)new JarFileProvider());
        vfs.addProvider("tmp", (FileProvider)new TemporaryFileProvider());
        vfs.addProvider("tar", (FileProvider)new TarFileProvider());
        vfs.addProvider("tbz2", (FileProvider)new TarFileProvider());
        vfs.addProvider("tgz", (FileProvider)new TarFileProvider());
        vfs.addProvider("bz2", (FileProvider)new Bzip2FileProvider());
        vfs.addProvider("hdfs", (FileProvider)new HdfsFileProvider());
        vfs.addExtensionMap("jar", "jar");
        vfs.addExtensionMap("zip", "zip");
        vfs.addExtensionMap("gz", "gz");
        vfs.addExtensionMap("tar", "tar");
        vfs.addExtensionMap("tbz2", "tar");
        vfs.addExtensionMap("tgz", "tar");
        vfs.addExtensionMap("bz2", "bz2");
        vfs.addMimeTypeMap("application/x-tar", "tar");
        vfs.addMimeTypeMap("application/x-gzip", "gz");
        vfs.addMimeTypeMap("application/zip", "zip");
        vfs.setFileContentInfoFactory((FileContentInfoFactory)new FileContentInfoFilenameFactory());
        vfs.setFilesCache((FilesCache)new SoftRefFilesCache());
        String cacheDirPath = AccumuloClassLoader.getAccumuloString(VFS_CACHE_DIR, "");
        String procName = ManagementFactory.getRuntimeMXBean().getName();
        File cacheDir = new File(System.getProperty("java.io.tmpdir"), "accumulo-vfs-cache-" + procName + "-" + System.getProperty("user.name", "nouser"));
        if (!cacheDirPath.isEmpty()) {
            cacheDir = new File(cacheDirPath);
        }
        vfs.setReplicator(new UniqueFileReplicator(cacheDir));
        vfs.setCacheStrategy(CacheStrategy.ON_RESOLVE);
        vfs.init();
        vfsInstances.add(new WeakReference<FinalCloseDefaultFileSystemManager>(vfs));
        return vfs;
    }

    public static void printClassPath() {
        AccumuloVFSClassLoader.printClassPath(new Printer(){

            @Override
            public void print(String s) {
                System.out.println(s);
            }
        });
    }

    public static void printClassPath(Printer out) {
        try {
            ArrayList<ClassLoader> classloaders = new ArrayList<ClassLoader>();
            for (ClassLoader cl = AccumuloVFSClassLoader.getClassLoader(); cl != null; cl = cl.getParent()) {
                classloaders.add(cl);
            }
            Collections.reverse(classloaders);
            int level = 0;
            for (ClassLoader classLoader : classloaders) {
                String classLoaderDescription;
                if (level > 0) {
                    out.print("");
                }
                switch (++level) {
                    case 1: {
                        classLoaderDescription = level + ": Java System Classloader (loads Java system resources)";
                        break;
                    }
                    case 2: {
                        classLoaderDescription = level + ": Java Classloader (loads everything defined by java classpath)";
                        break;
                    }
                    case 3: {
                        classLoaderDescription = level + ": Accumulo Classloader (loads everything defined by general.classpaths)";
                        break;
                    }
                    case 4: {
                        classLoaderDescription = level + ": Accumulo Dynamic Classloader (loads everything defined by general.dynamic.classpaths)";
                        break;
                    }
                    default: {
                        classLoaderDescription = level + ": Mystery Classloader (someone probably added a classloader and didn't update the switch statement in " + AccumuloVFSClassLoader.class.getName() + ")";
                    }
                }
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader ucl = (URLClassLoader)classLoader;
                    out.print("Level " + classLoaderDescription + " URL classpath items are:");
                    for (URL uRL : ucl.getURLs()) {
                        out.print("\t" + uRL.toExternalForm());
                    }
                    continue;
                }
                if (classLoader instanceof VFSClassLoader) {
                    out.print("Level " + classLoaderDescription + " VFS classpaths items are:");
                    VFSClassLoader vcl = (VFSClassLoader)classLoader;
                    for (URL uRL : vcl.getFileObjects()) {
                        out.print("\t" + uRL.getURL().toExternalForm());
                    }
                    continue;
                }
                out.print("Unknown classloader configuration " + classLoader.getClass());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static synchronized ContextManager getContextManager() throws IOException {
        if (contextManager == null) {
            AccumuloVFSClassLoader.getClassLoader();
            contextManager = new ContextManager(AccumuloVFSClassLoader.generateVfs(), new ReloadingClassLoader(){

                @Override
                public ClassLoader getClassLoader() {
                    try {
                        return AccumuloVFSClassLoader.getClassLoader();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return contextManager;
    }

    public static void close() {
        for (WeakReference<DefaultFileSystemManager> vfsInstance : vfsInstances) {
            DefaultFileSystemManager ref = (DefaultFileSystemManager)vfsInstance.get();
            if (ref == null) continue;
            ref.close();
        }
    }

    static {
        log = Logger.getLogger(AccumuloVFSClassLoader.class);
        Runtime.getRuntime().addShutdownHook(new Thread(new AccumuloVFSClassLoaderShutdownThread()));
    }

    public static interface Printer {
        public void print(String var1);
    }

    public static class AccumuloVFSClassLoaderShutdownThread
    implements Runnable {
        @Override
        public void run() {
            try {
                AccumuloVFSClassLoader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

