/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.PostDelegatingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.log4j.Logger;

public class AccumuloReloadingVFSClassLoader
implements FileListener,
ReloadingClassLoader {
    private static final Logger log = Logger.getLogger(AccumuloReloadingVFSClassLoader.class);
    private static final int DEFAULT_TIMEOUT = 300000;
    private String uris;
    private FileObject[] files;
    private FileSystemManager vfs = null;
    private ReloadingClassLoader parent = null;
    private DefaultFileMonitor monitor = null;
    private VFSClassLoader cl = null;
    private boolean preDelegate;

    public String stringify(FileObject[] files) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        String delim = "";
        for (FileObject file : files) {
            sb.append(delim);
            delim = ", ";
            sb.append(file.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        if (this.cl == null || this.cl.getParent() != this.parent.getClassLoader()) {
            try {
                this.vfs = AccumuloVFSClassLoader.generateVfs();
                this.files = AccumuloVFSClassLoader.resolve(this.vfs, this.uris);
                log.debug((Object)("Rebuilding dynamic classloader using files- " + this.stringify(this.files)));
                this.cl = this.preDelegate ? new VFSClassLoader(this.files, this.vfs, this.parent.getClassLoader()) : new PostDelegatingVFSClassLoader(this.files, this.vfs, this.parent.getClassLoader());
            }
            catch (FileSystemException fse) {
                throw new RuntimeException(fse);
            }
        }
        return this.cl;
    }

    private synchronized void setClassloader(VFSClassLoader cl) {
        this.cl = cl;
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, long monitorDelay, boolean preDelegate) throws FileSystemException {
        this.uris = uris;
        this.vfs = vfs;
        this.parent = parent;
        this.preDelegate = preDelegate;
        ArrayList<FileObject> pathsToMonitor = new ArrayList<FileObject>();
        this.files = AccumuloVFSClassLoader.resolve(vfs, uris, pathsToMonitor);
        this.cl = preDelegate ? new VFSClassLoader(this.files, vfs, parent.getClassLoader()) : new PostDelegatingVFSClassLoader(this.files, vfs, parent.getClassLoader());
        this.monitor = new DefaultFileMonitor((FileListener)this);
        this.monitor.setDelay(monitorDelay);
        this.monitor.setRecursive(false);
        for (FileObject file : pathsToMonitor) {
            this.monitor.addFile(file);
            log.debug((Object)("monitoring " + file));
        }
        this.monitor.start();
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, boolean preDelegate) throws FileSystemException {
        this(uris, vfs, parent, 300000L, preDelegate);
    }

    public synchronized FileObject[] getFiles() {
        return Arrays.copyOf(this.files, this.files.length);
    }

    public void close() {
        this.monitor.stop();
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(event.getFile().getURL().toString() + " created, recreating classloader"));
        }
        this.setClassloader(null);
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(event.getFile().getURL().toString() + " changed, recreating classloader"));
        }
        this.setClassloader(null);
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)(event.getFile().getURL().toString() + " deleted, recreating classloader"));
        }
        this.setClassloader(null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (FileObject f : this.files) {
            try {
                buf.append("\t").append(f.getURL().toString()).append("\n");
            }
            catch (FileSystemException e) {
                log.error((Object)"Error getting URL for file", (Throwable)e);
            }
        }
        return buf.toString();
    }
}

