/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityConfig;
import com.mapr.web.security.XmlSslConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class WebSecurityManager {
    private static WebSecurityManager securityManager;
    private final SslContextFactory sslContextFactory = new SslContextFactory.Server();
    private static String storePassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importUrlCertificate(String importUrl, String truststore) {
        URL url = new URL(importUrl);
        String host = url.getHost();
        if (!url.getProtocol().equals("https")) {
            System.out.println("URL is not an https url");
            return false;
        }
        int port = url.getPort();
        if (port < 0) {
            port = 443;
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        String passphrase = Password.deobfuscate((String)storePassword);
        try (FileInputStream in = new FileInputStream(truststore);){
            ks.load(in, passphrase.toCharArray());
        }
        SSLContext context = SSLContext.getInstance("TLS");
        X509TrustManager defaultTrustManager = null;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        for (TrustManager trustManager : tmf.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            defaultTrustManager = (X509TrustManager)trustManager;
            break;
        }
        if (defaultTrustManager == null) {
            System.out.println("Could not obtain a X509TrustManager");
            return false;
        }
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        System.out.println("Opening connection to " + host + ':' + port + "...");
        try {
            Throwable throwable = null;
            try (SSLSocket socket = (SSLSocket)factory.createSocket(host, port);){
                socket.setSoTimeout(10000);
                System.out.println("Starting SSL handshake...");
                socket.startHandshake();
                socket.close();
                System.out.println();
                System.out.println("No errors, certificate is already trusted");
                boolean bl = false;
                return bl;
            }
            catch (Throwable bl) {
                Throwable throwable4 = bl;
                throw bl;
            }
        }
        catch (SSLException e) {
            System.out.println("Certificate is not currently trusted. Attempting to add...");
            X509Certificate[] chain = tm.getChain();
            if (chain == null) {
                System.out.println("Could not obtain server certificate chain");
                return false;
            }
            X509Certificate x509Certificate = chain[0];
            String alias = host + ':' + port;
            ks.setCertificateEntry(alias, x509Certificate);
            try (FileOutputStream out = new FileOutputStream(truststore);){
                ks.store(out, passphrase.toCharArray());
            }
            System.out.println("Added certificate to truststore using alias: " + alias);
            return true;
        }
    }

    private void init(String processName) {
        WebSecurityConfig.CONFIG.setProcessName(processName);
        String keystore = System.getProperty(processName + ".ssl.keystore", WebSecurityConfig.CONFIG.getMaprHome() + "/conf/ssl_keystore");
        String truststore = System.getProperty(processName + ".ssl.truststore", WebSecurityConfig.CONFIG.getMaprHome() + "/conf/ssl_truststore");
        File keyStoreFile = new File(keystore);
        if (!keyStoreFile.canRead()) {
            // empty if block
        }
        storePassword = System.getProperty(processName + ".ssl.truststore.password", "OBF:1ku11i9a1l1a1y7z1kxs1i6o1kqt");
        this.sslContextFactory.setKeyStorePath(keyStoreFile.getAbsolutePath());
        this.sslContextFactory.setKeyStorePassword(storePassword);
        this.sslContextFactory.setKeyManagerPassword(storePassword);
        File trustStoreFile = new File(truststore);
        if (trustStoreFile.canRead()) {
            this.sslContextFactory.setTrustStorePath(trustStoreFile.getAbsolutePath());
            this.sslContextFactory.setTrustStorePassword(storePassword);
        }
        this.sslContextFactory.setExcludeCipherSuites(System.getProperty(processName + ".ssl.exclude-ciphers", "^TLS_DHE.*,^TLS_EDH.*,^TLS_RSA_.*,^.*_(MD5|SHA|SHA1)$").split(","));
        this.sslContextFactory.setExcludeProtocols(System.getProperty(processName + ".ssl.exclude-protocols", "SSLv3,TLSv1.0").split(","));
        this.sslContextFactory.setRenegotiationAllowed(false);
    }

    public static synchronized WebSecurityManager getSecurityManager(String processName) {
        if (securityManager == null) {
            securityManager = new WebSecurityManager();
            securityManager.init(processName);
        }
        return securityManager;
    }

    public static SslConfig getSslConfig() throws SecurityException {
        return WebSecurityManager.getSslConfig(SslConfig.SslConfigScope.SCOPE_ALL);
    }

    public static SslConfig getSslConfig(SslConfig.SslConfigScope scope) throws SecurityException {
        return new XmlSslConfig(scope);
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            this.chain = certificates;
            this.tm.checkServerTrusted(this.chain, authType);
        }

        public X509TrustManager getTm() {
            return this.tm;
        }

        public X509Certificate[] getChain() {
            return this.chain;
        }

        public SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }
    }
}

