/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.HiveServer2;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;

public class SessionManager
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    public static final String HIVERCFILE = ".hiverc";
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new ConcurrentHashMap<SessionHandle, HiveSession>();
    private final OperationManager operationManager = new OperationManager();
    private ThreadPoolExecutor backgroundOperationPool;
    private boolean isOperationLogEnabled;
    private File operationLogRootDir;
    private long checkInterval;
    private long sessionTimeout;
    private boolean checkOperation;
    private volatile boolean shutdown;
    private final HiveServer2 hiveServer2;
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalProxyUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager(HiveServer2 hiveServer2) {
        super(SessionManager.class.getSimpleName());
        this.hiveServer2 = hiveServer2;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            this.initOperationLogRootDir();
        }
        this.createBackgroundOperationPool();
        this.addService(this.operationManager);
        super.init(hiveConf);
    }

    private void createBackgroundOperationPool() {
        int poolSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        LOG.info("HiveServer2: Background operation thread pool size: " + poolSize);
        int poolQueueSize = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_WAIT_QUEUE_SIZE);
        LOG.info("HiveServer2: Background operation thread wait queue size: " + poolQueueSize);
        long keepAliveTime = HiveConf.getTimeVar(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_KEEPALIVE_TIME, TimeUnit.SECONDS);
        LOG.info("HiveServer2: Background operation thread keepalive time: " + keepAliveTime + " seconds");
        String threadPoolName = "HiveServer2-Background-Pool";
        this.backgroundOperationPool = new ThreadPoolExecutor(poolSize, poolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(poolQueueSize), new ThreadFactoryWithGarbageCleanup(threadPoolName));
        this.backgroundOperationPool.allowCoreThreadTimeOut(true);
        this.checkInterval = HiveConf.getTimeVar(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL, TimeUnit.MILLISECONDS);
        this.sessionTimeout = HiveConf.getTimeVar(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT, TimeUnit.MILLISECONDS);
        this.checkOperation = HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_CHECK_OPERATION);
    }

    private void initOperationLogRootDir() {
        this.operationLogRootDir = new File(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION));
        this.isOperationLogEnabled = true;
        if (this.operationLogRootDir.exists() && !this.operationLogRootDir.isDirectory()) {
            LOG.warn("The operation log root directory exists, but it is not a directory: " + this.operationLogRootDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (!this.operationLogRootDir.exists() && !this.operationLogRootDir.mkdirs()) {
            LOG.warn("Unable to create operation log root directory: " + this.operationLogRootDir.getAbsolutePath());
            this.isOperationLogEnabled = false;
        }
        if (this.isOperationLogEnabled) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        FileUtils.forceDelete((File)SessionManager.this.operationLogRootDir);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to schedule cleanup HS2 operation logging root dir: " + SessionManager.this.operationLogRootDir.getAbsolutePath(), e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.checkInterval > 0L) {
            this.startTimeoutChecker();
        }
    }

    private void startTimeoutChecker() {
        final long interval = Math.max(this.checkInterval, 3000L);
        Runnable timeoutChecker = new Runnable(){

            @Override
            public void run() {
                this.sleepInterval(interval);
                while (!SessionManager.this.shutdown) {
                    long current = System.currentTimeMillis();
                    for (HiveSession session : new ArrayList(SessionManager.this.handleToSession.values())) {
                        if (!(SessionManager.this.sessionTimeout <= 0L || session.getLastAccessTime() + SessionManager.this.sessionTimeout > current || SessionManager.this.checkOperation && session.getNoOperationTime() <= SessionManager.this.sessionTimeout)) {
                            SessionHandle handle = session.getSessionHandle();
                            LOG.warn("Session " + handle + " is Timed-out (last access : " + new Date(session.getLastAccessTime()) + ") and will be closed");
                            try {
                                SessionManager.this.closeSession(handle);
                            }
                            catch (HiveSQLException e) {
                                LOG.warn("Exception is thrown closing session " + handle, e);
                            }
                            continue;
                        }
                        session.closeExpiredOperations();
                    }
                    this.sleepInterval(interval);
                }
            }

            private void sleepInterval(long interval2) {
                try {
                    Thread.sleep(interval2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.backgroundOperationPool.execute(timeoutChecker);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.shutdown = true;
        if (this.backgroundOperationPool != null) {
            this.backgroundOperationPool.shutdown();
            long timeout = this.hiveConf.getTimeVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT, TimeUnit.SECONDS);
            try {
                this.backgroundOperationPool.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = " + timeout + " seconds has been exceeded. RUNNING background operations will be shut down", e);
            }
            this.backgroundOperationPool = null;
        }
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> sessionConf) throws HiveSQLException {
        return this.openSession(protocol, username, password, ipAddress, sessionConf, false, null);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        if (withImpersonation) {
            HiveSessionImplwithUGI sessionWithUGI = new HiveSessionImplwithUGI(protocol, username, password, this.hiveConf, ipAddress, delegationToken);
            session = HiveSessionProxy.getProxy(sessionWithUGI, sessionWithUGI.getSessionUgi());
            sessionWithUGI.setProxySession(session);
        } else {
            session = new HiveSessionImpl(protocol, username, password, this.hiveConf, ipAddress);
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        try {
            session.open(sessionConf);
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing session", t);
            }
            session = null;
            throw new HiveSQLException("Failed to open new session: " + e, e);
        }
        if (this.isOperationLogEnabled) {
            session.setOperationLogSessionDir(this.operationLogRootDir);
        }
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (Throwable t) {
                LOG.warn("Error closing session", t);
            }
            session = null;
            throw new HiveSQLException("Failed to execute session hooks", e);
        }
        this.handleToSession.put(session.getSessionHandle(), session);
        return session.getSessionHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        block4: {
            HiveSession session = this.handleToSession.remove(sessionHandle);
            if (session == null) {
                throw new HiveSQLException("Session does not exist!");
            }
            try {
                session.close();
                if (this.hiveServer2 == null || !this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY) || this.hiveServer2.isRegisteredWithZooKeeper() || this.getOpenSessionCount() != 0) break block4;
                LOG.info("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
            }
            catch (Throwable throwable) {
                if (this.hiveServer2 != null && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_SUPPORT_DYNAMIC_SERVICE_DISCOVERY) && !this.hiveServer2.isRegisteredWithZooKeeper() && this.getOpenSessionCount() == 0) {
                    LOG.info("This instance of HiveServer2 has been removed from the list of server instances available for dynamic service discovery. The last client session has ended - will shutdown now.");
                    Thread shutdownThread = new Thread(){

                        @Override
                        public void run() {
                            SessionManager.this.hiveServer2.stop();
                        }
                    };
                    shutdownThread.start();
                }
                throw throwable;
            }
            Thread shutdownThread = new /* invalid duplicate definition of identical inner class */;
            shutdownThread.start();
        }
    }

    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.get(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    public static void clearUserName() {
        threadLocalUserName.remove();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }

    public static void setProxyUserName(String userName) {
        LOG.debug("setting proxy user name based on query param to: " + userName);
        threadLocalProxyUserName.set(userName);
    }

    public static String getProxyUserName() {
        return threadLocalProxyUserName.get();
    }

    public static void clearProxyUserName() {
        threadLocalProxyUserName.remove();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        List sessionHooks = HookUtils.getHooks((HiveConf)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK, HiveSessionHook.class);
        for (HiveSessionHook sessionHook : sessionHooks) {
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.backgroundOperationPool.submit(r);
    }

    public int getOpenSessionCount() {
        return this.handleToSession.size();
    }
}

