/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.IllegalFormatException;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;

public class HiveSchemaHelper {
    public static final String DB_DERBY = "derby";
    public static final String DB_MSSQL = "mssql";
    public static final String DB_MYSQL = "mysql";
    public static final String DB_POSTGRACE = "postgres";
    public static final String DB_ORACLE = "oracle";

    public static Connection getConnectionToMetastore(String userName, String password, boolean printInfo, HiveConf hiveConf) throws HiveMetaException {
        try {
            String connectionURL = HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, hiveConf);
            String driver = HiveSchemaHelper.getValidConfVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, hiveConf);
            if (printInfo) {
                System.out.println("Metastore connection URL:\t " + connectionURL);
                System.out.println("Metastore Connection Driver :\t " + driver);
                System.out.println("Metastore connection User:\t " + userName);
            }
            if (userName == null || userName.isEmpty()) {
                throw new HiveMetaException("UserName empty ");
            }
            Class.forName(driver);
            return DriverManager.getConnection(connectionURL, userName, password);
        }
        catch (IOException e) {
            throw new HiveMetaException("Failed to get schema version.", (Throwable)e);
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new HiveMetaException("Failed to load driver", (Throwable)e);
        }
    }

    public static String getValidConfVar(HiveConf.ConfVars confVar, HiveConf hiveConf) throws IOException {
        String confVarStr = hiveConf.get(confVar.varname);
        if (confVarStr == null || confVarStr.isEmpty()) {
            throw new IOException("Empty " + confVar.varname);
        }
        return confVarStr;
    }

    public static NestedScriptParser getDbCommandParser(String dbName) {
        return HiveSchemaHelper.getDbCommandParser(dbName, null, null, null, null);
    }

    public static NestedScriptParser getDbCommandParser(String dbName, String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
        if (dbName.equalsIgnoreCase(DB_DERBY)) {
            return new DerbyCommandParser(dbOpts, msUsername, msPassword, hiveConf);
        }
        if (dbName.equalsIgnoreCase(DB_MSSQL)) {
            return new MSSQLCommandParser(dbOpts, msUsername, msPassword, hiveConf);
        }
        if (dbName.equalsIgnoreCase(DB_MYSQL)) {
            return new MySqlCommandParser(dbOpts, msUsername, msPassword, hiveConf);
        }
        if (dbName.equalsIgnoreCase(DB_POSTGRACE)) {
            return new PostgresCommandParser(dbOpts, msUsername, msPassword, hiveConf);
        }
        if (dbName.equalsIgnoreCase(DB_ORACLE)) {
            return new OracleCommandParser(dbOpts, msUsername, msPassword, hiveConf);
        }
        throw new IllegalArgumentException("Unknown dbType " + dbName);
    }

    public static class MSSQLCommandParser
    extends AbstractCommandParser {
        private static String MSSQL_NESTING_TOKEN = ":r";

        public MSSQLCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            super(dbOpts, msUsername, msPassword, hiveConf);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1];
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MSSQL_NESTING_TOKEN);
        }
    }

    public static class OracleCommandParser
    extends AbstractCommandParser {
        private static String ORACLE_NESTING_TOKEN = "@";

        public OracleCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            super(dbOpts, msUsername, msPassword, hiveConf);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a nested script format " + dbCommand);
            }
            return dbCommand.replace(";", "").replace(ORACLE_NESTING_TOKEN, "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(ORACLE_NESTING_TOKEN);
        }
    }

    public static class PostgresCommandParser
    extends AbstractCommandParser {
        private static String POSTGRES_NESTING_TOKEN = "\\i";
        @VisibleForTesting
        public static String POSTGRES_STANDARD_STRINGS_OPT = "SET standard_conforming_strings";
        @VisibleForTesting
        public static String POSTGRES_SKIP_STANDARD_STRINGS_DBOPT = "postgres.filter.81";

        public PostgresCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            super(dbOpts, msUsername, msPassword, hiveConf);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(POSTGRES_NESTING_TOKEN);
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return true;
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            if (this.getDbOpts().contains(POSTGRES_SKIP_STANDARD_STRINGS_DBOPT) && dbCommand.startsWith(POSTGRES_STANDARD_STRINGS_OPT)) {
                return true;
            }
            return super.isNonExecCommand(dbCommand);
        }
    }

    public static class MySqlCommandParser
    extends AbstractCommandParser {
        private static final String MYSQL_NESTING_TOKEN = "SOURCE";
        private static final String DELIMITER_TOKEN = "DELIMITER";
        private String delimiter = ";";

        public MySqlCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            super(dbOpts, msUsername, msPassword, hiveConf);
        }

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            boolean isPartial = super.isPartialCommand(dbCommand);
            if (dbCommand.startsWith(DELIMITER_TOKEN)) {
                String[] tokens = dbCommand.split(" ");
                if (tokens.length != 2) {
                    throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
                }
                this.delimiter = tokens[1];
            }
            return isPartial;
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(MYSQL_NESTING_TOKEN);
        }

        @Override
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return super.isNonExecCommand(dbCommand) || dbCommand.startsWith("/*") && dbCommand.endsWith("*/") || dbCommand.startsWith(DELIMITER_TOKEN);
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            return super.cleanseCommand(dbCommand).replaceAll("/\\*.*?\\*/[^;]", "");
        }
    }

    public static class DerbyCommandParser
    extends AbstractCommandParser {
        private static String DERBY_NESTING_TOKEN = "RUN";

        public DerbyCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            super(dbOpts, msUsername, msPassword, hiveConf);
        }

        @Override
        public String getScriptName(String dbCommand) throws IllegalArgumentException {
            if (!this.isNestedScript(dbCommand)) {
                throw new IllegalArgumentException("Not a script format " + dbCommand);
            }
            String[] tokens = dbCommand.split(" ");
            if (tokens.length != 2) {
                throw new IllegalArgumentException("Couldn't parse line " + dbCommand);
            }
            return tokens[1].replace(";", "").replaceAll("'", "");
        }

        @Override
        public boolean isNestedScript(String dbCommand) {
            return dbCommand.startsWith(DERBY_NESTING_TOKEN);
        }
    }

    private static abstract class AbstractCommandParser
    implements NestedScriptParser {
        private List<String> dbOpts;
        private String msUsername;
        private String msPassword;
        private HiveConf hiveConf;

        public AbstractCommandParser(String dbOpts, String msUsername, String msPassword, HiveConf hiveConf) {
            this.setDbOpts(dbOpts);
            this.msUsername = msUsername;
            this.msPassword = msPassword;
            this.hiveConf = hiveConf;
        }

        @Override
        public boolean isPartialCommand(String dbCommand) throws IllegalArgumentException {
            if (dbCommand == null || dbCommand.isEmpty()) {
                throw new IllegalArgumentException("invalid command line " + dbCommand);
            }
            return !(dbCommand = dbCommand.trim()).endsWith(this.getDelimiter()) && !this.isNonExecCommand(dbCommand);
        }

        @Override
        public boolean isNonExecCommand(String dbCommand) {
            return dbCommand.startsWith("--") || dbCommand.startsWith("#");
        }

        @Override
        public String getDelimiter() {
            return ";";
        }

        @Override
        public String cleanseCommand(String dbCommand) {
            if (dbCommand.endsWith(this.getDelimiter())) {
                dbCommand = dbCommand.substring(0, dbCommand.length() - this.getDelimiter().length());
            }
            return dbCommand;
        }

        @Override
        public boolean needsQuotedIdentifier() {
            return false;
        }

        @Override
        public String buildCommand(String scriptDir, String scriptFile) throws IllegalFormatException, IOException {
            String currLine;
            BufferedReader bfReader = new BufferedReader(new FileReader(scriptDir + File.separatorChar + scriptFile));
            StringBuilder sb = new StringBuilder();
            String currentCommand = null;
            while ((currLine = bfReader.readLine()) != null) {
                if ((currLine = currLine.trim()).isEmpty()) continue;
                currentCommand = currentCommand == null ? currLine : currentCommand + " " + currLine;
                if (this.isPartialCommand(currLine)) continue;
                if (!this.isNonExecCommand(currentCommand)) {
                    if (this.isNestedScript(currentCommand = this.cleanseCommand(currentCommand))) {
                        String currScript = this.getScriptName(currentCommand);
                        sb.append(this.buildCommand(scriptDir, currScript));
                    } else {
                        sb.append(currentCommand);
                        sb.append(System.getProperty("line.separator"));
                    }
                }
                currentCommand = null;
            }
            bfReader.close();
            return sb.toString();
        }

        private void setDbOpts(String dbOpts) {
            this.dbOpts = dbOpts != null ? Lists.newArrayList((Object[])dbOpts.split(",")) : Lists.newArrayList();
        }

        protected List<String> getDbOpts() {
            return this.dbOpts;
        }

        protected String getMsUsername() {
            return this.msUsername;
        }

        protected String getMsPassword() {
            return this.msPassword;
        }

        protected HiveConf getHiveConf() {
            return this.hiveConf;
        }
    }

    public static interface NestedScriptParser {
        public static final String DEFAUTL_DELIMITER = ";";

        public boolean isPartialCommand(String var1) throws IllegalArgumentException;

        public String getScriptName(String var1) throws IllegalArgumentException;

        public boolean isNestedScript(String var1);

        public boolean isNonExecCommand(String var1);

        public String getDelimiter();

        public String cleanseCommand(String var1);

        public boolean needsQuotedIdentifier();

        public String buildCommand(String var1, String var2) throws IllegalFormatException, IOException;

        public static enum CommandType {
            PARTIAL_STATEMENT,
            TERMINATED_STATEMENT,
            COMMENT;

        }
    }
}

