/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Tool;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.DelegationTokenCache;
import org.apache.hive.hcatalog.templeton.tool.JobSubmissionConstants;
import org.apache.hive.hcatalog.templeton.tool.LaunchMapper;
import org.apache.hive.hcatalog.templeton.tool.SingleInputFormat;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.apache.thrift.TException;

@InterfaceAudience.Private
public class TempletonControllerJob
extends Configured
implements Tool,
JobSubmissionConstants {
    private static final Log LOG = LogFactory.getLog(TempletonControllerJob.class);
    private final boolean secureMetastoreAccess;
    private final AppConfig appConf;
    private JobID submittedJobId;

    public TempletonControllerJob(boolean secureMetastoreAccess, AppConfig conf) {
        super(new Configuration((Configuration)conf));
        this.secureMetastoreAccess = secureMetastoreAccess;
        this.appConf = conf;
    }

    public String getSubmittedId() {
        if (this.submittedJobId == null) {
            return null;
        }
        return this.submittedJobId.toString();
    }

    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException, TException {
        String amJavaOpts;
        String amMemoryMB;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Preparing to submit job: " + Arrays.toString(args)));
        }
        Configuration conf = this.getConf();
        conf.set("templeton.args", TempletonUtils.encodeArray(args));
        String memoryMb = this.appConf.mapperMemoryMb();
        if (memoryMb != null && memoryMb.length() != 0) {
            conf.set("mapreduce.map.memory.mb", memoryMb);
        }
        if ((amMemoryMB = this.appConf.amMemoryMb()) != null && !amMemoryMB.isEmpty()) {
            conf.set("yarn.app.mapreduce.am.resource.mb", amMemoryMB);
        }
        if ((amJavaOpts = this.appConf.controllerAMChildOpts()) != null && !amJavaOpts.isEmpty()) {
            conf.set("yarn.app.mapreduce.am.command-opts", amJavaOpts);
        }
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set("user.name", user);
        Job job = new Job(conf);
        job.setJarByClass(LaunchMapper.class);
        job.setJobName(TempletonControllerJob.class.getSimpleName());
        job.setMapperClass(LaunchMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setInputFormatClass(SingleInputFormat.class);
        NullOutputFormat of = new NullOutputFormat();
        job.setOutputFormatClass(of.getClass());
        job.setNumReduceTasks(0);
        JobClient jc = new JobClient(new JobConf(job.getConfiguration()));
        if (UserGroupInformation.isSecurityEnabled()) {
            Token mrdt = jc.getDelegationToken(new Text("mr token"));
            job.getCredentials().addToken(new Text("mr token"), mrdt);
        }
        String metastoreTokenStrForm = this.addHMSToken(job, user);
        job.submit();
        this.submittedJobId = job.getJobID();
        if (metastoreTokenStrForm != null) {
            DelegationTokenCache.getStringFormTokenCache().storeDelegationToken(this.submittedJobId.toString(), metastoreTokenStrForm);
            LOG.debug((Object)("Added metastore delegation token for jobId=" + this.submittedJobId.toString() + " user=" + user));
        }
        return 0;
    }

    private String addHMSToken(Job job, String user) throws IOException, InterruptedException, TException {
        if (!this.secureMetastoreAccess) {
            return null;
        }
        Token hiveToken = new Token();
        String metastoreTokenStrForm = this.buildHcatDelegationToken(user);
        hiveToken.decodeFromUrlString(metastoreTokenStrForm);
        job.getCredentials().addToken(new Text("hcat"), hiveToken);
        return metastoreTokenStrForm;
    }

    private String buildHcatDelegationToken(String user) throws IOException, InterruptedException, TException {
        final HiveConf c = new HiveConf();
        LOG.debug((Object)("Creating hive metastore delegation token for user " + user));
        final UserGroupInformation ugi = UgiFactory.getUgi(user);
        UserGroupInformation real = ugi.getRealUser();
        return (String)real.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException, TException, InterruptedException {
                final IMetaStoreClient client = HCatUtil.getHiveMetastoreClient((HiveConf)c);
                return (String)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws IOException, TException, InterruptedException {
                        String u = ugi.getUserName();
                        return client.getDelegationToken(c.getUser(), u);
                    }
                });
            }
        });
    }
}

