/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.JsonBuilder;
import org.apache.hive.hcatalog.templeton.SimpleWebException;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;

public class VersionDelegator
extends TempletonDelegator {
    public VersionDelegator(AppConfig appConf) {
        super(appConf);
    }

    public Response getVersion(String module) throws IOException {
        if (module.toLowerCase().equals("hadoop")) {
            return this.getHadoopVersion();
        }
        if (module.toLowerCase().equals("hive")) {
            return this.getHiveVersion();
        }
        if (module.toLowerCase().equals("sqoop")) {
            return this.getSqoopVersion();
        }
        if (module.toLowerCase().equals("pig")) {
            return this.getPigVersion();
        }
        return SimpleWebException.buildMessage(404, null, "Unknown module " + module);
    }

    private Response getHadoopVersion() throws IOException {
        String version = VersionInfo.getVersion();
        return JsonBuilder.create().put("module", "hadoop").put("version", version).build();
    }

    private Response getHiveVersion() throws IOException {
        String version = HiveVersionInfo.getVersion();
        return JsonBuilder.create().put("module", "hive").put("version", version).build();
    }

    private Response getSqoopVersion() {
        return SimpleWebException.buildMessage(501, null, "Sqoop version request not yet implemented");
    }

    private Response getPigVersion() {
        return SimpleWebException.buildMessage(501, null, "Pig version request not yet implemented");
    }
}

