/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.MockPartitionExpressionForMetastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHiveMetaStoreGetMetaConf {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Logger LOG = LoggerFactory.getLogger(TestHiveMetaStoreGetMetaConf.class);
    private static HiveConf hiveConf;
    private HiveMetaStoreClient hmsc;

    @AfterClass
    public static void tearDown() throws Exception {
        LOG.info("Shutting down metastore.");
    }

    @BeforeClass
    public static void startMetaStoreServer() throws Exception {
        HiveConf metastoreConf = new HiveConf();
        metastoreConf.setClass(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS.varname, MockPartitionExpressionForMetastore.class, PartitionExpressionProxy.class);
        metastoreConf.setBoolVar(HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL_DDL, false);
        int msPort = MetaStoreUtils.startMetaStore((HiveConf)metastoreConf);
        hiveConf = new HiveConf(TestHiveMetaStoreGetMetaConf.class);
        hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://localhost:" + msPort);
        hiveConf.setVar(HiveConf.ConfVars.PREEXECHOOKS, "");
        hiveConf.setVar(HiveConf.ConfVars.POSTEXECHOOKS, "");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        hiveConf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, 10);
        System.setProperty(HiveConf.ConfVars.PREEXECHOOKS.varname, " ");
        System.setProperty(HiveConf.ConfVars.POSTEXECHOOKS.varname, " ");
    }

    @Before
    public void setup() throws MetaException {
        this.hmsc = new HiveMetaStoreClient(hiveConf);
    }

    @After
    public void closeClient() {
        if (this.hmsc != null) {
            this.hmsc.close();
        }
    }

    @Test
    public void testGetMetaConfDefault() throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL;
        String expected = metaConfVar.getDefaultValue();
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfDefaultEmptyString() throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN;
        String expected = "";
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfOverridden() throws MetaException, TException {
        HiveConf.ConfVars metaConfVar = HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL_DDL;
        String expected = "false";
        String actual = this.hmsc.getMetaConf(metaConfVar.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetMetaConfUnknownPreperty() throws MetaException, TException {
        String unknownPropertyName = "hive.meta.foo.bar";
        this.thrown.expect(MetaException.class);
        this.thrown.expectMessage("Invalid configuration key " + unknownPropertyName);
        this.hmsc.getMetaConf(unknownPropertyName);
    }
}

