/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hive.maprdb.json.BaseExplainTest;
import org.apache.hadoop.hive.maprdb.json.BaseSingleDeleteTest;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class SingleDeletePositiveTest
extends BaseSingleDeleteTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)SingleDeletePositiveTest.class.getName());

    public SingleDeletePositiveTest(String query) {
        super(query);
    }

    @Override
    @Before
    public void setup() throws HiveException {
        super.setup();
    }

    @Parameterized.Parameters
    public static Collection queries() throws IOException, URISyntaxException {
        ArrayList<String> queries = new ArrayList<String>();
        URL url = Resources.getResource((String)"single-delete-positive");
        File folder = new File(url.toURI());
        for (File file : folder.listFiles()) {
            queries.add(SingleDeletePositiveTest.readFile(file.getPath()));
        }
        ArrayList<String[]> arguments = new ArrayList<String[]>();
        for (String query : queries) {
            arguments.add(new String[]{query});
        }
        return arguments;
    }

    @Test
    public void testPositive() throws Exception {
        try {
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertTrue((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }
}

