/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDe;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDeUtils;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ojai.Document;
import org.ojai.types.ODate;
import org.ojai.types.OTimestamp;

public class MapRDBSerDeTest {
    private MapRDBSerDe serDe;

    @Before
    public void init() {
        this.serDe = new MapRDBSerDe();
    }

    @Test
    public void testString() throws SerDeException {
        String columnNames = "s";
        String columnTypes = "string";
        String value = "value";
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(String.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testInt() throws SerDeException {
        String columnNames = "i";
        String columnTypes = "int";
        Integer value = 1234;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value.intValue());
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Integer.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value.intValue());
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testBoolean() throws SerDeException {
        String columnNames = "bool";
        String columnTypes = "boolean";
        Boolean value = false;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value.booleanValue());
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Boolean.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value.booleanValue());
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testDouble() throws SerDeException {
        String columnNames = "doub";
        String columnTypes = "double";
        Double value = 1.1;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value.doubleValue());
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Double.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value.doubleValue());
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testFloat() throws SerDeException {
        String columnNames = "fl";
        String columnTypes = "float";
        Float value = Float.valueOf(1.1f);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value.floatValue());
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Float.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value.floatValue());
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testList() throws SerDeException {
        String columnNames = "a";
        String columnTypes = "array<string>";
        String innerValueOne = "first";
        String innerValueTwo = "second";
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(innerValueOne);
        expected.add(innerValueTwo);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(expected);
        Object actual = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertTrue((boolean)(actual instanceof List));
        List result = (List)actual;
        Assert.assertTrue((boolean)result.containsAll(expected));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(String.class);
        StandardListObjectInspector listInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)innerInspector);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, expected);
        Object serialized = this.serialize(columnNames, (ObjectInspector)listInspector, expected, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testMap() throws SerDeException {
        String columnNames = "m";
        String columnTypes = "map<string,int>";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String oneKey = "one";
        int oneValue = 10;
        map.put(oneKey, oneValue);
        String twoKey = "two";
        int twoValue = 20;
        map.put(twoKey, twoValue);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(map);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertThat(map, (Matcher)CoreMatchers.equalTo((Object)result));
        PrimitiveObjectInspector keyInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(String.class);
        PrimitiveObjectInspector valueInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Integer.class);
        StandardMapObjectInspector mapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyInspector, (ObjectInspector)valueInspector);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, map);
        Object serialized = this.serialize(columnNames, (ObjectInspector)mapInspector, map, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testStruct() throws SerDeException {
        String columnNames = "doc";
        String columnTypes = "struct<one:int,two:string>";
        Document value = MapRDBImpl.newDocument();
        int oneValue = 10;
        String twoValue = "key";
        value.set("one", oneValue);
        value.set("two", twoValue);
        ArrayList<Object> returned = new ArrayList<Object>();
        returned.add(oneValue);
        returned.add(twoValue);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, value);
        ArrayList ar = (ArrayList)result;
        Assert.assertEquals((long)ar.size(), (long)value.size());
        Assert.assertEquals(ar.get(0), (Object)value.getInt("one"));
        Assert.assertEquals(ar.get(1), (Object)value.getString("two"));
        ArrayList<PrimitiveObjectInspector> innerInspectorList = new ArrayList<PrimitiveObjectInspector>();
        innerInspectorList.add(PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Integer.class));
        innerInspectorList.add(PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(String.class));
        ArrayList<String> innerFieldsList = new ArrayList<String>();
        innerFieldsList.add("one");
        innerFieldsList.add("two");
        StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(innerFieldsList, innerInspectorList);
        StructObjectInspector oi = this.createObjectInspector(columnNames, (ObjectInspector)structInspector);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        ArrayList<ArrayList<Object>> obj = new ArrayList<ArrayList<Object>>();
        obj.add(returned);
        Writable serialized = this.serDe.serialize(obj, (ObjectInspector)oi);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testDate() throws SerDeException {
        String columnNames = "d";
        String columnTypes = "date";
        long dateNow = System.currentTimeMillis();
        Date sqlDate = new Date(dateNow);
        ODate value = new ODate(dateNow);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertEquals((Object)sqlDate.toString(), (Object)result.toString());
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Date.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, sqlDate, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testTimeStamp() throws SerDeException {
        String columnNames = "ts";
        String columnTypes = "timestamp";
        long dateNow = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(dateNow);
        OTimestamp value = new OTimestamp(dateNow);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertEquals((Object)result, (Object)timestamp);
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Timestamp.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, timestamp, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testTinyInt() throws SerDeException {
        String columnNames = "ti";
        String columnTypes = "tinyint";
        byte value = 12;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertEquals((Object)value, (Object)result);
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Byte.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testSmallInt() throws SerDeException {
        String columnNames = "si";
        String columnTypes = "smallint";
        short value = 12;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertEquals((Object)value, (Object)result);
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Short.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testBigInt() throws SerDeException {
        String columnNames = "bi";
        String columnTypes = "bigint";
        long value = 18273993L;
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertEquals((Object)value, (Object)result);
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(Long.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testBinary() throws SerDeException {
        String columnNames = "bin";
        String columnTypes = "binary";
        byte[] bytes = new byte[]{1, 2, 3, 125, 37, 64};
        ByteBuffer value = ByteBuffer.wrap(bytes);
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(value);
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertArrayEquals((byte[])bytes, (byte[])((byte[])result));
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(byte[].class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, bytes);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, bytes, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    @Test
    public void testNullValue() throws SerDeException {
        String columnNames = "s";
        String columnTypes = "string";
        String value = "null";
        KeyValue ojaiValue = DBValueBuilderImpl.KeyValueBuilder.initFromNull();
        Object result = this.deserialize(this.serDe, columnNames, columnTypes, ojaiValue);
        Assert.assertNull((Object)result);
        PrimitiveObjectInspector innerInspector = PrimitiveObjectInspectorFactory.getPrimitiveObjectInspectorFromClass(String.class);
        Document document = MapRDBImpl.newDocument();
        document.set(columnNames, value);
        Object serialized = this.serialize(columnNames, (ObjectInspector)innerInspector, value, this.serDe);
        Assert.assertThat((Object)new DocumentWritable(document), (Matcher)CoreMatchers.equalTo((Object)serialized));
    }

    private Object serialize(String columnNames, ObjectInspector innerInspector, Object value, MapRDBSerDe serDe) throws SerDeException {
        StructObjectInspector oi = this.createObjectInspector(columnNames, innerInspector);
        ArrayList<Object> obj = new ArrayList<Object>();
        obj.add(value);
        return serDe.serialize(obj, (ObjectInspector)oi);
    }

    private Object deserialize(MapRDBSerDe serDe, String columnNames, String columnTypes, Object value) throws SerDeException {
        Properties tblProperties = new Properties();
        tblProperties.setProperty("maprdb.column.id", "_id");
        tblProperties.setProperty("columns", columnNames);
        tblProperties.setProperty("columns.types", columnTypes);
        serDe.initialize(new Configuration(), tblProperties);
        return MapRDBSerDeUtils.deserializeField((Object)value, (TypeInfo)((TypeInfo)TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes).get(0)));
    }

    private StructObjectInspector createObjectInspector(String columnNames, ObjectInspector oi) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(columnNames);
        ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
        fieldInspectors.add(oi);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors);
    }
}

