/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;

public abstract class LlapAllocatorBuffer
extends LlapCacheableBuffer
implements MemoryBuffer {
    private final AtomicLong state = new AtomicLong(0L);
    public ByteBuffer byteBuffer;
    public int allocSize;
    static final int INCREF_EVICTED = -1;
    static final int INCREF_FAILED = -2;

    public void initialize(ByteBuffer byteBuffer, int offset, int length) {
        this.byteBuffer = byteBuffer.slice();
        this.byteBuffer.position(offset);
        this.byteBuffer.limit(offset + length);
        this.allocSize = length;
    }

    public void initializeWithExistingSlice(ByteBuffer byteBuffer, int allocSize) {
        this.byteBuffer = byteBuffer;
        this.allocSize = allocSize;
    }

    public void setNewAllocLocation(int arenaIx, int headerIx) {
        assert (this.state.get() == 0L) : "New buffer state is not 0 " + this;
        long newState = State.setFlag(State.setLocation(0L, arenaIx, headerIx), 16);
        if (!this.state.compareAndSet(0L, newState)) {
            throw new AssertionError((Object)("Contention on the new buffer " + this));
        }
    }

    public ByteBuffer getByteBufferDup() {
        return this.byteBuffer.duplicate();
    }

    public ByteBuffer getByteBufferRaw() {
        return this.byteBuffer;
    }

    @Override
    public long getMemoryUsage() {
        return this.allocSize;
    }

    public int incRef() {
        return this.incRefInternal(true);
    }

    int tryIncRef() {
        return this.incRefInternal(false);
    }

    private int incRefInternal(boolean doWait) {
        long newValue = -1L;
        while (true) {
            long oldValue;
            if (State.hasFlags(oldValue = this.state.get(), 2)) {
                return -1;
            }
            if (State.hasFlags(oldValue, 1)) {
                if (doWait && this.waitForState()) continue;
                return -2;
            }
            int oldRefCount = State.getRefCount(oldValue);
            assert (oldRefCount >= 0) : "oldValue is " + oldValue + " " + this;
            if ((long)oldRefCount == 524287L) {
                throw new AssertionError(this);
            }
            newValue = State.incRefCount(oldValue);
            if (State.hasFlags(oldValue, 16)) {
                newValue = State.switchFlag(newValue, 16);
            }
            if (this.state.compareAndSet(oldValue, newValue)) break;
        }
        int newRefCount = State.getRefCount(newValue);
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Locked {}; new ref count {}", (Object)this, (Object)newRefCount);
        }
        return newRefCount;
    }

    @VisibleForTesting
    int getRefCount() {
        return State.getRefCount(this.state.get());
    }

    @Override
    @VisibleForTesting
    public boolean isLocked() {
        return State.getRefCount(this.state.get()) > 0;
    }

    @VisibleForTesting
    public boolean isInvalid() {
        return State.hasFlags(this.state.get(), 2);
    }

    public int decRef() {
        long newState;
        long oldState;
        do {
            int oldRefCount;
            if ((oldRefCount = State.getRefCount(oldState = this.state.get())) == 0) {
                throw new AssertionError((Object)("Invalid decRef when refCount is 0: " + this));
            }
        } while (!this.state.compareAndSet(oldState, newState = State.decRefCount(oldState)));
        int newRefCount = State.getRefCount(newState);
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Unlocked {}; refcount {}", (Object)this, (Object)newRefCount);
        }
        return newRefCount;
    }

    @Override
    public int invalidate() {
        long newValue;
        long oldValue;
        do {
            if (State.getRefCount(oldValue = this.state.get()) != 0) {
                return 1;
            }
            if (!State.hasFlags(oldValue, 2)) continue;
            return 2;
        } while (!this.state.compareAndSet(oldValue, newValue = State.setFlag(oldValue, 10)));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Invalidated {} due to eviction", (Object)this);
        }
        return 0;
    }

    public int invalidateAndRelease() {
        boolean result;
        long newValue;
        long oldValue;
        do {
            result = false;
            oldValue = this.state.get();
            if (State.getRefCount(oldValue) != 0) {
                throw new AssertionError((Object)("Refcount is " + State.getRefCount(oldValue)));
            }
            if (State.hasFlags(oldValue, 2)) {
                return -1;
            }
            newValue = State.setFlag(oldValue, 2);
            if (State.hasFlags(oldValue, 1)) continue;
            newValue = State.setFlag(newValue, 12);
            result = true;
        } while (!this.state.compareAndSet(oldValue, newValue));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Invalidated {} due to direct deallocation", (Object)this);
        }
        return result ? State.getArena(oldValue) : -1;
    }

    public int releaseInvalidated() {
        long newValue;
        long oldValue;
        do {
            if (!State.hasFlags(oldValue = this.state.get(), 2)) {
                throw new AssertionError((Object)"Not invalidated");
            }
            if (!State.hasFlags(oldValue, 5)) continue;
            return -1;
        } while (!this.state.compareAndSet(oldValue, newValue = State.setFlag(oldValue, 4)));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Removed {}", (Object)this);
        }
        return State.getArena(oldValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForState() {
        AtomicLong atomicLong = this.state;
        synchronized (atomicLong) {
            try {
                this.state.wait(10L);
                return true;
            }
            catch (InterruptedException e) {
                LlapIoImpl.LOG.debug("Buffer incRef is deffering an interrupt");
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    @Override
    public String toString() {
        long state = this.state.get();
        int flags = State.getAllFlags(state);
        return "0x" + Integer.toHexString(System.identityHashCode(this)) + "(" + State.getRefCount(state) + (String)(flags == 0 ? "" : ", " + State.toFlagString(flags)) + ")";
    }

    public String toDebugString() {
        return this.toDebugString(this.state.get());
    }

    private String toDebugString(long state) {
        return "0x" + Integer.toHexString(System.identityHashCode(this)) + "(" + State.getArena(state) + ":" + State.getHeader(state) + "; " + this.allocSize + "; " + State.toFlagString(State.getAllFlags(state)) + ")";
    }

    public boolean startMoveOrDiscard(int arenaIx, int headerIx, boolean isForceDiscard) {
        long newValue;
        long oldValue;
        do {
            if (State.getRefCount(oldValue = this.state.get()) != 0) {
                return false;
            }
            int flags = State.getAllFlags(oldValue);
            if (flags != 0 && (isForceDiscard || flags != 16)) {
                return false;
            }
            if (State.getArena(oldValue) == arenaIx && State.getHeader(oldValue) == headerIx) continue;
            return false;
        } while (!this.state.compareAndSet(oldValue, newValue = State.setFlag(oldValue, 1)));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Locked {} in preparation for a move", (Object)this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean cancelDiscard() {
        Boolean result;
        long newValue;
        long oldValue;
        do {
            oldValue = this.state.get();
            assert (State.hasFlags(oldValue, 1)) : this.toDebugString();
            newValue = State.switchFlag(oldValue, 1);
            result = null;
            if (!State.hasFlags(oldValue, 2)) continue;
            if (State.hasFlags(oldValue, 4)) {
                throw new AssertionError((Object)("Removed during the move " + this));
            }
            result = !State.hasFlags(oldValue, 8);
            newValue = State.setFlag(newValue, 12);
        } while (!this.state.compareAndSet(oldValue, newValue));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Move ended for {}", (Object)this);
        }
        AtomicLong atomicLong = this.state;
        synchronized (atomicLong) {
            this.state.notifyAll();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean endDiscard() {
        Boolean result;
        long newValue;
        long oldValue;
        do {
            oldValue = this.state.get();
            assert (State.hasFlags(oldValue, 1));
            newValue = State.switchFlag(oldValue, 1);
            newValue = State.setFlag(newValue, 14);
            result = null;
            if (!State.hasFlags(oldValue, 2)) continue;
            if (State.hasFlags(oldValue, 4)) {
                throw new AssertionError((Object)("Removed during the move " + this));
            }
            result = !State.hasFlags(oldValue, 8);
        } while (!this.state.compareAndSet(oldValue, newValue));
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Discared {}", (Object)this);
        }
        AtomicLong atomicLong = this.state;
        synchronized (atomicLong) {
            this.state.notifyAll();
        }
        return result;
    }

    @VisibleForTesting
    int getArenaIndex() {
        return State.getArena(this.state.get());
    }

    private static final class State {
        public static final int FLAG_MOVING = 1;
        public static final int FLAG_EVICTED = 2;
        public static final int FLAG_REMOVED = 4;
        public static final int FLAG_MEM_RELEASED = 8;
        public static final int FLAG_NEW_ALLOC = 16;
        private static final int FLAGS_WIDTH = 5;
        private static final int REFCOUNT_WIDTH = 19;
        private static final int ARENA_WIDTH = 16;
        private static final int HEADER_WIDTH = 24;
        public static final long MAX_REFCOUNT = 524287L;
        private static final int REFCOUNT_SHIFT = 5;
        private static final int ARENA_SHIFT = 24;
        private static final int HEADER_SHIFT = 40;
        private static final long FLAGS_MASK = 31L;
        private static final long REFCOUNT_MASK = 0xFFFFE0L;
        private static final long ARENA_MASK = 0xFFFF000000L;
        private static final long HEADER_MASK = -1099511627776L;

        private State() {
        }

        public static boolean hasFlags(long value, int flags) {
            return (value & (long)flags) != 0L;
        }

        public static int getAllFlags(long state) {
            return (int)(state & 0x1FL);
        }

        public static final int getRefCount(long state) {
            return (int)((state & 0xFFFFE0L) >>> 5);
        }

        public static final int getArena(long state) {
            return (int)((state & 0xFFFF000000L) >>> 24);
        }

        public static final int getHeader(long state) {
            return (int)((state & 0xFFFFFF0000000000L) >>> 40);
        }

        public static final long incRefCount(long state) {
            return state + 32L;
        }

        public static final long decRefCount(long state) {
            return state - 32L;
        }

        public static final long setLocation(long state, int arenaIx, int headerIx) {
            long arenaVal = (long)arenaIx << 24;
            long arenaWMask = arenaVal & 0xFFFF000000L;
            long headerVal = (long)headerIx << 40;
            long headerWMask = headerVal & 0xFFFFFF0000000000L;
            assert (arenaVal == arenaWMask) : "Arena " + arenaIx + " is wider than 16";
            assert (headerVal == headerWMask) : "Header " + headerIx + " is wider than 24";
            return state & 0xFFFFFFL | arenaWMask | headerWMask;
        }

        public static final long setFlag(long state, int flags) {
            assert ((long)flags <= 31L);
            return state | (long)flags;
        }

        public static final long switchFlag(long state, int flags) {
            assert ((long)flags <= 31L);
            return state ^ (long)flags;
        }

        public static String toFlagString(int state) {
            return StringUtils.leftPad((String)Integer.toBinaryString(state), (int)5, (char)'0');
        }
    }
}

