/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LlapStatusHelpers {

    public static final class AppStatusBuilder {
        private AmInfo amInfo;
        private State state = State.UNKNOWN;
        private String diagnostics;
        private String originalConfigurationPath;
        private String generatedConfigurationPath;
        private Integer desiredInstances = null;
        private Integer liveInstances = null;
        private Integer launchingInstances = null;
        private Long appStartTime;
        private Long appFinishTime;
        private boolean runningThresholdAchieved = false;
        private final List<LlapInstance> runningInstances = new LinkedList<LlapInstance>();
        private final List<LlapInstance> completedInstances = new LinkedList<LlapInstance>();
        private final transient Map<String, LlapInstance> containerToRunningInstanceMap = new HashMap<String, LlapInstance>();
        private final transient Map<String, LlapInstance> containerToCompletedInstanceMap = new HashMap<String, LlapInstance>();

        public void setAmInfo(AmInfo amInfo) {
            this.amInfo = amInfo;
        }

        public AppStatusBuilder setState(State state) {
            this.state = state;
            return this;
        }

        public AppStatusBuilder setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public AppStatusBuilder setOriginalConfigurationPath(String originalConfigurationPath) {
            this.originalConfigurationPath = originalConfigurationPath;
            return this;
        }

        public AppStatusBuilder setGeneratedConfigurationPath(String generatedConfigurationPath) {
            this.generatedConfigurationPath = generatedConfigurationPath;
            return this;
        }

        public AppStatusBuilder setAppStartTime(long appStartTime) {
            this.appStartTime = appStartTime;
            return this;
        }

        public AppStatusBuilder setAppFinishTime(long finishTime) {
            this.appFinishTime = finishTime;
            return this;
        }

        public void setRunningThresholdAchieved(boolean runningThresholdAchieved) {
            this.runningThresholdAchieved = runningThresholdAchieved;
        }

        public AppStatusBuilder setDesiredInstances(int desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public AppStatusBuilder setLiveInstances(int liveInstances) {
            this.liveInstances = liveInstances;
            return this;
        }

        public AppStatusBuilder setLaunchingInstances(int launchingInstances) {
            this.launchingInstances = launchingInstances;
            return this;
        }

        public AppStatusBuilder addNewRunningLlapInstance(LlapInstance llapInstance) {
            this.runningInstances.add(llapInstance);
            this.containerToRunningInstanceMap.put(llapInstance.getContainerId(), llapInstance);
            return this;
        }

        public LlapInstance removeAndGetRunningLlapInstanceForContainer(String containerIdString) {
            return this.containerToRunningInstanceMap.remove(containerIdString);
        }

        public void clearRunningLlapInstances() {
            this.runningInstances.clear();
            this.containerToRunningInstanceMap.clear();
        }

        public AppStatusBuilder clearAndAddPreviouslyKnownRunningInstances(List<LlapInstance> llapInstances) {
            this.clearRunningLlapInstances();
            for (LlapInstance llapInstance : llapInstances) {
                this.addNewRunningLlapInstance(llapInstance);
            }
            return this;
        }

        @JsonIgnore
        public List<LlapInstance> allRunningInstances() {
            return this.runningInstances;
        }

        public AppStatusBuilder addNewCompleteLlapInstance(LlapInstance llapInstance) {
            this.completedInstances.add(llapInstance);
            this.containerToCompletedInstanceMap.put(llapInstance.getContainerId(), llapInstance);
            return this;
        }

        public LlapInstance removeAndGetCompletedLlapInstanceForContainer(String containerIdString) {
            return this.containerToCompletedInstanceMap.remove(containerIdString);
        }

        public void clearCompletedLlapInstances() {
            this.completedInstances.clear();
            this.containerToCompletedInstanceMap.clear();
        }

        public AppStatusBuilder clearAndAddPreviouslyKnownCompletedInstances(List<LlapInstance> llapInstances) {
            this.clearCompletedLlapInstances();
            for (LlapInstance llapInstance : llapInstances) {
                this.addNewCompleteLlapInstance(llapInstance);
            }
            return this;
        }

        @JsonIgnore
        public List<LlapInstance> allCompletedInstances() {
            return this.completedInstances;
        }

        public AmInfo getAmInfo() {
            return this.amInfo;
        }

        public State getState() {
            return this.state;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public String getOriginalConfigurationPath() {
            return this.originalConfigurationPath;
        }

        public String getGeneratedConfigurationPath() {
            return this.generatedConfigurationPath;
        }

        public Integer getDesiredInstances() {
            return this.desiredInstances;
        }

        public Integer getLiveInstances() {
            return this.liveInstances;
        }

        public Integer getLaunchingInstances() {
            return this.launchingInstances;
        }

        public Long getAppStartTime() {
            return this.appStartTime;
        }

        public Long getAppFinishTime() {
            return this.appFinishTime;
        }

        public boolean isRunningThresholdAchieved() {
            return this.runningThresholdAchieved;
        }

        public List<LlapInstance> getRunningInstances() {
            return this.runningInstances;
        }

        public List<LlapInstance> getCompletedInstances() {
            return this.completedInstances;
        }

        @JsonIgnore
        public AmInfo maybeCreateAndGetAmInfo() {
            if (this.amInfo == null) {
                this.amInfo = new AmInfo();
            }
            return this.amInfo;
        }

        public String toString() {
            return "AppStatusBuilder{amInfo=" + this.amInfo + ", state=" + this.state + ", diagnostics=" + this.diagnostics + ", originalConfigurationPath='" + this.originalConfigurationPath + "', generatedConfigurationPath='" + this.generatedConfigurationPath + "', desiredInstances=" + this.desiredInstances + ", liveInstances=" + this.liveInstances + ", launchingInstances=" + this.launchingInstances + ", appStartTime=" + this.appStartTime + ", appFinishTime=" + this.appFinishTime + ", runningThresholdAchieved=" + this.runningThresholdAchieved + ", runningInstances=" + this.runningInstances + ", completedInstances=" + this.completedInstances + ", containerToRunningInstanceMap=" + this.containerToRunningInstanceMap + "}";
        }
    }

    public static class LlapInstance {
        private final String hostname;
        private final String containerId;
        private String logUrl;
        private String statusUrl;
        private String webUrl;
        private Integer rpcPort;
        private Integer mgmtPort;
        private Integer shufflePort;
        private String diagnostics;
        private int yarnContainerExitStatus;

        public LlapInstance(String hostname, String containerId) {
            this.hostname = hostname;
            this.containerId = containerId;
        }

        public LlapInstance setLogUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public LlapInstance setWebUrl(String webUrl) {
            this.webUrl = webUrl;
            return this;
        }

        public LlapInstance setStatusUrl(String statusUrl) {
            this.statusUrl = statusUrl;
            return this;
        }

        public LlapInstance setRpcPort(int rpcPort) {
            this.rpcPort = rpcPort;
            return this;
        }

        public LlapInstance setMgmtPort(int mgmtPort) {
            this.mgmtPort = mgmtPort;
            return this;
        }

        public LlapInstance setShufflePort(int shufflePort) {
            this.shufflePort = shufflePort;
            return this;
        }

        public LlapInstance setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public LlapInstance setYarnContainerExitStatus(int yarnContainerExitStatus) {
            this.yarnContainerExitStatus = yarnContainerExitStatus;
            return this;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getLogUrl() {
            return this.logUrl;
        }

        public String getStatusUrl() {
            return this.statusUrl;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public Integer getRpcPort() {
            return this.rpcPort;
        }

        public Integer getMgmtPort() {
            return this.mgmtPort;
        }

        public Integer getShufflePort() {
            return this.shufflePort;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public int getYarnContainerExitStatus() {
            return this.yarnContainerExitStatus;
        }

        public String toString() {
            return "LlapInstance{hostname='" + this.hostname + "'logUrl=" + this.logUrl + "', containerId='" + this.containerId + "', statusUrl='" + this.statusUrl + "', webUrl='" + this.webUrl + "', rpcPort=" + this.rpcPort + ", mgmtPort=" + this.mgmtPort + ", shufflePort=" + this.shufflePort + ", diagnostics=" + this.diagnostics + ", yarnContainerExitStatus=" + this.yarnContainerExitStatus + "}";
        }
    }

    public static class AmInfo {
        private String appName;
        private String appType;
        private String appId;
        private String containerId;
        private String hostname;
        private String amWebUrl;

        public AmInfo setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public AmInfo setAppType(String appType) {
            this.appType = appType;
            return this;
        }

        public AmInfo setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public AmInfo setContainerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        public AmInfo setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public AmInfo setAmWebUrl(String amWebUrl) {
            this.amWebUrl = amWebUrl;
            return this;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppType() {
            return this.appType;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getAmWebUrl() {
            return this.amWebUrl;
        }

        public String toString() {
            return "AmInfo{appName='" + this.appName + "', appType='" + this.appType + "', appId='" + this.appId + "', containerId='" + this.containerId + "', hostname='" + this.hostname + "', amWebUrl='" + this.amWebUrl + "'}";
        }
    }

    public static enum State {
        APP_NOT_FOUND,
        LAUNCHING,
        RUNNING_PARTIAL,
        RUNNING_ALL,
        COMPLETE,
        UNKNOWN;

    }
}

