/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.log;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="LlapRandomAccessFileAppender", category="Core", elementType="appender", printObject=true)
public final class LlapRandomAccessFileAppender
extends AbstractOutputStreamAppender<RandomAccessFileManager> {
    private static final String RENAME_SUFFIX = ".done";
    private final AtomicBoolean renameOnStop = new AtomicBoolean(false);

    protected LlapRandomAccessFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, RandomAccessFileManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, (OutputStreamManager)manager);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        if (this.renameOnStop.get()) {
            this.rename();
        }
        this.setStopped();
        return true;
    }

    private void rename() {
        String currentName = ((RandomAccessFileManager)this.getManager()).getFileName();
        Path newFileName = this.findRenamePath();
        try {
            LOGGER.trace("Renaming file: {} to {}", (Object)currentName, (Object)newFileName);
            Files.move(Paths.get(currentName, new String[0]), newFileName, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to rename file: " + currentName + " to " + newFileName, (Throwable)e);
        }
    }

    private Path findRenamePath() {
        Path renamedPath;
        int i = 0;
        do {
            Object suffix = i == 0 ? RENAME_SUFFIX : i + RENAME_SUFFIX;
            renamedPath = Paths.get(((RandomAccessFileManager)this.getManager()).getFileName() + (String)suffix, new String[0]);
            ++i;
        } while (Files.exists(renamedPath, new LinkOption[0]));
        return renamedPath;
    }

    public void append(LogEvent event) {
        if (event.getMarker() != null && event.getMarker().getName().equals("EOF_MARKER")) {
            this.renameOnStop.set(true);
            return;
        }
        ((RandomAccessFileManager)this.getManager()).setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LlapRandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;

        public LlapRandomAccessFileAppender build() {
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for FileAppender");
                return null;
            }
            if (this.fileName == null) {
                LOGGER.error("No filename provided for FileAppender with name " + name);
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            boolean immediateFlush = this.isImmediateFlush();
            RandomAccessFileManager manager = RandomAccessFileManager.getFileManager((String)this.fileName, (boolean)this.append, (boolean)immediateFlush, (int)this.getBufferSize(), null, (Layout)layout, null);
            if (manager == null) {
                return null;
            }
            return new LlapRandomAccessFileAppender(name, (Layout<? extends Serializable>)layout, this.getFilter(), this.isIgnoreExceptions(), immediateFlush, manager);
        }

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

