/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.llap.IncrementalObjectSizeEstimator;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileFormatException;
import org.apache.orc.FileMetadata;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ReaderImpl;

public final class OrcFileMetadata
extends LlapCacheableBuffer
implements FileMetadata,
ConsumerFileMetadata {
    private final List<StripeInformation> stripes;
    private final List<Integer> versionList;
    private final List<OrcProto.StripeStatistics> stripeStats;
    private final List<OrcProto.Type> types;
    private final List<OrcProto.ColumnStatistics> fileStats;
    private final Object fileKey;
    private final CompressionKind compressionKind;
    private final int rowIndexStride;
    private final int compressionBufferSize;
    private final int metadataSize;
    private final int writerVersionNum;
    private final long contentLength;
    private final long numberOfRows;
    private final boolean isOriginalFormat;
    private final int estimatedMemUsage;
    private static final HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> SIZE_ESTIMATORS;
    private static final IncrementalObjectSizeEstimator.ObjectEstimator SIZE_ESTIMATOR;

    @VisibleForTesting
    public static OrcFileMetadata createDummy(Object fileKey) {
        OrcFileMetadata ofm = new OrcFileMetadata(fileKey);
        ofm.stripes.add((StripeInformation)new ReaderImpl.StripeInformationImpl(OrcProto.StripeInformation.getDefaultInstance()));
        ofm.fileStats.add(OrcProto.ColumnStatistics.getDefaultInstance());
        ofm.stripeStats.add(OrcProto.StripeStatistics.newBuilder().addColStats(OrcFileMetadata.createStatsDummy()).build());
        ofm.types.add(OrcProto.Type.newBuilder().addFieldNames("a").addSubtypes(0).build());
        ofm.versionList.add(0);
        return ofm;
    }

    static OrcProto.ColumnStatistics.Builder createStatsDummy() {
        return OrcProto.ColumnStatistics.newBuilder().setBucketStatistics(OrcProto.BucketStatistics.newBuilder().addCount(0L)).setStringStatistics(OrcProto.StringStatistics.newBuilder().setMaximum("zzz"));
    }

    private OrcFileMetadata(Object fileKey) {
        this.fileKey = fileKey;
        this.stripes = new ArrayList<StripeInformation>();
        this.versionList = new ArrayList<Integer>();
        this.fileStats = new ArrayList<OrcProto.ColumnStatistics>();
        this.stripeStats = new ArrayList<OrcProto.StripeStatistics>();
        this.types = new ArrayList<OrcProto.Type>();
        this.rowIndexStride = 0;
        this.compressionBufferSize = 0;
        this.metadataSize = 0;
        this.writerVersionNum = 0;
        this.numberOfRows = 0L;
        this.contentLength = 0L;
        this.estimatedMemUsage = 0;
        this.isOriginalFormat = false;
        this.compressionKind = CompressionKind.NONE;
    }

    public OrcFileMetadata(Object fileKey, Reader reader) {
        this.fileKey = fileKey;
        this.stripeStats = reader.getOrcProtoStripeStatistics();
        this.compressionKind = reader.getCompressionKind();
        this.compressionBufferSize = reader.getCompressionSize();
        this.stripes = reader.getStripes();
        this.isOriginalFormat = OrcInputFormat.isOriginal((Reader)reader);
        this.writerVersionNum = reader.getWriterVersion().getId();
        this.versionList = reader.getVersionList();
        this.metadataSize = reader.getMetadataSize();
        this.types = reader.getTypes();
        this.rowIndexStride = reader.getRowIndexStride();
        this.contentLength = reader.getContentLength();
        this.numberOfRows = reader.getNumberOfRows();
        this.fileStats = reader.getOrcProtoFileStatistics();
        this.estimatedMemUsage = SIZE_ESTIMATOR.estimate(this, SIZE_ESTIMATORS);
    }

    @Override
    public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
        evictionDispatcher.notifyEvicted(this);
    }

    @Override
    protected boolean invalidate() {
        return true;
    }

    @Override
    public long getMemoryUsage() {
        return this.estimatedMemUsage;
    }

    @Override
    protected boolean isLocked() {
        return false;
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.types;
    }

    public boolean isOriginalFormat() {
        return this.isOriginalFormat;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    @Override
    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public int getCompressionBufferSize() {
        return this.compressionBufferSize;
    }

    public int getRowIndexStride() {
        return this.rowIndexStride;
    }

    public int getColumnCount() {
        return this.types.size();
    }

    public int getFlattenedColumnCount() {
        return this.types.get(0).getSubtypesCount();
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    public List<Integer> getVersionList() {
        return this.versionList;
    }

    public int getMetadataSize() {
        return this.metadataSize;
    }

    public int getWriterImplementation() {
        return OrcFile.WriterImplementation.ORC_JAVA.getId();
    }

    public int getWriterVersionNum() {
        return this.writerVersionNum;
    }

    public List<OrcProto.StripeStatistics> getStripeStats() {
        return this.stripeStats;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public List<OrcProto.ColumnStatistics> getFileStats() {
        return this.fileStats;
    }

    @Override
    public int getStripeCount() {
        return this.stripes.size();
    }

    @Override
    public TypeDescription getSchema() throws FileFormatException {
        return OrcUtils.convertTypeFromProtobuf(this.types, (int)0);
    }

    static {
        OrcFileMetadata ofm = OrcFileMetadata.createDummy(new SyntheticFileId());
        SIZE_ESTIMATORS = IncrementalObjectSizeEstimator.createEstimators(ofm);
        IncrementalObjectSizeEstimator.addEstimator("com.google.protobuf.LiteralByteString", SIZE_ESTIMATORS);
        IncrementalObjectSizeEstimator.createEstimators(Long.class, SIZE_ESTIMATORS);
        SIZE_ESTIMATOR = SIZE_ESTIMATORS.get(OrcFileMetadata.class);
    }
}

