/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcMetadataCache {
    @Test
    public void testGetPut() throws Exception {
        DummyMemoryManager mm = new DummyMemoryManager();
        DummyCachePolicy cp = new DummyCachePolicy();
        OrcMetadataCache cache = new OrcMetadataCache((MemoryManager)mm, (LowLevelCachePolicy)cp, false);
        OrcFileMetadata ofm1 = OrcFileMetadata.createDummy((Object)1);
        OrcFileMetadata ofm2 = OrcFileMetadata.createDummy((Object)2);
        Assert.assertSame((Object)ofm1, (Object)cache.putFileMetadata(ofm1));
        Assert.assertEquals((long)1L, (long)mm.allocs);
        cp.verifyEquals(1);
        Assert.assertSame((Object)ofm2, (Object)cache.putFileMetadata(ofm2));
        Assert.assertEquals((long)2L, (long)mm.allocs);
        cp.verifyEquals(2);
        Assert.assertSame((Object)ofm1, (Object)cache.getFileMetadata((Object)1));
        Assert.assertSame((Object)ofm2, (Object)cache.getFileMetadata((Object)2));
        cp.verifyEquals(4);
        OrcFileMetadata ofm3 = OrcFileMetadata.createDummy((Object)1);
        Assert.assertSame((Object)ofm1, (Object)cache.putFileMetadata(ofm3));
        Assert.assertEquals((long)2L, (long)mm.allocs);
        cp.verifyEquals(5);
        Assert.assertSame((Object)ofm1, (Object)cache.getFileMetadata((Object)1));
        cp.verifyEquals(6);
        OrcStripeMetadata osm1 = OrcStripeMetadata.createDummy((Object)1);
        OrcStripeMetadata osm2 = OrcStripeMetadata.createDummy((Object)2);
        Assert.assertSame((Object)osm1, (Object)cache.putStripeMetadata(osm1));
        Assert.assertEquals((long)3L, (long)mm.allocs);
        Assert.assertSame((Object)osm2, (Object)cache.putStripeMetadata(osm2));
        Assert.assertEquals((long)4L, (long)mm.allocs);
        Assert.assertSame((Object)osm1, (Object)cache.getStripeMetadata(osm1.getKey()));
        Assert.assertSame((Object)osm2, (Object)cache.getStripeMetadata(osm2.getKey()));
        OrcStripeMetadata osm3 = OrcStripeMetadata.createDummy((Object)1);
        Assert.assertSame((Object)osm1, (Object)cache.putStripeMetadata(osm3));
        Assert.assertEquals((long)4L, (long)mm.allocs);
        Assert.assertSame((Object)osm1, (Object)cache.getStripeMetadata(osm3.getKey()));
        cp.verifyEquals(12);
    }

    private static class DummyMemoryManager
    implements MemoryManager {
        int allocs = 0;

        private DummyMemoryManager() {
        }

        public void reserveMemory(long memoryToReserve) {
            ++this.allocs;
        }

        public void releaseMemory(long memUsage) {
            --this.allocs;
        }

        public String debugDumpForOom() {
            return "";
        }

        public void updateMaxSize(long maxSize) {
        }

        public long forceReservedMemory(int allocationSize, int count) {
            return allocationSize * count;
        }
    }

    private static class DummyCachePolicy
    implements LowLevelCachePolicy {
        int lockCount = 0;
        int unlockCount = 0;

        private DummyCachePolicy() {
        }

        public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
            ++this.lockCount;
        }

        public void notifyLock(LlapCacheableBuffer buffer) {
            ++this.lockCount;
        }

        public void notifyUnlock(LlapCacheableBuffer buffer) {
            ++this.unlockCount;
        }

        public long evictSomeBlocks(long memoryToReserve) {
            return memoryToReserve;
        }

        public void setEvictionListener(EvictionListener listener) {
        }

        public String debugDumpForOom() {
            return "";
        }

        public void setParentDebugDumper(LlapOomDebugDump dumper) {
        }

        public void verifyEquals(int i) {
            Assert.assertEquals((long)i, (long)this.lockCount);
            Assert.assertEquals((long)i, (long)this.unlockCount);
        }

        public long tryEvictContiguousData(int allocationSize, int count) {
            return 0L;
        }
    }
}

