/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.conf;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.storage.jdbc.QueryConditionBuilder;
import org.apache.hive.storage.jdbc.conf.CustomConfigManager;
import org.apache.hive.storage.jdbc.conf.CustomConfigManagerFactory;
import org.apache.hive.storage.jdbc.conf.DatabaseType;
import org.apache.hive.storage.jdbc.conf.JdbcStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcStorageConfigManager.class);
    public static final String CONFIG_PREFIX = "hive.sql";
    public static final String CONFIG_PWD = "hive.sql.dbcp.password";
    public static final String CONFIG_USERNAME = "hive.sql.dbcp.username";
    private static final EnumSet<JdbcStorageConfig> DEFAULT_REQUIRED_PROPERTIES = EnumSet.of(JdbcStorageConfig.DATABASE_TYPE, JdbcStorageConfig.JDBC_URL, JdbcStorageConfig.JDBC_DRIVER_CLASS);
    private static final EnumSet<JdbcStorageConfig> METASTORE_REQUIRED_PROPERTIES = EnumSet.of(JdbcStorageConfig.DATABASE_TYPE, JdbcStorageConfig.QUERY);

    private JdbcStorageConfigManager() {
    }

    public static void copyConfigurationToJob(Properties props, Map<String, String> jobProps) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (String.valueOf(entry.getKey()).equals(CONFIG_PWD)) continue;
            jobProps.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
    }

    public static void copySecretsToJob(Properties props, Map<String, String> jobSecrets) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        String secret = props.getProperty(CONFIG_PWD);
        if (secret != null) {
            jobSecrets.put(CONFIG_PWD, secret);
        }
    }

    public static Configuration convertPropertiesToConfiguration(Properties props) throws HiveException, IOException {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        JdbcStorageConfigManager.resolveMetadata(props);
        Configuration conf = new Configuration();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            conf.set(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return conf;
    }

    private static void checkRequiredPropertiesAreDefined(Properties props) {
        DatabaseType dbType = null;
        try {
            String dbTypeName = props.getProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName());
            dbType = DatabaseType.valueOf(dbTypeName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown database type.", e);
        }
        for (JdbcStorageConfig configKey : DatabaseType.METASTORE.equals((Object)dbType) ? METASTORE_REQUIRED_PROPERTIES : DEFAULT_REQUIRED_PROPERTIES) {
            String propertyKey = configKey.getPropertyName();
            if (props != null && props.containsKey(propertyKey) && !JdbcStorageConfigManager.isEmptyString(props.getProperty(propertyKey))) continue;
            throw new IllegalArgumentException("Property " + propertyKey + " is required.");
        }
        CustomConfigManager configManager = CustomConfigManagerFactory.getCustomConfigManagerFor(dbType);
        configManager.checkRequiredProperties(props);
    }

    public static String getConfigValue(JdbcStorageConfig key, Configuration config) {
        return config.get(key.getPropertyName());
    }

    public static String getQueryToExecute(Configuration config) {
        String hiveFilterCondition;
        Object query = config.get(JdbcStorageConfig.QUERY.getPropertyName());
        if (query == null) {
            String tableName = config.get(JdbcStorageConfig.TABLE.getPropertyName());
            query = "select * from " + tableName;
        }
        if ((hiveFilterCondition = QueryConditionBuilder.getInstance().buildCondition(config)) != null && !hiveFilterCondition.trim().isEmpty()) {
            query = (String)query + " WHERE " + hiveFilterCondition;
        }
        return query;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static void resolveMetadata(Properties props) throws HiveException, IOException {
        DatabaseType dbType = DatabaseType.valueOf(props.getProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()));
        LOGGER.debug("Resolving db type: {}", (Object)dbType.toString());
        if (dbType == DatabaseType.METASTORE) {
            String pwd;
            HiveConf hconf = Hive.get().getConf();
            props.setProperty(JdbcStorageConfig.JDBC_URL.getPropertyName(), JdbcStorageConfigManager.getMetastoreConnectionURL(hconf));
            props.setProperty(JdbcStorageConfig.JDBC_DRIVER_CLASS.getPropertyName(), JdbcStorageConfigManager.getMetastoreDriver(hconf));
            String user = JdbcStorageConfigManager.getMetastoreJdbcUser(hconf);
            if (user != null) {
                props.setProperty(CONFIG_USERNAME, user);
            }
            if ((pwd = JdbcStorageConfigManager.getMetastoreJdbcPasswd(hconf)) != null) {
                props.setProperty(CONFIG_PWD, pwd);
            }
            props.setProperty(JdbcStorageConfig.DATABASE_TYPE.getPropertyName(), JdbcStorageConfigManager.getMetastoreDatabaseType(hconf));
        }
    }

    private static String getMetastoreDatabaseType(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTOREDBTYPE);
    }

    private static String getMetastoreConnectionURL(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORECONNECTURLKEY);
    }

    private static String getMetastoreDriver(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER);
    }

    private static String getMetastoreJdbcUser(HiveConf conf) {
        return conf.getVar(HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
    }

    private static String getMetastoreJdbcPasswd(HiveConf conf) throws IOException {
        return ShimLoader.getHadoopShims().getPassword((Configuration)conf, HiveConf.ConfVars.METASTOREPWD.varname);
    }
}

