/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hive.hplsql.Hplsql;

public class Utils {
    public static String unquoteString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder s2 = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch = s.charAt(i);
            char c = ch2 = i < len - 1 ? s.charAt(i + 1) : (char)'\u0000';
            if ((i == 0 || i == len - 1) && (ch == '\'' || ch == '\"') || ch == '\\' && ch2 == '\'' || ch == '\'' && ch2 == '\'') continue;
            s2.append(ch);
        }
        return s2.toString();
    }

    public static String quoteString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder s2 = new StringBuilder(len + 2).append('\'');
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            s2.append(ch);
            if (ch != '\'') continue;
            s2.append(ch);
        }
        s2.append('\'');
        return s2.toString();
    }

    public static String mergeQuotedStrings(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return null;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 == 0 || len2 == 0) {
            return s1;
        }
        return s1.substring(0, len1 - 1) + s2.substring(1);
    }

    public static Date toDate(String s) {
        int len = s.length();
        if (len >= 10) {
            char c4 = s.charAt(4);
            char c7 = s.charAt(7);
            if (c4 == '-' && c7 == '-') {
                return Date.valueOf(s.substring(0, 10));
            }
        }
        return null;
    }

    public static Timestamp toTimestamp(String s) {
        int len = ((String)s).length();
        if (len >= 10) {
            char c4 = ((String)s).charAt(4);
            char c7 = ((String)s).charAt(7);
            if (c4 == '-' && c7 == '-') {
                if (len > 19) {
                    if (((String)s).charAt(10) == '-') {
                        String s2 = ((String)s).substring(0, 10) + " " + ((String)s).substring(11, 13) + ":" + ((String)s).substring(14, 16) + ":" + ((String)s).substring(17);
                        return Timestamp.valueOf(s2);
                    }
                } else if (len == 10) {
                    s = (String)s + " 00:00:00.000";
                }
                return Timestamp.valueOf((String)s);
            }
        }
        return null;
    }

    public static String minMaxString(String s1, String s2, boolean max) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int cmp = s1.compareTo(s2);
        if (max && cmp < 0 || !max && cmp > 0) {
            return s2;
        }
        return s1;
    }

    public static Long minMaxInt(Long i1, String s, boolean max) {
        Long i2 = null;
        try {
            i2 = Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        if (max && i1 < i2 || !max && i1 > i2) {
            return i2;
        }
        return i1;
    }

    public static Date minMaxDate(Date d1, String s, boolean max) {
        Date d2 = Utils.toDate(s);
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (max && d1.before(d2) || !max && d1.after(d2)) {
            return d2;
        }
        return d1;
    }

    public static String toString(String[] a, char del) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                s.append(del);
            }
            s.append(a[i]);
        }
        return s.toString();
    }

    public static String convertSqlDatetimeFormat(String in) {
        StringBuilder out = new StringBuilder();
        int len = in.length();
        int i = 0;
        while (i < len) {
            if (i + 4 <= len && in.substring(i, i + 4).compareTo("YYYY") == 0) {
                out.append("yyyy");
                i += 4;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("mm") == 0) {
                out.append("MM");
                i += 2;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("DD") == 0) {
                out.append("dd");
                i += 2;
                continue;
            }
            if (i + 4 <= len && in.substring(i, i + 4).compareToIgnoreCase("HH24") == 0) {
                out.append("HH");
                i += 4;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareToIgnoreCase("MI") == 0) {
                out.append("mm");
                i += 2;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("SS") == 0) {
                out.append("ss");
                i += 2;
                continue;
            }
            out.append(in.charAt(i));
            ++i;
        }
        return out.toString();
    }

    public static String getExecDir() {
        String dir = Hplsql.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (dir.endsWith(".jar")) {
            dir = dir.substring(0, dir.lastIndexOf("/") + 1);
        }
        return dir;
    }

    public static String formatSizeInBytes(long bytes, String postfix) {
        String out = bytes == 1L ? bytes + " byte" : (bytes < 1024L ? bytes + " bytes" : (bytes < 0x100000L ? String.format("%.1f", Float.valueOf((float)bytes / 1024.0f)) + " KB" : (bytes < 0x40000000L ? String.format("%.1f", Float.valueOf((float)bytes / 1048576.0f)) + " MB" : String.format("%.1f", Float.valueOf((float)bytes / 1.0737418E9f)) + " GB")));
        if (postfix != null && !postfix.isEmpty()) {
            out = out + postfix;
        }
        return out;
    }

    public static String formatSizeInBytes(long bytes) {
        return Utils.formatSizeInBytes(bytes, null);
    }

    public static String formatTime(long msElapsed) {
        if (msElapsed < 60000L) {
            return msElapsed / 1000L + " sec";
        }
        if (msElapsed < 3600000L) {
            return msElapsed / 60000L + " min " + msElapsed % 60000L / 1000L + " sec";
        }
        return "";
    }

    public static String formatBytesPerSec(long bytes, long msElapsed) {
        if (msElapsed < 30L) {
            return "n/a";
        }
        float bytesPerSec = (float)bytes / (float)msElapsed * 1000.0f;
        return Utils.formatSizeInBytes((long)bytesPerSec, "/sec");
    }

    public static String formatPercent(long current, long all) {
        return String.format("%.1f", Float.valueOf((float)current / (float)all * 100.0f)) + "%";
    }

    public static String formatCnt(long value, String suffix) {
        if (value == 1L) {
            return value + " " + suffix;
        }
        return value + " " + suffix + "s";
    }

    public static String formatCnt(long value, String suffix, String suffix2) {
        if (value == 1L) {
            return value + " " + suffix;
        }
        return value + " " + suffix2;
    }

    static <T> String join(T[] array, String separator) {
        return org.antlr.v4.runtime.misc.Utils.join((Object[])array, (String)separator);
    }
}

