/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.File;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.Function;

public class FunctionOra
extends Function {
    public FunctionOra(Exec e) {
        super(e);
    }

    @Override
    public void register(Function f) {
        f.map.put("DBMS_OUTPUT.PUT_LINE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.dbmsOutputPutLine(ctx);
            }
        });
        f.map.put("UTL_FILE.FOPEN", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.utlFileFopen(ctx);
            }
        });
        f.map.put("UTL_FILE.GET_LINE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.utlFileGetLine(ctx);
            }
        });
        f.map.put("UTL_FILE.PUT_LINE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.utlFilePutLine(ctx);
            }
        });
        f.map.put("UTL_FILE.PUT", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.utlFilePut(ctx);
            }
        });
        f.map.put("UTL_FILE.FCLOSE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionOra.this.utlFileFclose(ctx);
            }
        });
    }

    void dbmsOutputPutLine(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() > 0) {
            System.out.println(this.evalPop(ctx.func_param(0).expr()));
        }
    }

    public void utlFileFopen(HplsqlParser.Expr_func_paramsContext ctx) {
        String dir = "";
        String name = "";
        boolean write = true;
        boolean overwrite = false;
        int cnt = ctx.func_param().size();
        if (cnt > 0) {
            dir = this.evalPop(ctx.func_param(0).expr()).toString();
        }
        if (cnt > 1) {
            name = this.evalPop(ctx.func_param(1).expr()).toString();
        }
        if (cnt >= 2) {
            String mode = this.evalPop(ctx.func_param(2).expr()).toString();
            if (mode.equalsIgnoreCase("r")) {
                write = false;
            } else if (mode.equalsIgnoreCase("w")) {
                write = true;
                overwrite = true;
            }
        }
        File file = new File();
        if (write) {
            file.create(dir, name, overwrite);
        } else {
            file.open(dir, name);
        }
        this.exec.stackPush(new Var(Var.Type.FILE, file));
    }

    void utlFileGetLine(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        Var file = null;
        Var str = null;
        StringBuilder out = new StringBuilder();
        if (cnt > 0) {
            this.visit(ctx.func_param(0).expr());
            file = this.exec.stackPop();
        }
        if (cnt > 1) {
            this.visit(ctx.func_param(1).expr());
            str = this.exec.stackPop();
        }
        if (file != null && file.type == Var.Type.FILE) {
            block11: {
                File f = (File)file.value;
                if (this.trace) {
                    this.trace(ctx, "File: " + f.toString());
                }
                try {
                    char c;
                    while ((c = f.readChar()) != '\n') {
                        out.append(c);
                    }
                }
                catch (IOException e) {
                    if (e instanceof EOFException) break block11;
                    out.setLength(0);
                }
            }
            if (str != null) {
                str.setValue(out.toString());
                if (this.trace) {
                    this.trace(ctx, "OUT " + str.getName() + " = " + str.toString());
                }
            }
        } else if (this.trace) {
            this.trace(ctx, "Variable of FILE type not found");
        }
    }

    public void utlFilePutLine(HplsqlParser.Expr_func_paramsContext ctx) {
        this.utlFilePut(ctx, true);
    }

    public void utlFilePut(HplsqlParser.Expr_func_paramsContext ctx) {
        this.utlFilePut(ctx, false);
    }

    void utlFilePut(HplsqlParser.Expr_func_paramsContext ctx, boolean newline) {
        int cnt = ctx.func_param().size();
        Var file = null;
        String str = "";
        if (cnt > 0) {
            this.visit(ctx.func_param(0).expr());
            file = this.exec.stackPop();
        }
        if (cnt > 1) {
            this.visit(ctx.func_param(1).expr());
            str = this.exec.stackPop().toString();
        }
        if (file != null && file.type == Var.Type.FILE) {
            File f = (File)file.value;
            if (this.trace) {
                this.trace(ctx, "File: " + f.toString());
            }
            f.writeString(str);
            if (newline) {
                f.writeString("\n");
            }
        } else if (this.trace) {
            this.trace(ctx, "Variable of FILE type not found");
        }
    }

    void utlFileFclose(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        Var file = null;
        if (cnt > 0) {
            this.visit(ctx.func_param(0).expr());
            file = this.exec.stackPop();
        }
        if (file != null && file.type == Var.Type.FILE) {
            File f = (File)file.value;
            if (this.trace) {
                this.trace(ctx, "File: " + f.toString());
            }
            f.close();
            file.removeValue();
        } else if (this.trace) {
            this.trace(ctx, "Variable of FILE type not found");
        }
    }
}

