/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hive.hplsql.Conn;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Query;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.FuncSpecCommand;
import org.apache.hive.hplsql.functions.Function;
import org.apache.hive.hplsql.functions.FunctionDatetime;

public class FunctionMisc
extends Function {
    public FunctionMisc(Exec e) {
        super(e);
    }

    @Override
    public void register(Function f) {
        f.map.put("COALESCE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionMisc.this.nvl(ctx);
            }
        });
        f.map.put("DECODE", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionMisc.this.decode(ctx);
            }
        });
        f.map.put("NVL", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionMisc.this.nvl(ctx);
            }
        });
        f.map.put("NVL2", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionMisc.this.nvl2(ctx);
            }
        });
        f.map.put("PART_COUNT_BY", new FuncCommand(){

            @Override
            public void run(HplsqlParser.Expr_func_paramsContext ctx) {
                FunctionMisc.this.partCountBy(ctx);
            }
        });
        f.specMap.put("ACTIVITY_COUNT", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.activityCount(ctx);
            }
        });
        f.specMap.put("CAST", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.cast(ctx);
            }
        });
        f.specMap.put("CURRENT", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.current(ctx);
            }
        });
        f.specMap.put("CURRENT_USER", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.currentUser(ctx);
            }
        });
        f.specMap.put("PART_COUNT", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.partCount(ctx);
            }
        });
        f.specMap.put("USER", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.currentUser(ctx);
            }
        });
        f.specSqlMap.put("CURRENT", new FuncSpecCommand(){

            @Override
            public void run(HplsqlParser.Expr_spec_funcContext ctx) {
                FunctionMisc.this.currentSql(ctx);
            }
        });
    }

    void activityCount(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalInt(new Long(this.exec.getRowCount()));
    }

    void cast(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.expr().size() != 1) {
            this.evalNull();
            return;
        }
        String type = ctx.dtype().getText();
        String len = null;
        String scale = null;
        if (ctx.dtype_len() != null) {
            len = ctx.dtype_len().L_INT(0).getText();
            if (ctx.dtype_len().L_INT(1) != null) {
                scale = ctx.dtype_len().L_INT(1).getText();
            }
        }
        Var var = new Var(null, type, len, scale, null);
        var.cast(this.evalPop(ctx.expr(0)));
        this.evalVar(var);
    }

    void current(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            this.evalVar(FunctionDatetime.currentDate());
        } else if (ctx.T_TIMESTAMP() != null) {
            int precision = this.evalPop(ctx.expr(0), 3).intValue();
            this.evalVar(FunctionDatetime.currentTimestamp(precision));
        } else if (ctx.T_USER() != null) {
            this.evalVar(FunctionMisc.currentUser());
        } else {
            this.evalNull();
        }
    }

    void currentSql(HplsqlParser.Expr_spec_funcContext ctx) {
        if (ctx.T_DATE() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalString("TO_DATE(FROM_UNIXTIME(UNIX_TIMESTAMP()))");
            } else {
                this.evalString("CURRENT_DATE");
            }
        } else if (ctx.T_TIMESTAMP() != null) {
            if (this.exec.getConnectionType() == Conn.Type.HIVE) {
                this.evalString("FROM_UNIXTIME(UNIX_TIMESTAMP())");
            } else {
                this.evalString("CURRENT_TIMESTAMP");
            }
        } else {
            this.evalString(this.exec.getFormattedText(ctx));
        }
    }

    void currentUser(HplsqlParser.Expr_spec_funcContext ctx) {
        this.evalVar(FunctionMisc.currentUser());
    }

    public static Var currentUser() {
        return new Var(System.getProperty("user.name"));
    }

    void decode(HplsqlParser.Expr_func_paramsContext ctx) {
        int cnt = ctx.func_param().size();
        if (cnt < 3) {
            this.evalNull();
            return;
        }
        Var value = this.evalPop(ctx.func_param(0).expr());
        int i = 1;
        while (i + 1 < cnt) {
            Var when = this.evalPop(ctx.func_param(i).expr());
            if (value.isNull() && when.isNull() || value.equals(when)) {
                this.eval(ctx.func_param(i + 1).expr());
                return;
            }
            i += 2;
        }
        if (i < cnt) {
            this.eval(ctx.func_param(i).expr());
        } else {
            this.evalNull();
        }
    }

    void nvl(HplsqlParser.Expr_func_paramsContext ctx) {
        for (int i = 0; i < ctx.func_param().size(); ++i) {
            Var v = this.evalPop(ctx.func_param(i).expr());
            if (v.type == Var.Type.NULL) continue;
            this.exec.stackPush(v);
            return;
        }
        this.evalNull();
    }

    void nvl2(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx.func_param().size() == 3) {
            if (!this.evalPop(ctx.func_param(0).expr()).isNull()) {
                this.eval(ctx.func_param(1).expr());
            } else {
                this.eval(ctx.func_param(2).expr());
            }
        } else {
            this.evalNull();
        }
    }

    public void partCount(HplsqlParser.Expr_spec_funcContext ctx) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        StringBuilder sql = new StringBuilder();
        sql.append("SHOW PARTITIONS ");
        sql.append(tabname);
        int cnt = ctx.expr().size();
        if (cnt > 1) {
            sql.append(" PARTITION (");
            int i = 1;
            while (i + 1 < cnt) {
                String col = this.evalPop(ctx.expr(i)).toString();
                String val = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql.append(", ");
                }
                sql.append(col);
                sql.append("=");
                sql.append(val);
                i += 2;
            }
            sql.append(")");
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        Query query = this.exec.executeQuery((ParserRuleContext)ctx, sql.toString(), this.exec.conf.defaultConnection);
        if (query.error()) {
            this.evalNullClose(query, this.exec.conf.defaultConnection);
            return;
        }
        int result = 0;
        ResultSet rs = query.getResultSet();
        try {
            while (rs.next()) {
                ++result;
            }
        }
        catch (SQLException e) {
            this.evalNullClose(query, this.exec.conf.defaultConnection);
            return;
        }
        this.evalInt(result);
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
    }

    public void partCountBy(HplsqlParser.Expr_func_paramsContext ctx) {
        String sql;
        Query query;
        int cnt = ctx.func_param().size();
        if (cnt < 1 || this.exec.getOffline()) {
            return;
        }
        String tabname = this.evalPop(ctx.func_param(0).expr()).toString();
        ArrayList<String> keys = null;
        if (cnt > 1) {
            keys = new ArrayList<String>();
            for (int i = 1; i < cnt; ++i) {
                keys.add(this.evalPop(ctx.func_param(i).expr()).toString().toUpperCase());
            }
        }
        if ((query = this.exec.executeQuery((ParserRuleContext)ctx, sql = "SHOW PARTITIONS " + tabname, this.exec.conf.defaultConnection)).error()) {
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
            return;
        }
        ResultSet rs = query.getResultSet();
        HashMap<String, Integer> group = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                Integer count;
                String part = rs.getString(1);
                String[] parts = part.split("/");
                String key = parts[0];
                if (cnt > 1) {
                    StringBuilder k = new StringBuilder();
                    for (int i = 0; i < parts.length; ++i) {
                        if (!keys.contains(parts[i].split("=")[0].toUpperCase())) continue;
                        if (k.length() > 0) {
                            k.append("/");
                        }
                        k.append(parts[i]);
                    }
                    key = k.toString();
                }
                if ((count = (Integer)group.get(key)) == null) {
                    count = new Integer(0);
                }
                group.put(key, count + 1);
            }
        }
        catch (SQLException e) {
            this.exec.closeQuery(query, this.exec.conf.defaultConnection);
            return;
        }
        if (cnt == 1) {
            this.evalInt(group.size());
        } else {
            for (Map.Entry i : group.entrySet()) {
                System.out.println((String)i.getKey() + '\t' + i.getValue());
            }
        }
        this.exec.closeQuery(query, this.exec.conf.defaultConnection);
    }
}

