/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.HBaseStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.JobConf;

public abstract class AbstractHBaseKeyFactory
implements HBaseKeyFactory {
    protected HBaseSerDeParameters hbaseParams;
    protected ColumnMappings.ColumnMapping keyMapping;
    protected Properties properties;

    @Override
    public void init(HBaseSerDeParameters hbaseParam, Properties properties) throws SerDeException {
        this.hbaseParams = hbaseParam;
        this.keyMapping = hbaseParam.getKeyColumnMapping();
        this.properties = properties;
    }

    @Override
    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) throws IOException {
        TableMapReduceUtil.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{this.getClass()});
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        return HBaseStorageHandler.decomposePredicate(jobConf, (HBaseSerDe)deserializer, predicate);
    }
}

