/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.hbase.DefaultHBaseKeyFactory;
import org.apache.hadoop.hive.serde2.BaseStructObjectInspector;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class SampleHBaseKeyFactory
extends DefaultHBaseKeyFactory {
    private static final String DELIMITER_PATTERN = "\\$\\$";
    private static final byte[] DELIMITER_BINARY = "$$".getBytes();
    private final ByteStream.Output output = new ByteStream.Output();

    public ObjectInspector createKeyObjectInspector(TypeInfo type) {
        return new SlashSeparatedOI((StructTypeInfo)type);
    }

    public LazyObjectBase createKey(ObjectInspector inspector) throws SerDeException {
        return new DoubleDollarSeparated();
    }

    public byte[] serializeKey(Object object, StructField field) throws IOException {
        ObjectInspector inspector = field.getFieldObjectInspector();
        if (inspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new IllegalStateException("invalid type value " + inspector.getTypeName());
        }
        this.output.reset();
        for (Object element : ((StructObjectInspector)inspector).getStructFieldsDataAsList(object)) {
            if (this.output.getLength() > 0) {
                this.output.write(DELIMITER_BINARY);
            }
            this.output.write(String.valueOf(element).getBytes());
        }
        return this.output.getLength() > 0 ? this.output.toByteArray() : null;
    }

    private static class SlashSeparatedOI
    extends BaseStructObjectInspector {
        private int length;

        private SlashSeparatedOI(StructTypeInfo type) {
            ArrayList names = type.getAllStructFieldNames();
            ArrayList<JavaStringObjectInspector> ois = new ArrayList<JavaStringObjectInspector>();
            for (int i = 0; i < names.size(); ++i) {
                ois.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
            }
            this.init(names, ois, null);
        }

        public Object getStructFieldData(Object data, StructField fieldRef) {
            return ((DoubleDollarSeparated)data).fields[((BaseStructObjectInspector.MyField)fieldRef).getFieldID()];
        }

        public List<Object> getStructFieldsDataAsList(Object data) {
            return Arrays.asList(((DoubleDollarSeparated)data).fields);
        }
    }

    private static class DoubleDollarSeparated
    implements LazyObjectBase {
        private Object[] fields;
        private transient boolean isNull;

        private DoubleDollarSeparated() {
        }

        public void init(ByteArrayRef bytes, int start, int length) {
            this.fields = new String(bytes.getData(), start, length).split(SampleHBaseKeyFactory.DELIMITER_PATTERN);
            this.isNull = false;
        }

        public void setNull() {
            this.isNull = true;
        }

        public Object getObject() {
            return this.isNull ? null : this;
        }
    }
}

