/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.hbase.PutWritable;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.hive.hbase.avro.Address;
import org.apache.hadoop.hive.hbase.avro.ContactInfo;
import org.apache.hadoop.hive.hbase.avro.Employee;
import org.apache.hadoop.hive.hbase.avro.Gender;
import org.apache.hadoop.hive.hbase.avro.HomePhone;
import org.apache.hadoop.hive.hbase.avro.OfficePhone;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.thrift.TException;
import org.junit.Ignore;

public class TestHBaseSerDe
extends TestCase {
    static final byte[] TEST_BYTE_ARRAY = Bytes.toBytes((String)"test");
    private static final String RECORD_SCHEMA = "{\n  \"namespace\": \"testing.test.mctesty\",\n  \"name\": \"oneRecord\",\n  \"type\": \"record\",\n  \"fields\": [\n    {\n      \"name\":\"aRecord\",\n      \"type\":{\"type\":\"record\",\n              \"name\":\"recordWithinARecord\",\n              \"fields\": [\n                 {\n                  \"name\":\"int1\",\n                  \"type\":\"int\"\n                },\n                {\n                  \"name\":\"boolean1\",\n                  \"type\":\"boolean\"\n                },\n                {\n                  \"name\":\"long1\",\n                  \"type\":\"long\"\n                }\n      ]}\n    }\n  ]\n}";
    private static final String RECORD_SCHEMA_EVOLVED = "{\n  \"namespace\": \"testing.test.mctesty\",\n  \"name\": \"oneRecord\",\n  \"type\": \"record\",\n  \"fields\": [\n    {\n      \"name\":\"aRecord\",\n      \"type\":{\"type\":\"record\",\n              \"name\":\"recordWithinARecord\",\n              \"fields\": [\n                 {\n                  \"name\":\"int1\",\n                  \"type\":\"int\"\n                },\n                {\n                  \"name\":\"string1\",\n                  \"type\":\"string\", \"default\": \"test\"\n                },\n                {\n                  \"name\":\"boolean1\",\n                  \"type\":\"boolean\"\n                },\n                {\n                  \"name\":\"long1\",\n                  \"type\":\"long\"\n                }\n      ]}\n    }\n  ]\n}";
    private static final String EXPECTED_DESERIALIZED_AVRO_STRING = "{\"key\":\"test-row1\",\"cola_avro\":{\"arecord\":{\"int1\":42,\"boolean1\":true,\"long1\":42432234234}}}";
    private static final String EXPECTED_DESERIALIZED_AVRO_STRING_2 = "{\"key\":\"test-row1\",\"cola_avro\":{\"employeename\":\"Avro Employee1\",\"employeeid\":11111,\"age\":25,\"gender\":\"FEMALE\",\"contactinfo\":{\"address\":[{\"address1\":\"Avro First Address1\",\"address2\":\"Avro Second Address1\",\"city\":\"Avro City1\",\"zipcode\":123456,\"county\":{0:{\"areacode\":999,\"number\":1234567890}},\"aliases\":null,\"metadata\":{\"testkey\":\"testvalue\"}},{\"address1\":\"Avro First Address1\",\"address2\":\"Avro Second Address1\",\"city\":\"Avro City1\",\"zipcode\":123456,\"county\":{0:{\"areacode\":999,\"number\":1234567890}},\"aliases\":null,\"metadata\":{\"testkey\":\"testvalue\"}}],\"homephone\":{\"areacode\":999,\"number\":1234567890},\"officephone\":{\"areacode\":999,\"number\":1234455555}}}}";
    private static final String EXPECTED_DESERIALIZED_AVRO_STRING_3 = "{\"key\":\"test-row1\",\"cola_avro\":{\"arecord\":{\"int1\":42,\"string1\":\"test\",\"boolean1\":true,\"long1\":42432234234}}}";

    public void testHBaseSerDeI() throws SerDeException {
        byte[] cfa = "cola".getBytes();
        byte[] cfb = "colb".getBytes();
        byte[] cfc = "colc".getBytes();
        byte[] qualByte = "byte".getBytes();
        byte[] qualShort = "short".getBytes();
        byte[] qualInt = "int".getBytes();
        byte[] qualLong = "long".getBytes();
        byte[] qualFloat = "float".getBytes();
        byte[] qualDouble = "double".getBytes();
        byte[] qualString = "string".getBytes();
        byte[] qualBool = "boolean".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(rowKey, cfa, qualByte, Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(rowKey, cfb, qualShort, Bytes.toBytes((String)"456")));
        kvs.add(new KeyValue(rowKey, cfc, qualInt, Bytes.toBytes((String)"789")));
        kvs.add(new KeyValue(rowKey, cfa, qualLong, Bytes.toBytes((String)"1000")));
        kvs.add(new KeyValue(rowKey, cfb, qualFloat, Bytes.toBytes((String)"-0.01")));
        kvs.add(new KeyValue(rowKey, cfc, qualDouble, Bytes.toBytes((String)"5.3")));
        kvs.add(new KeyValue(rowKey, cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive")));
        kvs.add(new KeyValue(rowKey, cfb, qualBool, Bytes.toBytes((String)"true")));
        Collections.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.addColumn(cfa, qualByte, Bytes.toBytes((String)"123"));
        p.addColumn(cfb, qualShort, Bytes.toBytes((String)"456"));
        p.addColumn(cfc, qualInt, Bytes.toBytes((String)"789"));
        p.addColumn(cfa, qualLong, Bytes.toBytes((String)"1000"));
        p.addColumn(cfb, qualFloat, Bytes.toBytes((String)"-0.01"));
        p.addColumn(cfc, qualDouble, Bytes.toBytes((String)"5.3"));
        p.addColumn(cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive"));
        p.addColumn(cfb, qualBool, Bytes.toBytes((String)"true"));
        Object[] expectedFieldsData = new Object[]{new Text("test-row1"), new ByteWritable(123), new ShortWritable(456), new IntWritable(789), new LongWritable(1000L), new FloatWritable(-0.01f), new DoubleWritable(5.3), new Text("Hadoop, HBase, and Hive"), new BooleanWritable(true)};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesI_I();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
        serDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesI_II();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
        serDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesI_III();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
        serDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesI_IV();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
    }

    public void testHBaseSerDeWithTimestamp() throws SerDeException {
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesI_I();
        long putTimestamp = 1L;
        tbl.setProperty("hbase.put.timestamp", Long.toString(putTimestamp));
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        byte[] cfa = "cola".getBytes();
        byte[] cfb = "colb".getBytes();
        byte[] cfc = "colc".getBytes();
        byte[] qualByte = "byte".getBytes();
        byte[] qualShort = "short".getBytes();
        byte[] qualInt = "int".getBytes();
        byte[] qualLong = "long".getBytes();
        byte[] qualFloat = "float".getBytes();
        byte[] qualDouble = "double".getBytes();
        byte[] qualString = "string".getBytes();
        byte[] qualBool = "boolean".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(rowKey, cfa, qualByte, Bytes.toBytes((String)"123")));
        kvs.add(new KeyValue(rowKey, cfb, qualShort, Bytes.toBytes((String)"456")));
        kvs.add(new KeyValue(rowKey, cfc, qualInt, Bytes.toBytes((String)"789")));
        kvs.add(new KeyValue(rowKey, cfa, qualLong, Bytes.toBytes((String)"1000")));
        kvs.add(new KeyValue(rowKey, cfb, qualFloat, Bytes.toBytes((String)"-0.01")));
        kvs.add(new KeyValue(rowKey, cfc, qualDouble, Bytes.toBytes((String)"5.3")));
        kvs.add(new KeyValue(rowKey, cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive")));
        kvs.add(new KeyValue(rowKey, cfb, qualBool, Bytes.toBytes((String)"true")));
        Collections.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create(kvs);
        Put p = new Put(rowKey, putTimestamp);
        p.addColumn(cfa, qualByte, Bytes.toBytes((String)"123"));
        p.addColumn(cfb, qualShort, Bytes.toBytes((String)"456"));
        p.addColumn(cfc, qualInt, Bytes.toBytes((String)"789"));
        p.addColumn(cfa, qualLong, Bytes.toBytes((String)"1000"));
        p.addColumn(cfb, qualFloat, Bytes.toBytes((String)"-0.01"));
        p.addColumn(cfc, qualDouble, Bytes.toBytes((String)"5.3"));
        p.addColumn(cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive"));
        p.addColumn(cfb, qualBool, Bytes.toBytes((String)"true"));
        Object[] expectedFieldsData = new Object[]{new Text("test-row1"), new ByteWritable(123), new ShortWritable(456), new IntWritable(789), new LongWritable(1000L), new FloatWritable(-0.01f), new DoubleWritable(5.3), new Text("Hadoop, HBase, and Hive"), new BooleanWritable(true)};
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
    }

    private void deserializeAndSerialize(HBaseSerDe serDe, Result r, Put p, Object[] expectedFieldsData) throws SerDeException {
        StructObjectInspector oi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = oi.getAllStructFieldRefs();
        TestHBaseSerDe.assertEquals((int)9, (int)fieldRefs.size());
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        for (int i = 0; i < fieldRefs.size(); ++i) {
            Object fieldData = oi.getStructFieldData(row, (StructField)fieldRefs.get(i));
            if (fieldData != null) {
                fieldData = ((LazyPrimitive)fieldData).getWritableObject();
            }
            TestHBaseSerDe.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
        }
        TestHBaseSerDe.assertEquals(PutWritable.class, (Object)serDe.getSerializedClass());
        PutWritable serializedPut = (PutWritable)serDe.serialize(row, (ObjectInspector)oi);
        TestHBaseSerDe.assertEquals((String)"Serialized data", (String)p.toString(), (String)String.valueOf(serializedPut.getPut()));
    }

    private Properties createPropertiesI_I() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", "cola:byte,colb:short,colc:int,cola:long,colb:float,colc:double,cola:string,colb:boolean");
        return tbl;
    }

    private Properties createPropertiesI_II() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cola:byte#s,colb:short#-,colc:int#s,cola:long#s,colb:float#-,colc:double#-,cola:string#s,colb:boolean#s");
        return tbl;
    }

    private Properties createPropertiesI_III() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#s,cola:byte#s,colb:short#s,colc:int#s,cola:long#s,colb:float#s,colc:double#s,cola:string#s,colb:boolean#s");
        tbl.setProperty("hbase.table.default.storage.type", "binary");
        return tbl;
    }

    private Properties createPropertiesI_IV() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cola:byte#s,colb:short#s,colc:int#s,cola:long#s,colb:float#s,colc:double#s,cola:string#b,colb:boolean#s");
        tbl.setProperty("hbase.table.default.storage.type", "binary");
        return tbl;
    }

    public void testHBaseSerDeII() throws SerDeException {
        byte[] cfa = "cfa".getBytes();
        byte[] cfb = "cfb".getBytes();
        byte[] cfc = "cfc".getBytes();
        byte[] qualByte = "byte".getBytes();
        byte[] qualShort = "short".getBytes();
        byte[] qualInt = "int".getBytes();
        byte[] qualLong = "long".getBytes();
        byte[] qualFloat = "float".getBytes();
        byte[] qualDouble = "double".getBytes();
        byte[] qualString = "string".getBytes();
        byte[] qualBool = "boolean".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row-2");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(rowKey, cfa, qualByte, new byte[]{-128}));
        kvs.add(new KeyValue(rowKey, cfb, qualShort, Bytes.toBytes((short)Short.MIN_VALUE)));
        kvs.add(new KeyValue(rowKey, cfc, qualInt, Bytes.toBytes((int)Integer.MIN_VALUE)));
        kvs.add(new KeyValue(rowKey, cfa, qualLong, Bytes.toBytes((long)Long.MIN_VALUE)));
        kvs.add(new KeyValue(rowKey, cfb, qualFloat, Bytes.toBytes((float)Float.MIN_VALUE)));
        kvs.add(new KeyValue(rowKey, cfc, qualDouble, Bytes.toBytes((double)Double.MAX_VALUE)));
        kvs.add(new KeyValue(rowKey, cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive Again!")));
        kvs.add(new KeyValue(rowKey, cfb, qualBool, Bytes.toBytes((boolean)false)));
        Collections.sort(kvs, KeyValue.COMPARATOR);
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.addColumn(cfa, qualByte, new byte[]{-128});
        p.addColumn(cfb, qualShort, Bytes.toBytes((short)Short.MIN_VALUE));
        p.addColumn(cfc, qualInt, Bytes.toBytes((int)Integer.MIN_VALUE));
        p.addColumn(cfa, qualLong, Bytes.toBytes((long)Long.MIN_VALUE));
        p.addColumn(cfb, qualFloat, Bytes.toBytes((float)Float.MIN_VALUE));
        p.addColumn(cfc, qualDouble, Bytes.toBytes((double)Double.MAX_VALUE));
        p.addColumn(cfa, qualString, Bytes.toBytes((String)"Hadoop, HBase, and Hive Again!"));
        p.addColumn(cfb, qualBool, Bytes.toBytes((boolean)false));
        Object[] expectedFieldsData = new Object[]{new Text("test-row-2"), new ByteWritable(-128), new ShortWritable(Short.MIN_VALUE), new IntWritable(Integer.MIN_VALUE), new LongWritable(Long.MIN_VALUE), new FloatWritable(Float.MIN_VALUE), new DoubleWritable(Double.MAX_VALUE), new Text("Hadoop, HBase, and Hive Again!"), new BooleanWritable(false)};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesII_I();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
        serDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesII_II();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
        serDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesII_III();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerialize(serDe, r, p, expectedFieldsData);
    }

    private Properties createPropertiesII_I() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cfa:byte#b,cfb:short#b,cfc:int#-,cfa:long#b,cfb:float#-,cfc:double#b,cfa:string#b,cfb:boolean#-");
        tbl.setProperty("hbase.table.default.storage.type", "binary");
        return tbl;
    }

    private Properties createPropertiesII_II() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#b,cfa:byte#b,cfb:short#b,cfc:int#b,cfa:long#b,cfb:float#b,cfc:double#b,cfa:string#b,cfb:boolean#b");
        tbl.setProperty("hbase.table.default.storage.type", "string");
        return tbl;
    }

    private Properties createPropertiesII_III() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,abyte,ashort,aint,along,afloat,adouble,astring,abool");
        tbl.setProperty("columns.types", "string,tinyint:smallint:int:bigint:float:double:string:boolean");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cfa:byte#b,cfb:short#b,cfc:int#b,cfa:long#b,cfb:float#b,cfc:double#b,cfa:string#-,cfb:boolean#b");
        return tbl;
    }

    public void testHBaseSerDeWithHiveMapToHBaseColumnFamily() throws SerDeException {
        byte[] cfint = "cf-int".getBytes();
        byte[] cfbyte = "cf-byte".getBytes();
        byte[] cfshort = "cf-short".getBytes();
        byte[] cflong = "cf-long".getBytes();
        byte[] cffloat = "cf-float".getBytes();
        byte[] cfdouble = "cf-double".getBytes();
        byte[] cfbool = "cf-bool".getBytes();
        byte[][] columnFamilies = new byte[][]{cfint, cfbyte, cfshort, cflong, cffloat, cfdouble, cfbool};
        byte[][] rowKeys = new byte[][]{Integer.toString(1).getBytes(), Integer.toString(Integer.MIN_VALUE).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes()};
        byte[][][] columnQualifiersAndValues = new byte[][][]{new byte[][]{Bytes.toBytes((int)1), {1}, Bytes.toBytes((short)1), Bytes.toBytes((long)1L), Bytes.toBytes((float)1.0f), Bytes.toBytes((double)1.0), Bytes.toBytes((boolean)true)}, new byte[][]{Bytes.toBytes((int)Integer.MIN_VALUE), {-128}, Bytes.toBytes((short)Short.MIN_VALUE), Bytes.toBytes((long)Long.MIN_VALUE), Bytes.toBytes((float)Float.MIN_VALUE), Bytes.toBytes((double)Double.MIN_VALUE), Bytes.toBytes((boolean)false)}, new byte[][]{Bytes.toBytes((int)Integer.MAX_VALUE), {127}, Bytes.toBytes((short)Short.MAX_VALUE), Bytes.toBytes((long)Long.MAX_VALUE), Bytes.toBytes((float)Float.MAX_VALUE), Bytes.toBytes((double)Double.MAX_VALUE), Bytes.toBytes((boolean)true)}};
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        Result[] r = new Result[]{null, null, null};
        Put[] p = new Put[]{null, null, null};
        for (int i = 0; i < r.length; ++i) {
            kvs.clear();
            p[i] = new Put(rowKeys[i]);
            for (int j = 0; j < columnQualifiersAndValues[i].length; ++j) {
                kvs.add(new KeyValue(rowKeys[i], columnFamilies[j], columnQualifiersAndValues[i][j], columnQualifiersAndValues[i][j]));
                p[i].addColumn(columnFamilies[j], columnQualifiersAndValues[i][j], columnQualifiersAndValues[i][j]);
            }
            r[i] = Result.create(kvs);
        }
        Object[][] expectedData = new Object[][]{{new Text(Integer.toString(1)), new IntWritable(1), new ByteWritable(1), new ShortWritable(1), new LongWritable(1L), new FloatWritable(1.0f), new DoubleWritable(1.0), new BooleanWritable(true)}, {new Text(Integer.toString(Integer.MIN_VALUE)), new IntWritable(Integer.MIN_VALUE), new ByteWritable(-128), new ShortWritable(Short.MIN_VALUE), new LongWritable(Long.MIN_VALUE), new FloatWritable(Float.MIN_VALUE), new DoubleWritable(Double.MIN_VALUE), new BooleanWritable(false)}, {new Text(Integer.toString(Integer.MAX_VALUE)), new IntWritable(Integer.MAX_VALUE), new ByteWritable(127), new ShortWritable(Short.MAX_VALUE), new LongWritable(Long.MAX_VALUE), new FloatWritable(Float.MAX_VALUE), new DoubleWritable(Double.MAX_VALUE), new BooleanWritable(true)}};
        HBaseSerDe hbaseSerDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveMapHBaseColumnFamily();
        SerDeUtils.initializeSerDe((Deserializer)hbaseSerDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHiveMapHBaseColumnFamily(hbaseSerDe, r, p, expectedData, rowKeys, columnFamilies, columnQualifiersAndValues);
        hbaseSerDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesForHiveMapHBaseColumnFamilyII();
        SerDeUtils.initializeSerDe((Deserializer)hbaseSerDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHiveMapHBaseColumnFamily(hbaseSerDe, r, p, expectedData, rowKeys, columnFamilies, columnQualifiersAndValues);
    }

    private void deserializeAndSerializeHiveMapHBaseColumnFamily(HBaseSerDe hbaseSerDe, Result[] r, Put[] p, Object[][] expectedData, byte[][] rowKeys, byte[][] columnFamilies, byte[][][] columnQualifiersAndValues) throws SerDeException {
        StructObjectInspector soi = (StructObjectInspector)hbaseSerDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        TestHBaseSerDe.assertEquals((int)8, (int)fieldRefs.size());
        for (int i = 0; i < r.length; ++i) {
            Object row = hbaseSerDe.deserialize((Writable)new ResultWritable(r[i]));
            Put serializedPut = ((PutWritable)hbaseSerDe.serialize(row, (ObjectInspector)soi)).getPut();
            byte[] rowKey = serializedPut.getRow();
            for (int k = 0; k < rowKey.length; ++k) {
                TestHBaseSerDe.assertEquals((byte)rowKey[k], (byte)rowKeys[i][k]);
            }
            TestHBaseSerDe.assertEquals((int)columnFamilies.length, (int)serializedPut.numFamilies());
            for (int j = 0; j < fieldRefs.size(); ++j) {
                Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(j));
                TestHBaseSerDe.assertNotNull((Object)fieldData);
                if (fieldData instanceof LazyPrimitive) {
                    TestHBaseSerDe.assertEquals((Object)expectedData[i][j], (Object)((LazyPrimitive)fieldData).getWritableObject());
                    continue;
                }
                if (fieldData instanceof LazyHBaseCellMap) {
                    LazyPrimitive lazyPrimitive = (LazyPrimitive)((LazyHBaseCellMap)fieldData).getMapValueElement(expectedData[i][j]);
                    TestHBaseSerDe.assertEquals((Object)expectedData[i][j], (Object)lazyPrimitive.getWritableObject());
                    continue;
                }
                TestHBaseSerDe.fail((String)"Error: field data not an instance of LazyPrimitive<?,?> or LazyMap");
            }
        }
    }

    private Properties createPropertiesForHiveMapHBaseColumnFamily() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,valint,valbyte,valshort,vallong,valfloat,valdouble,valbool");
        tbl.setProperty("columns.types", "string:map<int,int>:map<tinyint,tinyint>:map<smallint,smallint>:map<bigint,bigint>:map<float,float>:map<double,double>:map<boolean,boolean>");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cf-int:#b:b,cf-byte:#b:b,cf-short:#b:b,cf-long:#b:b,cf-float:#b:b,cf-double:#b:b,cf-bool:#b:b");
        return tbl;
    }

    private Properties createPropertiesForHiveMapHBaseColumnFamilyII() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,valint,valbyte,valshort,vallong,valfloat,valdouble,valbool");
        tbl.setProperty("columns.types", "string:map<int,int>:map<tinyint,tinyint>:map<smallint,smallint>:map<bigint,bigint>:map<float,float>:map<double,double>:map<boolean,boolean>");
        tbl.setProperty("hbase.columns.mapping", ":key#-,cf-int:#-:-,cf-byte:#-:-,cf-short:#-:-,cf-long:#-:-,cf-float:#-:-,cf-double:#-:-,cf-bool:#-:-");
        tbl.setProperty("hbase.table.default.storage.type", "binary");
        return tbl;
    }

    public void testHBaseSerDeWithHiveMapToHBaseColumnFamilyII() throws SerDeException {
        byte[] cfbyte = "cf-byte".getBytes();
        byte[] cfshort = "cf-short".getBytes();
        byte[] cfint = "cf-int".getBytes();
        byte[] cflong = "cf-long".getBytes();
        byte[] cffloat = "cf-float".getBytes();
        byte[] cfdouble = "cf-double".getBytes();
        byte[] cfstring = "cf-string".getBytes();
        byte[] cfbool = "cf-bool".getBytes();
        byte[][] columnFamilies = new byte[][]{cfbyte, cfshort, cfint, cflong, cffloat, cfdouble, cfstring, cfbool};
        byte[] rowKey = Bytes.toBytes((String)"row-key");
        byte[][] columnQualifiersAndValues = new byte[][]{Bytes.toBytes((String)"123"), Bytes.toBytes((String)"456"), Bytes.toBytes((String)"789"), Bytes.toBytes((String)"1000"), Bytes.toBytes((String)"-0.01"), Bytes.toBytes((String)"5.3"), Bytes.toBytes((String)"Hive"), Bytes.toBytes((String)"true")};
        Put p = new Put(rowKey);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (int j = 0; j < columnQualifiersAndValues.length; ++j) {
            kvs.add(new KeyValue(rowKey, columnFamilies[j], columnQualifiersAndValues[j], columnQualifiersAndValues[j]));
            p.addColumn(columnFamilies[j], columnQualifiersAndValues[j], columnQualifiersAndValues[j]);
        }
        Result r = Result.create(kvs);
        Object[] expectedData = new Object[]{new Text("row-key"), new ByteWritable(123), new ShortWritable(456), new IntWritable(789), new LongWritable(1000L), new FloatWritable(-0.01f), new DoubleWritable(5.3), new Text("Hive"), new BooleanWritable(true)};
        HBaseSerDe hbaseSerDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveMapHBaseColumnFamilyII_I();
        SerDeUtils.initializeSerDe((Deserializer)hbaseSerDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHiveMapHBaseColumnFamilyII(hbaseSerDe, r, p, expectedData, columnFamilies, columnQualifiersAndValues);
        hbaseSerDe = new HBaseSerDe();
        conf = new Configuration();
        tbl = this.createPropertiesForHiveMapHBaseColumnFamilyII_II();
        SerDeUtils.initializeSerDe((Deserializer)hbaseSerDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHiveMapHBaseColumnFamilyII(hbaseSerDe, r, p, expectedData, columnFamilies, columnQualifiersAndValues);
    }

    private Properties createPropertiesForHiveMapHBaseColumnFamilyII_I() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,valbyte,valshort,valint,vallong,valfloat,valdouble,valstring,valbool");
        tbl.setProperty("columns.types", "string:map<tinyint,tinyint>:map<smallint,smallint>:map<int,int>:map<bigint,bigint>:map<float,float>:map<double,double>:map<string,string>:map<boolean,boolean>");
        tbl.setProperty("hbase.columns.mapping", ":key#s,cf-byte:#-:s,cf-short:#s:-,cf-int:#s:s,cf-long:#-:-,cf-float:#s:-,cf-double:#-:s,cf-string:#s:s,cf-bool:#-:-");
        return tbl;
    }

    private Properties createPropertiesForHiveMapHBaseColumnFamilyII_II() {
        Properties tbl = new Properties();
        tbl.setProperty("serialization.format", "9");
        tbl.setProperty("columns", "key,valbyte,valshort,valint,vallong,valfloat,valdouble,valstring,valbool");
        tbl.setProperty("columns.types", "string:map<tinyint,tinyint>:map<smallint,smallint>:map<int,int>:map<bigint,bigint>:map<float,float>:map<double,double>:map<string,string>:map<boolean,boolean>");
        tbl.setProperty("hbase.columns.mapping", ":key#s,cf-byte:#s:s,cf-short:#s:s,cf-int:#s:s,cf-long:#s:s,cf-float:#s:s,cf-double:#s:s,cf-string:#s:s,cf-bool:#s:s");
        tbl.setProperty("hbase.table.default.storage.type", "binary");
        return tbl;
    }

    private void deserializeAndSerializeHiveMapHBaseColumnFamilyII(HBaseSerDe hbaseSerDe, Result r, Put p, Object[] expectedData, byte[][] columnFamilies, byte[][] columnQualifiersAndValues) throws SerDeException {
        StructObjectInspector soi = (StructObjectInspector)hbaseSerDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        TestHBaseSerDe.assertEquals((int)9, (int)fieldRefs.size());
        Object row = hbaseSerDe.deserialize((Writable)new ResultWritable(r));
        for (int j = 0; j < fieldRefs.size(); ++j) {
            Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(j));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
            if (fieldData instanceof LazyPrimitive) {
                TestHBaseSerDe.assertEquals((Object)expectedData[j], (Object)((LazyPrimitive)fieldData).getWritableObject());
                continue;
            }
            if (fieldData instanceof LazyHBaseCellMap) {
                LazyPrimitive lazyPrimitive = (LazyPrimitive)((LazyHBaseCellMap)fieldData).getMapValueElement(expectedData[j]);
                TestHBaseSerDe.assertEquals((Object)expectedData[j], (Object)lazyPrimitive.getWritableObject());
                continue;
            }
            TestHBaseSerDe.fail((String)"Error: field data not an instance of LazyPrimitive<?, ?> or LazyHBaseCellMap");
        }
        Put serializedPut = ((PutWritable)hbaseSerDe.serialize(row, (ObjectInspector)soi)).getPut();
        TestHBaseSerDe.assertEquals((String)"Serialized data: ", (String)p.toString(), (String)serializedPut.toString());
    }

    public void testHBaseSerDeWithColumnPrefixes() throws Exception {
        byte[] cfa = "cola".getBytes();
        byte[] qualA = "prefixA_col1".getBytes();
        byte[] qualB = "prefixB_col2".getBytes();
        byte[] qualC = "prefixB_col3".getBytes();
        byte[] qualD = "unwanted_col".getBytes();
        ArrayList<Text> qualifiers = new ArrayList<Text>();
        qualifiers.add(new Text("prefixA_col1"));
        qualifiers.add(new Text("prefixB_col2"));
        qualifiers.add(new Text("prefixB_col3"));
        qualifiers.add(new Text("unwanted_col"));
        ArrayList<Object> expectedQualifiers = new ArrayList<Object>();
        expectedQualifiers.add(new Text("prefixA_col1"));
        expectedQualifiers.add(new Text("prefixB_col2"));
        expectedQualifiers.add(new Text("prefixB_col3"));
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] dataA = "This is first test data".getBytes();
        byte[] dataB = "This is second test data".getBytes();
        byte[] dataC = "This is third test data".getBytes();
        byte[] dataD = "Unwanted data".getBytes();
        kvs.add(new KeyValue(rowKey, cfa, qualA, dataA));
        kvs.add(new KeyValue(rowKey, cfa, qualB, dataB));
        kvs.add(new KeyValue(rowKey, cfa, qualC, dataC));
        kvs.add(new KeyValue(rowKey, cfa, qualD, dataD));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualA, dataA));
        p.add((Cell)new KeyValue(rowKey, cfa, qualB, dataB));
        p.add((Cell)new KeyValue(rowKey, cfa, qualC, dataC));
        Object[] expectedFieldsData = new Object[]{new Text("test-row1"), new String("This is first test data"), new String("This is second test data"), new String("This is third test data")};
        int[] expectedMapSize = new int[]{1, 2};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForColumnPrefixes();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        Text notPresentKey = new Text("unwanted_col");
        this.deserializeAndSerializeHivePrefixColumnFamily(serDe, r, p, expectedFieldsData, expectedMapSize, expectedQualifiers, notPresentKey);
    }

    private Properties createPropertiesForColumnPrefixes() {
        Properties tbl = new Properties();
        tbl.setProperty("columns", "key,astring,along");
        tbl.setProperty("columns.types", "string:map<string,string>:map<string,string>");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:prefixA_.*,cola:prefixB_.*");
        return tbl;
    }

    private void deserializeAndSerializeHivePrefixColumnFamily(HBaseSerDe serDe, Result r, Put p, Object[] expectedFieldsData, int[] expectedMapSize, List<Object> expectedQualifiers, Object notPresentKey) throws SerDeException, IOException {
        StructObjectInspector soi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        int j = 0;
        for (int i = 0; i < fieldRefs.size(); ++i) {
            Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(i));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
            if (fieldData instanceof LazyPrimitive) {
                TestHBaseSerDe.assertEquals((Object)expectedFieldsData[i], (Object)((LazyPrimitive)fieldData).getWritableObject());
                continue;
            }
            if (fieldData instanceof LazyHBaseCellMap) {
                TestHBaseSerDe.assertEquals((Object)expectedFieldsData[i], (Object)((LazyHBaseCellMap)fieldData).getMapValueElement(expectedQualifiers.get(j)).toString().trim());
                TestHBaseSerDe.assertEquals((int)expectedMapSize[j], (int)((LazyHBaseCellMap)fieldData).getMapSize());
                TestHBaseSerDe.assertNull((Object)((LazyHBaseCellMap)fieldData).getMapValueElement(notPresentKey));
                ++j;
                continue;
            }
            TestHBaseSerDe.fail((String)"Error: field data not an instance of LazyPrimitive<?, ?> or LazyHBaseCellMap");
        }
        SerDeUtils.getJSONString((Object)row, (ObjectInspector)soi);
        Put put = ((PutWritable)serDe.serialize(row, (ObjectInspector)soi)).getPut();
        if (p != null) {
            TestHBaseSerDe.assertEquals((String)"Serialized put:", (String)p.toString(), (String)put.toString());
        }
    }

    public void testHBaseSerDeCompositeKeyWithSeparator() throws SerDeException, TException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualStruct = "struct".getBytes();
        TestStruct testStruct = new TestStruct("A", "B", "C", true, 45);
        byte[] rowKey = testStruct.getBytes();
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] testData = "This is a test data".getBytes();
        kvs.add(new KeyValue(rowKey, cfa, qualStruct, testData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualStruct, testData));
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForCompositeKeyWithSeparator();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHBaseCompositeKey(serDe, r, p);
    }

    private Properties createPropertiesForCompositeKeyWithSeparator() {
        Properties tbl = new Properties();
        tbl.setProperty("columns", "key,astring");
        tbl.setProperty("columns.types", "struct<col1:string,col2:string,col3:string>,string");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:struct");
        tbl.setProperty("collection.delim", "-");
        return tbl;
    }

    public void testHBaseSerDeCompositeKeyWithoutSeparator() throws SerDeException, TException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualStruct = "struct".getBytes();
        TestStruct testStruct = new TestStruct("A", "B", "C", false, 0);
        byte[] rowKey = testStruct.getBytes();
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] testData = "This is a test data".getBytes();
        kvs.add(new KeyValue(rowKey, cfa, qualStruct, testData));
        Result r = Result.create(kvs);
        byte[] putRowKey = testStruct.getBytesWithDelimiters();
        Put p = new Put(putRowKey);
        p.add((Cell)new KeyValue(putRowKey, cfa, qualStruct, testData));
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForCompositeKeyWithoutSeparator();
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeAndSerializeHBaseCompositeKey(serDe, r, p);
    }

    private Properties createPropertiesForCompositeKeyWithoutSeparator() {
        Properties tbl = new Properties();
        tbl.setProperty("columns", "key,astring");
        tbl.setProperty("columns.types", "struct<col1:string,col2:string,col3:string>,string");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:struct");
        tbl.setProperty("hbase.composite.key.class", "org.apache.hadoop.hive.hbase.HBaseTestCompositeKey");
        return tbl;
    }

    private void deserializeAndSerializeHBaseCompositeKey(HBaseSerDe serDe, Result r, Put p) throws SerDeException, IOException {
        StructObjectInspector soi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        for (int j = 0; j < fieldRefs.size(); ++j) {
            Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(j));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
        }
        TestHBaseSerDe.assertEquals((String)"{\"key\":{\"col1\":\"A\",\"col2\":\"B\",\"col3\":\"C\"},\"astring\":\"This is a test data\"}", (String)SerDeUtils.getJSONString((Object)row, (ObjectInspector)soi));
        Put put = ((PutWritable)serDe.serialize(row, (ObjectInspector)soi)).getPut();
        TestHBaseSerDe.assertEquals((String)"Serialized put:", (String)p.toString(), (String)put.toString());
    }

    public void testHBaseSerDeWithAvroSchemaInline() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromSchema(RECORD_SCHEMA);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[[42, true, 42432234234]]")};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroSchemaInline();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING);
    }

    private Properties createPropertiesForHiveAvroSchemaInline() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty("cola.avro." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), RECORD_SCHEMA);
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    public void testHBaseSerDeWithForwardEvolvedSchema() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromSchema(RECORD_SCHEMA);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[[42, test, true, 42432234234]]")};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroForwardEvolvedSchema();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING_3);
    }

    private Properties createPropertiesForHiveAvroForwardEvolvedSchema() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty("cola.avro." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), RECORD_SCHEMA_EVOLVED);
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    public void testHBaseSerDeWithBackwardEvolvedSchema() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromSchema(RECORD_SCHEMA_EVOLVED);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[[42, true, 42432234234]]")};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroBackwardEvolvedSchema();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING);
    }

    private Properties createPropertiesForHiveAvroBackwardEvolvedSchema() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty("cola.avro." + AvroSerdeUtils.AvroTableProperties.SCHEMA_LITERAL.getPropName(), RECORD_SCHEMA);
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    public void testHBaseSerDeWithAvroSerClass() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromClass1(1);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[Avro Employee1, 11111, 25, FEMALE, [[[Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}], [Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}]], [999, 1234567890], [999, 1234455555]]]")};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroSerClass();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING_2);
    }

    private Properties createPropertiesForHiveAvroSerClass() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty("cola.avro.serialization.class", "org.apache.hadoop.hive.hbase.avro.Employee");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void ignoreTestHBaseSerDeWithAvroSchemaUrl() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromSchema(RECORD_SCHEMA);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[[42, true, 42432234234]]")};
        MiniDFSCluster miniDfs = null;
        try {
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", "file:///");
            miniDfs = new MiniDFSCluster(conf, 1, true, null);
            miniDfs.getFileSystem().mkdirs(new Path("/path/to/schema"));
            FSDataOutputStream out = miniDfs.getFileSystem().create(new Path("/path/to/schema/schema.avsc"));
            out.writeBytes(RECORD_SCHEMA);
            out.close();
            String onHDFS = miniDfs.getFileSystem().getUri() + "/path/to/schema/schema.avsc";
            HBaseSerDe serDe = new HBaseSerDe();
            Properties tbl = this.createPropertiesForHiveAvroSchemaUrl(onHDFS);
            serDe.initialize(conf, tbl);
            this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING);
        }
        finally {
            if (miniDfs != null) {
                miniDfs.shutdown();
            }
        }
    }

    private Properties createPropertiesForHiveAvroSchemaUrl(String schemaUrl) {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty("cola.avro." + AvroSerdeUtils.AvroTableProperties.SCHEMA_URL.getPropName(), schemaUrl);
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    public void testHBaseSerDeWithAvroExternalSchema() throws SerDeException, IOException {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvro = "avro".getBytes();
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroData = this.getTestAvroBytesFromClass2(1);
        kvs.add(new KeyValue(rowKey, cfa, qualAvro, avroData));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvro, avroData));
        Object[] expectedFieldsData = new Object[]{new String("test-row1"), new String("[Avro Employee1, 11111, 25, FEMALE, [[[Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}], [Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}]], [999, 1234567890], [999, 1234455555]]]")};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroExternalSchema();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHiveAvro(serDe, r, p, expectedFieldsData, EXPECTED_DESERIALIZED_AVRO_STRING_2);
    }

    private Properties createPropertiesForHiveAvroExternalSchema() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.avro.serialization.type", "avro");
        tbl.setProperty(AvroSerdeUtils.AvroTableProperties.SCHEMA_RETRIEVER.getPropName(), "org.apache.hadoop.hive.hbase.HBaseTestAvroSchemaRetriever");
        tbl.setProperty("cola.avro.serialization.class", "org.apache.hadoop.hive.hbase.avro.Employee");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:avro");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        return tbl;
    }

    public void testHBaseSerDeWithHiveMapToHBaseAvroColumnFamily() throws Exception {
        byte[] cfa = "cola".getBytes();
        byte[] qualAvroA = "prefixA_avro1".getBytes();
        byte[] qualAvroB = "prefixB_avro2".getBytes();
        byte[] qualAvroC = "prefixB_avro3".getBytes();
        ArrayList<Text> qualifiers = new ArrayList<Text>();
        qualifiers.add(new Text("prefixA_avro1"));
        qualifiers.add(new Text("prefixB_avro2"));
        qualifiers.add(new Text("prefixB_avro3"));
        ArrayList<Object> expectedQualifiers = new ArrayList<Object>();
        expectedQualifiers.add(new Text("prefixB_avro2"));
        expectedQualifiers.add(new Text("prefixB_avro3"));
        byte[] rowKey = Bytes.toBytes((String)"test-row1");
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] avroDataA = this.getTestAvroBytesFromSchema(RECORD_SCHEMA);
        byte[] avroDataB = this.getTestAvroBytesFromClass1(1);
        byte[] avroDataC = this.getTestAvroBytesFromClass1(2);
        kvs.add(new KeyValue(rowKey, cfa, qualAvroA, avroDataA));
        kvs.add(new KeyValue(rowKey, cfa, qualAvroB, avroDataB));
        kvs.add(new KeyValue(rowKey, cfa, qualAvroC, avroDataC));
        Result r = Result.create(kvs);
        Put p = new Put(rowKey);
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvroB, Bytes.padTail((byte[])avroDataB, (int)11)));
        p.add((Cell)new KeyValue(rowKey, cfa, qualAvroC, Bytes.padTail((byte[])avroDataC, (int)11)));
        Object[] expectedFieldsData = new Object[]{new Text("test-row1"), new String("[Avro Employee1, 11111, 25, FEMALE, [[[Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}], [Avro First Address1, Avro Second Address1, Avro City1, 123456, 0:[999, 1234567890], null, {testkey=testvalue}]], [999, 1234567890], [999, 1234455555]]]"), new String("[Avro Employee2, 11111, 25, FEMALE, [[[Avro First Address2, Avro Second Address2, Avro City2, 123456, 0:[999, 1234567890], null, {testkey=testvalue}], [Avro First Address2, Avro Second Address2, Avro City2, 123456, 0:[999, 1234567890], null, {testkey=testvalue}]], [999, 1234567890], [999, 1234455555]]]")};
        int[] expectedMapSize = new int[]{2};
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForHiveAvroColumnFamilyMap();
        serDe.initialize(conf, tbl);
        Text notPresentKey = new Text("prefixA_avro1");
        this.deserializeAndSerializeHiveStructColumnFamily(serDe, r, p, expectedFieldsData, expectedMapSize, expectedQualifiers, notPresentKey);
    }

    private Properties createPropertiesForHiveAvroColumnFamilyMap() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.prefixB_.serialization.type", "avro");
        tbl.setProperty("cola.prefixB_.serialization.class", "org.apache.hadoop.hive.hbase.avro.Employee");
        tbl.setProperty("hbase.columns.mapping", "cola:prefixB_.*");
        tbl.setProperty("hbase.struct.autogenerate", "true");
        tbl.setProperty("hive.serialization.extend.nesting.levels", "true");
        return tbl;
    }

    public void testHBaseSerDeCustomStructValue() throws IOException, SerDeException {
        byte[] cfa = "cola".getBytes();
        byte[] qualStruct = "struct".getBytes();
        TestStruct testStruct = new TestStruct("A", "B", "C", false, 0);
        byte[] key = testStruct.getBytes();
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        byte[] testData = testStruct.getBytes();
        kvs.add(new KeyValue(key, cfa, qualStruct, testData));
        Result r = Result.create(kvs);
        byte[] putKey = testStruct.getBytesWithDelimiters();
        Put p = new Put(putKey);
        p.add((Cell)new KeyValue(putKey, cfa, qualStruct, Bytes.padTail((byte[])testData, (int)2)));
        HBaseSerDe serDe = new HBaseSerDe();
        Configuration conf = new Configuration();
        Properties tbl = this.createPropertiesForValueStruct();
        serDe.initialize(conf, tbl);
        this.deserializeAndSerializeHBaseValueStruct(serDe, r, p);
    }

    public void testEmptyColumnComment() throws SerDeException {
        HBaseSerDe serDe = new HBaseSerDe();
        Properties tbl = this.createPropertiesForValueStruct();
        tbl.setProperty("columns.comments", "");
        serDe.initialize(new Configuration(), tbl);
    }

    private Properties createPropertiesForValueStruct() {
        Properties tbl = new Properties();
        tbl.setProperty("cola.struct.serialization.type", "struct");
        tbl.setProperty("cola.struct.test.value", "test value");
        tbl.setProperty("hbase.struct.serialization.class", "org.apache.hadoop.hive.hbase.HBaseTestStructSerializer");
        tbl.setProperty("columns", "key,astring");
        tbl.setProperty("columns.types", "struct<col1:string,col2:string,col3:string>,struct<col1:string,col2:string,col3:string>");
        tbl.setProperty("hbase.columns.mapping", ":key,cola:struct");
        tbl.setProperty("hbase.composite.key.class", "org.apache.hadoop.hive.hbase.HBaseTestCompositeKey");
        return tbl;
    }

    private void deserializeAndSerializeHBaseValueStruct(HBaseSerDe serDe, Result r, Put p) throws SerDeException, IOException {
        StructObjectInspector soi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        Object fieldData = null;
        for (int j = 0; j < fieldRefs.size(); ++j) {
            fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(j));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
            if (fieldData instanceof LazyStruct) {
                TestHBaseSerDe.assertEquals((String)((LazyStruct)fieldData).getField(0).toString(), (String)"A");
                TestHBaseSerDe.assertEquals((String)((LazyStruct)fieldData).getField(1).toString(), (String)"B");
                TestHBaseSerDe.assertEquals((String)((LazyStruct)fieldData).getField(2).toString(), (String)"C");
                continue;
            }
            Assert.fail((String)"fieldData should be an instance of LazyStruct");
        }
        TestHBaseSerDe.assertEquals((String)"{\"key\":{\"col1\":\"A\",\"col2\":\"B\",\"col3\":\"C\"},\"astring\":{\"col1\":\"A\",\"col2\":\"B\",\"col3\":\"C\"}}", (String)SerDeUtils.getJSONString((Object)row, (ObjectInspector)soi));
        Put put = ((PutWritable)serDe.serialize(row, (ObjectInspector)soi)).getPut();
        TestHBaseSerDe.assertEquals((String)"Serialized put:", (String)p.toString(), (String)put.toString());
    }

    private void deserializeAndSerializeHiveAvro(HBaseSerDe serDe, Result r, Put p, Object[] expectedFieldsData, String expectedDeserializedAvroString) throws SerDeException, IOException {
        StructObjectInspector soi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        for (int j = 0; j < fieldRefs.size(); ++j) {
            Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(j));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
            TestHBaseSerDe.assertEquals((Object)expectedFieldsData[j], (Object)fieldData.toString().trim());
        }
        TestHBaseSerDe.assertEquals((String)expectedDeserializedAvroString, (String)SerDeUtils.getJSONString((Object)row, (ObjectInspector)soi));
        Put put = ((PutWritable)serDe.serialize(row, (ObjectInspector)soi)).getPut();
        TestHBaseSerDe.assertNotNull((Object)put);
        TestHBaseSerDe.assertEquals((Object)p.getFamilyCellMap(), (Object)put.getFamilyCellMap());
    }

    private void deserializeAndSerializeHiveStructColumnFamily(HBaseSerDe serDe, Result r, Put p, Object[] expectedFieldsData, int[] expectedMapSize, List<Object> expectedQualifiers, Object notPresentKey) throws SerDeException, IOException {
        StructObjectInspector soi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object row = serDe.deserialize((Writable)new ResultWritable(r));
        int k = 0;
        for (int i = 0; i < fieldRefs.size(); ++i) {
            Object fieldData = soi.getStructFieldData(row, (StructField)fieldRefs.get(i));
            TestHBaseSerDe.assertNotNull((Object)fieldData);
            if (fieldData instanceof LazyPrimitive) {
                TestHBaseSerDe.assertEquals((Object)expectedFieldsData[i], (Object)((LazyPrimitive)fieldData).getWritableObject());
                continue;
            }
            if (fieldData instanceof LazyHBaseCellMap) {
                for (int j = 0; j < ((LazyHBaseCellMap)fieldData).getMapSize(); ++j) {
                    TestHBaseSerDe.assertEquals((Object)expectedFieldsData[k + 1], (Object)((LazyHBaseCellMap)fieldData).getMapValueElement(expectedQualifiers.get(k)).toString().trim());
                    ++k;
                }
                TestHBaseSerDe.assertEquals((int)expectedMapSize[i - 1], (int)((LazyHBaseCellMap)fieldData).getMapSize());
                TestHBaseSerDe.assertNull((Object)((LazyHBaseCellMap)fieldData).getMapValueElement(notPresentKey));
                continue;
            }
            TestHBaseSerDe.fail((String)"Error: field data not an instance of LazyPrimitive<?, ?> or LazyHBaseCellMap");
        }
        SerDeUtils.getJSONString((Object)row, (ObjectInspector)soi);
        Put put = ((PutWritable)serDe.serialize(row, (ObjectInspector)soi)).getPut();
        TestHBaseSerDe.assertNotNull((Object)put);
    }

    private byte[] getTestAvroBytesFromSchema(String schemaToUse) throws IOException {
        Schema s = Schema.parse((String)schemaToUse);
        GenericData.Record record = new GenericData.Record(s);
        GenericData.Record innerRecord = new GenericData.Record(s.getField("aRecord").schema());
        innerRecord.put("int1", (Object)42);
        innerRecord.put("boolean1", (Object)true);
        innerRecord.put("long1", (Object)42432234234L);
        if (schemaToUse.equals(RECORD_SCHEMA_EVOLVED)) {
            innerRecord.put("string1", (Object)"new value");
        }
        record.put("aRecord", (Object)innerRecord);
        GenericDatumWriter datumWriter = new GenericDatumWriter(s);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.create(s, (OutputStream)out);
        dataFileWriter.append((Object)record);
        dataFileWriter.close();
        byte[] data = out.toByteArray();
        out.close();
        return data;
    }

    private byte[] getTestAvroBytesFromClass1(int i) throws IOException {
        Employee employee = new Employee();
        employee.setEmployeeName("Avro Employee" + i);
        employee.setEmployeeID(11111L);
        employee.setGender(Gender.FEMALE);
        employee.setAge(25L);
        Address address = new Address();
        address.setAddress1("Avro First Address" + i);
        address.setAddress2("Avro Second Address" + i);
        address.setCity("Avro City" + i);
        address.setZipcode(123456L);
        HashMap<CharSequence, CharSequence> metadata = new HashMap<CharSequence, CharSequence>();
        metadata.put("testkey", "testvalue");
        address.setMetadata(metadata);
        HomePhone hPhone = new HomePhone();
        hPhone.setAreaCode(999L);
        hPhone.setNumber(1234567890L);
        OfficePhone oPhone = new OfficePhone();
        oPhone.setAreaCode(999L);
        oPhone.setNumber(1234455555L);
        ContactInfo contact = new ContactInfo();
        ArrayList<Address> addresses = new ArrayList<Address>();
        address.setCounty((Object)hPhone);
        addresses.add(address);
        addresses.add(address);
        contact.setAddress(addresses);
        contact.setHomePhone(hPhone);
        contact.setOfficePhone(oPhone);
        employee.setContactInfo(contact);
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(Employee.class);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        dataFileWriter.create(employee.getSchema(), (OutputStream)out);
        dataFileWriter.append((Object)employee);
        dataFileWriter.close();
        return out.toByteArray();
    }

    private byte[] getTestAvroBytesFromClass2(int i) throws IOException {
        Employee employee = new Employee();
        employee.setEmployeeName("Avro Employee" + i);
        employee.setEmployeeID(11111L);
        employee.setGender(Gender.FEMALE);
        employee.setAge(25L);
        Address address = new Address();
        address.setAddress1("Avro First Address" + i);
        address.setAddress2("Avro Second Address" + i);
        address.setCity("Avro City" + i);
        address.setZipcode(123456L);
        HashMap<CharSequence, CharSequence> metadata = new HashMap<CharSequence, CharSequence>();
        metadata.put("testkey", "testvalue");
        address.setMetadata(metadata);
        HomePhone hPhone = new HomePhone();
        hPhone.setAreaCode(999L);
        hPhone.setNumber(1234567890L);
        OfficePhone oPhone = new OfficePhone();
        oPhone.setAreaCode(999L);
        oPhone.setNumber(1234455555L);
        ContactInfo contact = new ContactInfo();
        ArrayList<Address> addresses = new ArrayList<Address>();
        address.setCounty((Object)hPhone);
        addresses.add(address);
        addresses.add(address);
        contact.setAddress(addresses);
        contact.setHomePhone(hPhone);
        contact.setOfficePhone(oPhone);
        employee.setContactInfo(contact);
        SpecificDatumWriter employeeWriter = new SpecificDatumWriter(Employee.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        out.write(TEST_BYTE_ARRAY);
        employeeWriter.write((Object)employee, (Encoder)encoder);
        encoder.flush();
        return out.toByteArray();
    }

    class TestStruct {
        String f1;
        String f2;
        String f3;
        boolean hasSeparator;
        byte separator;

        TestStruct(String f1, String f2, String f3, boolean hasSeparator, byte separator) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.hasSeparator = hasSeparator;
            this.separator = separator;
        }

        public byte[] getBytes() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.f1.getBytes());
            if (this.hasSeparator) {
                bos.write(this.separator);
            }
            bos.write(this.f2.getBytes());
            if (this.hasSeparator) {
                bos.write(this.separator);
            }
            bos.write(this.f3.getBytes());
            return bos.toByteArray();
        }

        public byte[] getBytesWithDelimiters() throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.f1.getBytes());
            bos.write("\u0002".getBytes("UTF8"));
            bos.write(this.f2.getBytes());
            bos.write("\u0002".getBytes("UTF8"));
            bos.write(this.f3.getBytes());
            return bos.toByteArray();
        }
    }
}

