/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.DefaultHBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.HBaseSerDeHelper;
import org.apache.hadoop.hive.hbase.HBaseSerDeParameters;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.hbase.struct.HBaseValueFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.LazyTimestamp;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.LongWritable;

public class LazyHBaseRow
extends LazyStruct {
    private Result result;
    private ArrayList<Object> cachedList;
    private final HBaseKeyFactory keyFactory;
    private final List<HBaseValueFactory> valueFactories;
    private final ColumnMappings.ColumnMapping[] columnsMapping;

    @VisibleForTesting
    LazyHBaseRow(LazySimpleStructObjectInspector oi, ColumnMappings columnMappings) {
        super(oi);
        this.keyFactory = DefaultHBaseKeyFactory.forTest(null, columnMappings);
        this.valueFactories = null;
        this.columnsMapping = columnMappings.getColumnsMapping();
    }

    public LazyHBaseRow(LazySimpleStructObjectInspector oi, HBaseSerDeParameters serdeParams) {
        super(oi);
        this.keyFactory = serdeParams.getKeyFactory();
        this.valueFactories = serdeParams.getValueFactories();
        this.columnsMapping = serdeParams.getColumnMappings().getColumnsMapping();
    }

    public void init(Result r) {
        this.result = r;
        this.setParsed(false);
    }

    protected LazyObjectBase createLazyField(int fieldID, StructField fieldRef) throws SerDeException {
        if (this.columnsMapping[fieldID].hbaseRowKey) {
            return this.keyFactory.createKey(fieldRef.getFieldObjectInspector());
        }
        if (this.columnsMapping[fieldID].hbaseTimestamp) {
            return LazyFactory.createLazyObject((ObjectInspector)fieldRef.getFieldObjectInspector());
        }
        if (this.valueFactories != null) {
            return this.valueFactories.get(fieldID).createValueObject(fieldRef.getFieldObjectInspector());
        }
        return HBaseSerDeHelper.createLazyField(this.columnsMapping, fieldID, fieldRef.getFieldObjectInspector());
    }

    public Object getField(int fieldID) {
        this.initFields();
        return this.uncheckedGetField(fieldID);
    }

    private void initFields() {
        if (this.getFields() == null) {
            this.initLazyFields(((LazySimpleStructObjectInspector)this.oi).getAllStructFieldRefs());
        }
        if (!this.getParsed()) {
            Arrays.fill(this.getFieldInited(), false);
            this.setParsed(true);
        }
    }

    private Object uncheckedGetField(int fieldID) {
        LazyObjectBase[] fields = this.getFields();
        boolean[] fieldsInited = this.getFieldInited();
        if (!fieldsInited[fieldID]) {
            fieldsInited[fieldID] = true;
            ColumnMappings.ColumnMapping colMap = this.columnsMapping[fieldID];
            if (!colMap.hbaseRowKey && !colMap.hbaseTimestamp && colMap.qualifierName == null) {
                ((LazyHBaseCellMap)fields[fieldID]).init(this.result, colMap.familyNameBytes, colMap.binaryStorage, colMap.qualifierPrefixBytes, colMap.isDoPrefixCut());
                return fields[fieldID].getObject();
            }
            if (colMap.hbaseTimestamp) {
                long timestamp = this.result.rawCells()[0].getTimestamp();
                for (int i = 1; i < this.result.rawCells().length; ++i) {
                    timestamp = Math.max(timestamp, this.result.rawCells()[i].getTimestamp());
                }
                LazyObjectBase lz = fields[fieldID];
                if (lz instanceof LazyTimestamp) {
                    ((LazyTimestamp)lz).getWritableObject().setTime(timestamp);
                } else {
                    ((LongWritable)((LazyLong)lz).getWritableObject()).set(timestamp);
                }
                return lz.getObject();
            }
            byte[] bytes = colMap.hbaseRowKey ? this.result.getRow() : this.result.getValue(colMap.familyNameBytes, colMap.qualifierNameBytes);
            if (bytes == null || this.isNull(((LazySimpleStructObjectInspector)this.oi).getNullSequence(), bytes, 0, bytes.length)) {
                fields[fieldID].setNull();
            } else {
                ByteArrayRef ref = new ByteArrayRef();
                ref.setData(bytes);
                fields[fieldID].init(ref, 0, bytes.length);
            }
        }
        return fields[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        this.initFields();
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

