/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.VoidObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;

public final class GenericUDFUtils {
    public static boolean isUtfStartByte(byte b) {
        return (b & 0xC0) != 128;
    }

    public static TypeInfo deriveInType(List<ExprNodeDesc> children) {
        TypeInfo returnType = null;
        for (ExprNodeDesc node : children) {
            TypeInfo ti = node.getTypeInfo();
            if (ti.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)ti).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.VOID) continue;
            if (returnType == null) {
                returnType = ti;
                continue;
            }
            if (returnType == ti) continue;
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForComparison(returnType, ti);
            if (commonTypeInfo == null) {
                return null;
            }
            returnType = commonTypeInfo;
        }
        return returnType;
    }

    public static String getOrdinal(int i) {
        int unit = i % 10;
        return i <= 0 ? "" : (i != 11 && unit == 1 ? i + "st" : (i != 12 && unit == 2 ? i + "nd" : (i != 13 && unit == 3 ? i + "rd" : i + "th")));
    }

    public static int findText(Text text, Text subtext, int start) {
        String subtextString;
        int length = text.getLength() - start;
        if (start < 0 || length < 0 || length < subtext.getLength()) {
            return -1;
        }
        if (subtext.getLength() == 0) {
            return 0;
        }
        if (length == 0) {
            return -1;
        }
        String textString = text.toString();
        int index = textString.indexOf(subtextString = subtext.toString(), start);
        if (index == -1) {
            return index;
        }
        return textString.codePointCount(0, index);
    }

    private GenericUDFUtils() {
    }

    public static class StringHelper {
        protected Object returnValue;
        protected PrimitiveObjectInspector.PrimitiveCategory type;

        public StringHelper(PrimitiveObjectInspector.PrimitiveCategory type) throws UDFArgumentException {
            this.type = type;
            switch (type) {
                case STRING: {
                    this.returnValue = new Text();
                    break;
                }
                case CHAR: {
                    this.returnValue = new HiveCharWritable();
                    break;
                }
                case VARCHAR: {
                    this.returnValue = new HiveVarcharWritable();
                    break;
                }
                default: {
                    throw new UDFArgumentException("Unexpected non-string type " + type);
                }
            }
        }

        public Object setReturnValue(String val) throws UDFArgumentException {
            if (val == null) {
                return null;
            }
            switch (this.type) {
                case STRING: {
                    ((Text)this.returnValue).set(val);
                    return this.returnValue;
                }
                case CHAR: {
                    ((HiveCharWritable)this.returnValue).set(val);
                    return this.returnValue;
                }
                case VARCHAR: {
                    ((HiveVarcharWritable)this.returnValue).set(val);
                    return this.returnValue;
                }
            }
            throw new UDFArgumentException("Bad return type " + this.type);
        }

        public static int getFixedStringSizeForType(PrimitiveObjectInspector poi) throws UDFArgumentException {
            switch (poi.getPrimitiveCategory()) {
                case CHAR: 
                case VARCHAR: {
                    BaseCharTypeInfo typeInfo = (BaseCharTypeInfo)poi.getTypeInfo();
                    return typeInfo.getLength();
                }
            }
            throw new UDFArgumentException("No fixed size for type " + poi.getTypeName());
        }
    }

    public static class ConversionHelper {
        private final ObjectInspector[] givenParameterOIs;
        Type[] methodParameterTypes;
        private final boolean isVariableLengthArgument;
        Type lastParaElementType;
        boolean conversionNeeded;
        ObjectInspectorConverters.Converter[] converters;
        Object[] convertedParameters;
        Object[] convertedParametersInArray;

        private static Class<?> getClassFromType(Type t) {
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                return (Class)pt.getRawType();
            }
            return null;
        }

        public ConversionHelper(Method m, ObjectInspector[] parameterOIs) throws UDFArgumentException {
            this.givenParameterOIs = parameterOIs;
            this.methodParameterTypes = m.getGenericParameterTypes();
            this.lastParaElementType = TypeInfoUtils.getArrayElementType(this.methodParameterTypes.length == 0 ? null : this.methodParameterTypes[this.methodParameterTypes.length - 1]);
            this.isVariableLengthArgument = this.lastParaElementType != null;
            ObjectInspector[] methodParameterOIs = new ObjectInspector[parameterOIs.length];
            if (this.isVariableLengthArgument) {
                int i;
                if (parameterOIs.length < this.methodParameterTypes.length - 1) {
                    throw new UDFArgumentLengthException(m.toString() + " requires at least " + (this.methodParameterTypes.length - 1) + " arguments but only " + parameterOIs.length + " are passed in.");
                }
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector(this.methodParameterTypes[i], ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
                if (this.lastParaElementType == Object.class) {
                    for (i = this.methodParameterTypes.length - 1; i < parameterOIs.length; ++i) {
                        methodParameterOIs[i] = ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
                    }
                } else {
                    ObjectInspector oi = ObjectInspectorFactory.getReflectionObjectInspector(this.lastParaElementType, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                    for (int i2 = this.methodParameterTypes.length - 1; i2 < parameterOIs.length; ++i2) {
                        methodParameterOIs[i2] = oi;
                    }
                }
            } else {
                if (this.methodParameterTypes.length != parameterOIs.length) {
                    throw new UDFArgumentLengthException(m.toString() + " requires " + this.methodParameterTypes.length + " arguments but " + parameterOIs.length + " are passed in.");
                }
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    methodParameterOIs[i] = this.methodParameterTypes[i] == Object.class ? ObjectInspectorUtils.getStandardObjectInspector(parameterOIs[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA) : ObjectInspectorFactory.getReflectionObjectInspector(this.methodParameterTypes[i], ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
                }
            }
            this.conversionNeeded = false;
            this.converters = new ObjectInspectorConverters.Converter[parameterOIs.length];
            for (int i = 0; i < parameterOIs.length; ++i) {
                ObjectInspectorConverters.Converter pc;
                this.converters[i] = pc = ObjectInspectorConverters.getConverter(parameterOIs[i], methodParameterOIs[i]);
                this.conversionNeeded = this.conversionNeeded || !(pc instanceof ObjectInspectorConverters.IdentityConverter);
            }
            if (this.isVariableLengthArgument) {
                this.convertedParameters = new Object[this.methodParameterTypes.length];
                this.convertedParameters[this.convertedParameters.length - 1] = this.convertedParametersInArray = (Object[])Array.newInstance(ConversionHelper.getClassFromType(this.lastParaElementType), parameterOIs.length - this.methodParameterTypes.length + 1);
            } else {
                this.convertedParameters = new Object[parameterOIs.length];
            }
        }

        public Object[] convertIfNecessary(Object ... parameters) {
            assert (parameters.length == this.givenParameterOIs.length);
            if (!this.conversionNeeded && !this.isVariableLengthArgument) {
                return parameters;
            }
            if (this.isVariableLengthArgument) {
                int i;
                for (i = 0; i < this.methodParameterTypes.length - 1; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
                for (i = this.methodParameterTypes.length - 1; i < parameters.length; ++i) {
                    this.convertedParametersInArray[i + 1 - this.methodParameterTypes.length] = this.converters[i].convert(parameters[i]);
                }
            } else {
                for (int i = 0; i < this.methodParameterTypes.length; ++i) {
                    this.convertedParameters[i] = this.converters[i].convert(parameters[i]);
                }
            }
            return this.convertedParameters;
        }
    }

    public static class ReturnObjectInspectorResolver {
        boolean allowTypeConversion;
        ObjectInspector returnObjectInspector;
        HashMap<ObjectInspector, ObjectInspectorConverters.Converter> converters;

        public ReturnObjectInspectorResolver() {
            this(false);
        }

        public ReturnObjectInspectorResolver(boolean allowTypeConversion) {
            this.allowTypeConversion = allowTypeConversion;
        }

        public boolean update(ObjectInspector oi) throws UDFArgumentTypeException {
            return this.update(oi, ConversionType.COMMON);
        }

        public boolean updateForUnionAll(ObjectInspector oi) throws UDFArgumentTypeException {
            return this.update(oi, ConversionType.UNION);
        }

        public boolean updateForComparison(ObjectInspector oi) throws UDFArgumentTypeException {
            return this.update(oi, ConversionType.COMPARISON);
        }

        private boolean update(ObjectInspector oi, ConversionType conversionType) throws UDFArgumentTypeException {
            TypeInfo rTypeInfo;
            if (oi instanceof VoidObjectInspector) {
                return true;
            }
            if (this.returnObjectInspector == null) {
                this.returnObjectInspector = ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                return true;
            }
            if (this.returnObjectInspector == oi) {
                return true;
            }
            TypeInfo oiTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(oi);
            if (oiTypeInfo == (rTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector(this.returnObjectInspector))) {
                this.returnObjectInspector = ObjectInspectorUtils.getStandardObjectInspector(this.returnObjectInspector, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                return true;
            }
            if (!this.allowTypeConversion) {
                return false;
            }
            TypeInfo commonTypeInfo = null;
            switch (conversionType) {
                case COMMON: {
                    commonTypeInfo = FunctionRegistry.getCommonClass(oiTypeInfo, rTypeInfo);
                    break;
                }
                case UNION: {
                    commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(rTypeInfo, oiTypeInfo);
                    break;
                }
                case COMPARISON: {
                    commonTypeInfo = FunctionRegistry.getCommonClassForComparison(rTypeInfo, oiTypeInfo);
                }
            }
            if (commonTypeInfo == null) {
                return false;
            }
            this.returnObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(commonTypeInfo);
            return true;
        }

        public ObjectInspector get() {
            return this.get(PrimitiveObjectInspectorFactory.javaVoidObjectInspector);
        }

        public ObjectInspector get(ObjectInspector defaultOI) {
            return this.returnObjectInspector != null ? this.returnObjectInspector : defaultOI;
        }

        public Object convertIfNecessary(Object o, ObjectInspector oi) {
            return this.convertIfNecessary(o, oi, true);
        }

        public Object convertIfNecessary(Object o, ObjectInspector oi, boolean reuse) {
            Object converted = null;
            if (oi == this.returnObjectInspector) {
                converted = o;
            } else {
                if (o == null) {
                    return null;
                }
                ObjectInspectorConverters.Converter converter = null;
                if (reuse) {
                    if (this.converters == null) {
                        this.converters = new HashMap();
                    }
                    converter = this.converters.get(oi);
                }
                if (converter == null) {
                    converter = ObjectInspectorConverters.getConverter(oi, this.returnObjectInspector);
                    if (reuse) {
                        this.converters.put(oi, converter);
                    }
                }
                converted = converter.convert(o);
            }
            return converted;
        }

        public static enum ConversionType {
            COMMON,
            UNION,
            COMPARISON;

        }
    }
}

