/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.NodeType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class Graph
implements TBase<Graph, _Fields>,
Serializable,
Cloneable,
Comparable<Graph> {
    private static final TStruct STRUCT_DESC = new TStruct("Graph");
    private static final TField NODE_TYPE_FIELD_DESC = new TField("nodeType", 8, 1);
    private static final TField ROOTS_FIELD_DESC = new TField("roots", 15, 2);
    private static final TField ADJACENCY_LIST_FIELD_DESC = new TField("adjacencyList", 15, 3);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new GraphStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new GraphTupleSchemeFactory();
    @Nullable
    private NodeType nodeType;
    @Nullable
    private List<String> roots;
    @Nullable
    private List<Adjacency> adjacencyList;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Graph() {
    }

    public Graph(NodeType nodeType, List<String> roots, List<Adjacency> adjacencyList) {
        this();
        this.nodeType = nodeType;
        this.roots = roots;
        this.adjacencyList = adjacencyList;
    }

    public Graph(Graph other) {
        if (other.isSetNodeType()) {
            this.nodeType = other.nodeType;
        }
        if (other.isSetRoots()) {
            ArrayList<String> __this__roots = new ArrayList<String>(other.roots);
            this.roots = __this__roots;
        }
        if (other.isSetAdjacencyList()) {
            ArrayList<Adjacency> __this__adjacencyList = new ArrayList<Adjacency>(other.adjacencyList.size());
            for (Adjacency other_element : other.adjacencyList) {
                __this__adjacencyList.add(new Adjacency(other_element));
            }
            this.adjacencyList = __this__adjacencyList;
        }
    }

    @Override
    public Graph deepCopy() {
        return new Graph(this);
    }

    @Override
    public void clear() {
        this.nodeType = null;
        this.roots = null;
        this.adjacencyList = null;
    }

    @Nullable
    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(@Nullable NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void unsetNodeType() {
        this.nodeType = null;
    }

    public boolean isSetNodeType() {
        return this.nodeType != null;
    }

    public void setNodeTypeIsSet(boolean value) {
        if (!value) {
            this.nodeType = null;
        }
    }

    public int getRootsSize() {
        return this.roots == null ? 0 : this.roots.size();
    }

    @Nullable
    public Iterator<String> getRootsIterator() {
        return this.roots == null ? null : this.roots.iterator();
    }

    public void addToRoots(String elem) {
        if (this.roots == null) {
            this.roots = new ArrayList<String>();
        }
        this.roots.add(elem);
    }

    @Nullable
    public List<String> getRoots() {
        return this.roots;
    }

    public void setRoots(@Nullable List<String> roots) {
        this.roots = roots;
    }

    public void unsetRoots() {
        this.roots = null;
    }

    public boolean isSetRoots() {
        return this.roots != null;
    }

    public void setRootsIsSet(boolean value) {
        if (!value) {
            this.roots = null;
        }
    }

    public int getAdjacencyListSize() {
        return this.adjacencyList == null ? 0 : this.adjacencyList.size();
    }

    @Nullable
    public Iterator<Adjacency> getAdjacencyListIterator() {
        return this.adjacencyList == null ? null : this.adjacencyList.iterator();
    }

    public void addToAdjacencyList(Adjacency elem) {
        if (this.adjacencyList == null) {
            this.adjacencyList = new ArrayList<Adjacency>();
        }
        this.adjacencyList.add(elem);
    }

    @Nullable
    public List<Adjacency> getAdjacencyList() {
        return this.adjacencyList;
    }

    public void setAdjacencyList(@Nullable List<Adjacency> adjacencyList) {
        this.adjacencyList = adjacencyList;
    }

    public void unsetAdjacencyList() {
        this.adjacencyList = null;
    }

    public boolean isSetAdjacencyList() {
        return this.adjacencyList != null;
    }

    public void setAdjacencyListIsSet(boolean value) {
        if (!value) {
            this.adjacencyList = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case NODE_TYPE: {
                if (value == null) {
                    this.unsetNodeType();
                    break;
                }
                this.setNodeType((NodeType)value);
                break;
            }
            case ROOTS: {
                if (value == null) {
                    this.unsetRoots();
                    break;
                }
                this.setRoots((List)value);
                break;
            }
            case ADJACENCY_LIST: {
                if (value == null) {
                    this.unsetAdjacencyList();
                    break;
                }
                this.setAdjacencyList((List)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NODE_TYPE: {
                return this.getNodeType();
            }
            case ROOTS: {
                return this.getRoots();
            }
            case ADJACENCY_LIST: {
                return this.getAdjacencyList();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NODE_TYPE: {
                return this.isSetNodeType();
            }
            case ROOTS: {
                return this.isSetRoots();
            }
            case ADJACENCY_LIST: {
                return this.isSetAdjacencyList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof Graph) {
            return this.equals((Graph)that);
        }
        return false;
    }

    public boolean equals(Graph that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_nodeType = this.isSetNodeType();
        boolean that_present_nodeType = that.isSetNodeType();
        if (this_present_nodeType || that_present_nodeType) {
            if (!this_present_nodeType || !that_present_nodeType) {
                return false;
            }
            if (!this.nodeType.equals(that.nodeType)) {
                return false;
            }
        }
        boolean this_present_roots = this.isSetRoots();
        boolean that_present_roots = that.isSetRoots();
        if (this_present_roots || that_present_roots) {
            if (!this_present_roots || !that_present_roots) {
                return false;
            }
            if (!this.roots.equals(that.roots)) {
                return false;
            }
        }
        boolean this_present_adjacencyList = this.isSetAdjacencyList();
        boolean that_present_adjacencyList = that.isSetAdjacencyList();
        if (this_present_adjacencyList || that_present_adjacencyList) {
            if (!this_present_adjacencyList || !that_present_adjacencyList) {
                return false;
            }
            if (!this.adjacencyList.equals(that.adjacencyList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetNodeType() ? 131071 : 524287);
        if (this.isSetNodeType()) {
            hashCode = hashCode * 8191 + this.nodeType.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetRoots() ? 131071 : 524287);
        if (this.isSetRoots()) {
            hashCode = hashCode * 8191 + this.roots.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAdjacencyList() ? 131071 : 524287);
        if (this.isSetAdjacencyList()) {
            hashCode = hashCode * 8191 + this.adjacencyList.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(Graph other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetNodeType(), other.isSetNodeType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNodeType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.nodeType), (Comparable)((Object)other.nodeType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRoots(), other.isSetRoots());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRoots() && (lastComparison = TBaseHelper.compareTo(this.roots, other.roots)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAdjacencyList(), other.isSetAdjacencyList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAdjacencyList() && (lastComparison = TBaseHelper.compareTo(this.adjacencyList, other.adjacencyList)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        Graph.scheme(iprot).read(iprot, (Graph)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        Graph.scheme(oprot).write(oprot, (Graph)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Graph(");
        boolean first = true;
        sb.append("nodeType:");
        if (this.nodeType == null) {
            sb.append("null");
        } else {
            sb.append(this.nodeType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("roots:");
        if (this.roots == null) {
            sb.append("null");
        } else {
            sb.append(this.roots);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("adjacencyList:");
        if (this.adjacencyList == null) {
            sb.append("null");
        } else {
            sb.append(this.adjacencyList);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NODE_TYPE, new FieldMetaData("nodeType", 3, new EnumMetaData(16, NodeType.class)));
        tmpMap.put(_Fields.ROOTS, new FieldMetaData("roots", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ADJACENCY_LIST, new FieldMetaData("adjacencyList", 3, new ListMetaData(15, new StructMetaData(12, Adjacency.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Graph.class, metaDataMap);
    }

    private static class GraphTupleScheme
    extends TupleScheme<Graph> {
        private GraphTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, Graph struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetNodeType()) {
                optionals.set(0);
            }
            if (struct.isSetRoots()) {
                optionals.set(1);
            }
            if (struct.isSetAdjacencyList()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetNodeType()) {
                oprot.writeI32(struct.nodeType.getValue());
            }
            if (struct.isSetRoots()) {
                oprot.writeI32(struct.roots.size());
                for (String _iter16 : struct.roots) {
                    oprot.writeString(_iter16);
                }
            }
            if (struct.isSetAdjacencyList()) {
                oprot.writeI32(struct.adjacencyList.size());
                for (Adjacency _iter17 : struct.adjacencyList) {
                    _iter17.write(oprot);
                }
            }
        }

        @Override
        public void read(TProtocol prot, Graph struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.nodeType = NodeType.findByValue(iprot.readI32());
                struct.setNodeTypeIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list18 = iprot.readListBegin((byte)11);
                struct.roots = new ArrayList<String>(_list18.size);
                for (int _i20 = 0; _i20 < _list18.size; ++_i20) {
                    String _elem19 = iprot.readString();
                    struct.roots.add(_elem19);
                }
                struct.setRootsIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list21 = iprot.readListBegin((byte)12);
                struct.adjacencyList = new ArrayList<Adjacency>(_list21.size);
                for (int _i23 = 0; _i23 < _list21.size; ++_i23) {
                    Adjacency _elem22 = new Adjacency();
                    _elem22.read(iprot);
                    struct.adjacencyList.add(_elem22);
                }
                struct.setAdjacencyListIsSet(true);
            }
        }
    }

    private static class GraphTupleSchemeFactory
    implements SchemeFactory {
        private GraphTupleSchemeFactory() {
        }

        public GraphTupleScheme getScheme() {
            return new GraphTupleScheme();
        }
    }

    private static class GraphStandardScheme
    extends StandardScheme<Graph> {
        private GraphStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, Graph struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.nodeType = NodeType.findByValue(iprot.readI32());
                            struct.setNodeTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list8 = iprot.readListBegin();
                            struct.roots = new ArrayList<String>(_list8.size);
                            for (int _i10 = 0; _i10 < _list8.size; ++_i10) {
                                String _elem9 = iprot.readString();
                                struct.roots.add(_elem9);
                            }
                            iprot.readListEnd();
                            struct.setRootsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list11 = iprot.readListBegin();
                            struct.adjacencyList = new ArrayList<Adjacency>(_list11.size);
                            for (int _i13 = 0; _i13 < _list11.size; ++_i13) {
                                Adjacency _elem12 = new Adjacency();
                                _elem12.read(iprot);
                                struct.adjacencyList.add(_elem12);
                            }
                            iprot.readListEnd();
                            struct.setAdjacencyListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, Graph struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.nodeType != null) {
                oprot.writeFieldBegin(NODE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.nodeType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.roots != null) {
                oprot.writeFieldBegin(ROOTS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.roots.size()));
                for (String _iter14 : struct.roots) {
                    oprot.writeString(_iter14);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.adjacencyList != null) {
                oprot.writeFieldBegin(ADJACENCY_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.adjacencyList.size()));
                for (Adjacency _iter15 : struct.adjacencyList) {
                    _iter15.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class GraphStandardSchemeFactory
    implements SchemeFactory {
        private GraphStandardSchemeFactory() {
        }

        public GraphStandardScheme getScheme() {
            return new GraphStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NODE_TYPE(1, "nodeType"),
        ROOTS(2, "roots"),
        ADJACENCY_LIST(3, "adjacencyList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NODE_TYPE;
                }
                case 2: {
                    return ROOTS;
                }
                case 3: {
                    return ADJACENCY_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

