/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.LogicVisitor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveSubQRemoveRelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.SubqueryConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;

public class HiveSubQueryRemoveRule
extends RelOptRule {
    private HiveConf conf;

    public HiveSubQueryRemoveRule(HiveConf conf) {
        super(HiveSubQueryRemoveRule.operand(RelNode.class, null, HiveSubQueryFinder.RELNODE_PREDICATE, (RelOptRuleOperandChildren)HiveSubQueryRemoveRule.any()), HiveRelFactories.HIVE_BUILDER, "SubQueryRemoveRule:Filter");
        this.conf = conf;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode relNode = call.rel(0);
        HiveSubQRemoveRelBuilder builder = new HiveSubQRemoveRelBuilder(null, call.rel(0).getCluster(), null);
        if (relNode instanceof Filter) {
            Filter filter = (Filter)call.rel(0);
            RexSubQuery e = RexUtil.SubQueryFinder.find((RexNode)filter.getCondition());
            assert (e != null);
            RelOptUtil.Logic logic = LogicVisitor.find((RelOptUtil.Logic)RelOptUtil.Logic.TRUE, ImmutableList.of(filter.getCondition()), (RexNode)e);
            builder.push(filter.getInput());
            int fieldCount = builder.peek().getRowType().getFieldCount();
            assert (filter instanceof HiveFilter);
            SubqueryConf subqueryConfig = (SubqueryConf)filter.getCluster().getPlanner().getContext().unwrap(SubqueryConf.class);
            boolean isCorrScalarQuery = subqueryConfig.getCorrScalarRexSQWithAgg().contains(e.rel);
            boolean hasNoWindowingAndNoGby = subqueryConfig.getScalarAggWithoutGbyWindowing().contains(e.rel);
            RexNode target = this.apply(e, HiveFilter.getVariablesSet(e), logic, builder, 1, fieldCount, isCorrScalarQuery, hasNoWindowingAndNoGby);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.filter(shuttle.apply(filter.getCondition()));
            builder.project(HiveSubQueryRemoveRule.fields(builder, filter.getRowType().getFieldCount()));
            call.transformTo(builder.build());
        } else if (relNode instanceof Project) {
            Project project = (Project)call.rel(0);
            RexSubQuery e = RexUtil.SubQueryFinder.find((Iterable)project.getProjects());
            assert (e != null);
            RelOptUtil.Logic logic = LogicVisitor.find((RelOptUtil.Logic)RelOptUtil.Logic.TRUE_FALSE_UNKNOWN, (List)project.getProjects(), (RexNode)e);
            builder.push(project.getInput());
            int fieldCount = builder.peek().getRowType().getFieldCount();
            SubqueryConf subqueryConfig = (SubqueryConf)project.getCluster().getPlanner().getContext().unwrap(SubqueryConf.class);
            boolean isCorrScalarQuery = subqueryConfig.getCorrScalarRexSQWithAgg().contains(e.rel);
            boolean hasNoWindowingAndNoGby = subqueryConfig.getScalarAggWithoutGbyWindowing().contains(e.rel);
            RexNode target = this.apply(e, HiveFilter.getVariablesSet(e), logic, builder, 1, fieldCount, isCorrScalarQuery, hasNoWindowingAndNoGby);
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            builder.project(shuttle.apply(project.getProjects()), project.getRowType().getFieldNames());
            call.transformTo(builder.build());
        }
    }

    private boolean isAggZeroOnEmpty(RexSubQuery e) {
        assert (e.getKind() == SqlKind.SCALAR_QUERY);
        assert (e.rel.getInputs().size() == 1);
        Aggregate relAgg = (Aggregate)e.rel.getInput(0);
        assert (relAgg.getAggCallList().size() == 1);
        return ((AggregateCall)relAgg.getAggCallList().get(0)).getAggregation().getKind() == SqlKind.COUNT;
    }

    private SqlTypeName getAggTypeForScalarSub(RexSubQuery e) {
        assert (e.getKind() == SqlKind.SCALAR_QUERY);
        assert (e.rel.getInputs().size() == 1);
        Aggregate relAgg = (Aggregate)e.rel.getInput(0);
        assert (relAgg.getAggCallList().size() == 1);
        return ((AggregateCall)relAgg.getAggCallList().get(0)).getType().getSqlTypeName();
    }

    protected RexNode apply(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, HiveSubQRemoveRelBuilder builder, int inputCount, int offset, boolean isCorrScalarAgg, boolean hasNoWindowingAndNoGby) {
        switch (e.getKind()) {
            case SCALAR_QUERY: {
                ArrayList<RexNode> parentQueryFields;
                if (!hasNoWindowingAndNoGby) {
                    parentQueryFields = new ArrayList<RexNode>();
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REMOVE_SQ_COUNT_CHECK)) {
                        parentQueryFields.addAll(builder.fields());
                    }
                    builder.push(e.rel);
                    builder.aggregate(builder.groupKey(), builder.count(false, "cnt", new RexNode[0]));
                    SqlFunction countCheck = new SqlFunction("sq_count_check", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
                    builder.filter(builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, builder.call((SqlOperator)countCheck, new RexNode[]{builder.field("cnt")}), builder.literal(1)));
                    if (!variablesSet.isEmpty()) {
                        builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                    } else {
                        builder.join(JoinRelType.INNER, builder.literal(true), variablesSet);
                    }
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_REMOVE_SQ_COUNT_CHECK)) {
                        builder.project(parentQueryFields);
                    } else {
                        ++offset;
                    }
                }
                if (isCorrScalarAgg) {
                    builder.push(e.rel);
                    parentQueryFields = new ArrayList();
                    parentQueryFields.addAll(builder.fields());
                    String indicator = "alwaysTrue" + e.rel.getId();
                    parentQueryFields.add(builder.alias(builder.literal(true), indicator));
                    builder.project(parentQueryFields);
                    builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                    ImmutableList.Builder operands = ImmutableList.builder();
                    Object literal = this.isAggZeroOnEmpty(e) ? e.rel.getCluster().getRexBuilder().makeBigintLiteral(new BigDecimal(0)) : e.rel.getCluster().getRexBuilder().makeNullLiteral(this.getAggTypeForScalarSub(e));
                    operands.add(new RexNode[]{builder.isNull((RexNode)builder.field(indicator)), literal});
                    operands.add(this.field(builder, 1, builder.fields().size() - 2));
                    return builder.call((SqlOperator)SqlStdOperatorTable.CASE, operands.build());
                }
                builder.push(e.rel);
                builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                return this.field(builder, inputCount, offset);
            }
            case IN: 
            case EXISTS: {
                builder.push(e.rel);
                ArrayList<RexNode> fields = new ArrayList<RexNode>();
                switch (e.getKind()) {
                    case IN: {
                        fields.addAll(builder.fields());
                        if (!isCorrScalarAgg) break;
                        builder.aggregate(builder.groupKey(), builder.count(false, "cnt_in", new RexNode[0]));
                        if (!variablesSet.isEmpty()) {
                            builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                        } else {
                            builder.join(JoinRelType.INNER, builder.literal(true), variablesSet);
                        }
                        SqlFunction inCountCheck = new SqlFunction("sq_count_check", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.USER_DEFINED_FUNCTION);
                        builder.filter(builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, builder.call((SqlOperator)inCountCheck, new RexNode[]{builder.field("cnt_in"), builder.literal(true)}), builder.literal(0)));
                        ++offset;
                        builder.push(e.rel);
                    }
                }
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        if (e.getKind() == SqlKind.EXISTS) {
                            logic = RelOptUtil.Logic.TRUE_FALSE;
                            break;
                        }
                        builder.aggregate(builder.groupKey(), builder.count(false, "c", new RexNode[0]), builder.aggregateCall(SqlStdOperatorTable.COUNT, false, null, "ck", builder.fields()));
                        builder.as("ct");
                        if (!variablesSet.isEmpty()) {
                            builder.join(JoinRelType.LEFT, builder.literal(true), variablesSet);
                        } else {
                            builder.join(JoinRelType.INNER, builder.literal(true), variablesSet);
                        }
                        offset += 2;
                        builder.push(e.rel);
                    }
                }
                String trueLiteral = "literalTrue";
                switch (logic) {
                    case TRUE: {
                        if (fields.isEmpty()) {
                            builder.project(builder.alias(builder.literal(true), trueLiteral));
                            if (!variablesSet.isEmpty() && (e.getKind() == SqlKind.EXISTS || e.getKind() == SqlKind.IN)) break;
                            builder.aggregate(builder.groupKey(0), new HiveSubQRemoveRelBuilder.AggCall[0]);
                            break;
                        }
                        if (!variablesSet.isEmpty() && (e.getKind() == SqlKind.EXISTS || e.getKind() == SqlKind.IN)) break;
                        builder.aggregate(builder.groupKey(fields), new HiveSubQRemoveRelBuilder.AggCall[0]);
                        break;
                    }
                    default: {
                        fields.add(builder.alias(builder.literal(true), trueLiteral));
                        builder.project(fields);
                        builder.distinct();
                    }
                }
                builder.as("dt");
                ArrayList<RexNode> conditions = new ArrayList<RexNode>();
                for (Object pair : Pair.zip((List)e.getOperands(), builder.fields())) {
                    conditions.add(builder.equals((RexNode)((Pair)pair).left, RexUtil.shift((RexNode)((RexNode)((Pair)pair).right), (int)offset)));
                }
                switch (logic) {
                    case TRUE: {
                        builder.join(JoinRelType.INNER, builder.and(conditions), variablesSet, true);
                        return builder.literal(true);
                    }
                }
                builder.join(JoinRelType.LEFT, builder.and(conditions), variablesSet);
                ArrayList<RexNode> keyIsNulls = new ArrayList<RexNode>();
                for (RexNode operand : e.getOperands()) {
                    if (!operand.getType().isNullable()) continue;
                    keyIsNulls.add(builder.isNull(operand));
                }
                ImmutableList.Builder operands = ImmutableList.builder();
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: 
                    case UNKNOWN_AS_TRUE: {
                        operands.add(new RexNode[]{builder.equals(builder.field("ct", "c"), builder.literal(0)), builder.literal(false)});
                        operands.add(new RexNode[]{builder.isNull(builder.field("ct", "c")), builder.literal(false)});
                    }
                }
                operands.add(new RexNode[]{builder.isNotNull(builder.field("dt", trueLiteral)), builder.literal(true)});
                if (!keyIsNulls.isEmpty()) {
                    operands.add(new RexNode[]{builder.or(keyIsNulls), e.rel.getCluster().getRexBuilder().makeNullLiteral(SqlTypeName.BOOLEAN)});
                }
                RexNode b = builder.literal(true);
                switch (logic) {
                    case TRUE_FALSE_UNKNOWN: {
                        b = e.rel.getCluster().getRexBuilder().makeNullLiteral(SqlTypeName.BOOLEAN);
                    }
                    case UNKNOWN_AS_TRUE: {
                        operands.add(new RexNode[]{builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, builder.field("ct", "ck"), builder.field("ct", "c")), b});
                    }
                }
                operands.add(builder.literal(false));
                return builder.call((SqlOperator)SqlStdOperatorTable.CASE, operands.build());
            }
        }
        throw new AssertionError(e.getKind());
    }

    private RexInputRef field(HiveSubQRemoveRelBuilder builder, int inputCount, int offset) {
        int inputOrdinal = 0;
        RelNode r;
        while (offset >= (r = builder.peek(inputCount, inputOrdinal)).getRowType().getFieldCount()) {
            ++inputOrdinal;
            offset -= r.getRowType().getFieldCount();
        }
        return builder.field(inputCount, inputOrdinal, offset);
    }

    private static List<RexNode> fields(HiveSubQRemoveRelBuilder builder, int fieldCount) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int i = 0; i < fieldCount; ++i) {
            projects.add((RexNode)builder.field(i));
        }
        return projects;
    }

    public static final class HiveSubQueryFinder
    extends RexVisitorImpl<Void> {
        public static final HiveSubQueryFinder INSTANCE = new HiveSubQueryFinder();
        public static final Predicate<RelNode> RELNODE_PREDICATE = new Predicate<RelNode>(){

            @Override
            public boolean apply(RelNode relNode) {
                if (relNode instanceof Project) {
                    Project project = (Project)relNode;
                    for (RexNode node : project.getProjects()) {
                        try {
                            node.accept((RexVisitor)INSTANCE);
                        }
                        catch (Util.FoundOne e) {
                            return true;
                        }
                    }
                    return false;
                }
                if (relNode instanceof Filter) {
                    try {
                        ((Filter)relNode).getCondition().accept((RexVisitor)INSTANCE);
                        return false;
                    }
                    catch (Util.FoundOne e) {
                        return true;
                    }
                }
                return false;
            }
        };

        private HiveSubQueryFinder() {
            super(true);
        }

        public Void visitSubQuery(RexSubQuery subQuery) {
            throw new Util.FoundOne((Object)subQuery);
        }

        public static RexSubQuery find(Iterable<RexNode> nodes) {
            for (RexNode node : nodes) {
                try {
                    node.accept((RexVisitor)INSTANCE);
                }
                catch (Util.FoundOne e) {
                    return (RexSubQuery)e.getNode();
                }
            }
            return null;
        }

        public static RexSubQuery find(RexNode node) {
            try {
                node.accept((RexVisitor)INSTANCE);
                return null;
            }
            catch (Util.FoundOne e) {
                return (RexSubQuery)e.getNode();
            }
        }
    }

    private static class ReplaceSubQueryShuttle
    extends RexShuttle {
        private final RexSubQuery subQuery;
        private final RexNode replacement;

        ReplaceSubQueryShuttle(RexSubQuery subQuery, RexNode replacement) {
            this.subQuery = subQuery;
            this.replacement = replacement;
        }

        public RexNode visitSubQuery(RexSubQuery subQuery) {
            return RexUtil.eq((RexNode)subQuery, (RexNode)this.subQuery) ? this.replacement : subQuery;
        }
    }
}

