/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="ProcessIdPatternConverter", category="Converter")
@ConverterKeys(value={"pid", "processId"})
public final class ProcessIdPatternConverter
extends LogEventPatternConverter {
    private final String pid;

    private ProcessIdPatternConverter(String[] options) {
        super("Process ID", "pid");
        String temp = options.length > 0 ? options[0] : "???";
        try {
            temp = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (Exception ex) {
            try {
                temp = new File("/proc/self").getCanonicalFile().getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pid = temp;
        ThreadContext.put((String)"pid", (String)this.pid);
    }

    public static ProcessIdPatternConverter newInstance(String[] options) {
        return new ProcessIdPatternConverter(options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(this.pid);
    }
}

