/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexBaseCol;

public class VectorUDFMapIndexStringCol
extends VectorUDFMapIndexBaseCol {
    public VectorUDFMapIndexStringCol() {
    }

    public VectorUDFMapIndexStringCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(mapColumnNum, indexColumnNum, outputColumnNum);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.getMapColumnNum()) + ", key: " + this.getColumnParamString(1, this.getIndexColumnNum());
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.MAP, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }

    @Override
    public int findInMap(ColumnVector indexColumnVector, int indexBatchIndex, MapColumnVector mapColumnVector, int mapBatchIndex) {
        int offset = (int)mapColumnVector.offsets[mapBatchIndex];
        int count = (int)mapColumnVector.lengths[mapBatchIndex];
        BytesColumnVector keyColVector = (BytesColumnVector)mapColumnVector.keys;
        byte[][] keyVector = keyColVector.vector;
        int[] keyStart = keyColVector.start;
        int[] keyLength = keyColVector.length;
        BytesColumnVector indexColVector = (BytesColumnVector)indexColumnVector;
        byte[] indexBytes = indexColVector.vector[indexBatchIndex];
        int indexStart = indexColVector.start[indexBatchIndex];
        int indexLength = indexColVector.length[indexBatchIndex];
        for (int i = 0; i < count; ++i) {
            int keyOffset = offset + i;
            if (!StringExpr.equal(indexBytes, indexStart, indexLength, keyVector[keyOffset], keyStart[keyOffset], keyLength[keyOffset])) continue;
            return offset + i;
        }
        return -1;
    }
}

