/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ListIndexColColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int listColumnNum;
    private int indexColumnNum;

    public ListIndexColColumn() {
    }

    public ListIndexColColumn(int listColumnNum, int indexColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.listColumnNum = listColumnNum;
        this.indexColumnNum = indexColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        ListColumnVector listV = (ListColumnVector)batch.cols[this.listColumnNum];
        ColumnVector childV = listV.child;
        LongColumnVector indexColumnVector = (LongColumnVector)batch.cols[this.indexColumnNum];
        long[] indexV = indexColumnVector.vector;
        int[] sel = batch.selected;
        boolean[] indexIsNull = indexColumnVector.isNull;
        boolean[] listIsNull = listV.isNull;
        boolean[] outputIsNull = outV.isNull;
        outV.isRepeating = false;
        if (indexColumnVector.isRepeating) {
            if (indexColumnVector.noNulls || !indexIsNull[0]) {
                long repeatedLongIndex = indexV[0];
                if (repeatedLongIndex < 0L) {
                    outputIsNull[0] = true;
                    outV.noNulls = false;
                    outV.isRepeating = true;
                    return;
                }
                if (listV.isRepeating) {
                    if (listV.noNulls || !listIsNull[0]) {
                        long repeatedLongListLength = listV.lengths[0];
                        if (repeatedLongIndex >= repeatedLongListLength) {
                            outV.isNull[0] = true;
                            outV.noNulls = false;
                        } else {
                            outV.isNull[0] = false;
                            outV.setElement(0, (int)(listV.offsets[0] + repeatedLongIndex), childV);
                        }
                    } else {
                        outputIsNull[0] = true;
                        outV.noNulls = false;
                    }
                    outV.isRepeating = true;
                    return;
                }
                if (listV.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outV.noNulls) {
                            for (int j = 0; j < n; ++j) {
                                int i = sel[j];
                                long longListLength = listV.lengths[i];
                                if (repeatedLongIndex >= longListLength) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.isNull[i] = false;
                                outV.setElement(i, (int)(listV.offsets[i] + repeatedLongIndex), childV);
                            }
                        } else {
                            for (int j = 0; j < n; ++j) {
                                int i = sel[j];
                                long longListLength = listV.lengths[i];
                                if (repeatedLongIndex >= longListLength) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.setElement(i, (int)(listV.offsets[i] + repeatedLongIndex), childV);
                            }
                        }
                    } else {
                        if (!outV.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outV.noNulls = true;
                        }
                        for (int i = 0; i < n; ++i) {
                            long longListLength = listV.lengths[i];
                            if (repeatedLongIndex >= longListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, (int)(listV.offsets[i] + repeatedLongIndex), childV);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!listIsNull[i]) {
                            long longListLength = listV.lengths[i];
                            if (repeatedLongIndex >= longListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, (int)(listV.offsets[i] + repeatedLongIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (!listIsNull[i]) {
                            long longListLength = listV.lengths[i];
                            if (repeatedLongIndex >= longListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, (int)(listV.offsets[i] + repeatedLongIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            }
            return;
        }
        if (listV.isRepeating) {
            if (listV.noNulls || !listIsNull[0]) {
                long repeatedLongListOffset = listV.offsets[0];
                long repeatedLongListLength = listV.lengths[0];
                if (indexColumnVector.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outV.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                long longIndex = indexV[i];
                                if (longIndex < 0L) {
                                    outputIsNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                if (longIndex >= repeatedLongListLength) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.isNull[i] = false;
                                outV.setElement(i, (int)(repeatedLongListOffset + longIndex), childV);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                long longIndex = indexV[i];
                                if (longIndex < 0L) {
                                    outputIsNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                if (longIndex >= repeatedLongListLength) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.setElement(i, (int)(repeatedLongListOffset + longIndex), childV);
                            }
                        }
                    } else {
                        if (!outV.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outV.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            long longIndex = indexV[i];
                            if (longIndex < 0L) {
                                outputIsNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            if (longIndex >= repeatedLongListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, (int)(repeatedLongListOffset + longIndex), childV);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!indexIsNull[i]) {
                            long longIndex = indexV[i];
                            if (longIndex < 0L) {
                                outputIsNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            if (longIndex >= repeatedLongListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, (int)(repeatedLongListOffset + longIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (!indexIsNull[i]) {
                            long longIndex = indexV[i];
                            if (longIndex < 0L) {
                                outputIsNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            if (longIndex >= repeatedLongListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, (int)(repeatedLongListOffset + longIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            }
            return;
        }
        boolean listNoNulls = listV.noNulls;
        if (indexColumnVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        long longIndex = indexV[i];
                        if (longIndex < 0L) {
                            outputIsNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        if (listNoNulls || !listIsNull[i]) {
                            long longListLength = listV.lengths[i];
                            if (longIndex >= longListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, (int)(listV.offsets[i] + longIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        long longIndex = indexV[i];
                        if (longIndex < 0L) {
                            outputIsNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        if (listNoNulls || !listIsNull[i]) {
                            long longListLength = listV.lengths[i];
                            if (longIndex >= longListLength) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, (int)(listV.offsets[i] + longIndex), childV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long longIndex = indexV[i];
                    if (longIndex < 0L) {
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    if (listNoNulls || !listIsNull[i]) {
                        long longListLength = listV.lengths[i];
                        if (longIndex >= longListLength) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.setElement(i, (int)(listV.offsets[i] + longIndex), childV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!indexIsNull[i]) {
                    long longIndex = indexV[i];
                    if (longIndex < 0L) {
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    if (listNoNulls || !listIsNull[i]) {
                        long longListLength = listV.lengths[i];
                        if (longIndex >= longListLength) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, (int)(listV.offsets[i] + longIndex), childV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!indexIsNull[i]) {
                    long longIndex = indexV[i];
                    if (longIndex < 0L) {
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                        continue;
                    }
                    if (listNoNulls || !listIsNull[i]) {
                        long longListLength = listV.lengths[i];
                        if (longIndex >= longListLength) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, (int)(listV.offsets[i] + longIndex), childV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.listColumnNum) + ", " + this.getColumnParamString(1, this.indexColumnNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.LIST, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

