/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowContainer<ROW extends List<Object>>
implements AbstractRowContainer<ROW>,
AbstractRowContainer.RowIterator<ROW> {
    protected static final Logger LOG = LoggerFactory.getLogger(RowContainer.class);
    private static final int BLOCKSIZE = 25000;
    private ROW[] currentWriteBlock;
    private ROW[] currentReadBlock;
    private ROW[] firstReadBlockPointer;
    private int blockSize;
    private int numFlushedBlocks;
    private long size;
    private int itrCursor;
    private int readBlockSize;
    private int addCursor;
    private AbstractSerDe serde;
    private ObjectInspector standardOI;
    private List<Object> keyObject;
    private TableDesc tblDesc;
    SpillFile spillFile = null;
    boolean firstCalled = false;
    FileSinkOperator.RecordWriter rw = null;
    InputFormat<WritableComparable, Writable> inputFormat = null;
    InputSplit[] inputSplits = null;
    RecordReader rr = null;
    private ROW dummyRow = null;
    private final Reporter reporter;
    private final String spillFileDirs;
    Writable val = null;
    Configuration jc;
    private final ArrayList<Object> row = new ArrayList(2);

    public RowContainer(Configuration jc, Reporter reporter) throws HiveException {
        this(25000, jc, reporter);
    }

    public RowContainer(int bs, Configuration jc, Reporter reporter) throws HiveException {
        this.blockSize = bs <= 0 ? 25000 : bs;
        this.size = 0L;
        this.itrCursor = 0;
        this.addCursor = 0;
        this.spillFileDirs = HiveUtils.getLocalDirList(jc);
        this.numFlushedBlocks = 0;
        this.currentWriteBlock = new ArrayList[this.blockSize];
        this.currentReadBlock = this.currentWriteBlock;
        this.firstReadBlockPointer = this.currentReadBlock;
        this.serde = null;
        this.standardOI = null;
        this.jc = jc;
        this.reporter = reporter == null ? Reporter.NULL : reporter;
    }

    public void setSerDe(AbstractSerDe sd, ObjectInspector oi) {
        this.serde = sd;
        this.standardOI = oi;
    }

    @Override
    public void addRow(ROW t) throws HiveException {
        if (this.tblDesc != null) {
            if (this.willSpill()) {
                this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
                this.addCursor = 0;
                if (this.numFlushedBlocks == 1) {
                    this.currentWriteBlock = new ArrayList[this.blockSize];
                }
            }
            this.currentWriteBlock[this.addCursor++] = t;
        } else if (t != null) {
            this.dummyRow = t;
        }
        ++this.size;
    }

    @Override
    public AbstractRowContainer.RowIterator<ROW> rowIter() {
        return this;
    }

    @Override
    public ROW first() throws HiveException {
        if (this.size == 0L) {
            return null;
        }
        try {
            this.firstCalled = true;
            this.itrCursor = 0;
            this.closeWriter();
            this.closeReader();
            if (this.tblDesc == null) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            this.currentReadBlock = this.firstReadBlockPointer;
            if (this.numFlushedBlocks == 0) {
                this.readBlockSize = this.addCursor;
                this.currentReadBlock = this.currentWriteBlock;
            } else {
                this.rr = this.spillFile.initRecordReader(this.tblDesc);
                this.nextBlock(0);
            }
            ROW ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public ROW next() throws HiveException {
        if (!this.firstCalled) {
            throw new RuntimeException("Call first() then call next().");
        }
        if (this.size == 0L) {
            return null;
        }
        if (this.tblDesc == null) {
            if ((long)this.itrCursor < this.size) {
                ++this.itrCursor;
                return this.dummyRow;
            }
            return null;
        }
        if (this.itrCursor < this.readBlockSize) {
            ROW ret = this.currentReadBlock[this.itrCursor++];
            this.removeKeys(ret);
            return ret;
        }
        this.nextBlock(0);
        if (this.readBlockSize == 0) {
            if (this.currentWriteBlock != null && this.currentReadBlock != this.currentWriteBlock) {
                this.setWriteBlockAsReadBlock();
            } else {
                return null;
            }
        }
        return (ROW)this.next();
    }

    private void removeKeys(ROW ret) {
        if (this.keyObject != null && this.currentReadBlock != this.currentWriteBlock) {
            int len = this.keyObject.size();
            int rowSize = ret.size();
            for (int i = 0; i < len; ++i) {
                ret.remove(rowSize - i - 1);
            }
        }
    }

    private void spillBlock(ROW[] block, int length) throws HiveException {
        try {
            if (this.spillFile == null) {
                this.setupWriter();
            } else if (this.rw == null) {
                throw new HiveException("RowContainer has already been closed for writing.");
            }
            this.row.clear();
            this.row.add(null);
            this.row.add(null);
            if (this.keyObject != null) {
                this.row.set(1, this.keyObject);
                for (int i = 0; i < length; ++i) {
                    ROW currentValRow = block[i];
                    this.row.set(0, currentValRow);
                    Writable outVal = this.serde.serialize(this.row, this.standardOI);
                    this.rw.write(outVal);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    ROW currentValRow = block[i];
                    Writable outVal = this.serde.serialize(currentValRow, this.standardOI);
                    this.rw.write(outVal);
                }
            }
            if (block == this.currentWriteBlock) {
                this.addCursor = 0;
            }
            ++this.numFlushedBlocks;
        }
        catch (Exception e) {
            this.clearRows();
            LOG.error(e.toString(), (Throwable)e);
            if (e instanceof HiveException) {
                throw (HiveException)e;
            }
            throw new HiveException(e);
        }
    }

    @Override
    public boolean hasRows() {
        return this.size > 0L;
    }

    @Override
    public boolean isSingleRow() {
        return this.size == 1L;
    }

    @Override
    public int rowCount() {
        return (int)this.size;
    }

    protected boolean nextBlock(int readIntoOffset) throws HiveException {
        this.itrCursor = 0;
        this.readBlockSize = 0;
        if (this.numFlushedBlocks == 0) {
            return false;
        }
        try {
            if (this.val == null) {
                this.val = this.serde.getSerializedClass().newInstance();
            }
            boolean nextSplit = true;
            int i = readIntoOffset;
            if (this.rr != null) {
                Object key = this.rr.createKey();
                while (i < this.currentReadBlock.length && this.rr.next(key, (Object)this.val)) {
                    nextSplit = false;
                    this.currentReadBlock[i++] = (List)ObjectInspectorUtils.copyToStandardObject(this.serde.deserialize(this.val), this.serde.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                }
            }
            if (nextSplit && this.spillFile.hasNextSplit()) {
                if (this.rr != null) {
                    this.rr.close();
                }
                this.rr = this.spillFile.nextRecordReader();
                return this.nextBlock(0);
            }
            this.readBlockSize = i;
            return this.readBlockSize > 0;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                this.clearRows();
            }
            catch (HiveException e1) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            throw new HiveException(e);
        }
    }

    public void copyToDFSDirecory(FileSystem destFs, Path destPath) throws IOException, HiveException {
        if (this.addCursor > 0) {
            this.spillBlock((List[])this.currentWriteBlock, this.addCursor);
        }
        if (this.spillFile == null) {
            return;
        }
        this.closeWriter();
        this.spillFile.copyToDFSDirectory(destFs, destPath);
        this.clearRows();
    }

    @Override
    public void clearRows() throws HiveException {
        this.itrCursor = 0;
        this.addCursor = 0;
        this.numFlushedBlocks = 0;
        this.readBlockSize = 0;
        this.firstCalled = false;
        this.addCursor = 0;
        this.size = 0L;
        try {
            if (this.rw != null) {
                this.rw.close(false);
            }
            if (this.rr != null) {
                this.rr.close();
            }
        }
        catch (Exception e) {
            LOG.error(e.toString());
            throw new HiveException(e);
        }
        finally {
            this.rw = null;
            this.rr = null;
            if (this.spillFile != null) {
                this.spillFile.clean();
                this.spillFile = null;
            }
        }
    }

    private void deleteLocalFile(File file, boolean recursive) {
        try {
            if (file != null) {
                boolean deleteSuccess;
                if (!file.exists()) {
                    return;
                }
                if (file.isDirectory() && recursive) {
                    File[] files;
                    for (File file2 : files = file.listFiles()) {
                        this.deleteLocalFile(file2, true);
                    }
                }
                if (!(deleteSuccess = file.delete())) {
                    LOG.error("Error deleting tmp file:" + file.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error deleting tmp file:" + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private void closeWriter() throws IOException {
        if (this.rw != null) {
            this.rw.close(false);
            this.rw = null;
        }
    }

    private void closeReader() throws IOException {
        if (this.rr != null) {
            this.rr.close();
            this.rr = null;
        }
    }

    public void setKeyObject(List<Object> dummyKey) {
        this.keyObject = dummyKey;
    }

    public void setTableDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    protected int getAddCursor() {
        return this.addCursor;
    }

    protected final boolean willSpill() {
        return this.addCursor >= this.blockSize;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }

    protected void setupWriter() throws HiveException {
        try {
            if (this.spillFile != null) {
                return;
            }
            Object suffix = ".tmp";
            if (this.keyObject != null) {
                String keyObjectStr = this.keyObject.toString();
                String md5Str = DigestUtils.md5Hex((String)keyObjectStr.toString());
                LOG.info("Using md5Str: " + md5Str + " for keyObject: " + keyObjectStr);
                suffix = "." + md5Str + (String)suffix;
            }
            this.spillFile = this.getSpillFile(this.jc, this.reporter);
            this.spillFile.init((String)suffix);
            this.rw = this.spillFile.initRecordWriter(this.tblDesc, this.reporter, this.serde);
        }
        catch (Exception e) {
            this.clearRows();
            LOG.error(e.toString(), (Throwable)e);
            throw new HiveException(e);
        }
    }

    protected FileSinkOperator.RecordWriter getRecordWriter() {
        return this.rw;
    }

    protected InputSplit[] getInputSplits() {
        if (this.spillFile != null) {
            return this.spillFile.getInputSplits();
        }
        return null;
    }

    protected boolean endOfCurrentReadBlock() {
        if (this.tblDesc == null) {
            return false;
        }
        return this.itrCursor >= this.readBlockSize;
    }

    protected int getCurrentReadBlockSize() {
        return this.readBlockSize;
    }

    protected void setWriteBlockAsReadBlock() {
        this.itrCursor = 0;
        this.readBlockSize = this.addCursor;
        this.firstReadBlockPointer = this.currentReadBlock;
        this.currentReadBlock = this.currentWriteBlock;
    }

    protected RecordReader setReaderAtSplit(int splitNum) throws IOException {
        if (this.rr != null) {
            this.rr.close();
        }
        this.rr = this.spillFile.getRecordReader(splitNum);
        return this.rr;
    }

    protected ROW getReadBlockRow(int rowOffset) {
        this.itrCursor = rowOffset + 1;
        return this.currentReadBlock[rowOffset];
    }

    protected void resetCurrentReadBlockToFirstReadBlock() {
        this.currentReadBlock = this.firstReadBlockPointer;
    }

    protected void resetReadBlocks() {
        this.currentReadBlock = this.currentWriteBlock;
        this.firstReadBlockPointer = this.currentReadBlock;
    }

    protected void close() throws HiveException {
        this.clearRows();
        this.currentWriteBlock = null;
        this.firstReadBlockPointer = null;
        this.currentReadBlock = null;
    }

    protected int getLastActualSplit() {
        return this.spillFile.actualSplitNum - 1;
    }

    SpillFile getSpillFile(Configuration jobConf, Reporter reporter) throws IOException {
        boolean fTmpFileOnDfs = HiveConf.getBoolVar(jobConf, HiveConf.ConfVars.TMP_MAPRFS_VOLUME);
        String engine = HiveConf.getVar(jobConf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        boolean isTezEngine = "tez".equalsIgnoreCase(engine);
        String tmpDirDfs = null;
        if (fTmpFileOnDfs && !isTezEngine) {
            try {
                tmpDirDfs = RowContainer.getDfsTmpDir(jobConf);
                FileSystem dfs = FileSystem.get((Configuration)jobConf);
                dfs.mkdirs(new Path(tmpDirDfs));
            }
            catch (Exception ex) {
                LOG.info("Failed to create temporary directory on MapRFS local volume. Continuing with creating temporary files on local filesystem.");
                LOG.debug("Error: ", (Throwable)ex);
                tmpDirDfs = null;
            }
            if (tmpDirDfs != null) {
                return new DFSSpillFile(tmpDirDfs, jobConf, reporter);
            }
        }
        return new LocalSpillFile(jobConf, reporter);
    }

    private static String getDfsTmpDir(Configuration jobConf) throws IOException {
        Object tmpDirDfs = jobConf.get("mapr.mapred.localvolume.root.dir.path");
        if (tmpDirDfs == null || ((String)tmpDirDfs).isEmpty()) {
            LOG.debug("Can't find mapred volume path directly in JobConf. Constructing it from known properties in JobConf");
            tmpDirDfs = jobConf.get("mapr.localvolumes.path", "/var/mapr/local");
            tmpDirDfs = (String)tmpDirDfs + "/";
            tmpDirDfs = (String)tmpDirDfs + RowContainer.getMapRHostname(jobConf);
            tmpDirDfs = (String)tmpDirDfs + "/mapred/";
            tmpDirDfs = (String)tmpDirDfs + jobConf.get("mapr.mapred.localvolume.root.dir.name", "taskTracker");
        }
        tmpDirDfs = (String)tmpDirDfs + "/";
        tmpDirDfs = (String)tmpDirDfs + jobConf.get("mapr.localspill.dir", "spill");
        if (!jobConf.getBoolean("mapreduce.maprfs.use.compression", true)) {
            tmpDirDfs = (String)tmpDirDfs + ".U";
        }
        String jobId = jobConf.get("mapreduce.job.id");
        String taskId = jobConf.get("mapreduce.task.id");
        if (jobId == null || jobId.isEmpty() || taskId == null || taskId.isEmpty()) {
            LOG.debug("mapreduce.job.id or mapreduce.task.id are not set in JobConf");
            String[] workDirSplits = null;
            String workDir = null;
            try {
                workDir = new File(".").getCanonicalPath();
                workDirSplits = workDir.split("/");
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failed to get the current working directory of the task: " + e);
                }
                throw e;
            }
            jobId = workDirSplits[workDirSplits.length - 3];
            taskId = workDirSplits[workDirSplits.length - 2];
        }
        tmpDirDfs = (String)tmpDirDfs + "/" + jobId;
        tmpDirDfs = (String)tmpDirDfs + "/" + taskId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("tmpDirDfs: " + (String)tmpDirDfs);
        }
        return tmpDirDfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMapRHostname(Configuration jobConf) {
        String hostName = jobConf.get("slave.host.name");
        if (hostName != null) {
            return hostName;
        }
        String maprHome = System.getProperty("mapr.home.dir");
        if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
            maprHome = "/opt/mapr/";
        }
        String hostNameFile = maprHome + "/hostname";
        BufferedReader breader = null;
        FileReader freader = null;
        try {
            freader = new FileReader(hostNameFile);
            breader = new BufferedReader(freader);
            String string = breader.readLine();
            return string;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error while reading " + hostNameFile, (Throwable)e);
            }
        }
        finally {
            block28: {
                block27: {
                    try {
                        if (breader != null) {
                            breader.close();
                        }
                    }
                    catch (Throwable t) {
                        if (!LOG.isErrorEnabled()) break block27;
                        LOG.error("Failed to close breader", t);
                    }
                }
                try {
                    if (freader != null) {
                        freader.close();
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isErrorEnabled()) break block28;
                    LOG.error("Failed to close " + hostNameFile, t);
                }
            }
        }
        if (hostName == null) {
            try {
                hostName = DNS.getDefaultHost((String)jobConf.get("mapred.tasktracker.dns.interface", "default"), (String)jobConf.get("mapred.tasktracker.dns.nameserver", "default"));
            }
            catch (IOException ioe) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Failed to retrieve local host name", (Throwable)ioe);
                }
                throw new RuntimeException(ioe);
            }
        }
        return hostName;
    }

    public int getNumFlushedBlocks() {
        return this.numFlushedBlocks;
    }

    class LocalSpillFile
    extends SpillFile {
        private File tmpFileParent;
        private File tmpFile;
        private Path tmpFilePath;

        public LocalSpillFile(Configuration jobConf, Reporter reporter) {
            jobConf.set("fs.defaultFS", "file:///");
            this.jobConf = new JobConf(jobConf);
            this.reporter = reporter;
        }

        @Override
        public void clean() {
            this.deleteLocalFile(this.tmpFileParent, true);
            this.tmpFile = null;
            this.tmpFileParent = null;
            this.tmpFilePath = null;
            super.clean();
        }

        @Override
        public String getParentDir() {
            return this.tmpFileParent.getAbsolutePath();
        }

        @Override
        public void init(String suffix) throws IOException {
            while (true) {
                boolean success;
                this.tmpFileParent = File.createTempFile("hive-rowcontainer", "");
                boolean bl = success = this.tmpFileParent.delete() && this.tmpFileParent.mkdir();
                if (success) break;
                LOG.debug("retry creating tmp row-container directory...");
            }
            this.tmpFile = File.createTempFile("RowContainer", suffix, this.tmpFileParent);
            LOG.info("RowContainer created temp file " + this.tmpFile.getAbsolutePath());
            this.tmpFileParent.deleteOnExit();
            this.tmpFile.deleteOnExit();
        }

        @Override
        public FileSinkOperator.RecordWriter initRecordWriter(TableDesc tblDesc, Reporter reporter, AbstractSerDe serde) throws Exception {
            OutputFormat outputFormat = tblDesc.getOutputFileFormatClass().newInstance();
            this.tmpFilePath = new Path(this.tmpFile.toString());
            return HiveFileFormatUtils.getRecordWriter(this.jobConf, outputFormat, serde.getSerializedClass(), false, tblDesc.getProperties(), this.tmpFilePath, reporter);
        }

        @Override
        public void copyToDFSDirectory(FileSystem destFs, Path destPath) throws IOException, HiveException {
            if (this.tmpFilePath == null || this.tmpFilePath.toString().trim().equals("")) {
                return;
            }
            LOG.info("RowContainer copied temp file " + this.tmpFile.getAbsolutePath() + " to dfs directory " + destPath.toString());
            destFs.copyFromLocalFile(true, this.tmpFilePath, new Path(destPath, new Path(this.tmpFilePath.getName())));
        }

        private void deleteLocalFile(File file, boolean recursive) {
            try {
                if (file != null) {
                    boolean deleteSuccess;
                    if (!file.exists()) {
                        return;
                    }
                    if (file.isDirectory() && recursive) {
                        File[] files;
                        for (File file2 : files = file.listFiles()) {
                            this.deleteLocalFile(file2, true);
                        }
                    }
                    if (!(deleteSuccess = file.delete())) {
                        LOG.error("Error deleting tmp file:" + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error deleting tmp file:" + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    class DFSSpillFile
    extends SpillFile {
        private FileSystem fs;
        private String spillDir;
        private String tmpFileParent;
        private String tmpFile;
        private Path tmpFilePath;

        public DFSSpillFile(String tmpDirDfs, Configuration jobConf, Reporter reporter) throws IOException {
            this.jobConf = new JobConf(jobConf);
            this.fs = FileSystem.get((Configuration)jobConf);
            this.spillDir = tmpDirDfs;
            this.reporter = reporter;
        }

        @Override
        public void clean() {
            try {
                if (this.tmpFileParent != null) {
                    this.fs.delete(new Path(this.tmpFileParent), true);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.tmpFileParent = null;
            this.tmpFile = null;
            this.tmpFilePath = null;
            super.clean();
        }

        @Override
        public String getParentDir() {
            return this.tmpFileParent;
        }

        @Override
        public void init(String suffix) throws IOException {
            Path tmpFileParentPath;
            this.fs.mkdirs(new Path(this.spillDir));
            while (true) {
                this.tmpFileParent = this.spillDir + "/hive-rowcontainer" + new Random().nextInt();
                tmpFileParentPath = new Path(this.tmpFileParent);
                if (!this.fs.exists(tmpFileParentPath)) break;
                LOG.debug("retry creating tmp row-container directory...");
            }
            this.fs.mkdirs(tmpFileParentPath);
            this.tmpFile = this.tmpFileParent + "/RowContainer" + suffix;
            LOG.info("RowContainer created temp file " + this.tmpFile);
        }

        @Override
        public FileSinkOperator.RecordWriter initRecordWriter(TableDesc tblDesc, Reporter reporter, AbstractSerDe serde) throws Exception {
            OutputFormat outputFormat = tblDesc.getOutputFileFormatClass().newInstance();
            this.tmpFilePath = new Path(this.tmpFile.toString());
            return HiveFileFormatUtils.getRecordWriter(this.jobConf, outputFormat, serde.getSerializedClass(), false, tblDesc.getProperties(), this.tmpFilePath, reporter);
        }

        @Override
        public void copyToDFSDirectory(FileSystem destFs, Path destPath) throws IOException, HiveException {
            if (this.tmpFilePath == null || this.tmpFilePath.toString().trim().equals("")) {
                return;
            }
            LOG.info("RowContainer copied temp file " + this.tmpFile + " to dfs directory " + destPath.toString());
            FileUtil.copy((FileSystem)this.fs, (Path)this.tmpFilePath, (FileSystem)destFs, (Path)new Path(destPath, new Path(this.tmpFilePath.getName())), (boolean)false, (Configuration)this.jobConf);
        }
    }

    abstract class SpillFile {
        protected JobConf jobConf;
        protected Reporter reporter;
        protected int currentSplitNumber = -1;
        protected int actualSplitNum = 0;
        protected InputSplit[] inputSplits = null;
        protected InputFormat<WritableComparable, Writable> inputFormat = null;

        SpillFile() {
        }

        public abstract void init(String var1) throws IOException;

        public abstract FileSinkOperator.RecordWriter initRecordWriter(TableDesc var1, Reporter var2, AbstractSerDe var3) throws Exception;

        public abstract String getParentDir();

        public abstract void copyToDFSDirectory(FileSystem var1, Path var2) throws IOException, HiveException;

        public RecordReader initRecordReader(TableDesc tblDesc) throws IOException {
            if (this.inputSplits == null) {
                if (this.inputFormat == null) {
                    this.inputFormat = (InputFormat)ReflectionUtils.newInstance(tblDesc.getInputFileFormatClass(), (Configuration)this.jobConf);
                }
                this.jobConf.set("mapreduce.input.fileinputformat.inputdir", StringUtils.escapeString((String)this.getParentDir()));
                this.inputSplits = this.inputFormat.getSplits(this.jobConf, 1);
                this.actualSplitNum = this.inputSplits.length;
            }
            this.currentSplitNumber = 0;
            RecordReader rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitNumber], this.jobConf, this.reporter);
            ++this.currentSplitNumber;
            return rr;
        }

        public RecordReader nextRecordReader() throws IOException {
            if (this.inputSplits == null) {
                throw new IOException("Initialize reading splill file");
            }
            RecordReader rr = this.inputFormat.getRecordReader(this.inputSplits[this.currentSplitNumber], this.jobConf, this.reporter);
            ++this.currentSplitNumber;
            return rr;
        }

        public RecordReader getRecordReader(int splitNum) throws IOException {
            RecordReader rr = this.inputFormat.getRecordReader(this.inputSplits[splitNum], this.jobConf, this.reporter);
            this.currentSplitNumber = splitNum + 1;
            return rr;
        }

        public boolean hasNextSplit() throws IOException {
            if (this.inputSplits == null) {
                throw new IOException("Initialize reading spill file");
            }
            return this.currentSplitNumber < this.actualSplitNum;
        }

        public void clean() {
            this.actualSplitNum = 0;
            this.currentSplitNumber = -1;
            this.inputSplits = null;
            this.inputFormat = null;
        }

        public InputSplit[] getInputSplits() {
            return this.inputSplits;
        }
    }
}

