/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public interface DataSourceProvider {
    public DataSource create(Configuration var1) throws SQLException;

    public boolean mayReturnClosedConnection();

    public boolean supports(Configuration var1);

    public static Properties getPrefixedProperties(Configuration hdpConfig, String factoryPrefix) {
        Properties dataSourceProps = new Properties();
        Iterables.filter(hdpConfig, entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith(factoryPrefix)).forEach(entry -> dataSourceProps.put(entry.getKey(), entry.getValue()));
        return dataSourceProps;
    }

    public static String getMetastoreJdbcUser(Configuration conf) {
        return MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECTION_USER_NAME);
    }

    public static String getMetastoreJdbcPasswd(Configuration conf) throws SQLException {
        try {
            return MetastoreConf.getPassword(conf, MetastoreConf.ConfVars.PWD);
        }
        catch (IOException err) {
            throw new SQLException("Error getting metastore password", err);
        }
    }

    public static String getMetastoreJdbcDriverUrl(Configuration conf) throws SQLException {
        return MetastoreConf.getVar(conf, MetastoreConf.ConfVars.CONNECT_URL_KEY);
    }
}

