/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.positive;

import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTransactionStatement {
    private static SessionState sessionState;
    private ParseDriver pd;

    @BeforeClass
    public static void initialize() {
        HiveConf conf = new HiveConf(SemanticAnalyzer.class);
        conf.set("fs.defaultFS", "file:///");
        sessionState = SessionState.start((HiveConf)conf);
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        if (sessionState != null) {
            sessionState.close();
        }
    }

    @Before
    public void setup() throws SemanticException {
        this.pd = new ParseDriver();
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = this.pd.parse(query);
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testTxnStart() throws ParseException {
        ASTNode ast = this.parse("START TRANSACTION");
        Assert.assertEquals((String)"AST doesn't match", (Object)"tok_start_transaction", (Object)ast.toStringTree());
        ast = this.parse("START TRANSACTION ISOLATION LEVEL SNAPSHOT");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_start_transaction (tok_isolation_level tok_isolation_snapshot))", (Object)ast.toStringTree());
        ast = this.parse("START TRANSACTION READ ONLY");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_start_transaction (tok_txn_access_mode tok_txn_read_only))", (Object)ast.toStringTree());
        ast = this.parse("START TRANSACTION READ WRITE, ISOLATION LEVEL SNAPSHOT");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_start_transaction (tok_txn_access_mode tok_txn_read_write) (tok_isolation_level tok_isolation_snapshot))", (Object)ast.toStringTree());
    }

    @Test
    public void testTxnCommitRollback() throws ParseException {
        ASTNode ast = this.parse("COMMIT");
        Assert.assertEquals((String)"AST doesn't match", (Object)"tok_commit", (Object)ast.toStringTree());
        ast = this.parse("COMMIT WORK");
        Assert.assertEquals((String)"AST doesn't match", (Object)"tok_commit", (Object)ast.toStringTree());
        ast = this.parse("ROLLBACK");
        Assert.assertEquals((String)"AST doesn't match", (Object)"tok_rollback", (Object)ast.toStringTree());
        ast = this.parse("ROLLBACK WORK");
        Assert.assertEquals((String)"AST doesn't match", (Object)"tok_rollback", (Object)ast.toStringTree());
    }

    @Test
    public void testAutoCommit() throws ParseException {
        ASTNode ast = this.parse("SET AUTOCOMMIT TRUE");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_set_autocommit tok_true)", (Object)ast.toStringTree());
        ast = this.parse("SET AUTOCOMMIT FALSE");
        Assert.assertEquals((String)"AST doesn't match", (Object)"(tok_set_autocommit tok_false)", (Object)ast.toStringTree());
    }
}

