/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.ql.optimizer.NestedColumnFieldPruningUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestNestedColumnFieldPruningUtils {
    @Parameterized.Parameter(value=0)
    public String origTreeExpr;
    @Parameterized.Parameter(value=1)
    public String[] paths;
    @Parameterized.Parameter(value=2)
    public String resTreeExpr;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"root[a]", new String[]{"root.a.b.c"}, "root[a]"}, {"root[a[b[d,e]],c]", new String[]{"root.a.b.c"}, "root[a[b[d,e,c]],c]"}, {"root[a[b[c]]]", new String[]{"root.a.b.c.d"}, "root[a[b[c]]]"}, {null, new String[]{"a.b.c"}, "a[b[c]]"}, {null, new String[]{"a.b", "a.c"}, "a[b,c]"}, {"a[b]", new String[]{"a.b.c"}, "a[b]"});
    }

    @Test
    public void testAddNodeByPath() {
        FieldNode root = null;
        if (this.origTreeExpr != null) {
            root = TestNestedColumnFieldPruningUtils.buildTreeByExpr(this.origTreeExpr);
            Assert.assertEquals((String)"The original tree is built incorrect", (Object)root.toString(), (Object)this.origTreeExpr);
        }
        for (String p : this.paths) {
            root = NestedColumnFieldPruningUtils.addNodeByPath((FieldNode)root, (String)p);
        }
        Assert.assertEquals((Object)this.resTreeExpr, (Object)root.toString());
    }

    private static boolean isSpecialChar(char element) {
        return element == '[' || element == ']' || element == ',';
    }

    private static FieldNode buildTreeByExpr(String expr) {
        int index = 0;
        LinkedList<FieldNode> fieldStack = new LinkedList<FieldNode>();
        while (index < expr.length()) {
            int i = index;
            if (TestNestedColumnFieldPruningUtils.isSpecialChar(expr.charAt(i))) {
                if (expr.charAt(index) == ',' || expr.charAt(index) == ']') {
                    FieldNode node = (FieldNode)fieldStack.pop();
                    FieldNode pre = (FieldNode)fieldStack.peek();
                    pre.addFieldNodes(new FieldNode[]{node});
                }
                ++index;
                continue;
            }
            while (i < expr.length() && !TestNestedColumnFieldPruningUtils.isSpecialChar(expr.charAt(i))) {
                ++i;
            }
            FieldNode current = new FieldNode(expr.substring(index, i));
            fieldStack.push(current);
            index = i;
        }
        return (FieldNode)fieldStack.pop();
    }
}

