/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.hooks.LineageLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSlidingFilenameRolloverStrategy {
    private static final String PROPERTIES_FILE = "log4j2_test_sliding_rollover.properties";
    private static final String FILE_PATTERN = "./target/tmp/log/slidingTest.log";

    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("log4j.configurationFile", PROPERTIES_FILE);
    }

    @AfterClass
    public static void tearDown() {
        System.clearProperty("log4j.configurationFile");
        LogManager.shutdown();
    }

    @Test
    public void testSlidingLogFiles() throws Exception {
        Assert.assertEquals((String)"bad props file", (Object)PROPERTIES_FILE, (Object)System.getProperty("log4j.configurationFile"));
        Path logTemplate = FileSystems.getDefault().getPath(FILE_PATTERN, new String[0]);
        String fileName = logTemplate.getFileName().toString();
        Path parent = logTemplate.getParent();
        try {
            Files.createDirectory(parent, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        this.deleteLogFiles(parent, fileName);
        Logger logger = LogManager.getLogger(LineageLogger.class);
        org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
        LoggerConfig loggerConfig = coreLogger.get();
        Map appenders = loggerConfig.getAppenders();
        Assert.assertNotNull((String)"sliding appender is missing", appenders.get("sliding"));
        int NUM_LOGS = 7;
        logger.debug("Debug Message Logged !!!");
        logger.info("Info Message Logged !!!");
        String errorString = "Error Message Logged ";
        for (int i = 0; i < NUM_LOGS; ++i) {
            TimeUnit.MILLISECONDS.sleep(100L);
            logger.error(errorString + i, (Throwable)new RuntimeException("part of a test"));
        }
        DirectoryStream<Path> stream = Files.newDirectoryStream(parent, fileName + ".*");
        int count = 0;
        for (Path path : stream) {
            ++count;
            String contents = new String(Files.readAllBytes(path), "UTF-8");
            Assert.assertTrue((String)("File " + path + " did not have expected content"), (boolean)contents.contains(errorString));
            String suffix = StringUtils.substringAfterLast((String)path.toString(), (String)".");
            try {
                long l = Long.parseLong(suffix);
            }
            catch (NumberFormatException e) {
                Assert.fail((String)("Suffix " + suffix + " is not a long"));
            }
        }
        Assert.assertEquals((String)"bad count of log files", (long)NUM_LOGS, (long)count);
        Assert.assertFalse((String)("file should not exist:" + logTemplate), (boolean)Files.exists(logTemplate, new LinkOption[0]));
        this.deleteLogFiles(parent, fileName);
    }

    private void deleteLogFiles(Path parent, String fileName) throws IOException {
        DirectoryStream<Path> stream = Files.newDirectoryStream(parent, fileName + ".*");
        for (Path path : stream) {
            Files.delete(path);
        }
    }
}

