/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;

public class HiveParquetSchemaTestUtils {
    public static List<String> createHiveColumnsFrom(String columnNamesStr) {
        List<Object> columnNames = columnNamesStr.length() == 0 ? new ArrayList() : Arrays.asList(columnNamesStr.split(","));
        return columnNames;
    }

    public static List<TypeInfo> createHiveTypeInfoFrom(String columnsTypeStr) {
        ArrayList<TypeInfo> columnTypes = columnsTypeStr.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnsTypeStr);
        return columnTypes;
    }

    public static void testConversion(String columnNamesStr, String columnsTypeStr, String actualSchema) throws Exception {
        List<String> columnNames = HiveParquetSchemaTestUtils.createHiveColumnsFrom(columnNamesStr);
        List<TypeInfo> columnTypes = HiveParquetSchemaTestUtils.createHiveTypeInfoFrom(columnsTypeStr);
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)actualSchema);
        Assert.assertEquals((String)("converting " + columnNamesStr + ": " + columnsTypeStr + " to " + actualSchema), (Object)expectedMT, (Object)messageTypeFound);
        List expectedFields = expectedMT.getFields();
        List actualFields = messageTypeFound.getFields();
        int n = expectedFields.size();
        for (int i = 0; i < n; ++i) {
            OriginalType exp = ((Type)expectedFields.get(i)).getOriginalType();
            OriginalType act = ((Type)actualFields.get(i)).getOriginalType();
            Assert.assertEquals((String)"Original types of the field do not match", (Object)exp, (Object)act);
        }
    }
}

