/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util.batchgen;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.util.batchgen.VectorColumnGroupGenerator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public class VectorBatchGenerator {
    private VectorColumnGroupGenerator[] columnGroups;
    private boolean[] isGenerateSeries;

    public VectorBatchGenerator(GenerateType[] generateTypes) {
        int size = generateTypes.length;
        this.columnGroups = new VectorColumnGroupGenerator[size];
        for (int i = 0; i < size; ++i) {
            this.columnGroups[i] = new VectorColumnGroupGenerator(i, generateTypes[i]);
        }
        this.isGenerateSeries = new boolean[size];
        Arrays.fill(this.isGenerateSeries, true);
    }

    public VectorBatchGenerator(VectorColumnGroupGenerator[] columnGroups) {
        this.columnGroups = columnGroups;
    }

    public void assignColumnVectors(VectorizedRowBatch batch, int columnNum, VectorColumnGroupGenerator columnGroup) {
        LongColumnVector colVector;
        GenerateType[] generateTypes = columnGroup.generateTypes();
        GenerateType generateType = generateTypes[0];
        switch (generateType.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                colVector = new LongColumnVector();
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                colVector = new DoubleColumnVector();
                break;
            }
            case STRING: {
                colVector = new BytesColumnVector();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported catagory " + generateType.getCategory());
            }
        }
        colVector.init();
        batch.cols[columnNum] = colVector;
    }

    public VectorizedRowBatch createBatch() {
        int size = this.columnGroups.length;
        VectorizedRowBatch batch = new VectorizedRowBatch(size);
        for (int i = 0; i < size; ++i) {
            this.assignColumnVectors(batch, i, this.columnGroups[i]);
        }
        return batch;
    }

    public void generateBatch(VectorizedRowBatch batch, Random random, int size) {
        int c;
        for (int c2 = 0; c2 < this.columnGroups.length; ++c2) {
            this.columnGroups[c2].clearColumnValueArrays();
        }
        int i = 0;
        block1: do {
            for (c = 0; c < this.columnGroups.length; ++c) {
                this.columnGroups[c].generateRowValues(i, random);
            }
            if (i + 1 >= size) break;
            if (i >= size - 1) continue;
            for (c = 0; c < this.columnGroups.length; ++c) {
                int seriesCount;
                if (!this.isGenerateSeries[c] || (seriesCount = this.getSeriesCount(random)) == 1) continue;
                Preconditions.checkState(((seriesCount = Math.min(seriesCount, size - i)) > 1 ? 1 : 0) != 0);
                VectorColumnGroupGenerator columnGroup = this.columnGroups[c];
                columnGroup.fillDownRowValues(i, seriesCount, random);
                for (int other = 0; other < this.columnGroups.length; ++other) {
                    if (other == c) continue;
                    VectorColumnGroupGenerator otherColumnGroup = this.columnGroups[other];
                    otherColumnGroup.generateDownRowValues(i, seriesCount, random);
                }
                i += seriesCount - 1;
                continue block1;
            }
        } while (++i < size);
        for (c = 0; c < this.columnGroups.length; ++c) {
            VectorColumnGroupGenerator columnGroup = this.columnGroups[c];
            columnGroup.populateBatch(batch, size, false);
        }
        batch.size = size;
    }

    private int getSeriesCount(Random random) {
        if (random.nextBoolean()) {
            return 1;
        }
        return 1 + random.nextInt(10);
    }

    public static class GenerateType {
        private GenerateCategory category;
        private long integerMin;
        private long integerMax;
        private float floatMin;
        private float floatMax;
        private double doubleMin;
        private double doubleMax;

        public GenerateType(GenerateCategory category) {
            this.category = category;
        }

        public GenerateCategory getCategory() {
            return this.category;
        }

        public static enum GenerateCategory {
            BOOLEAN("boolean", true),
            BYTE("tinyint", true),
            SHORT("smallint", true),
            INT("int", true),
            LONG("bigint", true),
            FLOAT("float", true),
            DOUBLE("double", true),
            STRING("string", true),
            DATE("date", true),
            TIMESTAMP("timestamp", true),
            BINARY("binary", true),
            DECIMAL("decimal", true),
            VARCHAR("varchar", true),
            CHAR("char", true),
            LIST("array", false),
            MAP("map", false),
            STRUCT("struct", false),
            UNION("uniontype", false);

            final boolean isPrimitive;
            final String name;

            private GenerateCategory(String name, boolean isPrimitive) {
                this.name = name;
                this.isPrimitive = isPrimitive;
            }

            public boolean isPrimitive() {
                return this.isPrimitive;
            }

            public String getName() {
                return this.name;
            }

            public static GenerateCategory generateCategoryFromPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return BOOLEAN;
                    }
                    case BYTE: {
                        return BYTE;
                    }
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                    case FLOAT: {
                        return FLOAT;
                    }
                    case DOUBLE: {
                        return DOUBLE;
                    }
                    case STRING: {
                        return STRING;
                    }
                    case DATE: {
                        return DATE;
                    }
                    case TIMESTAMP: {
                        return TIMESTAMP;
                    }
                    case BINARY: {
                        return BINARY;
                    }
                    case DECIMAL: {
                        return DECIMAL;
                    }
                    case VARCHAR: {
                        return VARCHAR;
                    }
                    case CHAR: {
                        return CHAR;
                    }
                }
                return null;
            }
        }
    }
}

