/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColGreaterLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColLessLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualDoubleColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColNotEqualLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnColumnFilterVectorExpressionEvaluation {
    private static final int BATCH_SIZE = 100;
    private static final long SEED = 64087L;

    @Test
    public void testFilterLongColEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualDoubleColumn vectorExpression = new FilterLongColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualDoubleColumn vectorExpression = new FilterLongColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualDoubleColumn vectorExpression = new FilterLongColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualDoubleColumn vectorExpression = new FilterLongColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualDoubleColumn vectorExpression = new FilterLongColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualDoubleColumn vectorExpression = new FilterDoubleColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualDoubleColumn vectorExpression = new FilterDoubleColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualDoubleColumn vectorExpression = new FilterDoubleColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualDoubleColumn vectorExpression = new FilterDoubleColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualDoubleColumn vectorExpression = new FilterDoubleColEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualDoubleColumn vectorExpression = new FilterLongColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualDoubleColumn vectorExpression = new FilterLongColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualDoubleColumn vectorExpression = new FilterLongColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualDoubleColumn vectorExpression = new FilterLongColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualDoubleColumn vectorExpression = new FilterLongColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || (double)inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualDoubleColumn vectorExpression = new FilterDoubleColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualDoubleColumn vectorExpression = new FilterDoubleColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualDoubleColumn vectorExpression = new FilterDoubleColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualDoubleColumn vectorExpression = new FilterDoubleColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualDoubleColumn vectorExpression = new FilterDoubleColNotEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessDoubleColumn vectorExpression = new FilterLongColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessDoubleColumn vectorExpression = new FilterLongColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessDoubleColumn vectorExpression = new FilterLongColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessDoubleColumn vectorExpression = new FilterLongColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessDoubleColumn vectorExpression = new FilterLongColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessDoubleColumn vectorExpression = new FilterDoubleColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessDoubleColumn vectorExpression = new FilterDoubleColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessDoubleColumn vectorExpression = new FilterDoubleColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessDoubleColumn vectorExpression = new FilterDoubleColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessDoubleColumn vectorExpression = new FilterDoubleColLessDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualDoubleColumn vectorExpression = new FilterLongColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualDoubleColumn vectorExpression = new FilterLongColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualDoubleColumn vectorExpression = new FilterLongColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualDoubleColumn vectorExpression = new FilterLongColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualDoubleColumn vectorExpression = new FilterLongColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualDoubleColumn vectorExpression = new FilterDoubleColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualDoubleColumn vectorExpression = new FilterDoubleColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualDoubleColumn vectorExpression = new FilterDoubleColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualDoubleColumn vectorExpression = new FilterDoubleColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualDoubleColumn vectorExpression = new FilterDoubleColLessEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterDoubleColumn vectorExpression = new FilterLongColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterDoubleColumn vectorExpression = new FilterLongColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterDoubleColumn vectorExpression = new FilterLongColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterDoubleColumn vectorExpression = new FilterLongColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterDoubleColumn vectorExpression = new FilterLongColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterDoubleColumn vectorExpression = new FilterDoubleColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterDoubleColumn vectorExpression = new FilterDoubleColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterDoubleColumn vectorExpression = new FilterDoubleColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterDoubleColumn vectorExpression = new FilterDoubleColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterDoubleColumn vectorExpression = new FilterDoubleColGreaterDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualDoubleColumn vectorExpression = new FilterLongColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualDoubleColumn vectorExpression = new FilterLongColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualDoubleColumn vectorExpression = new FilterLongColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualDoubleColumn vectorExpression = new FilterLongColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualDoubleColumn vectorExpression = new FilterLongColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !((double)inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualDoubleColumn vectorExpression = new FilterDoubleColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualDoubleColumn vectorExpression = new FilterDoubleColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualDoubleColumn vectorExpression = new FilterDoubleColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualDoubleColumn vectorExpression = new FilterDoubleColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualDoubleColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        DoubleColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualDoubleColumn vectorExpression = new FilterDoubleColGreaterEqualDoubleColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualLongColumn vectorExpression = new FilterLongColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualLongColumn vectorExpression = new FilterLongColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualLongColumn vectorExpression = new FilterLongColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualLongColumn vectorExpression = new FilterLongColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColEqualLongColumn vectorExpression = new FilterLongColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualLongColumn vectorExpression = new FilterDoubleColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualLongColumn vectorExpression = new FilterDoubleColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualLongColumn vectorExpression = new FilterDoubleColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualLongColumn vectorExpression = new FilterDoubleColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColEqualLongColumn vectorExpression = new FilterDoubleColEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] != (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "==" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualLongColumn vectorExpression = new FilterLongColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualLongColumn vectorExpression = new FilterLongColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualLongColumn vectorExpression = new FilterLongColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualLongColumn vectorExpression = new FilterLongColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColNotEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColNotEqualLongColumn vectorExpression = new FilterLongColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualLongColumn vectorExpression = new FilterDoubleColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualLongColumn vectorExpression = new FilterDoubleColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualLongColumn vectorExpression = new FilterDoubleColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualLongColumn vectorExpression = new FilterDoubleColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColNotEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColNotEqualLongColumn vectorExpression = new FilterDoubleColNotEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] == (double)inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "!=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessLongColumn vectorExpression = new FilterLongColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] >= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessLongColumn vectorExpression = new FilterLongColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] >= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessLongColumn vectorExpression = new FilterLongColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] >= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessLongColumn vectorExpression = new FilterLongColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] >= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessLongColumn vectorExpression = new FilterLongColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] >= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessLongColumn vectorExpression = new FilterDoubleColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessLongColumn vectorExpression = new FilterDoubleColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessLongColumn vectorExpression = new FilterDoubleColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessLongColumn vectorExpression = new FilterDoubleColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessLongColumn vectorExpression = new FilterDoubleColLessLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] < (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualLongColumn vectorExpression = new FilterLongColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] > inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualLongColumn vectorExpression = new FilterLongColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] > inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualLongColumn vectorExpression = new FilterLongColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] > inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualLongColumn vectorExpression = new FilterLongColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] > inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColLessEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColLessEqualLongColumn vectorExpression = new FilterLongColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] > inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualLongColumn vectorExpression = new FilterDoubleColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualLongColumn vectorExpression = new FilterDoubleColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualLongColumn vectorExpression = new FilterDoubleColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualLongColumn vectorExpression = new FilterDoubleColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColLessEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColLessEqualLongColumn vectorExpression = new FilterDoubleColLessEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] <= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + "<=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterLongColumn vectorExpression = new FilterLongColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] <= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterLongColumn vectorExpression = new FilterLongColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] <= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterLongColumn vectorExpression = new FilterLongColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] <= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterLongColumn vectorExpression = new FilterLongColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] <= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterLongColumn vectorExpression = new FilterLongColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] <= inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterLongColumn vectorExpression = new FilterDoubleColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterLongColumn vectorExpression = new FilterDoubleColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterLongColumn vectorExpression = new FilterDoubleColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterLongColumn vectorExpression = new FilterDoubleColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterLongColumn vectorExpression = new FilterDoubleColGreaterLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] > (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualLongColumn vectorExpression = new FilterLongColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] < inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualLongColumn vectorExpression = new FilterLongColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] < inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualLongColumn vectorExpression = new FilterLongColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] < inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualLongColumn vectorExpression = new FilterLongColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] < inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterLongColGreaterEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        LongColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterLongColGreaterEqualLongColumn vectorExpression = new FilterLongColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || inputColumnVector1.vector[i] < inputColumnVector2.vector[i]) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongColumnC1RepeatsC2NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualLongColumn vectorExpression = new FilterDoubleColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongColumn() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(false, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualLongColumn vectorExpression = new FilterDoubleColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongColumnC1NullsC2Nulls() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualLongColumn vectorExpression = new FilterDoubleColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongColumnC1NullsRepeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, true, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, false, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualLongColumn vectorExpression = new FilterDoubleColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }

    @Test
    public void testFilterDoubleColGreaterEqualLongColumnC1NullsC2Repeats() throws HiveException {
        Random rand = new Random(64087L);
        DoubleColumnVector inputColumnVector1 = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, 100, rand);
        LongColumnVector inputColumnVector2 = VectorizedRowGroupGenUtil.generateLongColumnVector(false, true, 100, rand);
        VectorizedRowBatch rowBatch = new VectorizedRowBatch(2, 100);
        rowBatch.cols[0] = inputColumnVector1;
        rowBatch.cols[1] = inputColumnVector2;
        FilterDoubleColGreaterEqualLongColumn vectorExpression = new FilterDoubleColGreaterEqualLongColumn(0, 1);
        vectorExpression.evaluate(rowBatch);
        int selectedIndex = 0;
        for (int i = 0; i < 100; ++i) {
            if (inputColumnVector1.isNull[i] || inputColumnVector2.isNull[i] || !(inputColumnVector1.vector[i] >= (double)inputColumnVector2.vector[i])) continue;
            Assert.assertEquals((String)("Vector index that passes filter " + inputColumnVector1.vector[i] + ">=" + inputColumnVector2.vector[i] + " is not in rowBatch selected index"), (long)i, (long)rowBatch.selected[selectedIndex]);
            ++selectedIndex;
        }
        Assert.assertEquals((String)("Row batch size not set to number of selected rows: " + selectedIndex), (long)selectedIndex, (long)rowBatch.size);
        if (selectedIndex > 0 && selectedIndex < 100) {
            Assert.assertEquals((String)("selectedInUse should be set when > 0 and < entire batch(100) is selected: " + selectedIndex), (Object)true, (Object)rowBatch.selectedInUse);
        } else if (selectedIndex == 100) {
            Assert.assertEquals((String)("selectedInUse should not be set when entire batch(100) is selected: " + selectedIndex), (Object)false, (Object)rowBatch.selectedInUse);
        }
    }
}

