/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColDivideLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongScalarDivideLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorArithmeticExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarModuloLongColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongScalarSubtractLongColumn;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorScalarColArithmetic {
    private final double EPS = 1.0E-7;

    private VectorizedRowBatch getVectorizedRowBatchSingleLongVector(int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = i * 37;
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getBatchSingleLongVectorPositiveNonZero() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        int size = 1024;
        LongColumnVector lcv = new LongColumnVector();
        for (int i = 0; i < 1024; ++i) {
            lcv.vector[i] = (i + 1) * 37;
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector();
        batch.size = 1024;
        return batch;
    }

    @Test
    public void testLongScalarModuloLongColNoNulls() throws HiveException {
        VectorizedRowBatch batch = this.getBatchSingleLongVectorPositiveNonZero();
        LongScalarModuloLongColumn expr = new LongScalarModuloLongColumn(100L, 0, 1);
        expr.evaluate(batch);
        for (int i = 0; i < 1024; ++i) {
            junit.framework.Assert.assertEquals((long)(100 % ((i + 1) * 37)), (long)((LongColumnVector)batch.cols[1]).vector[i]);
        }
        junit.framework.Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        junit.framework.Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
    }

    @Test
    public void testLongScalarSubtractLongColNoNulls() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatchSingleLongVector(1024);
        LongScalarSubtractLongColumn expr = new LongScalarSubtractLongColumn(100L, 0, 1);
        expr.evaluate(batch);
        for (int i = 0; i < 1024; ++i) {
            junit.framework.Assert.assertEquals((long)(100 - i * 37), (long)((LongColumnVector)batch.cols[1]).vector[i]);
        }
        junit.framework.Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        junit.framework.Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
    }

    @Test
    public void testLongScalarSubtractLongColWithNulls() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatchSingleLongVector(1024);
        LongColumnVector lcv = (LongColumnVector)batch.cols[0];
        TestVectorizedRowBatch.addRandomNulls((ColumnVector)lcv);
        LongScalarSubtractLongColumn expr = new LongScalarSubtractLongColumn(100L, 0, 1);
        expr.evaluate(batch);
        for (int i = 0; i < 1024; ++i) {
            if (!lcv.isNull[i]) {
                junit.framework.Assert.assertEquals((long)(100 - i * 37), (long)((LongColumnVector)batch.cols[1]).vector[i]);
                continue;
            }
            junit.framework.Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).isNull[i]);
        }
        junit.framework.Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        junit.framework.Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries((LongColumnVector)batch.cols[1], batch.selected, batch.selectedInUse, batch.size);
    }

    @Test
    public void testLongScalarSubtractLongColWithRepeating() throws HiveException {
        VectorizedRowBatch batch = this.getVectorizedRowBatchSingleLongVector(1024);
        LongColumnVector in = (LongColumnVector)batch.cols[0];
        in.isRepeating = true;
        LongColumnVector out = (LongColumnVector)batch.cols[1];
        out.isRepeating = false;
        LongScalarSubtractLongColumn expr = new LongScalarSubtractLongColumn(100L, 0, 1);
        expr.evaluate(batch);
        junit.framework.Assert.assertTrue((boolean)out.isRepeating);
        junit.framework.Assert.assertTrue((boolean)out.noNulls);
        junit.framework.Assert.assertEquals((long)out.vector[0], (long)100L);
        batch = this.getVectorizedRowBatchSingleLongVector(1024);
        in = (LongColumnVector)batch.cols[0];
        in.isRepeating = true;
        in.noNulls = false;
        in.isNull[0] = true;
        out = (LongColumnVector)batch.cols[1];
        out.isRepeating = false;
        out.isNull[0] = false;
        out.noNulls = true;
        expr = new LongScalarSubtractLongColumn(100L, 0, 1);
        expr.evaluate(batch);
        junit.framework.Assert.assertTrue((boolean)out.isRepeating);
        junit.framework.Assert.assertFalse((boolean)out.noNulls);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)out.isNull[0]);
        TestVectorArithmeticExpressions.verifyLongNullDataVectorEntries(out, batch.selected, batch.selectedInUse, batch.size);
    }

    private boolean equalsWithinTolerance(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    @Test
    public void testLongScalarDivide() throws HiveException {
        VectorizedRowBatch batch = TestVectorArithmeticExpressions.getVectorizedRowBatch2LongInDoubleOut();
        LongColDivideLongScalar expr = new LongColDivideLongScalar(0, 100L, 2);
        batch.cols[0].isNull[0] = true;
        batch.cols[0].noNulls = false;
        DoubleColumnVector out = (DoubleColumnVector)batch.cols[2];
        out.noNulls = true;
        out.isRepeating = true;
        expr.evaluate(batch);
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertTrue((boolean)out.isNull[0]);
        Assert.assertTrue((boolean)Double.isNaN(out.vector[0]));
        for (int i = 1; i != batch.size; ++i) {
            Assert.assertTrue((boolean)this.equalsWithinTolerance((double)(i * 37) / 100.0, out.vector[i]));
        }
        Assert.assertFalse((boolean)out.isRepeating);
    }

    @Test
    public void testScalarLongDivide() throws HiveException {
        VectorizedRowBatch batch = TestVectorArithmeticExpressions.getVectorizedRowBatch2LongInDoubleOut();
        LongScalarDivideLongColumn expr = new LongScalarDivideLongColumn(100L, 0, 2);
        batch.cols[0].isNull[1] = true;
        batch.cols[0].noNulls = false;
        DoubleColumnVector out = (DoubleColumnVector)batch.cols[2];
        out.noNulls = true;
        out.isRepeating = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)out.isNull[0]);
        Assert.assertTrue((boolean)Double.isNaN(out.vector[0]));
        Assert.assertTrue((boolean)out.isNull[1]);
        Assert.assertTrue((boolean)Double.isNaN(out.vector[1]));
        for (int i = 2; i != batch.size; ++i) {
            Assert.assertTrue((boolean)this.equalsWithinTolerance(100.0 / (double)(i * 37), out.vector[i]));
        }
        Assert.assertFalse((boolean)out.noNulls);
        Assert.assertFalse((boolean)out.isRepeating);
    }

    @Test
    public void testBooleanValuedLongIn() throws HiveException {
        VectorizedRowBatch batch = this.getBatch();
        long[] a = new long[]{20L, 1000L};
        batch.size = 2;
        LongColumnInList expr = new LongColumnInList(0, 1);
        expr.setInListValues(a);
        expr.evaluate(batch);
        LongColumnVector out = (LongColumnVector)batch.cols[1];
        junit.framework.Assert.assertEquals((long)0L, (long)out.vector[0]);
        junit.framework.Assert.assertEquals((long)1L, (long)out.vector[1]);
    }

    private VectorizedRowBatch getBatch() {
        VectorizedRowBatch b = new VectorizedRowBatch(2);
        LongColumnVector v = new LongColumnVector();
        v.vector[0] = 10L;
        v.vector[1] = 20L;
        b.cols[0] = v;
        b.cols[1] = new LongColumnVector();
        return b;
    }
}

