/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorHashKeyWrapperBatch {
    @Test
    public void testVectorHashKeyWrapperBatch() throws HiveException {
        VectorExpression[] keyExpressions = new VectorExpression[]{new IdentityExpression(0)};
        TypeInfo[] typeInfos = new TypeInfo[]{TypeInfoFactory.timestampTypeInfo};
        VectorHashKeyWrapperBatch vhkwb = VectorHashKeyWrapperBatch.compileKeyWrapperBatch((VectorExpression[])keyExpressions, (TypeInfo[])typeInfos);
        VectorizedRowBatch batch = new VectorizedRowBatch(1);
        batch.selectedInUse = false;
        batch.size = 10;
        TimestampColumnVector timestampColVector = new TimestampColumnVector(1024);
        batch.cols[0] = timestampColVector;
        timestampColVector.reset();
        timestampColVector.noNulls = false;
        timestampColVector.isNull[0] = true;
        Timestamp scratch = new Timestamp(2039L);
        Timestamp ts0 = new Timestamp(2039L);
        scratch.setTime(ts0.getTime());
        scratch.setNanos(ts0.getNanos());
        timestampColVector.set(1, scratch);
        Timestamp ts1 = new Timestamp(33222L);
        scratch.setTime(ts1.getTime());
        scratch.setNanos(ts1.getNanos());
        timestampColVector.set(2, scratch);
        batch.size = 3;
        vhkwb.evaluateBatch(batch);
        VectorHashKeyWrapper[] vhkwArray = vhkwb.getVectorHashKeyWrappers();
        VectorHashKeyWrapper vhk = vhkwArray[0];
        Assert.assertTrue((boolean)vhk.isNull(0));
        vhk = vhkwArray[1];
        Assert.assertFalse((boolean)vhk.isNull(0));
        Assert.assertEquals((Object)vhk.getTimestamp(0), (Object)ts0);
        vhk = vhkwArray[2];
        Assert.assertFalse((boolean)vhk.isNull(0));
        Assert.assertEquals((Object)vhk.getTimestamp(0), (Object)ts1);
    }
}

