/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTestGenericUDFOPNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFOPPlus
extends AbstractTestGenericUDFOPNumeric {
    @Test
    public void testBytePlusShort() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        ByteWritable left = new ByteWritable(4);
        ShortWritable right = new ShortWritable(6);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableByteObjectInspector, PrimitiveObjectInspectorFactory.writableShortObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.shortTypeInfo);
        ShortWritable res = (ShortWritable)udf.evaluate(args);
        Assert.assertEquals((long)10L, (long)res.get());
    }

    @Test
    public void testVarcharPlusInt() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveVarcharWritable left = new HiveVarcharWritable();
        left.set("123");
        IntWritable right = new IntWritable(456);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableIntObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.doubleTypeInfo);
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(579.0), (Object)new Double(res.get()));
    }

    @Test
    public void testDoublePlusLong() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DoubleWritable left = new DoubleWritable(4.5);
        LongWritable right = new LongWritable(10L);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(14.5), (Object)new Double(res.get()));
    }

    @Test
    public void testLongPlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        LongWritable left = new LongWritable(104L);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)9, (int)4))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)24, (int)4), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"338.97"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testFloatPlusFloat() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        FloatWritable f1 = new FloatWritable(4.5f);
        FloatWritable f2 = new FloatWritable(0.0f);
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableFloatObjectInspector, PrimitiveObjectInspectorFactory.writableFloatObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)f1), new GenericUDF.DeferredJavaObject((Object)f2)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)oi.getTypeInfo(), (Object)TypeInfoFactory.floatTypeInfo);
        FloatWritable res = (FloatWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Float(4.5), (Object)new Float(res.get()));
    }

    @Test
    public void testDoulePlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DoubleWritable left = new DoubleWritable(74.52);
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.doubleTypeInfo, (Object)oi.getTypeInfo());
        DoubleWritable res = (DoubleWritable)udf.evaluate(args);
        Assert.assertEquals((Object)new Double(309.49), (Object)new Double(res.get()));
    }

    @Test
    public void testDecimalPlusDecimal() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveDecimalWritable left = new HiveDecimalWritable(HiveDecimal.create((String)"14.5"));
        HiveDecimalWritable right = new HiveDecimalWritable(HiveDecimal.create((String)"234.97"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)3, (int)1)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
        HiveDecimalWritable res = (HiveDecimalWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveDecimal.create((String)"249.47"), (Object)res.getHiveDecimal());
    }

    @Test
    public void testDecimalPlusDecimalSameParams() throws HiveException {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2)), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)5, (int)2))};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.getDecimalTypeInfo((int)6, (int)2), (Object)oi.getTypeInfo());
    }

    @Test
    public void testReturnTypeBackwardCompat() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "0.12");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "decimal(10,2)", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
    }

    @Test
    public void testReturnTypeAnsiSql() throws Exception {
        SessionState.get().getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "int", "int");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "int", "decimal(10,2)", "decimal(13,2)");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "float", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "float", "decimal(10,2)", "float");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "double", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "double", "decimal(10,2)", "double");
        this.verifyReturnType((GenericUDF)new GenericUDFOPPlus(), "decimal(10,2)", "decimal(10,2)", "decimal(11,2)");
    }

    @Test
    public void testIntervalYearMonthPlusIntervalYearMonth() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalYearMonthWritable left = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"1-2"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"1-11"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intervalYearMonthTypeInfo, (Object)oi.getTypeInfo());
        HiveIntervalYearMonthWritable res = (HiveIntervalYearMonthWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveIntervalYearMonth.valueOf((String)"3-1"), (Object)res.getHiveIntervalYearMonth());
    }

    @Test
    public void testIntervalYearMonthPlusDate() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalYearMonthWritable left = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-8"));
        DateWritableV2 right = new DateWritableV2(Date.valueOf((String)"2001-06-15"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)oi.getTypeInfo());
        DateWritableV2 res = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Date.valueOf((String)"2004-02-15"), (Object)res.get());
    }

    @Test
    public void testDatePlusIntervalYearMonth() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DateWritableV2 left = new DateWritableV2(Date.valueOf((String)"2001-06-15"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-8"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.dateTypeInfo, (Object)oi.getTypeInfo());
        DateWritableV2 res = (DateWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Date.valueOf((String)"2004-02-15"), (Object)res.get());
    }

    @Test
    public void testIntervalYearMonthPlusTimestamp() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalYearMonthWritable left = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-2"));
        TimestampWritableV2 right = new TimestampWritableV2(Timestamp.valueOf((String)"2001-11-15 01:02:03.123456789"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector, PrimitiveObjectInspectorFactory.writableTimestampObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2004-01-15 01:02:03.123456789"), (Object)res.getTimestamp());
    }

    @Test
    public void testTimestampPlusIntervalYearMonth() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        TimestampWritableV2 left = new TimestampWritableV2(Timestamp.valueOf((String)"2001-11-15 01:02:03.123456789"));
        HiveIntervalYearMonthWritable right = new HiveIntervalYearMonthWritable(HiveIntervalYearMonth.valueOf((String)"2-2"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalYearMonthObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2004-01-15 01:02:03.123456789"), (Object)res.getTimestamp());
    }

    @Test
    public void testIntervalDayTimePlusIntervalDayTime() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalDayTimeWritable left = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 0:0:0.567"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.intervalDayTimeTypeInfo, (Object)oi.getTypeInfo());
        HiveIntervalDayTimeWritable res = (HiveIntervalDayTimeWritable)udf.evaluate(args);
        Assert.assertEquals((Object)HiveIntervalDayTime.valueOf((String)"2 2:3:4.567"), (Object)res.getHiveIntervalDayTime());
    }

    @Test
    public void testIntervalDayTimePlusTimestamp() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalDayTimeWritable left = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4.567"));
        TimestampWritableV2 right = new TimestampWritableV2(Timestamp.valueOf((String)"2001-01-01 00:00:00"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector, PrimitiveObjectInspectorFactory.writableTimestampObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-02 2:3:4.567"), (Object)res.getTimestamp());
    }

    @Test
    public void testTimestampPlusIntervalDayTime() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        TimestampWritableV2 left = new TimestampWritableV2(Timestamp.valueOf((String)"2001-01-01 00:00:00"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4.567"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-02 2:3:4.567"), (Object)res.getTimestamp());
    }

    @Test
    public void testIntervalDayTimePlusDate() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        HiveIntervalDayTimeWritable left = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4.567"));
        DateWritableV2 right = new DateWritableV2(Date.valueOf((String)"2001-01-01"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector, PrimitiveObjectInspectorFactory.writableDateObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-02 2:3:4.567"), (Object)res.getTimestamp());
    }

    @Test
    public void testDatePlusIntervalDayTime() throws Exception {
        GenericUDFOPPlus udf = new GenericUDFOPPlus();
        DateWritableV2 left = new DateWritableV2(Date.valueOf((String)"2001-01-01"));
        HiveIntervalDayTimeWritable right = new HiveIntervalDayTimeWritable(HiveIntervalDayTime.valueOf((String)"1 2:3:4.567"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector, PrimitiveObjectInspectorFactory.writableHiveIntervalDayTimeObjectInspector};
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)left), new GenericUDF.DeferredJavaObject((Object)right)};
        PrimitiveObjectInspector oi = (PrimitiveObjectInspector)udf.initialize(inputOIs);
        Assert.assertEquals((Object)TypeInfoFactory.timestampTypeInfo, (Object)oi.getTypeInfo());
        TimestampWritableV2 res = (TimestampWritableV2)udf.evaluate(args);
        Assert.assertEquals((Object)Timestamp.valueOf((String)"2001-01-02 2:3:4.567"), (Object)res.getTimestamp());
    }
}

