/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDatetimeLegacyHybridCalendar;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFDatetimeLegacyHybridCalendar {
    public static void runAndVerify(GenericUDF udf, Object arg1, Object expected) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject(arg1)};
        Object result = udf.evaluate(args);
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertEquals((Object)expected.toString(), (Object)result.toString());
        }
    }

    @Test
    public void testDateLegacyHybridCalendar() throws Exception {
        WritableDateObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        GenericUDFDatetimeLegacyHybridCalendar udf = new GenericUDFDatetimeLegacyHybridCalendar();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new DateWritableV2(Date.valueOf((String)"0000-12-30")), new DateWritableV2(Date.valueOf((String)"0001-01-01")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new DateWritableV2(Date.valueOf((String)"0601-03-07")), new DateWritableV2(Date.valueOf((String)"0601-03-04")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new DateWritableV2(Date.valueOf((String)"1582-10-14")), new DateWritableV2(Date.valueOf((String)"1582-10-04")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new DateWritableV2(Date.valueOf((String)"1582-10-15")), new DateWritableV2(Date.valueOf((String)"1582-10-15")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new DateWritableV2(Date.valueOf((String)"2015-03-07")), new DateWritableV2(Date.valueOf((String)"2015-03-07")));
    }

    @Test
    public void testDatetimeLegacyHybridCalendar() throws Exception {
        WritableTimestampObjectInspector valueOI = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        GenericUDFDatetimeLegacyHybridCalendar udf = new GenericUDFDatetimeLegacyHybridCalendar();
        ObjectInspector[] args2 = new ObjectInspector[]{valueOI, valueOI};
        udf.initialize(args2);
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"0601-03-07 17:00:00")), new TimestampWritableV2(Timestamp.valueOf((String)"0601-03-04 17:00:00")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"1582-10-14 09:17:22.13")), new TimestampWritableV2(Timestamp.valueOf((String)"1582-10-04 09:17:22.13")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"1582-10-15 11:17:22.13")), new TimestampWritableV2(Timestamp.valueOf((String)"1582-10-15 11:17:22.13")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"2015-03-07 17:00:00")), new TimestampWritableV2(Timestamp.valueOf((String)"2015-03-07 17:00:00")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"0601-03-07 18:00:00.123456789")), new TimestampWritableV2(Timestamp.valueOf((String)"0601-03-04 18:00:00.123456789")));
        TestGenericUDFDatetimeLegacyHybridCalendar.runAndVerify((GenericUDF)udf, new TimestampWritableV2(Timestamp.valueOf((String)"2018-07-07 18:00:00.123456789")), new TimestampWritableV2(Timestamp.valueOf((String)"2018-07-07 18:00:00.123456789")));
    }
}

