/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReduceExpressionsWithStatsRule;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveReduceExpressionsWithStatsRule {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    Map<String, String> tableParams = new HashMap<String, String>();
    private HepPlanner planner;
    private RelBuilder builder;
    private ColStatistics statObj;

    @Before
    public void before() {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        programBuilder.addRuleInstance((RelOptRule)HiveReduceExpressionsWithStatsRule.INSTANCE);
        this.planner = new HepPlanner(programBuilder.build());
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RelOptCluster optCluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)rexBuilder);
        RelDataType rowTypeMock = typeFactory.createStructType(MyRecord.class);
        ((RelOptHiveTable)Mockito.doReturn((Object)rowTypeMock).when((Object)this.tableMock)).getRowType();
        ((RelOptSchema)Mockito.doReturn((Object)this.tableMock).when((Object)this.schemaMock)).getTableForMember((List)Matchers.any());
        this.statObj = new ColStatistics("_int", "int");
        ((RelOptHiveTable)Mockito.doReturn((Object)Lists.newArrayList((Object[])new ColStatistics[]{this.statObj})).when((Object)this.tableMock)).getColStat(Matchers.anyListOf(Integer.class), Matchers.eq((boolean)false));
        ((RelOptHiveTable)Mockito.doReturn((Object)this.hiveTableMDMock).when((Object)this.tableMock)).getHiveTableMD();
        ((Table)Mockito.doReturn(this.tableParams).when((Object)this.hiveTableMDMock)).getParameters();
        this.builder = HiveRelFactories.HIVE_BUILDER.create(optCluster, this.schemaMock);
        StatsSetupConst.setStatsStateForCreateTable(this.tableParams, (List)Lists.newArrayList((Object[])new String[]{"_int"}), (String)"true");
        this.tableParams.put("numRows", "3");
    }

    @Test
    public void testGreaterThan_Below() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.builder.field("_int"), this.builder.literal((Object)0)})}).build();
        this.statObj.setRange((Number)100, (Number)200);
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        Assert.assertEquals((String)"missing literal", (Object)SqlKind.LITERAL, (Object)((RexNode)optimizedRelNode.getChildExps().get(0)).getKind());
        RexLiteral val = (RexLiteral)optimizedRelNode.getChildExps().get(0);
        Assert.assertEquals((Object)true, (Object)val.getValue());
    }

    @Test
    public void testIsNull_zero() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.builder.field("_str")})}).build();
        this.statObj.setNumNulls(0L);
        this.planner.setRoot(basePlan);
        System.out.println(RelOptUtil.toString((RelNode)basePlan));
        RelNode optimizedRelNode = this.planner.findBestExp();
        System.out.println(RelOptUtil.toString((RelNode)optimizedRelNode));
        Assert.assertEquals((String)"missing literal", (Object)SqlKind.LITERAL, (Object)((RexNode)optimizedRelNode.getChildExps().get(0)).getKind());
        RexLiteral val = (RexLiteral)optimizedRelNode.getChildExps().get(0);
        Assert.assertEquals((Object)false, (Object)val.getValue());
    }

    @Test
    public void testIsNull_one() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.builder.field("_str")})}).build();
        this.statObj.setNumNulls(1L);
        this.planner.setRoot(basePlan);
        System.out.println(RelOptUtil.toString((RelNode)basePlan));
        RelNode optimizedRelNode = this.planner.findBestExp();
        System.out.println(RelOptUtil.toString((RelNode)optimizedRelNode));
        Assert.assertNotEquals((String)"should not be a literal", (Object)SqlKind.LITERAL, (Object)((RexNode)optimizedRelNode.getChildExps().get(0)).getKind());
    }

    @Test
    public void testIsNull_all() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.builder.field("_str")})}).build();
        this.statObj.setNumNulls(3L);
        this.planner.setRoot(basePlan);
        System.out.println(RelOptUtil.toString((RelNode)basePlan));
        RelNode optimizedRelNode = this.planner.findBestExp();
        System.out.println(RelOptUtil.toString((RelNode)optimizedRelNode));
        Assert.assertEquals((String)"missing literal", (Object)SqlKind.LITERAL, (Object)((RexNode)optimizedRelNode.getChildExps().get(0)).getKind());
        RexLiteral val = (RexLiteral)optimizedRelNode.getChildExps().get(0);
        Assert.assertEquals((Object)true, (Object)val.getValue());
    }

    @Test
    public void testIsNotNull() {
        RelNode basePlan = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.builder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{this.builder.field("_str")})}).build();
        this.statObj.setNumNulls(0L);
        this.planner.setRoot(basePlan);
        System.out.println(RelOptUtil.toString((RelNode)basePlan));
        RelNode optimizedRelNode = this.planner.findBestExp();
        System.out.println(RelOptUtil.toString((RelNode)optimizedRelNode));
        Assert.assertEquals((String)"missing literal", (Object)SqlKind.LITERAL, (Object)((RexNode)optimizedRelNode.getChildExps().get(0)).getKind());
        RexLiteral val = (RexLiteral)optimizedRelNode.getChildExps().get(0);
        Assert.assertEquals((Object)true, (Object)val.getValue());
    }

    private static class MyRecord {
        public int _int;
        public String _str;

        private MyRecord() {
        }
    }
}

