/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRawRecordMerger;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.OrcAcidUtils;
import org.apache.orc.impl.ReaderImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOrcRawRecordMerger {
    private static final Logger LOG = LoggerFactory.getLogger(TestOrcRawRecordMerger.class);
    private final MockSettings settings = Mockito.withSettings();
    private final Path tmpDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testOrdering() throws Exception {
        OrcRawRecordMerger.ReaderKey left = new OrcRawRecordMerger.ReaderKey(100L, 200, 1200L, 300L);
        OrcRawRecordMerger.ReaderKey right = new OrcRawRecordMerger.ReaderKey();
        right.setValues(100L, 200, 1000L, 200L, false);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)false, (Object)left.equals((Object)right));
        left.set((RecordIdentifier)right);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)true, (Object)right.equals((Object)left));
        right.setRowId(2000L);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 4L, false);
        right.setValues(100L, 2, 3L, 4L, false);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 4L, false);
        right.setValues(1L, 100, 3L, 4L, false);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        left.setValues(1L, 2, 3L, 100L, false);
        right.setValues(1L, 2, 3L, 4L, false);
        Assert.assertTrue((left.compareTo((RecordIdentifier)right) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((right.compareTo((RecordIdentifier)left) > 0 ? 1 : 0) != 0);
        RecordIdentifier ri = new RecordIdentifier(1L, 2, 3L);
        Assert.assertEquals((long)1L, (long)ri.compareTo((RecordIdentifier)left));
        Assert.assertEquals((long)-1L, (long)left.compareTo(ri));
        Assert.assertEquals((Object)false, (Object)ri.equals((Object)left));
        Assert.assertEquals((Object)false, (Object)left.equals((Object)ri));
    }

    private static void setRow(OrcStruct event, int operation, long originalTransaction, int bucket, long rowId, long currentTransaction, String value) {
        event.setFieldValue(0, (Object)new IntWritable(operation));
        event.setFieldValue(1, (Object)new LongWritable(originalTransaction));
        event.setFieldValue(2, (Object)new IntWritable(bucket));
        event.setFieldValue(3, (Object)new LongWritable(rowId));
        event.setFieldValue(4, (Object)new LongWritable(currentTransaction));
        OrcStruct row = new OrcStruct(1);
        row.setFieldValue(0, (Object)new Text(value));
        event.setFieldValue(5, (Object)row);
    }

    private static String value(OrcStruct event) {
        return OrcRecordUpdater.getRow((OrcStruct)event).getFieldValue(0).toString();
    }

    private List<StripeInformation> createStripes(long ... rowCounts) {
        long offset = 0L;
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(rowCounts.length);
        for (long count : rowCounts) {
            OrcProto.StripeInformation.Builder stripe = OrcProto.StripeInformation.newBuilder();
            stripe.setDataLength(800L).setIndexLength(100L).setFooterLength(100L).setNumberOfRows(count).setOffset(offset);
            offset += 1000L;
            result.add((StripeInformation)new ReaderImpl.StripeInformationImpl(stripe.build()));
        }
        return result;
    }

    private Reader createMockReader() throws IOException {
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        OrcStruct row1 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row1, 0, 10L, 20, 20L, 100L, "first");
        OrcStruct row2 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row2, 0, 10L, 20, 30L, 110L, "second");
        OrcStruct row3 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row3, 0, 10L, 20, 40L, 120L, "third");
        OrcStruct row4 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row4, 0, 40L, 50, 60L, 130L, "fourth");
        OrcStruct row5 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row5, 0, 40L, 50, 61L, 140L, "fifth");
        Mockito.when((Object)reader.rowsOptions((Reader.Options)Mockito.any(Reader.Options.class), (Configuration)Mockito.any(HiveConf.class))).thenReturn((Object)recordReader);
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)Float.valueOf(recordReader.getProgress())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1);
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row4);
        Mockito.when((Object)recordReader.next((Object)row4)).thenReturn((Object)row5);
        return reader;
    }

    @Test
    public void testReaderPair() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockReader();
        RecordIdentifier minKey = new RecordIdentifier(10L, 20, 30L);
        RecordIdentifier maxKey = new RecordIdentifier(40L, 50, 60L);
        OrcRawRecordMerger.ReaderPairAcid pair = new OrcRawRecordMerger.ReaderPairAcid(key, reader, minKey, maxKey, new Reader.Options(), (Configuration)new HiveConf());
        RecordReader recordReader = pair.getRecordReader();
        Assert.assertEquals((long)10L, (long)key.getWriteId());
        Assert.assertEquals((long)20L, (long)key.getBucketProperty());
        Assert.assertEquals((long)40L, (long)key.getRowId());
        Assert.assertEquals((long)120L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)40L, (long)key.getWriteId());
        Assert.assertEquals((long)50L, (long)key.getBucketProperty());
        Assert.assertEquals((long)60L, (long)key.getRowId());
        Assert.assertEquals((long)130L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals(null, (Object)pair.nextRecord());
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    @Test
    public void testReaderPairNoMin() throws Exception {
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockReader();
        OrcRawRecordMerger.ReaderPairAcid pair = new OrcRawRecordMerger.ReaderPairAcid(key, reader, null, null, new Reader.Options(), (Configuration)new HiveConf());
        RecordReader recordReader = pair.getRecordReader();
        Assert.assertEquals((long)10L, (long)key.getWriteId());
        Assert.assertEquals((long)20L, (long)key.getBucketProperty());
        Assert.assertEquals((long)20L, (long)key.getRowId());
        Assert.assertEquals((long)100L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"first", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)10L, (long)key.getWriteId());
        Assert.assertEquals((long)20L, (long)key.getBucketProperty());
        Assert.assertEquals((long)30L, (long)key.getRowId());
        Assert.assertEquals((long)110L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)10L, (long)key.getWriteId());
        Assert.assertEquals((long)20L, (long)key.getBucketProperty());
        Assert.assertEquals((long)40L, (long)key.getRowId());
        Assert.assertEquals((long)120L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)40L, (long)key.getWriteId());
        Assert.assertEquals((long)50L, (long)key.getBucketProperty());
        Assert.assertEquals((long)60L, (long)key.getRowId());
        Assert.assertEquals((long)130L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)40L, (long)key.getWriteId());
        Assert.assertEquals((long)50L, (long)key.getBucketProperty());
        Assert.assertEquals((long)61L, (long)key.getRowId());
        Assert.assertEquals((long)140L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals(null, (Object)pair.nextRecord());
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    private static OrcStruct createOriginalRow(String value) {
        OrcStruct result = new OrcStruct(1);
        result.setFieldValue(0, (Object)new Text(value));
        return result;
    }

    private Reader createMockOriginalReader() throws IOException {
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        OrcStruct row1 = TestOrcRawRecordMerger.createOriginalRow("first");
        OrcStruct row2 = TestOrcRawRecordMerger.createOriginalRow("second");
        OrcStruct row3 = TestOrcRawRecordMerger.createOriginalRow("third");
        OrcStruct row4 = TestOrcRawRecordMerger.createOriginalRow("fourth");
        OrcStruct row5 = TestOrcRawRecordMerger.createOriginalRow("fifth");
        Mockito.when((Object)reader.rowsOptions((Reader.Options)ArgumentMatchers.any(Reader.Options.class), (Configuration)ArgumentMatchers.any())).thenReturn((Object)recordReader);
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)recordReader.getRowNumber()).thenReturn((Object)0L, (Object[])new Long[]{1L, 2L, 3L, 4L});
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1);
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row4);
        Mockito.when((Object)recordReader.next((Object)row4)).thenReturn((Object)row5);
        return reader;
    }

    @Test
    public void testOriginalReaderPair() throws Exception {
        int BUCKET = 10;
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        int bucketProperty = OrcRawRecordMerger.encodeBucketId((Configuration)conf, (int)BUCKET, (int)0);
        Reader reader = this.createMockOriginalReader();
        RecordIdentifier minKey = new RecordIdentifier(0L, bucketProperty, 1L);
        RecordIdentifier maxKey = new RecordIdentifier(0L, bucketProperty, 3L);
        boolean[] includes = new boolean[]{true, true};
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testOriginalReaderPair");
        fs.makeQualified(root);
        fs.create(root);
        OrcRawRecordMerger.OriginalReaderPairToRead pair = new OrcRawRecordMerger.OriginalReaderPairToRead(key, reader, BUCKET, minKey, maxKey, new Reader.Options().include(includes), new OrcRawRecordMerger.Options().rootPath(root), conf, (ValidWriteIdList)new ValidReaderWriteIdList(), 0);
        RecordReader recordReader = pair.getRecordReader();
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)2L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)3L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        pair.next(pair.nextRecord());
        Assert.assertEquals(null, (Object)pair.nextRecord());
        ((RecordReader)Mockito.verify((Object)recordReader)).close();
    }

    private static ValidWriteIdList createMaximalTxnList() {
        return new ValidReaderWriteIdList();
    }

    @Test
    public void testOriginalReaderPairNoMin() throws Exception {
        int BUCKET = 10;
        OrcRawRecordMerger.ReaderKey key = new OrcRawRecordMerger.ReaderKey();
        Reader reader = this.createMockOriginalReader();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        int bucketProperty = OrcRawRecordMerger.encodeBucketId((Configuration)conf, (int)BUCKET, (int)0);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testOriginalReaderPairNoMin");
        fs.makeQualified(root);
        fs.create(root);
        OrcRawRecordMerger.OriginalReaderPairToRead pair = new OrcRawRecordMerger.OriginalReaderPairToRead(key, reader, BUCKET, null, null, new Reader.Options(), new OrcRawRecordMerger.Options().rootPath(root), conf, (ValidWriteIdList)new ValidReaderWriteIdList(), 0);
        Assert.assertEquals((Object)"first", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)0L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        pair.next(pair.nextRecord());
        Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)1L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        pair.next(pair.nextRecord());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)2L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        pair.next(pair.nextRecord());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)3L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        pair.next(pair.nextRecord());
        Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.value(pair.nextRecord()));
        Assert.assertEquals((long)0L, (long)key.getWriteId());
        Assert.assertEquals((long)bucketProperty, (long)key.getBucketProperty());
        Assert.assertEquals((long)4L, (long)key.getRowId());
        Assert.assertEquals((long)0L, (long)key.getCurrentWriteId());
        pair.next(pair.nextRecord());
        Assert.assertEquals(null, (Object)pair.nextRecord());
        ((RecordReader)Mockito.verify((Object)pair.getRecordReader())).close();
    }

    @Test
    public void testNewBase() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        conf.set("schema.evolution.columns", "col1");
        conf.set("schema.evolution.columns.types", "string");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, (boolean)true);
        Reader reader = (Reader)Mockito.mock(Reader.class, (MockSettings)this.settings);
        RecordReader recordReader = (RecordReader)Mockito.mock(RecordReader.class, (MockSettings)this.settings);
        ArrayList<OrcProto.Type> types = new ArrayList<OrcProto.Type>();
        OrcProto.Type.Builder typeBuilder = OrcProto.Type.newBuilder();
        typeBuilder.setKind(OrcProto.Type.Kind.STRUCT).addSubtypes(1).addSubtypes(2).addSubtypes(3).addSubtypes(4).addSubtypes(5).addSubtypes(6);
        typeBuilder.addAllFieldNames((Iterable)Lists.newArrayList((Object[])new String[]{"operation", "originalTransaction", "bucket", "rowId", "currentTransaction", "row"}));
        types.add(typeBuilder.build());
        types.add(null);
        types.add(null);
        types.add(null);
        types.add(null);
        types.add(null);
        typeBuilder.clearSubtypes();
        typeBuilder.addSubtypes(7);
        typeBuilder.addAllFieldNames((Iterable)Lists.newArrayList((Object[])new String[]{"col1"}));
        types.add(typeBuilder.build());
        typeBuilder.clear();
        typeBuilder.setKind(OrcProto.Type.Kind.STRING);
        types.add(typeBuilder.build());
        Mockito.when((Object)reader.getTypes()).thenReturn(types);
        Mockito.when((Object)reader.rowsOptions((Reader.Options)ArgumentMatchers.any(), (Configuration)ArgumentMatchers.any())).thenReturn((Object)recordReader);
        OrcStruct row1 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row1, 0, 10L, 20, 20L, 100L, "first");
        OrcStruct row2 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row2, 0, 10L, 20, 30L, 110L, "second");
        OrcStruct row3 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row3, 0, 10L, 20, 40L, 120L, "third");
        OrcStruct row4 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row4, 0, 40L, 50, 60L, 130L, "fourth");
        OrcStruct row5 = new OrcStruct(6);
        TestOrcRawRecordMerger.setRow(row5, 0, 40L, 50, 61L, 140L, "fifth");
        Mockito.when((Object)recordReader.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)Float.valueOf(recordReader.getProgress())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)recordReader.next(null)).thenReturn((Object)row1, new Object[]{row4});
        Mockito.when((Object)recordReader.next((Object)row1)).thenReturn((Object)row2);
        Mockito.when((Object)recordReader.next((Object)row2)).thenReturn((Object)row3);
        Mockito.when((Object)recordReader.next((Object)row3)).thenReturn((Object)row5);
        Mockito.when((Object)reader.getMetadataValue("hive.acid.key.index")).thenReturn((Object)ByteBuffer.wrap("10,20,30;40,50,60;40,50,61".getBytes("UTF-8")));
        Mockito.when((Object)reader.getStripes()).thenReturn(this.createStripes(2L, 2L, 1L));
        OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, false, reader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options().range(1000L, 1000L), null, new OrcRawRecordMerger.Options());
        RecordReader rr = merger.getCurrentReader().getRecordReader();
        Assert.assertEquals((long)0L, (long)merger.getOtherReaders().size());
        Assert.assertEquals((String)("" + merger.getMinKey()), (Object)new RecordIdentifier(10L, 20, 30L), (Object)merger.getMinKey());
        Assert.assertEquals((String)("" + merger.getMaxKey()), (Object)new RecordIdentifier(40L, 50, 60L), (Object)merger.getMaxKey());
        RecordIdentifier id = merger.createKey();
        OrcStruct event = merger.createValue();
        Assert.assertEquals((Object)true, (Object)merger.next(id, event));
        Assert.assertEquals((long)10L, (long)id.getWriteId());
        Assert.assertEquals((long)20L, (long)id.getBucketProperty());
        Assert.assertEquals((long)40L, (long)id.getRowId());
        Assert.assertEquals((Object)"third", (Object)TestOrcRawRecordMerger.getValue(event));
        Assert.assertEquals((Object)true, (Object)merger.next(id, event));
        Assert.assertEquals((long)40L, (long)id.getWriteId());
        Assert.assertEquals((long)50L, (long)id.getBucketProperty());
        Assert.assertEquals((long)60L, (long)id.getRowId());
        Assert.assertEquals((Object)"fourth", (Object)TestOrcRawRecordMerger.getValue(event));
        Assert.assertEquals((Object)false, (Object)merger.next(id, event));
        Assert.assertEquals((double)1.0, (double)merger.getProgress(), (double)0.01);
        merger.close();
        ((RecordReader)Mockito.verify((Object)rr)).close();
        ((RecordReader)Mockito.verify((Object)rr)).getProgress();
        StructObjectInspector eventObjectInspector = (StructObjectInspector)merger.getObjectInspector();
        List fields = eventObjectInspector.getAllStructFieldRefs();
        Assert.assertEquals((long)6L, (long)fields.size());
        Assert.assertEquals((Object)"operation", (Object)((StructField)fields.get(0)).getFieldName());
        Assert.assertEquals((Object)"currentTransaction", (Object)((StructField)fields.get(4)).getFieldName());
        Assert.assertEquals((Object)"originalTransaction", (Object)((StructField)fields.get(1)).getFieldName());
        Assert.assertEquals((Object)"bucket", (Object)((StructField)fields.get(2)).getFieldName());
        Assert.assertEquals((Object)"rowId", (Object)((StructField)fields.get(3)).getFieldName());
        StructObjectInspector rowObjectInspector = (StructObjectInspector)((StructField)fields.get(5)).getFieldObjectInspector();
        Assert.assertEquals((Object)"col1", (Object)((StructField)rowObjectInspector.getAllStructFieldRefs().get(0)).getFieldName());
    }

    static String getValue(OrcStruct event) {
        return OrcRecordUpdater.getRow((OrcStruct)event).getFieldValue(0).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetLogicalLength() throws Exception {
        boolean BUCKET = false;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        OrcOutputFormat of = new OrcOutputFormat();
        Path root = new Path(this.tmpDir, "testEmpty").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).inspector(inspector).bucket(0).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).finalDestination(root);
            Path delta1_1_0 = new Path(root, AcidUtils.deltaSubdir((long)options.getMinimumWriteId(), (long)options.getMaximumWriteId(), (int)options.getStatementId()));
            Path bucket0 = AcidUtils.createBucketFile((Path)delta1_1_0, (int)0);
            Path bucket0SideFile = OrcAcidUtils.getSideFile((Path)bucket0);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            ru.insert(options.getMaximumWriteId(), (Object)new MyRow("first"));
            ru.close(false);
            FileStatus bucket0File = fs.getFileStatus(bucket0);
            AcidUtils.getLogicalLength((FileSystem)fs, (FileStatus)bucket0File);
            Assert.assertTrue((String)("no " + bucket0), (boolean)fs.exists(bucket0));
            Assert.assertFalse((String)("unexpected " + bucket0SideFile), (boolean)fs.exists(bucket0SideFile));
            Assert.assertEquals((String)"closed file size mismatch", (long)bucket0File.getLen(), (long)AcidUtils.getLogicalLength((FileSystem)fs, (FileStatus)bucket0File));
            FSDataOutputStream flushLengths = fs.create(bucket0SideFile, true, 8);
            flushLengths.close();
            this.expectedException.expect(IOException.class);
            this.expectedException.expectMessage(bucket0SideFile.getName() + " found but is not readable");
            AcidUtils.getLogicalLength((FileSystem)fs, (FileStatus)bucket0File);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmpty() throws Exception {
        boolean BUCKET = false;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testEmpty").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).inspector(inspector).bucket(0).writingBase(true).maximumWriteId(100L).finalDestination(root);
            of.getRecordUpdater(root, options).close(false);
            OrcFile.WriterOptions wo = OrcFile.writerOptions((Configuration)conf);
            wo.inspector(inspector);
            wo.callback((OrcFile.WriterCallback)new OrcRecordUpdater.KeyIndexBuilder("testEmpty"));
            Writer w = OrcFile.createWriter((Path)AcidUtils.createBucketFile((Path)new Path(root, AcidUtils.baseDir((long)100L)), (int)0), (OrcFile.WriterOptions)wo);
            w.close();
            ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("testEmpty:200:9223372036854775807");
            AcidUtils.Directory directory = AcidUtils.getAcidState((Path)root, (Configuration)conf, (ValidWriteIdList)writeIdList);
            Path basePath = AcidUtils.createBucketFile((Path)directory.getBaseDirectory(), (int)0);
            Reader baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            conf.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
            conf.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
            HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, (boolean)true);
            OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, true, baseReader, false, 0, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()), new OrcRawRecordMerger.Options().isCompacting(false));
            RecordIdentifier key = merger.createKey();
            OrcStruct value = merger.createValue();
            Assert.assertEquals((Object)false, (Object)merger.next(key, value));
            return;
        }
    }

    @Test
    public void testNewBaseAndDelta() throws Exception {
        this.testNewBaseAndDelta(false);
        this.testNewBaseAndDelta(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNewBaseAndDelta(boolean use130Format) throws Exception {
        int BUCKET = 10;
        String[] values = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth"};
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testNewBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var9_8] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).inspector(inspector).bucket(10).finalDestination(root);
            int BUCKET_PROPERTY = BucketCodec.V1.encode(options);
            if (!use130Format) {
                options.statementId(-1);
            }
            RecordUpdater ru = of.getRecordUpdater(root, options.writingBase(true).maximumWriteId(100L));
            for (String v : values) {
                ru.insert(0L, (Object)new MyRow(v));
            }
            ru.close(false);
            ru = of.getRecordUpdater(root, options.writingBase(false).minimumWriteId(200L).maximumWriteId(200L).recordIdColumn(1));
            ru.update(200L, (Object)new MyRow("update 1", 0L, 0L, BUCKET_PROPERTY));
            ru.update(200L, (Object)new MyRow("update 2", 2L, 0L, BUCKET_PROPERTY));
            ru.update(200L, (Object)new MyRow("update 3", 3L, 0L, BUCKET_PROPERTY));
            ru.delete(200L, (Object)new MyRow("", 7L, 0L, BUCKET_PROPERTY));
            ru.delete(200L, (Object)new MyRow("", 8L, 0L, BUCKET_PROPERTY));
            ru.close(false);
            ValidReaderWriteIdList writeIdList = new ValidReaderWriteIdList("testNewBaseAndDelta:200:9223372036854775807");
            AcidUtils.Directory directory = AcidUtils.getAcidState((Path)root, (Configuration)conf, (ValidWriteIdList)writeIdList);
            Assert.assertEquals((Object)new Path(root, "base_0000100"), (Object)directory.getBaseDirectory());
            Assert.assertEquals((Object)new Path(root, use130Format ? AcidUtils.deleteDeltaSubdir((long)200L, (long)200L, (int)0) : AcidUtils.deleteDeltaSubdir((long)200L, (long)200L)), (Object)((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath());
            Assert.assertEquals((Object)new Path(root, use130Format ? AcidUtils.deltaSubdir((long)200L, (long)200L, (int)0) : AcidUtils.deltaSubdir((long)200L, (long)200L)), (Object)((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(1)).getPath());
            Path basePath = AcidUtils.createBucketFile((Path)directory.getBaseDirectory(), (int)10);
            Path deltaPath = AcidUtils.createBucketFile((Path)((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(1)).getPath(), (int)10);
            Path deleteDeltaDir = ((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath();
            conf.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
            conf.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
            AcidUtils.setAcidOperationalProperties((Configuration)conf, (boolean)true, null);
            conf.setBoolean("transactional", true);
            Reader baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            OrcRawRecordMerger merger = new OrcRawRecordMerger(conf, true, baseReader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), new Path[]{deleteDeltaDir}, new OrcRawRecordMerger.Options().isCompacting(false));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            RecordIdentifier id = merger.createKey();
            OrcStruct event = merger.createValue();
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 1L, 0L), (Object)id);
            Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 3L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 4L, 0L), (Object)id);
            Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 5L, 0L), (Object)id);
            Assert.assertEquals((Object)"sixth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 6L, 0L), (Object)id);
            Assert.assertEquals((Object)"seventh", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 9L, 0L), (Object)id);
            Assert.assertEquals((Object)"tenth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            baseReader = OrcFile.createReader((Path)deltaPath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            merger = new OrcRawRecordMerger(conf, true, baseReader, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), new Path[]{deleteDeltaDir}, new OrcRawRecordMerger.Options().isCompacting(false));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 3L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 1", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 1L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 2", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 3", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            merger = new OrcRawRecordMerger(conf, false, null, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()), new OrcRawRecordMerger.Options().isCompacting(true));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 3L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 1", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 1L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 2", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 3", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            merger = new OrcRawRecordMerger(conf, true, null, false, 10, TestOrcRawRecordMerger.createMaximalTxnList(), new Reader.Options(), AcidUtils.getPaths((List)directory.getCurrentDirectories()), new OrcRawRecordMerger.Options().isCompacting(true).isMajorCompaction(true).baseDir(new Path(root, "base_0000100")));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 1L, 0L), (Object)id);
            Assert.assertEquals((Object)"second", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 3L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 4L, 0L), (Object)id);
            Assert.assertEquals((Object)"fifth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 5L, 0L), (Object)id);
            Assert.assertEquals((Object)"sixth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 6L, 0L), (Object)id);
            Assert.assertEquals((Object)"seventh", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 7L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)2L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 8L, 200L), (Object)id);
            Assert.assertNull((Object)OrcRecordUpdater.getRow((OrcStruct)event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, 9L, 0L), (Object)id);
            Assert.assertEquals((Object)"tenth", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 0L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 1", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 1L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 2", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)true, (Object)merger.next(id, event));
            Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
            Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(200L, BUCKET_PROPERTY, 2L, 200L), (Object)id);
            Assert.assertEquals((Object)"update 3", (Object)TestOrcRawRecordMerger.getValue(event));
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList("testNewBaseAndDelta:2000:200:200");
            baseReader = OrcFile.createReader((Path)basePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            merger = new OrcRawRecordMerger(conf, false, baseReader, false, 10, (ValidWriteIdList)writeIds, new Reader.Options(), new Path[]{deleteDeltaDir}, new OrcRawRecordMerger.Options().isCompacting(false));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            for (int i = 0; i < values.length; ++i) {
                Assert.assertEquals((Object)true, (Object)merger.next(id, event));
                LOG.info("id = " + id + "event = " + event);
                Assert.assertEquals((long)0L, (long)OrcRecordUpdater.getOperation((OrcStruct)event));
                Assert.assertEquals((Object)new OrcRawRecordMerger.ReaderKey(0L, BUCKET_PROPERTY, (long)i, 0L), (Object)id);
                Assert.assertEquals((Object)values[i], (Object)TestOrcRawRecordMerger.getValue(event));
            }
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            baseReader = OrcFile.createReader((Path)deltaPath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            merger = new OrcRawRecordMerger(conf, false, baseReader, false, 10, (ValidWriteIdList)writeIds, new Reader.Options(), new Path[]{deleteDeltaDir}, new OrcRawRecordMerger.Options().isCompacting(false));
            Assert.assertEquals(null, (Object)merger.getMinKey());
            Assert.assertEquals(null, (Object)merger.getMaxKey());
            Assert.assertEquals((Object)false, (Object)merger.next(id, event));
            merger.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderOldBaseAndDelta() throws Exception {
        int BUCKET = 10;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcConf.ROWS_BETWEEN_CHECKS.setLong(conf, 2L);
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testOldBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[clazz] (shouldn't be in output)
            Writer writer = OrcFile.createWriter((Path)new Path(root, "0000010_0"), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).inspector(inspector).fileSystem((FileSystem)fs).blockPadding(false).bufferSize(10000).compress(CompressionKind.NONE).stripeSize(1L).batchSize(2).version(OrcFile.Version.V_0_11));
            String[] values = new String[]{"ignore.1", "0.1", "ignore.2", "ignore.3", "2.0", "2.1", "3.0", "ignore.4", "ignore.5", "ignore.6"};
            for (int i2 = 0; i2 < values.length; ++i2) {
                writer.addRow((Object)new BigRow(i2, i2, values[i2], i2, i2));
            }
            writer.close();
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).bucket(10).inspector(inspector).filesystem((FileSystem)fs).recordIdColumn(5).finalDestination(root);
            int BUCKET_PROPERTY = BucketCodec.V1.encode(options);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            values = new String[]{"0.0", null, null, "1.1", null, null, null, "ignore.7"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(1L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, BUCKET_PROPERTY));
            }
            ru.delete(1L, (Object)new BigRow(9L, 0L, BUCKET_PROPERTY));
            ru.close(false);
            options = options.minimumWriteId(100L).maximumWriteId(100L);
            ru = of.getRecordUpdater(root, options);
            values = new String[]{null, null, "1.0", null, null, null, null, "3.1"};
            for (i = 0; i < values.length - 1; ++i) {
                if (values[i] == null) continue;
                ru.update(100L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, BUCKET_PROPERTY));
            }
            ru.delete(100L, (Object)new BigRow(8L, 0L, BUCKET_PROPERTY));
            ru.update(100L, (Object)new BigRow(7, 7L, values[values.length - 1], 7.0f, 7.0, 2L, 1L, BUCKET_PROPERTY));
            ru.close(false);
            MyResult[] expected = new MyResult[10];
            int k = 0;
            expected[k++] = new MyResult(0, "0.0");
            expected[k++] = new MyResult(1, "0.1");
            expected[k++] = new MyResult(2, "1.0");
            expected[k++] = new MyResult(3, "1.1");
            expected[k++] = new MyResult(4, "2.0");
            expected[k++] = new MyResult(5, "2.1");
            expected[k++] = new MyResult(6, "3.0");
            expected[k] = new MyResult(7, "3.1");
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("schema.evolution.columns", BigRow.getColumnNamesProperty());
            job.set("schema.evolution.columns.types", BigRow.getColumnTypesProperty());
            AcidUtils.setAcidOperationalProperties((Configuration)job, (boolean)true, null);
            job.setBoolean("transactional", true);
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)7L, (long)splits.length);
            for (InputSplit inputSplit : splits) {
                org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(inputSplit, job, Reporter.NULL);
                NullWritable key = (NullWritable)rr.createKey();
                OrcStruct value = (OrcStruct)rr.createValue();
                while (rr.next((Object)key, (Object)value)) {
                    int i3;
                    MyResult mr = new MyResult(Integer.parseInt(value.getFieldValue(0).toString()), value.getFieldValue(2).toString());
                    for (i3 = 0; i3 < expected.length; ++i3) {
                        if (!mr.equals(expected[i3])) continue;
                        expected[i3] = null;
                        break;
                    }
                    if (i3 < expected.length) continue;
                    Assert.assertTrue((String)("Found unexpected row: " + mr), (boolean)false);
                }
            }
            for (MyResult myResult : expected) {
                Assert.assertTrue((String)("Expected " + myResult + " not found in any InputSplit"), (myResult == null ? 1 : 0) != 0);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderNewBaseAndDelta() throws Exception {
        int BUCKET = 11;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcConf.ROWS_BETWEEN_CHECKS.setLong(conf, 2L);
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testRecordReaderNewBaseAndDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(BigRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[clazz] (shouldn't be in output)
            OrcRecordUpdater.OrcOptions options = (OrcRecordUpdater.OrcOptions)new OrcRecordUpdater.OrcOptions(conf).writingBase(true).minimumWriteId(0L).maximumWriteId(0L).bucket(11).inspector(inspector).filesystem((FileSystem)fs);
            int BUCKET_PROPERTY = BucketCodec.V1.encode((AcidOutputFormat.Options)options);
            options.orcOptions(OrcFile.writerOptions((Configuration)conf).stripeSize(1L).blockPadding(false).compress(CompressionKind.NONE).batchSize(2));
            options.finalDestination(root);
            RecordUpdater ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            String[] values = new String[]{"ignore.1", "0.1", "ignore.2", "ignore.3", "2.0", "2.1", "3.0", "ignore.4", "ignore.5", "ignore.6"};
            for (i = 0; i < values.length; ++i) {
                ru.insert(0L, (Object)new BigRow(i, i, values[i], i, i));
            }
            ru.close(false);
            options.writingBase(false).minimumWriteId(1L).maximumWriteId(1L).recordIdColumn(5);
            ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            values = new String[]{"0.0", null, null, "1.1", null, null, null, "ignore.7"};
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                ru.update(1L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, BUCKET_PROPERTY));
            }
            ru.delete(1L, (Object)new BigRow(9L, 0L, BUCKET_PROPERTY));
            ru.close(false);
            options.minimumWriteId(100L).maximumWriteId(100L);
            ru = of.getRecordUpdater(root, (AcidOutputFormat.Options)options);
            values = new String[]{null, null, "1.0", null, null, null, null, "3.1"};
            for (i = 0; i < values.length - 1; ++i) {
                if (values[i] == null) continue;
                ru.update(100L, (Object)new BigRow(i, i, values[i], i, i, i, 0L, BUCKET_PROPERTY));
            }
            ru.delete(100L, (Object)new BigRow(8L, 0L, BUCKET_PROPERTY));
            ru.update(100L, (Object)new BigRow(7, 7L, values[values.length - 1], 7.0f, 7.0, 2L, 1L, BUCKET_PROPERTY));
            ru.close(false);
            MyResult[] expected = new MyResult[10];
            int k = 0;
            expected[k++] = new MyResult(0, "0.0");
            expected[k++] = new MyResult(1, "0.1");
            expected[k++] = new MyResult(2, "1.0");
            expected[k++] = new MyResult(3, "1.1");
            expected[k++] = new MyResult(4, "2.0");
            expected[k++] = new MyResult(5, "2.1");
            expected[k++] = new MyResult(6, "3.0");
            expected[k] = new MyResult(7, "3.1");
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            job.set("schema.evolution.columns", BigRow.getColumnNamesProperty());
            job.set("schema.evolution.columns.types", BigRow.getColumnTypesProperty());
            AcidUtils.setAcidOperationalProperties((Configuration)job, (boolean)true, null);
            job.setBoolean("transactional", true);
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)8L, (long)splits.length);
            for (InputSplit inputSplit : splits) {
                org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(inputSplit, job, Reporter.NULL);
                NullWritable key = (NullWritable)rr.createKey();
                OrcStruct value = (OrcStruct)rr.createValue();
                while (rr.next((Object)key, (Object)value)) {
                    int i2;
                    MyResult mr = new MyResult(Integer.parseInt(value.getFieldValue(0).toString()), value.getFieldValue(2).toString());
                    for (i2 = 0; i2 < expected.length; ++i2) {
                        if (!mr.equals(expected[i2])) continue;
                        expected[i2] = null;
                        break;
                    }
                    if (i2 < expected.length) continue;
                    Assert.assertTrue((String)("Found unexpected row: " + mr), (boolean)false);
                }
            }
            for (MyResult myResult : expected) {
                Assert.assertTrue((String)("Expected " + myResult + " not found in any InputSplit"), (myResult == null ? 1 : 0) != 0);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecordReaderDelta() throws Exception {
        boolean BUCKET = false;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcOutputFormat of = new OrcOutputFormat();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path root = new Path(this.tmpDir, "testRecordReaderDelta").makeQualified((FileSystem)fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).bucket(0).inspector(inspector).filesystem((FileSystem)fs).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).finalDestination(root);
            RecordUpdater ru = of.getRecordUpdater(root, options);
            String[][] values = new String[][]{{"a", "b", "c", "d", "e"}, {"f", "g", "h", "i", "j"}};
            for (i = 0; i < values[0].length; ++i) {
                ru.insert(1L, (Object)new MyRow(values[0][i]));
            }
            ru.close(false);
            options.minimumWriteId(2L).maximumWriteId(2L);
            ru = of.getRecordUpdater(root, options);
            for (i = 0; i < values[1].length; ++i) {
                ru.insert(2L, (Object)new MyRow(values[1][i]));
            }
            ru.close(false);
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.min.split.size", "1");
            job.set("mapred.max.split.size", "2");
            job.set("mapred.input.dir", root.toString());
            job.set("bucket_count", "1");
            job.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
            job.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
            AcidUtils.setAcidOperationalProperties((Configuration)job, (boolean)true, null);
            job.setBoolean("transactional", true);
            InputSplit[] splits = inf.getSplits(job, 5);
            Assert.assertEquals((long)2L, (long)splits.length);
            for (int j = 0; j < splits.length; ++j) {
                InputSplit split = splits[j];
                org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(split, job, Reporter.NULL);
                OrcStruct row = (OrcStruct)rr.createValue();
                for (int i2 = 0; i2 < values[j].length; ++i2) {
                    System.out.println("Checking " + i2);
                    String msg = "split[" + j + "] at i=" + i2;
                    Assert.assertEquals((String)msg, (Object)true, (Object)rr.next((Object)NullWritable.get(), (Object)row));
                    Assert.assertEquals((String)msg, (Object)values[j][i2], (Object)row.getFieldValue(0).toString());
                }
                Assert.assertEquals((Object)false, (Object)rr.next((Object)NullWritable.get(), (Object)row));
            }
            return;
        }
    }

    @Test
    public void testRecordReaderIncompleteDelta() throws Exception {
        this.testRecordReaderIncompleteDelta(false);
        this.testRecordReaderIncompleteDelta(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRecordReaderIncompleteDelta(boolean use130Format) throws Exception {
        boolean BUCKET = true;
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        OrcOutputFormat of = new OrcOutputFormat();
        FileSystem fs = FileSystem.getLocal((Configuration)conf).getRaw();
        Path root = new Path(this.tmpDir, "testRecordReaderIncompleteDelta").makeQualified(fs);
        fs.delete(root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            int i;
            int i2;
            int i3;
            ObjectInspector inspector = ObjectInspectorFactory.getReflectionObjectInspector(MyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).writingBase(true).minimumWriteId(0L).maximumWriteId(0L).bucket(1).inspector(inspector).filesystem(fs).finalDestination(root);
            if (!use130Format) {
                options.statementId(-1);
            }
            RecordUpdater ru = of.getRecordUpdater(root, options);
            String[] values = new String[]{"1", "2", "3", "4", "5"};
            for (i3 = 0; i3 < values.length; ++i3) {
                ru.insert(0L, (Object)new MyRow(values[i3]));
            }
            ru.close(false);
            options.writingBase(false).minimumWriteId(10L).maximumWriteId(19L);
            ru = of.getRecordUpdater(root, options);
            values = new String[]{"6", "7", "8"};
            for (i3 = 0; i3 < values.length; ++i3) {
                ru.insert(1L, (Object)new MyRow(values[i3]));
            }
            OrcInputFormat inf = new OrcInputFormat();
            JobConf job = new JobConf();
            job.set("mapred.input.dir", root.toString());
            job.set("bucket_count", "2");
            job.set("schema.evolution.columns", MyRow.getColumnNamesProperty());
            job.set("schema.evolution.columns.types", MyRow.getColumnTypesProperty());
            AcidUtils.setAcidOperationalProperties((Configuration)job, (boolean)true, null);
            job.setBoolean("transactional", true);
            InputSplit[] splits = inf.getSplits(job, 1);
            Assert.assertEquals((long)1L, (long)splits.length);
            org.apache.hadoop.mapred.RecordReader rr = inf.getRecordReader(splits[0], job, Reporter.NULL);
            NullWritable key = (NullWritable)rr.createKey();
            OrcStruct value = (OrcStruct)rr.createValue();
            System.out.println("Looking at split " + splits[0]);
            for (i2 = 1; i2 < 6; ++i2) {
                System.out.println("Checking row " + i2);
                Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                Assert.assertEquals((Object)Integer.toString(i2), (Object)value.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            ru.flush();
            ru.flush();
            values = new String[]{"9", "10"};
            for (i2 = 0; i2 < values.length; ++i2) {
                ru.insert(3L, (Object)new MyRow(values[i2]));
            }
            ru.flush();
            splits = inf.getSplits(job, 1);
            Assert.assertEquals((long)2L, (long)splits.length);
            Path sideFile = new Path(root + "/" + (use130Format ? AcidUtils.deltaSubdir((long)10L, (long)19L, (int)0) : AcidUtils.deltaSubdir((long)10L, (long)19L)) + "/bucket_00001_flush_length");
            Assert.assertEquals((Object)true, (Object)fs.exists(sideFile));
            Assert.assertEquals((long)32L, (long)fs.getFileStatus(sideFile).getLen());
            rr = inf.getRecordReader(splits[0], job, Reporter.NULL);
            for (i = 1; i <= 5; ++i) {
                Assert.assertEquals((Object)true, (Object)rr.next((Object)key, (Object)value));
                Assert.assertEquals((Object)Integer.toString(i), (Object)value.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            rr = inf.getRecordReader(splits[1], job, Reporter.NULL);
            for (i = 6; i < 11; ++i) {
                Assert.assertEquals((String)("i=" + i), (Object)true, (Object)rr.next((Object)key, (Object)value));
                Assert.assertEquals((Object)Integer.toString(i), (Object)value.getFieldValue(0).toString());
            }
            Assert.assertEquals((Object)false, (Object)rr.next((Object)key, (Object)value));
            return;
        }
    }

    private static final class MyResult {
        private final int myInt;
        private final String myText;

        MyResult(int myInt, String myText) {
            this.myInt = myInt;
            this.myText = myText;
        }

        public boolean equals(Object t) {
            if (!(t instanceof MyResult)) {
                return false;
            }
            MyResult that = (MyResult)t;
            return this.myInt == that.myInt && this.myText.equals(that.myText);
        }

        public String toString() {
            return "(" + this.myInt + "," + this.myText + ")";
        }
    }

    static class BigRow {
        int myint;
        long mylong;
        Text mytext;
        float myfloat;
        double mydouble;
        RecordIdentifier ROW__ID;

        BigRow(int myint, long mylong, String mytext, float myfloat, double mydouble) {
            this.myint = myint;
            this.mylong = mylong;
            this.mytext = new Text(mytext);
            this.myfloat = myfloat;
            this.mydouble = mydouble;
            this.ROW__ID = null;
        }

        BigRow(int myint, long mylong, String mytext, float myfloat, double mydouble, long rowId, long origTxn, int bucket) {
            this.myint = myint;
            this.mylong = mylong;
            this.mytext = new Text(mytext);
            this.myfloat = myfloat;
            this.mydouble = mydouble;
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        BigRow(long rowId, long origTxn, int bucket) {
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "myint,mylong,mytext,myfloat,mydouble,ROW__ID";
        }

        static String getColumnTypesProperty() {
            return "int:bigint:string:float:double:struct<writeId:bigint,bucketId:int,rowId:bigint>";
        }
    }

    static class MyRow {
        Text col1;
        RecordIdentifier ROW__ID;

        MyRow(String val) {
            this.col1 = new Text(val);
        }

        MyRow(String val, long rowId, long origTxn, int bucket) {
            this.col1 = new Text(val);
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "col1,ROW__ID";
        }

        static String getColumnTypesProperty() {
            return "string:struct<writeId:bigint,bucketId:int,rowId:bigint>";
        }
    }
}

