/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class Decimal64Util {
    public static long getDecimal64AbsMaxFromDecimalTypeString(String typeString) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeString);
        if (!(typeInfo instanceof DecimalTypeInfo)) {
            throw new RuntimeException("Expected decimal type but found " + typeInfo.toString());
        }
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
        int precision = decimalTypeInfo.precision();
        if (!HiveDecimalWritable.isPrecisionDecimal64(precision)) {
            throw new RuntimeException("Expected decimal type " + typeInfo.toString() + " to have a decimal64 precision (i.e. <= 18)");
        }
        return HiveDecimalWritable.getDecimal64AbsMax(precision);
    }
}

