/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.BlobStorageUtils;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.AddToClassPathAction;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GlobalWorkMapFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDFClassLoader;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecReducer;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.OneNullRowInputFormat;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.io.SelfDescribingInputFormatInterface;
import org.apache.hadoop.hive.ql.io.merge.MergeFileMapper;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MergeJoinWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.Adjacency;
import org.apache.hadoop.hive.ql.plan.api.Graph;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.common.util.ACLConfigurationParser;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utilities {
    public static final Logger FILE_OP_LOGGER = LoggerFactory.getLogger((String)"FileOperations");
    public static final String HADOOP_LOCAL_FS = "file:///";
    public static final String HADOOP_LOCAL_FS_SCHEME = "file";
    public static final String MAP_PLAN_NAME = "map.xml";
    public static final String REDUCE_PLAN_NAME = "reduce.xml";
    public static final String MERGE_PLAN_NAME = "merge.xml";
    public static final String INPUT_NAME = "iocontext.input.name";
    public static final String HAS_MAP_WORK = "has.map.work";
    public static final String HAS_REDUCE_WORK = "has.reduce.work";
    public static final String MAPRED_MAPPER_CLASS = "mapred.mapper.class";
    public static final String MAPRED_REDUCER_CLASS = "mapred.reducer.class";
    public static final String HIVE_ADDED_JARS = "hive.added.jars";
    public static final String VECTOR_MODE = "VECTOR_MODE";
    public static final String USE_VECTORIZED_INPUT_FILE_FORMAT = "USE_VECTORIZED_INPUT_FILE_FORMAT";
    public static final String MAPNAME = "Map ";
    public static final String REDUCENAME = "Reducer ";
    public static final String ENSURE_OPERATORS_EXECUTED = "ENSURE_OPERATORS_EXECUTED";
    @Deprecated
    protected static final String DEPRECATED_MAPRED_DFSCLIENT_PARALLELISM_MAX = "mapred.dfsclient.parallelism.max";
    public static Random randGen = new Random();
    public static List<String> reduceFieldNameList = new ArrayList<String>();
    private static GlobalWorkMapFactory gWorkMap;
    private static final String CLASS_NAME;
    private static final Logger LOG;
    @VisibleForTesting
    public static TableDesc defaultTd;
    public static final int carriageReturnCode = 13;
    public static final int newLineCode = 10;
    public static final int tabCode = 9;
    public static final int ctrlaCode = 1;
    public static final String INDENT = "  ";
    public static final String nullStringStorage = "\\N";
    public static final String nullStringOutput = "NULL";
    public static final String NSTR = "";
    private static final String tmpPrefix = "_tmp.";
    private static final String taskTmpPrefix = "_task_tmp.";
    private static final Pattern FILE_NAME_TO_TASK_ID_REGEX;
    public static final String COPY_KEYWORD = "_copy_";
    private static final Pattern COPY_FILE_NAME_TO_TASK_ID_REGEX;
    private static final Pattern FILE_NAME_PREFIXED_TASK_ID_REGEX;
    private static final Pattern PREFIXED_TASK_ID_REGEX;
    private static final Pattern PREFIXED_BUCKET_ID_REGEX;
    private static final Object INPUT_SUMMARY_LOCK;
    public static final String suffix = ".hashtable";
    public static final char sqlEscapeChar = '\\';
    private static final Path[] EMPTY_PATH;
    private static final String MANIFEST_EXTENSION = ".manifest";

    public static String removeValueTag(String column) {
        if (column.startsWith(ReduceField.VALUE + ".")) {
            return column.substring(6);
        }
        return column;
    }

    private Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearWork(Configuration conf) {
        Path mapPath = Utilities.getPlanPath(conf, MAP_PLAN_NAME);
        Path reducePath = Utilities.getPlanPath(conf, REDUCE_PLAN_NAME);
        if (mapPath == null && reducePath == null) {
            return;
        }
        try {
            FileSystem fs = mapPath.getFileSystem(conf);
            if (fs.exists(mapPath)) {
                fs.delete(mapPath, true);
            }
            if (fs.exists(reducePath)) {
                fs.delete(reducePath, true);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to clean-up tmp directories.", (Throwable)e);
        }
        finally {
            Utilities.clearWorkMapForConf(conf);
        }
    }

    public static MapredWork getMapRedWork(Configuration conf) {
        MapredWork w = new MapredWork();
        w.setMapWork(Utilities.getMapWork(conf));
        w.setReduceWork(Utilities.getReduceWork(conf));
        return w;
    }

    public static void cacheMapWork(Configuration conf, MapWork work, Path hiveScratchDir) {
        Utilities.cacheBaseWork(conf, MAP_PLAN_NAME, work, hiveScratchDir);
    }

    public static void setMapWork(Configuration conf, MapWork work) {
        Utilities.setBaseWork(conf, MAP_PLAN_NAME, work);
    }

    public static MapWork getMapWork(Configuration conf) {
        if (!conf.getBoolean(HAS_MAP_WORK, false)) {
            return null;
        }
        return (MapWork)Utilities.getBaseWork(conf, MAP_PLAN_NAME);
    }

    public static void setReduceWork(Configuration conf, ReduceWork work) {
        Utilities.setBaseWork(conf, REDUCE_PLAN_NAME, work);
    }

    public static ReduceWork getReduceWork(Configuration conf) {
        if (!conf.getBoolean(HAS_REDUCE_WORK, false)) {
            return null;
        }
        return (ReduceWork)Utilities.getBaseWork(conf, REDUCE_PLAN_NAME);
    }

    public static Path setMergeWork(JobConf conf, MergeJoinWork mergeJoinWork, Path mrScratchDir, boolean useCache) {
        for (BaseWork baseWork : mergeJoinWork.getBaseWorkList()) {
            Utilities.setBaseWork((Configuration)conf, baseWork, mrScratchDir, baseWork.getName() + MERGE_PLAN_NAME, useCache);
            Object prefixes = conf.get("hive.tez.merge.file.prefixes");
            prefixes = prefixes == null ? baseWork.getName() : (String)prefixes + "," + baseWork.getName();
            conf.set("hive.tez.merge.file.prefixes", (String)prefixes);
        }
        return null;
    }

    public static BaseWork getMergeWork(Configuration jconf) {
        String currentMergePrefix = jconf.get("hive.tez.current.merge.file.prefix");
        if (StringUtils.isEmpty(currentMergePrefix)) {
            return null;
        }
        return Utilities.getMergeWork(jconf, jconf.get("hive.tez.current.merge.file.prefix"));
    }

    public static BaseWork getMergeWork(Configuration jconf, String prefix) {
        if (StringUtils.isEmpty(prefix)) {
            return null;
        }
        return Utilities.getBaseWork(jconf, prefix + MERGE_PLAN_NAME);
    }

    public static void cacheBaseWork(Configuration conf, String name, BaseWork work, Path hiveScratchDir) {
        try {
            Utilities.setPlanPath(conf, hiveScratchDir);
            Utilities.setBaseWork(conf, name, work);
        }
        catch (IOException e) {
            LOG.error("Failed to cache plan", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void setBaseWork(Configuration conf, String name, BaseWork work) {
        Path path = Utilities.getPlanPath(conf, name);
        Utilities.setHasWork(conf, name);
        gWorkMap.get(conf).put(path, work);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BaseWork getBaseWork(Configuration conf, String name) {
        BaseWork baseWork;
        Kryo kryo;
        Object in;
        block26: {
            BaseWork baseWork2;
            block25: {
                BaseWork gWork;
                Path path = null;
                in = null;
                kryo = SerializationUtilities.borrowKryo();
                try {
                    block30: {
                        block28: {
                            String planMode;
                            long serializedSize;
                            block27: {
                                block29: {
                                    String addedJars;
                                    String engine = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
                                    if (engine.equals("spark") && StringUtils.isNotEmpty(addedJars = conf.get(HIVE_ADDED_JARS))) {
                                        AddToClassPathAction addAction = new AddToClassPathAction(Thread.currentThread().getContextClassLoader(), Arrays.asList(addedJars.split(";")));
                                        ClassLoader newLoader = AccessController.doPrivileged(addAction);
                                        Thread.currentThread().setContextClassLoader(newLoader);
                                        kryo.setClassLoader(newLoader);
                                    }
                                    path = Utilities.getPlanPath(conf, name);
                                    LOG.info("PLAN PATH = {}", (Object)path);
                                    if (path == null) {
                                        addedJars = null;
                                        return addedJars;
                                    }
                                    gWork = gWorkMap.get(conf).get(path);
                                    if (gWork != null) break block28;
                                    Path localPath = path;
                                    LOG.debug("local path = {}", (Object)localPath);
                                    if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN)) {
                                        String planStringPath = path.toUri().getPath();
                                        LOG.debug("Loading plan from string: {}", (Object)planStringPath);
                                        String planString = conf.getRaw(planStringPath);
                                        if (planString == null) {
                                            LOG.info("Could not find plan string in conf");
                                            baseWork2 = null;
                                            SerializationUtilities.releaseKryo(kryo);
                                            break block25;
                                        }
                                        serializedSize = planString.length();
                                        planMode = "RPC";
                                        byte[] planBytes = Base64.decodeBase64((String)planString);
                                        in = new ByteArrayInputStream(planBytes);
                                        in = new InflaterInputStream((InputStream)in);
                                    } else {
                                        LOG.debug("Open file to read in plan: {}", (Object)localPath);
                                        FileSystem fs = localPath.getFileSystem(conf);
                                        if (!fs.exists(localPath)) {
                                            LOG.info("No plan file found: " + path);
                                            baseWork = null;
                                            SerializationUtilities.releaseKryo(kryo);
                                            break block26;
                                        }
                                        in = fs.open(localPath);
                                        serializedSize = fs.getFileStatus(localPath).getLen();
                                        planMode = "FILE";
                                    }
                                    if (!MAP_PLAN_NAME.equals(name)) break block29;
                                    if (ExecMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) {
                                        gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, MapWork.class);
                                        break block27;
                                    } else if (MergeFileMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) {
                                        gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, MergeFileWork.class);
                                        break block27;
                                    } else {
                                        if (!ColumnTruncateMapper.class.getName().equals(conf.get(MAPRED_MAPPER_CLASS))) throw new RuntimeException("unable to determine work from configuration .mapred.mapper.class was " + conf.get(MAPRED_MAPPER_CLASS));
                                        gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, ColumnTruncateWork.class);
                                    }
                                    break block27;
                                }
                                if (REDUCE_PLAN_NAME.equals(name)) {
                                    if (!ExecReducer.class.getName().equals(conf.get(MAPRED_REDUCER_CLASS))) throw new RuntimeException("unable to determine work from configuration .mapred.reducer.class was " + conf.get(MAPRED_REDUCER_CLASS));
                                    gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, ReduceWork.class);
                                } else if (name.contains(MERGE_PLAN_NAME)) {
                                    if (name.startsWith(MAPNAME)) {
                                        gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, MapWork.class);
                                    } else {
                                        if (!name.startsWith(REDUCENAME)) throw new RuntimeException("Unknown work type: " + name);
                                        gWork = SerializationUtilities.deserializePlan(kryo, (InputStream)in, ReduceWork.class);
                                    }
                                }
                            }
                            LOG.info("Deserialized plan (via {}) - name: {} size: {}", new Object[]{planMode, gWork.getName(), Utilities.humanReadableByteCount(serializedSize)});
                            gWorkMap.get(conf).put(path, gWork);
                            break block30;
                        }
                        LOG.debug("Found plan in cache for name: {}", (Object)name);
                    }
                    BaseWork baseWork3 = gWork;
                    return baseWork3;
                }
                catch (FileNotFoundException fnf) {
                    LOG.debug("No plan file found: {}", path, (Object)fnf);
                    gWork = null;
                    return gWork;
                }
                catch (Exception e) {
                    String msg = "Failed to load plan: " + path;
                    LOG.error(msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
            IOUtils.closeStream((Closeable)in);
            return baseWork2;
        }
        IOUtils.closeStream((Closeable)in);
        return baseWork;
        finally {
            SerializationUtilities.releaseKryo(kryo);
            IOUtils.closeStream(in);
        }
    }

    private static void setHasWork(Configuration conf, String name) {
        if (MAP_PLAN_NAME.equals(name)) {
            conf.setBoolean(HAS_MAP_WORK, true);
        } else if (REDUCE_PLAN_NAME.equals(name)) {
            conf.setBoolean(HAS_REDUCE_WORK, true);
        }
    }

    public static void setWorkflowAdjacencies(Configuration conf, QueryPlan plan) {
        try {
            Graph stageGraph = plan.getQueryPlan().getStageGraph();
            if (stageGraph == null) {
                return;
            }
            List<Adjacency> adjList = stageGraph.getAdjacencyList();
            if (adjList == null) {
                return;
            }
            for (Adjacency adj : adjList) {
                List<String> children = adj.getChildren();
                if (CollectionUtils.isEmpty(children)) {
                    return;
                }
                conf.setStrings("mapreduce.workflow.adjacency." + adj.getNode(), children.toArray(new String[0]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<String> getFieldSchemaString(List<FieldSchema> fl) {
        if (fl == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema f : fl) {
            ret.add(f.getName() + " " + f.getType() + (String)(f.getComment() != null ? " " + f.getComment() : NSTR));
        }
        return ret;
    }

    public static void setMapRedWork(Configuration conf, MapredWork w, Path hiveScratchDir) {
        Object useName = conf.get(INPUT_NAME);
        if (useName == null) {
            useName = "mapreduce:" + hiveScratchDir;
        }
        conf.set(INPUT_NAME, (String)useName);
        Utilities.setMapWork(conf, w.getMapWork(), hiveScratchDir, true);
        if (w.getReduceWork() != null) {
            conf.set(INPUT_NAME, (String)useName);
            Utilities.setReduceWork(conf, w.getReduceWork(), hiveScratchDir, true);
        }
    }

    public static Path setMapWork(Configuration conf, MapWork w, Path hiveScratchDir, boolean useCache) {
        return Utilities.setBaseWork(conf, w, hiveScratchDir, MAP_PLAN_NAME, useCache);
    }

    public static Path setReduceWork(Configuration conf, ReduceWork w, Path hiveScratchDir, boolean useCache) {
        return Utilities.setBaseWork(conf, w, hiveScratchDir, REDUCE_PLAN_NAME, useCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path setBaseWork(Configuration conf, BaseWork w, Path hiveScratchDir, String name, boolean useCache) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            String planMode;
            long serializedSize;
            Path planPath;
            block14: {
                Object out;
                block13: {
                    Utilities.setPlanPath(conf, hiveScratchDir);
                    planPath = Utilities.getPlanPath(conf, name);
                    Utilities.setHasWork(conf, name);
                    out = null;
                    if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN)) break block13;
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    try {
                        out = new DeflaterOutputStream((OutputStream)byteOut, new Deflater(1));
                        SerializationUtilities.serializePlan(kryo, w, (OutputStream)out);
                        ((OutputStream)out).close();
                        out = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(out);
                        throw throwable;
                    }
                    IOUtils.closeStream((Closeable)out);
                    String serializedPlan = Base64.encodeBase64String((byte[])byteOut.toByteArray());
                    serializedSize = serializedPlan.length();
                    planMode = "RPC";
                    conf.set(planPath.toUri().getPath(), serializedPlan);
                    break block14;
                }
                FileSystem fs = planPath.getFileSystem(conf);
                try {
                    long fileLen;
                    out = fs.create(planPath);
                    SerializationUtilities.serializePlan(kryo, w, (OutputStream)out);
                    ((OutputStream)out).close();
                    out = null;
                    serializedSize = fileLen = fs.getFileStatus(planPath).getLen();
                    planMode = "FILE";
                }
                finally {
                    IOUtils.closeStream((Closeable)out);
                }
                if (useCache && !ShimLoader.getHadoopShims().isLocalMode(conf)) {
                    if (!DistributedCache.getSymlink((Configuration)conf)) {
                        DistributedCache.createSymlink((Configuration)conf);
                    }
                    String uriWithLink = planPath.toUri().toString() + "#" + name;
                    DistributedCache.addCacheFile((URI)new URI(uriWithLink), (Configuration)conf);
                    short replication = (short)conf.getInt("mapred.submit.replication", 10);
                    fs.setReplication(planPath, replication);
                }
            }
            LOG.info("Serialized plan (via {}) - name: {} size: {}", new Object[]{planMode, w.getName(), Utilities.humanReadableByteCount(serializedSize)});
            gWorkMap.get(conf).put(planPath, w);
            Path path = planPath;
            return path;
        }
        catch (Exception e) {
            String msg = "Error caching " + name;
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
    }

    private static Path getPlanPath(Configuration conf, String name) {
        Path planPath = Utilities.getPlanPath(conf);
        if (planPath == null) {
            return null;
        }
        return new Path(planPath, name);
    }

    private static void setPlanPath(Configuration conf, Path hiveScratchDir) throws IOException {
        if (Utilities.getPlanPath(conf) == null) {
            String jobID = UUID.randomUUID().toString();
            Path planPath = new Path(hiveScratchDir, jobID);
            FileSystem fs = planPath.getFileSystem(conf);
            fs.mkdirs(planPath);
            HiveConf.setVar(conf, HiveConf.ConfVars.PLAN, planPath.toUri().toString());
        }
    }

    public static Path getPlanPath(Configuration conf) {
        String plan = HiveConf.getVar(conf, HiveConf.ConfVars.PLAN);
        if (plan != null && !plan.isEmpty()) {
            return new Path(plan);
        }
        return null;
    }

    public static String getTaskId(Configuration hconf) {
        String taskid;
        String string = taskid = hconf == null ? null : hconf.get("mapred.task.id");
        if (StringUtils.isEmpty(taskid)) {
            return Integer.toString(randGen.nextInt(Integer.MAX_VALUE));
        }
        String ret = taskid.replaceAll(".*_[mr]_", NSTR).replaceAll(".*_(map|reduce)_", NSTR);
        return ret;
    }

    public static HashMap makeMap(Object ... olist) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (int i = 0; i < olist.length; i += 2) {
            ret.put(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static Properties makeProperties(String ... olist) {
        Properties ret = new Properties();
        for (int i = 0; i < olist.length; i += 2) {
            ret.setProperty(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static ArrayList makeList(Object ... olist) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object element : olist) {
            ret.add(element);
        }
        return ret;
    }

    public static TableDesc getTableDesc(Table tbl) {
        Properties props = tbl.getMetadata();
        props.put("serialization.lib", tbl.getDeserializer().getClass().getName());
        return new TableDesc(tbl.getInputFormatClass(), tbl.getOutputFormatClass(), props);
    }

    public static TableDesc getTableDesc(String cols, String colTypes) {
        return new TableDesc(SequenceFileInputFormat.class, HiveSequenceFileOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "columns", cols, "columns.types", colTypes, "serialization.lib", LazySimpleSerDe.class.getName()));
    }

    public static PartitionDesc getPartitionDesc(Partition part, TableDesc tableDesc) throws HiveException {
        return new PartitionDesc(part, tableDesc);
    }

    public static PartitionDesc getPartitionDesc(Partition part) throws HiveException {
        return new PartitionDesc(part);
    }

    public static PartitionDesc getPartitionDescFromTableDesc(TableDesc tblDesc, Partition part, boolean usePartSchemaProperties) throws HiveException {
        return new PartitionDesc(part, tblDesc, usePartSchemaProperties);
    }

    private static String getOpTreeSkel_helper(Operator<?> op, String indent) {
        if (op == null) {
            return NSTR;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append(op.toString());
        sb.append("\n");
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                sb.append(Utilities.getOpTreeSkel_helper(child, indent + INDENT));
            }
        }
        return sb.toString();
    }

    public static String getOpTreeSkel(Operator<?> op) {
        return Utilities.getOpTreeSkel_helper(op, NSTR);
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) throws IOException {
        try {
            int c2;
            int c1;
            if (is1 == is2 || is1 == null && is2 == null) {
                return true;
            }
            if (is1 == null || is2 == null) {
                return false;
            }
            do {
                c1 = is1.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = is1.read();
                }
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                return true;
            } while (c1 == c2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String abbreviate(String str, int max) {
        str = str.trim();
        int len = str.length();
        int suffixlength = 20;
        if (len <= max) {
            return str;
        }
        suffixlength = Math.min(suffixlength, (max - 3) / 2);
        String rev = StringUtils.reverse(str);
        String suffix = WordUtils.abbreviate(rev, 0, suffixlength, NSTR);
        suffix = StringUtils.reverse(suffix);
        String prefix = StringUtils.abbreviate(str, max - suffix.length());
        return prefix + suffix;
    }

    public static StreamStatus readColumn(DataInput in, OutputStream out) throws IOException {
        while (true) {
            byte b;
            try {
                b = in.readByte();
            }
            catch (EOFException e) {
                return StreamStatus.EOF;
            }
            if (b == 10) {
                return StreamStatus.TERMINATED;
            }
            out.write(b);
        }
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createCompressedStream(jc, out, isCompressed);
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out, boolean isCompressed) throws IOException {
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
            return codec.createOutputStream(out);
        }
        return out;
    }

    @Deprecated
    public static String getFileExtension(JobConf jc, boolean isCompressed) {
        return Utilities.getFileExtension(jc, isCompressed, new HiveIgnoreKeyTextOutputFormat());
    }

    public static String getFileExtension(JobConf jc, boolean isCompressed, HiveOutputFormat<?, ?> hiveOutputFormat) {
        String extension = HiveConf.getVar((Configuration)jc, HiveConf.ConfVars.OUTPUT_FILE_EXTENSION);
        if (!StringUtils.isEmpty(extension)) {
            return extension;
        }
        if (hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat && isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
            return codec.getDefaultExtension();
        }
        return NSTR;
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, Progressable progressable) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createSequenceWriter(jc, fs, file, keyClass, valClass, isCompressed, progressable);
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, boolean isCompressed, Progressable progressable) throws IOException {
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        Class codecClass = null;
        if (isCompressed) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)jc);
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
        }
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)jc, (Path)file, keyClass, valClass, (SequenceFile.CompressionType)compressionType, codec, (Progressable)progressable);
    }

    public static RCFile.Writer createRCFileWriter(JobConf jc, FileSystem fs, Path file, boolean isCompressed, Progressable progressable) throws IOException {
        CompressionCodec codec = null;
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)jc);
        }
        return new RCFile.Writer(fs, (Configuration)jc, file, progressable, codec);
    }

    public static String realFile(String newFile, Configuration conf) throws IOException {
        Path path = new Path(newFile);
        URI pathURI = path.toUri();
        Object fs = pathURI.getScheme() == null ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
        if (!fs.exists(path)) {
            return null;
        }
        String file = path.makeQualified((FileSystem)fs).toString();
        return file;
    }

    public static List<String> mergeUniqElems(List<String> src, List<String> dest) {
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        for (int pos = 0; pos < dest.size(); ++pos) {
            if (src.contains(dest.get(pos))) continue;
            src.add(dest.get(pos));
        }
        return src;
    }

    public static Path toTaskTempPath(Path orig) {
        if (orig.getName().indexOf(taskTmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), taskTmpPrefix + orig.getName());
    }

    public static Path toTempPath(Path orig) {
        if (orig.getName().indexOf(tmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), tmpPrefix + orig.getName());
    }

    public static Path toTempPath(String orig) {
        return Utilities.toTempPath(new Path(orig));
    }

    public static boolean isTempPath(FileStatus file) {
        String name = file.getPath().getName();
        return name.startsWith("_task") || name.startsWith(tmpPrefix);
    }

    public static void rename(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.rename(src, dst)) {
            throw new HiveException("Unable to move: " + src + " to: " + dst);
        }
    }

    private static void moveSpecifiedFiles(FileSystem fs, Path src, Path dst, Set<Path> filesToMove) throws IOException, HiveException {
        FileStatus[] files;
        if (!fs.exists(dst)) {
            fs.mkdirs(dst);
        }
        for (FileStatus file : files = fs.listStatus(src)) {
            if (filesToMove.contains(file.getPath())) {
                Utilities.moveFile(fs, file, dst);
                continue;
            }
            if (!file.isDir()) continue;
            Path nestedDstPath = new Path(dst, file.getPath().getName());
            Utilities.moveSpecifiedFiles(fs, file.getPath(), nestedDstPath, filesToMove);
        }
    }

    private static void moveFile(FileSystem fs, FileStatus file, Path dst) throws IOException, HiveException {
        Path srcFilePath = file.getPath();
        String fileName = srcFilePath.getName();
        Path dstFilePath = new Path(dst, fileName);
        if (file.isDir()) {
            Utilities.renameOrMoveFiles(fs, srcFilePath, dstFilePath);
        } else {
            if (fs.exists(dstFilePath)) {
                int suffix = 0;
                while (fs.exists(dstFilePath = new Path(dst, fileName + "_" + ++suffix))) {
                }
            }
            if (!fs.rename(srcFilePath, dstFilePath)) {
                throw new HiveException("Unable to move: " + srcFilePath + " to: " + dst);
            }
        }
    }

    public static void renameOrMoveFiles(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.exists(dst)) {
            if (!fs.rename(src, dst)) {
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        } else {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(src)) {
                Utilities.moveFile(fs, file, dst);
            }
        }
    }

    public static String getTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_TO_TASK_ID_REGEX);
    }

    public static String getPrefixedTaskIdFromFilename(String filename) {
        return Utilities.getIdFromFilename(filename, FILE_NAME_PREFIXED_TASK_ID_REGEX);
    }

    private static String getIdFromFilename(String filename, Pattern pattern) {
        Matcher m;
        String taskId = filename;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = pattern.matcher(taskId)).matches()) {
            LOG.warn("Unable to get task id from file name: {}. Using last component {} as task id.", (Object)filename, (Object)taskId);
        } else {
            taskId = m.group(1);
        }
        LOG.debug("TaskId for {} = {}", (Object)filename, (Object)taskId);
        return taskId;
    }

    public static String getFileNameFromDirName(String dirName) {
        int dirEnd = dirName.lastIndexOf("/");
        if (dirEnd != -1) {
            return dirName.substring(dirEnd + 1);
        }
        return dirName;
    }

    public static String replaceTaskIdFromFilename(String filename, int bucketNum) {
        return Utilities.replaceTaskIdFromFilename(filename, String.valueOf(bucketNum));
    }

    public static String replaceTaskIdFromFilename(String filename, String fileId) {
        String taskId = Utilities.getTaskIdFromFilename(filename);
        String newTaskId = Utilities.replaceTaskId(taskId, fileId);
        String ret = Utilities.replaceTaskIdFromFilename(filename, taskId, newTaskId);
        return ret;
    }

    public static String replaceTaskId(String taskId, int bucketNum) {
        String bucketNumStr = String.valueOf(bucketNum);
        Matcher m = PREFIXED_TASK_ID_REGEX.matcher(taskId);
        if (!m.matches()) {
            LOG.warn("Unable to determine bucket number from task id: {}. Using task ID as bucket number.", (Object)taskId);
            return Utilities.adjustBucketNumLen(bucketNumStr, taskId);
        }
        String adjustedBucketNum = Utilities.adjustBucketNumLen(bucketNumStr, m.group(2));
        return (m.group(1) == null ? NSTR : m.group(1)) + adjustedBucketNum;
    }

    private static String replaceTaskId(String taskId, String strBucketNum) {
        Matcher m = PREFIXED_TASK_ID_REGEX.matcher(strBucketNum);
        if (!m.matches()) {
            LOG.warn("Unable to determine bucket number from file ID: {}. Using file ID as bucket number.", (Object)strBucketNum);
            return Utilities.adjustBucketNumLen(strBucketNum, taskId);
        }
        String adjustedBucketNum = Utilities.adjustBucketNumLen(m.group(2), taskId);
        return (m.group(1) == null ? NSTR : m.group(1)) + adjustedBucketNum;
    }

    private static String adjustBucketNumLen(String bucketNum, String taskId) {
        int bucketNumLen = bucketNum.length();
        int taskIdLen = taskId.length();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < taskIdLen - bucketNumLen; ++i) {
            s.append('0');
        }
        s.append(bucketNum);
        return s.toString();
    }

    private static String replaceTaskIdFromFilename(String filename, String oldTaskId, String newTaskId) {
        String[] spl = filename.split(oldTaskId);
        if (spl.length == 0 || spl.length == 1) {
            return filename.replaceAll(oldTaskId, newTaskId);
        }
        StringBuilder snew = new StringBuilder();
        for (int idx = 0; idx < spl.length - 1; ++idx) {
            if (idx > 0) {
                snew.append(oldTaskId);
            }
            snew.append(spl[idx]);
        }
        snew.append(newTaskId);
        snew.append(spl[spl.length - 1]);
        return snew.toString();
    }

    public static FileStatus[] listStatusIfExists(Path path, FileSystem fs) throws IOException {
        try {
            return fs.listStatus(path, FileUtils.HIDDEN_FILES_PATH_FILTER);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void mvFileToFinalPath(Path specPath, Configuration hconf, boolean success, Logger log, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Reporter reporter) throws IOException, HiveException {
        FileSystem fs = specPath.getFileSystem(hconf);
        boolean isBlobStorage = BlobStorageUtils.isBlobStorageFileSystem(hconf, fs);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path taskTmpPath = Utilities.toTaskTempPath(specPath);
        if (success) {
            FileStatus[] statuses;
            if (!isBlobStorage && fs.exists(tmpPath)) {
                Path tmpPathOriginal = tmpPath;
                tmpPath = new Path(tmpPath.getParent(), tmpPath.getName() + ".moved");
                Utilities.rename(fs, tmpPathOriginal, tmpPath);
            }
            if ((statuses = HiveStatsUtils.getFileStatusRecurse(tmpPath, dpCtx == null ? 1 : dpCtx.getNumDPCols(), fs).toArray(new FileStatus[0])) != null && statuses.length > 0) {
                PerfLogger perfLogger = SessionState.getPerfLogger();
                HashSet<Path> filesKept = new HashSet<Path>();
                perfLogger.PerfLogBegin("FileSinkOperator", "RemoveTempOrDuplicateFiles");
                List<Path> emptyBuckets = Utilities.removeTempOrDuplicateFiles(fs, statuses, dpCtx, conf, hconf, filesKept, false);
                perfLogger.PerfLogEnd("FileSinkOperator", "RemoveTempOrDuplicateFiles");
                if (!emptyBuckets.isEmpty()) {
                    perfLogger.PerfLogBegin("FileSinkOperator", "CreateEmptyBuckets");
                    Utilities.createEmptyBuckets(hconf, emptyBuckets, conf.getCompressed(), conf.getTableInfo(), reporter);
                    filesKept.addAll(emptyBuckets);
                    perfLogger.PerfLogEnd("FileSinkOperator", "CreateEmptyBuckets");
                }
                FILE_OP_LOGGER.trace("Moving tmp dir: {} to: {}", (Object)tmpPath, (Object)specPath);
                perfLogger.PerfLogBegin("FileSinkOperator", "RenameOrMoveFiles");
                if (isBlobStorage) {
                    Utilities.moveSpecifiedFiles(fs, tmpPath, specPath, filesKept);
                } else {
                    Utilities.renameOrMoveFiles(fs, tmpPath, specPath);
                }
                perfLogger.PerfLogEnd("FileSinkOperator", "RenameOrMoveFiles");
            }
        } else {
            FILE_OP_LOGGER.trace("deleting tmpPath {}", (Object)tmpPath);
            fs.delete(tmpPath, true);
        }
        FILE_OP_LOGGER.trace("deleting taskTmpPath {}", (Object)taskTmpPath);
        fs.delete(taskTmpPath, true);
    }

    static void createEmptyBuckets(Configuration hconf, List<Path> paths, boolean isCompressed, TableDesc tableInfo, Reporter reporter) throws HiveException, IOException {
        JobConf jc = hconf instanceof JobConf ? new JobConf(hconf) : new JobConf(hconf);
        HiveOutputFormat<?, ?> hiveOutputFormat = null;
        Class<? extends Writable> outputClass = null;
        try {
            Serializer serializer = (Serializer)((Object)tableInfo.getDeserializerClass().newInstance());
            serializer.initialize(null, tableInfo.getProperties());
            outputClass = serializer.getSerializedClass();
            hiveOutputFormat = HiveFileFormatUtils.getHiveOutputFormat(hconf, tableInfo);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (InstantiationException e) {
            throw new HiveException(e);
        }
        catch (IllegalAccessException e) {
            throw new HiveException(e);
        }
        for (Path path : paths) {
            FILE_OP_LOGGER.trace("creating empty bucket for {}", (Object)path);
            FileSinkOperator.RecordWriter writer = HiveFileFormatUtils.getRecordWriter(jc, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), path, reporter);
            writer.close(false);
            LOG.info("created empty bucket for enforcing bucketing at {}", (Object)path);
        }
    }

    private static void addFilesToPathSet(Collection<FileStatus> files, Set<Path> fileSet) {
        for (FileStatus file : files) {
            fileSet.add(file.getPath());
        }
    }

    public static void removeTempOrDuplicateFiles(FileSystem fs, Path path, boolean isBaseDir) throws IOException {
        Utilities.removeTempOrDuplicateFiles(fs, path, null, null, null, isBaseDir);
    }

    public static List<Path> removeTempOrDuplicateFiles(FileSystem fs, Path path, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Configuration hconf, boolean isBaseDir) throws IOException {
        if (path == null) {
            return null;
        }
        List<FileStatus> statusList = HiveStatsUtils.getFileStatusRecurse(path, dpCtx == null ? 1 : dpCtx.getNumDPCols(), fs);
        FileStatus[] stats = statusList.toArray(new FileStatus[statusList.size()]);
        return Utilities.removeTempOrDuplicateFiles(fs, stats, dpCtx, conf, hconf, isBaseDir);
    }

    public static List<Path> removeTempOrDuplicateFiles(FileSystem fs, FileStatus[] fileStats, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Configuration hconf, boolean isBaseDir) throws IOException {
        return Utilities.removeTempOrDuplicateFiles(fs, fileStats, dpCtx, conf, hconf, null, isBaseDir);
    }

    public static List<Path> removeTempOrDuplicateFiles(FileSystem fs, FileStatus[] fileStats, DynamicPartitionCtx dpCtx, FileSinkDesc conf, Configuration hconf, Set<Path> filesKept, boolean isBaseDir) throws IOException {
        int dpLevels = dpCtx == null ? 0 : dpCtx.getNumDPCols();
        int numBuckets = conf != null && conf.getTable() != null ? conf.getTable().getNumBuckets() : 0;
        return Utilities.removeTempOrDuplicateFiles(fs, fileStats, null, dpLevels, numBuckets, hconf, null, 0, false, filesKept, isBaseDir);
    }

    private static boolean removeEmptyDpDirectory(FileSystem fs, Path path) throws IOException {
        FileStatus[] items = fs.listStatus(path);
        if (items.length != 0) {
            return false;
        }
        if (!fs.delete(path, true)) {
            LOG.error("Cannot delete empty directory {}", (Object)path);
            throw new IOException("Cannot delete empty directory " + path);
        }
        return true;
    }

    public static List<Path> removeTempOrDuplicateFiles(FileSystem fs, FileStatus[] fileStats, String unionSuffix, int dpLevels, int numBuckets, Configuration hconf, Long writeId, int stmtId, boolean isMmTable, Set<Path> filesKept, boolean isBaseDir) throws IOException {
        if (fileStats == null) {
            return null;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        HashMap<String, FileStatus> taskIDToFile = null;
        if (dpLevels > 0) {
            FileStatus[] parts = fileStats;
            for (int i = 0; i < parts.length; ++i) {
                assert (parts[i].isDirectory()) : "dynamic partition " + parts[i].getPath() + " is not a directory";
                Path path = parts[i].getPath();
                if (Utilities.removeEmptyDpDirectory(fs, path)) {
                    parts[i] = null;
                    continue;
                }
                if (isMmTable) {
                    Path mmDir = parts[i].getPath();
                    if (!mmDir.getName().equals(AcidUtils.baseOrDeltaSubdir(isBaseDir, writeId, writeId, stmtId))) {
                        throw new IOException("Unexpected non-MM directory name " + mmDir);
                    }
                    FILE_OP_LOGGER.trace("removeTempOrDuplicateFiles processing files in MM directory {}", (Object)mmDir);
                    if (!StringUtils.isEmpty(unionSuffix) && !fs.exists(path = new Path(path, unionSuffix))) continue;
                }
                FileStatus[] items = fs.listStatus(path);
                taskIDToFile = Utilities.removeTempOrDuplicateFilesNonMm(items, fs);
                if (filesKept != null && taskIDToFile != null) {
                    Utilities.addFilesToPathSet(taskIDToFile.values(), filesKept);
                }
                Utilities.addBucketFileToResults(taskIDToFile, numBuckets, hconf, result);
            }
        } else if (isMmTable && !StringUtils.isEmpty(unionSuffix)) {
            FileStatus[] items = fileStats;
            if (fileStats.length == 0) {
                return result;
            }
            Path mmDir = Utilities.extractNonDpMmDir(writeId, stmtId, items, isBaseDir);
            taskIDToFile = Utilities.removeTempOrDuplicateFilesNonMm(fs.listStatus(new Path(mmDir, unionSuffix)), fs);
            if (filesKept != null && taskIDToFile != null) {
                Utilities.addFilesToPathSet(taskIDToFile.values(), filesKept);
            }
            Utilities.addBucketFileToResults2(taskIDToFile, numBuckets, hconf, result);
        } else {
            FileStatus[] items = fileStats;
            if (items.length == 0) {
                return result;
            }
            if (!isMmTable) {
                taskIDToFile = Utilities.removeTempOrDuplicateFilesNonMm(items, fs);
                if (filesKept != null && taskIDToFile != null) {
                    Utilities.addFilesToPathSet(taskIDToFile.values(), filesKept);
                }
            } else {
                Path mmDir = Utilities.extractNonDpMmDir(writeId, stmtId, items, isBaseDir);
                taskIDToFile = Utilities.removeTempOrDuplicateFilesNonMm(fs.listStatus(mmDir), fs);
                if (filesKept != null && taskIDToFile != null) {
                    Utilities.addFilesToPathSet(taskIDToFile.values(), filesKept);
                }
            }
            Utilities.addBucketFileToResults2(taskIDToFile, numBuckets, hconf, result);
        }
        return result;
    }

    private static Path extractNonDpMmDir(Long writeId, int stmtId, FileStatus[] items, boolean isBaseDir) throws IOException {
        if (items.length > 1) {
            throw new IOException("Unexpected directories for non-DP MM: " + Arrays.toString(items));
        }
        Path mmDir = items[0].getPath();
        if (!mmDir.getName().equals(AcidUtils.baseOrDeltaSubdir(isBaseDir, writeId, writeId, stmtId))) {
            throw new IOException("Unexpected non-MM directory " + mmDir);
        }
        FILE_OP_LOGGER.trace("removeTempOrDuplicateFiles processing files in MM directory {}", (Object)mmDir);
        return mmDir;
    }

    private static void addBucketFileToResults2(HashMap<String, FileStatus> taskIDToFile, int numBuckets, Configuration hconf, List<Path> result) {
        if (MapUtils.isNotEmpty(taskIDToFile) && numBuckets > taskIDToFile.size() && !"tez".equalsIgnoreCase(hconf.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname))) {
            Utilities.addBucketsToResultsCommon(taskIDToFile, numBuckets, result);
        }
    }

    private static void addBucketFileToResults(HashMap<String, FileStatus> taskIDToFile, int numBuckets, Configuration hconf, List<Path> result) {
        if (numBuckets > 0 && taskIDToFile != null && !"tez".equalsIgnoreCase(hconf.get(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname))) {
            Utilities.addBucketsToResultsCommon(taskIDToFile, numBuckets, result);
        }
    }

    private static void addBucketsToResultsCommon(HashMap<String, FileStatus> taskIDToFile, int numBuckets, List<Path> result) {
        String taskID1 = taskIDToFile.keySet().iterator().next();
        Path bucketPath = taskIDToFile.values().iterator().next().getPath();
        for (int j = 0; j < numBuckets; ++j) {
            Utilities.addBucketFileIfMissing(result, taskIDToFile, taskID1, bucketPath, j);
        }
    }

    private static void addBucketFileIfMissing(List<Path> result, HashMap<String, FileStatus> taskIDToFile, String taskID1, Path bucketPath, int j) {
        String taskID2 = Utilities.replaceTaskId(taskID1, j);
        if (!taskIDToFile.containsKey(taskID2)) {
            URI bucketUri = bucketPath.toUri();
            String path2 = Utilities.replaceTaskIdFromFilename(bucketUri.getPath().toString(), j);
            FILE_OP_LOGGER.trace("Creating an empty bucket file {}", (Object)path2);
            result.add(new Path(bucketUri.getScheme(), bucketUri.getAuthority(), path2));
        }
    }

    private static HashMap<String, FileStatus> removeTempOrDuplicateFilesNonMm(FileStatus[] files, FileSystem fs) throws IOException {
        if (files == null || fs == null) {
            return null;
        }
        HashMap<String, FileStatus> taskIdToFile = new HashMap<String, FileStatus>();
        for (FileStatus one : files) {
            if (Utilities.isTempPath(one)) {
                Path onePath = one.getPath();
                FILE_OP_LOGGER.trace("removeTempOrDuplicateFiles deleting {}", (Object)onePath);
                if (fs.delete(onePath, true)) continue;
                throw new IOException("Unable to delete tmp file: " + onePath);
            }
            Utilities.ponderRemovingTempOrDuplicateFile(fs, one, taskIdToFile);
        }
        return taskIdToFile;
    }

    private static void ponderRemovingTempOrDuplicateFile(FileSystem fs, FileStatus file, HashMap<String, FileStatus> taskIdToFile) throws IOException {
        Path filePath = file.getPath();
        String taskId = Utilities.getPrefixedTaskIdFromFilename(filePath.getName());
        FILE_OP_LOGGER.trace("removeTempOrDuplicateFiles looking at {}, taskId {}", (Object)filePath, (Object)taskId);
        FileStatus otherFile = taskIdToFile.get(taskId);
        taskIdToFile.put(taskId, otherFile == null ? file : Utilities.compareTempOrDuplicateFiles(fs, file, otherFile));
    }

    private static FileStatus compareTempOrDuplicateFiles(FileSystem fs, FileStatus file, FileStatus existingFile) throws IOException {
        FileStatus toDelete = null;
        FileStatus toRetain = null;
        Path filePath = file.getPath();
        if (Utilities.isCopyFile(filePath.getName())) {
            LOG.info("{} file identified as duplicate. This file is not deleted as it has copySuffix.", (Object)filePath);
            return existingFile;
        }
        if (existingFile.getLen() >= file.getLen()) {
            toDelete = file;
            toRetain = existingFile;
        } else {
            toDelete = existingFile;
            toRetain = file;
        }
        if (!fs.delete(toDelete.getPath(), true)) {
            throw new IOException("Unable to delete duplicate file: " + toDelete.getPath() + ". Existing file: " + toRetain.getPath());
        }
        LOG.warn("Duplicate taskid file removed: " + toDelete.getPath() + " with length " + toDelete.getLen() + ". Existing file: " + toRetain.getPath() + " with length " + toRetain.getLen());
        return toRetain;
    }

    public static boolean isCopyFile(String filename) {
        Matcher m;
        String taskId = filename;
        String copyFileSuffix = null;
        int dirEnd = filename.lastIndexOf("/");
        if (dirEnd != -1) {
            taskId = filename.substring(dirEnd + 1);
        }
        if (!(m = COPY_FILE_NAME_TO_TASK_ID_REGEX.matcher(taskId)).matches()) {
            LOG.warn("Unable to verify if file name {} has _copy_ suffix.", (Object)filename);
        } else {
            taskId = m.group(1);
            copyFileSuffix = m.group(4);
        }
        LOG.debug("Filename: {} TaskId: {} CopySuffix: {}", new Object[]{filename, taskId, copyFileSuffix});
        return taskId != null && copyFileSuffix != null;
    }

    public static String getBucketFileNameFromPathSubString(String bucketName) {
        try {
            return bucketName.split(COPY_KEYWORD)[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return bucketName;
        }
    }

    public static int parseSplitBucket(InputSplit split) {
        if (split instanceof FileSplit) {
            return Utilities.getBucketIdFromFile(((FileSplit)split).getPath().getName());
        }
        return -1;
    }

    public static int getBucketIdFromFile(String bucketName) {
        Matcher m = PREFIXED_BUCKET_ID_REGEX.matcher(bucketName);
        if (m.matches()) {
            if (m.group(2).isEmpty()) {
                return m.group(1).isEmpty() ? -1 : 0;
            }
            return Integer.parseInt(m.group(2));
        }
        if (bucketName.startsWith("bucket_") && (m = AcidUtils.BUCKET_DIGIT_PATTERN.matcher(bucketName)).find()) {
            return Integer.parseInt(m.group());
        }
        return -1;
    }

    public static String getNameMessage(Throwable e) {
        return e.getClass().getName() + "(" + e.getMessage() + ")";
    }

    public static String getResourceFiles(Configuration conf, SessionState.ResourceType t) {
        SessionState ss = SessionState.get();
        Set<String> files = ss == null ? null : ss.list_resource(t, null);
        return Utilities.validateFiles(conf, files);
    }

    public static String getHdfsResourceFiles(Configuration conf, SessionState.ResourceType type) {
        SessionState ss = SessionState.get();
        Set<String> files = ss == null ? null : ss.list_hdfs_resource(type);
        return Utilities.validateFiles(conf, files);
    }

    public static String getLocalResourceFiles(Configuration conf, SessionState.ResourceType type) {
        SessionState ss = SessionState.get();
        Set<String> files = ss == null ? null : ss.list_local_resource(type);
        return Utilities.validateFiles(conf, files);
    }

    private static String validateFiles(Configuration conf, Set<String> files) {
        if (files != null) {
            ArrayList<String> realFiles = new ArrayList<String>(files.size());
            for (String one : files) {
                try {
                    String onefile = Utilities.realFile(one, conf);
                    if (onefile != null) {
                        realFiles.add(Utilities.realFile(one, conf));
                        continue;
                    }
                    LOG.warn("The file {} does not exist.", (Object)one);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot validate file " + one + "due to exception: " + e.getMessage(), e);
                }
            }
            return StringUtils.join(realFiles, ",");
        }
        return NSTR;
    }

    public static ClassLoader getSessionSpecifiedClassLoader() {
        SessionState state = SessionState.get();
        if (state == null || state.getConf() == null) {
            LOG.debug("Hive Conf not found or Session not initiated, use thread based class loader instead");
            return JavaUtils.getClassLoader();
        }
        ClassLoader sessionCL = state.getConf().getClassLoader();
        if (sessionCL != null) {
            LOG.trace("Use session specified class loader");
            return sessionCL;
        }
        LOG.debug("Session specified class loader not found, use thread based class loader");
        return JavaUtils.getClassLoader();
    }

    public static void restoreSessionSpecifiedClassLoader(ClassLoader prev) {
        ClassLoader current;
        SessionState state = SessionState.get();
        if (state != null && state.getConf() != null && (current = state.getConf().getClassLoader()) != prev && JavaUtils.closeClassLoadersTo(current, prev)) {
            Thread.currentThread().setContextClassLoader(prev);
            state.getConf().setClassLoader(prev);
        }
    }

    static URL urlFromPathString(String onestr) {
        URL oneurl = null;
        try {
            oneurl = StringUtils.indexOf(onestr, "file:/") == 0 ? new URL(onestr) : new File(onestr).toURL();
        }
        catch (Exception err) {
            LOG.error("Bad URL {}, ignoring path", (Object)onestr);
        }
        return oneurl;
    }

    public static void removeFromClassPath(String[] pathsToRemove) throws IOException {
        Thread curThread = Thread.currentThread();
        ClassLoader currentLoader = curThread.getContextClassLoader();
        if (!(currentLoader instanceof UDFClassLoader)) {
            LOG.warn("Ignoring attempt to manipulate {}; probably means we have closed more UDF loaders than opened.", (Object)(currentLoader == null ? "null" : currentLoader.getClass().getSimpleName()));
            return;
        }
        UDFClassLoader loader = (UDFClassLoader)currentLoader;
        HashSet<URL> newPath = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        for (String onestr : pathsToRemove) {
            URL oneurl = Utilities.urlFromPathString(onestr);
            if (oneurl == null) continue;
            newPath.remove(oneurl);
        }
        JavaUtils.closeClassLoader(loader);
        Registry reg = SessionState.getRegistry();
        if (reg != null) {
            reg.removeFromUDFLoaders(loader);
        }
        loader = new UDFClassLoader(newPath.toArray(new URL[0]));
        curThread.setContextClassLoader(loader);
        SessionState.get().getConf().setClassLoader(loader);
    }

    public static String formatBinaryString(byte[] array, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append('x');
            sb.append(array[i] < 0 ? array[i] + 256 : array[i] + 0);
        }
        return sb.toString();
    }

    public static List<String> getColumnNamesFromSortCols(List<Order> sortCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (Order o : sortCols) {
            names.add(o.getCol());
        }
        return names;
    }

    public static List<String> getColumnNamesFromFieldSchema(List<FieldSchema> partCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldSchema o : partCols) {
            names.add(o.getName());
        }
        return names;
    }

    public static List<String> getInternalColumnNamesFromSignature(List<ColumnInfo> colInfos) {
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnInfo ci : colInfos) {
            names.add(ci.getInternalName());
        }
        return names;
    }

    public static List<String> getColumnNames(Properties props) {
        String[] cols;
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns");
        for (String col : cols = colNames.trim().split(",")) {
            if (!StringUtils.isNotBlank(col)) continue;
            names.add(col);
        }
        return names;
    }

    public static List<String> getColumnTypes(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        String colNames = props.getProperty("columns.types");
        ArrayList<TypeInfo> cols = TypeInfoUtils.getTypeInfosFromTypeString(colNames);
        for (TypeInfo col : cols) {
            names.add(col.getTypeName());
        }
        return names;
    }

    public static String[] getDbTableName(String dbtable) throws SemanticException {
        return Utilities.getDbTableName(SessionState.get().getCurrentDatabase(), dbtable);
    }

    public static String[] getDbTableName(String defaultDb, String dbtable) throws SemanticException {
        if (dbtable == null) {
            return new String[2];
        }
        String[] names = dbtable.split("\\.");
        switch (names.length) {
            case 2: {
                return names;
            }
            case 1: {
                return new String[]{defaultDb, dbtable};
            }
        }
        throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbtable);
    }

    public static String getDatabaseName(String dbTableName) throws SemanticException {
        String[] split = dbTableName.split("\\.");
        if (split.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbTableName);
        }
        return split[0];
    }

    public static String getTableName(String dbTableName) throws SemanticException {
        String[] split = dbTableName.split("\\.");
        if (split.length != 2) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE_NAME, dbTableName);
        }
        return split[1];
    }

    public static void validateColumnNames(List<String> colNames, List<String> checkCols) throws SemanticException {
        for (String toCheck : checkCols) {
            boolean found = false;
            for (String colName : colNames) {
                if (!toCheck.equalsIgnoreCase(colName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
        }
    }

    public static int getDefaultNotificationInterval(Configuration hconf) {
        Integer expInterval = Integer.decode(hconf.get("mapred.tasktracker.expiry.interval"));
        int notificationInterval = expInterval != null ? expInterval / 2 : 300000;
        return notificationInterval;
    }

    public static void copyTableJobPropertiesToConf(TableDesc tbl, JobConf job) throws HiveException {
        Properties tblProperties = tbl.getProperties();
        for (String string : tblProperties.stringPropertyNames()) {
            String string2;
            if (job.get(string) != null || (string2 = (String)tblProperties.get(string)) == null) continue;
            job.set(string, StringEscapeUtils.escapeJava(string2));
        }
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties != null) {
            for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
                job.set(entry.getKey(), entry.getValue());
            }
        }
        try {
            Map<String, String> map = tbl.getJobSecrets();
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    job.getCredentials().addSecretKey(new Text(entry.getKey()), entry.getValue().getBytes());
                    UserGroupInformation.getCurrentUser().getCredentials().addSecretKey(new Text(entry.getKey()), entry.getValue().getBytes());
                }
            }
        }
        catch (IOException iOException) {
            throw new HiveException(iOException);
        }
    }

    public static void copyTablePropertiesToConf(TableDesc tbl, JobConf job) throws HiveException {
        Properties tblProperties = tbl.getProperties();
        for (String string : tblProperties.stringPropertyNames()) {
            String string2 = (String)tblProperties.get(string);
            if (string2 == null) continue;
            job.set(string, StringEscapeUtils.escapeJava(string2));
        }
        Map<String, String> jobProperties = tbl.getJobProperties();
        if (jobProperties != null) {
            for (Map.Entry<String, String> entry : jobProperties.entrySet()) {
                job.set(entry.getKey(), entry.getValue());
            }
        }
        try {
            Map<String, String> map = tbl.getJobSecrets();
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    job.getCredentials().addSecretKey(new Text(entry.getKey()), entry.getValue().getBytes());
                    UserGroupInformation.getCurrentUser().getCredentials().addSecretKey(new Text(entry.getKey()), entry.getValue().getBytes());
                }
            }
        }
        catch (IOException iOException) {
            throw new HiveException(iOException);
        }
    }

    @VisibleForTesting
    static int getMaxExecutorsForInputListing(Configuration conf, int inputLocationListSize) {
        if (inputLocationListSize < 1) {
            return 0;
        }
        int maxExecutors = 1;
        if (inputLocationListSize > 1) {
            int listingMaxThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS);
            if (listingMaxThreads <= 0 && (listingMaxThreads = conf.getInt(DEPRECATED_MAPRED_DFSCLIENT_PARALLELISM_MAX, 0)) > 0) {
                LOG.warn("Deprecated configuration is used: {}. Please use {}", (Object)DEPRECATED_MAPRED_DFSCLIENT_PARALLELISM_MAX, (Object)HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname);
            }
            if (listingMaxThreads > 1) {
                maxExecutors = Math.min(inputLocationListSize, listingMaxThreads);
            }
        }
        return maxExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentSummary getInputSummary(Context ctx, MapWork work, PathFilter filter) throws IOException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getInputSummary");
        long[] summary = new long[]{0L, 0L, 0L};
        HashSet<Path> pathNeedProcess = new HashSet<Path>();
        Object object = INPUT_SUMMARY_LOCK;
        synchronized (object) {
            ExecutorService executor;
            ContentSummary cs;
            Iterator<Path> iterator = work.getPathToAliases().keySet().iterator();
            while (iterator.hasNext()) {
                Path path;
                Path p = path = iterator.next();
                if (filter != null && !filter.accept(p)) continue;
                cs = ctx.getCS(path);
                if (cs == null) {
                    if (path == null) continue;
                    pathNeedProcess.add(path);
                    continue;
                }
                summary[0] = summary[0] + cs.getLength();
                summary[1] = summary[1] + cs.getFileCount();
                summary[2] = summary[2] + cs.getDirectoryCount();
            }
            ConcurrentHashMap resultMap = new ConcurrentHashMap();
            int numExecutors = Utilities.getMaxExecutorsForInputListing(ctx.getConf(), pathNeedProcess.size());
            if (numExecutors > 1) {
                LOG.info("Using {} threads for getContentSummary", (Object)numExecutors);
                executor = Executors.newFixedThreadPool(numExecutors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Input-Summary-%d").build());
            } else {
                executor = null;
            }
            cs = Utilities.getInputSummaryWithPool(ctx, pathNeedProcess, work, summary, executor);
            perfLogger.PerfLogEnd(CLASS_NAME, "getInputSummary");
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static ContentSummary getInputSummaryWithPool(final Context ctx, final Set<Path> pathNeedProcess, MapWork work, long[] summary, final ExecutorService executor) throws IOException {
        ArrayList results = new ArrayList();
        final ConcurrentHashMap resultMap = new ConcurrentHashMap();
        HiveInterruptCallback interrup = HiveInterruptUtils.add(new HiveInterruptCallback(){

            @Override
            public void interrupt() {
                for (Path path : pathNeedProcess) {
                    try {
                        path.getFileSystem(ctx.getConf()).close();
                    }
                    catch (IOException ignore) {
                        LOG.debug("Failed to close filesystem", (Throwable)ignore);
                    }
                }
                if (executor != null) {
                    executor.shutdownNow();
                }
            }
        });
        try {
            Configuration conf = ctx.getConf();
            JobConf jobConf = new JobConf(conf);
            Iterator<Object> iterator = pathNeedProcess.iterator();
            while (iterator.hasNext()) {
                Path path;
                final Path p = path = iterator.next();
                final String pathStr = path.toString();
                final Configuration myConf = conf;
                final JobConf myJobConf = jobConf;
                final LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = work.getAliasToWork();
                final LinkedHashMap<Path, ArrayList<String>> pathToAlias = work.getPathToAliases();
                final PartitionDesc partDesc = work.getPathToPartitionInfo().get(p);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HiveStorageHandler handler;
                            Class<? extends InputFormat> inputFormatCls = partDesc.getInputFileFormatClass();
                            InputFormat<WritableComparable, Writable> inputFormatObj = HiveInputFormat.getInputFormatFromCache(inputFormatCls, myJobConf);
                            if (inputFormatObj instanceof ContentSummaryInputFormat) {
                                ContentSummaryInputFormat cs = (ContentSummaryInputFormat)inputFormatObj;
                                resultMap.put(pathStr, cs.getContentSummary(p, myJobConf));
                                return;
                            }
                            String metaTableStorage = null;
                            if (partDesc.getTableDesc() != null && partDesc.getTableDesc().getProperties() != null) {
                                metaTableStorage = partDesc.getTableDesc().getProperties().getProperty("storage_handler", null);
                            }
                            if (partDesc.getProperties() != null) {
                                metaTableStorage = partDesc.getProperties().getProperty("storage_handler", metaTableStorage);
                            }
                            if ((handler = HiveUtils.getStorageHandler(myConf, metaTableStorage)) instanceof InputEstimator) {
                                long total = 0L;
                                TableDesc tableDesc = partDesc.getTableDesc();
                                InputEstimator estimator = (InputEstimator)((Object)handler);
                                for (String alias : HiveFileFormatUtils.doGetAliasesFromPath(pathToAlias, p)) {
                                    JobConf jobConf = new JobConf((Configuration)myJobConf);
                                    TableScanOperator scanOp = (TableScanOperator)aliasToWork.get(alias);
                                    Utilities.setColumnNameList(jobConf, scanOp, true);
                                    Utilities.setColumnTypeList(jobConf, scanOp, true);
                                    PlanUtils.configureInputJobPropertiesForStorageHandler(tableDesc);
                                    Utilities.copyTableJobPropertiesToConf(tableDesc, jobConf);
                                    total += estimator.estimate(jobConf, scanOp, -1L).getTotalLength();
                                }
                                resultMap.put(pathStr, new ContentSummary(total, -1L, -1L));
                            } else {
                                FileSystem fs = p.getFileSystem(myConf);
                                resultMap.put(pathStr, fs.getContentSummary(p));
                            }
                        }
                        catch (Exception e) {
                            LOG.info("Cannot get size of {}. Safely ignored.", (Object)pathStr);
                        }
                    }
                };
                if (executor == null) {
                    r.run();
                    continue;
                }
                Future<?> result = executor.submit(r);
                results.add(result);
            }
            if (executor != null) {
                block7: for (Future future : results) {
                    boolean executorDone = false;
                    do {
                        try {
                            future.get();
                            executorDone = true;
                        }
                        catch (InterruptedException e) {
                            LOG.info("Interrupted when waiting threads: ", (Throwable)e);
                            Thread.currentThread().interrupt();
                            continue block7;
                        }
                        catch (ExecutionException e) {
                            throw new IOException(e);
                        }
                    } while (!executorDone);
                }
                executor.shutdown();
            }
            HiveInterruptUtils.checkInterrupted();
            for (Map.Entry entry : resultMap.entrySet()) {
                ContentSummary cs = (ContentSummary)entry.getValue();
                summary[0] = summary[0] + cs.getLength();
                summary[1] = summary[1] + cs.getFileCount();
                summary[2] = summary[2] + cs.getDirectoryCount();
                ctx.addCS((String)entry.getKey(), cs);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Cache Content Summary for {} length: {} file count: {}  directory count: {}", new Object[]{entry.getKey(), cs.getLength(), cs.getFileCount(), cs.getDirectoryCount()});
            }
            iterator = new ContentSummary(summary[0], summary[1], summary[2]);
            return iterator;
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            HiveInterruptUtils.remove(interrup);
        }
    }

    public static long sumOf(Map<String, Long> aliasToSize, Set<String> aliases) {
        return Utilities.sumOfExcept(aliasToSize, aliases, null);
    }

    public static long sumOfExcept(Map<String, Long> aliasToSize, Set<String> aliases, Set<String> excepts) {
        long total = 0L;
        for (String alias : aliases) {
            if (excepts != null && excepts.contains(alias)) continue;
            Long size = aliasToSize.get(alias);
            if (size == null) {
                return -1L;
            }
            total += size.longValue();
        }
        return total;
    }

    public static boolean isEmptyPath(JobConf job, Path dirPath, Context ctx) throws Exception {
        if (ctx != null) {
            ContentSummary cs = ctx.getCS(dirPath);
            if (cs != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content Summary cached for {} length: {} num files: {} num directories: {}", new Object[]{dirPath, cs.getLength(), cs.getFileCount(), cs.getDirectoryCount()});
                }
                return cs.getLength() == 0L && cs.getFileCount() == 0L && cs.getDirectoryCount() <= 1L;
            }
            LOG.debug("Content Summary not cached for {}", (Object)dirPath);
        }
        return Utilities.isEmptyPath((Configuration)job, dirPath);
    }

    public static boolean isEmptyPath(Configuration job, Path dirPath) throws IOException {
        FileSystem inpFs = dirPath.getFileSystem(job);
        try {
            FileStatus[] fStats = inpFs.listStatus(dirPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
            if (fStats.length > 0) {
                return false;
            }
        }
        catch (FileNotFoundException fnf) {
            return true;
        }
        return true;
    }

    public static List<TezTask> getTezTasks(List<Task<? extends Serializable>> tasks) {
        return Utilities.getTasks(tasks, new TaskFilterFunction<TezTask>(TezTask.class));
    }

    public static List<SparkTask> getSparkTasks(List<Task<? extends Serializable>> tasks) {
        return Utilities.getTasks(tasks, new TaskFilterFunction<SparkTask>(SparkTask.class));
    }

    public static List<ExecDriver> getMRTasks(List<Task<? extends Serializable>> tasks) {
        return Utilities.getTasks(tasks, new TaskFilterFunction<ExecDriver>(ExecDriver.class));
    }

    public static int getNumClusterJobs(List<Task<? extends Serializable>> tasks) {
        return Utilities.getMRTasks(tasks).size() + Utilities.getTezTasks(tasks).size() + Utilities.getSparkTasks(tasks).size();
    }

    private static <T> List<T> getTasks(List<Task<? extends Serializable>> tasks, TaskFilterFunction<T> function) {
        DAGTraversal.traverse(tasks, function);
        return function.getTasks();
    }

    public static List<LinkedHashMap<String, String>> getFullDPSpecs(Configuration conf, DynamicPartitionCtx dpCtx) throws HiveException {
        try {
            Path loadPath = dpCtx.getRootPath();
            FileSystem fs = loadPath.getFileSystem(conf);
            int numDPCols = dpCtx.getNumDPCols();
            List<FileStatus> status = HiveStatsUtils.getFileStatusRecurse(loadPath, numDPCols, fs);
            if (status.isEmpty()) {
                LOG.warn("No partition is generated by dynamic partitioning");
                return null;
            }
            Map<String, String> partSpec = dpCtx.getPartSpec();
            ArrayList<LinkedHashMap<String, String>> fullPartSpecs = new ArrayList<LinkedHashMap<String, String>>();
            for (int i = 0; i < status.size(); ++i) {
                Path partPath = status.get(i).getPath();
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                if (!Warehouse.makeSpecFromName(fullPartSpec, partPath, new HashSet<String>(partSpec.keySet()))) {
                    FILE_OP_LOGGER.warn("Ignoring invalid DP directory {}", (Object)partPath);
                    continue;
                }
                FILE_OP_LOGGER.trace("Adding partition spec from {}: {}", (Object)partPath, fullPartSpec);
                fullPartSpecs.add(fullPartSpec);
            }
            return fullPartSpecs;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static StatsPublisher getStatsPublisher(JobConf jc) {
        StatsFactory factory = StatsFactory.newFactory((Configuration)jc);
        return factory == null ? null : factory.getStatsPublisher();
    }

    public static String join(String ... elements) {
        StringBuilder builder = new StringBuilder();
        for (String element : elements) {
            if (element == null || element.isEmpty()) continue;
            builder.append(element);
            if (element.endsWith("/")) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    public static void setColumnNameList(JobConf jobConf, RowSchema rowSchema) {
        Utilities.setColumnNameList(jobConf, rowSchema, false);
    }

    public static void setColumnNameList(JobConf jobConf, RowSchema rowSchema, boolean excludeVCs) {
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnNames = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (excludeVCs && colInfo.getIsVirtualCol()) continue;
            if (columnNames.length() > 0) {
                columnNames.append(',');
            }
            columnNames.append(colInfo.getInternalName());
        }
        String columnNamesString = columnNames.toString();
        jobConf.set("columns", columnNamesString);
    }

    public static void setColumnNameList(JobConf jobConf, Operator op) {
        Utilities.setColumnNameList(jobConf, op, false);
    }

    public static void setColumnNameList(JobConf jobConf, Operator op, boolean excludeVCs) {
        RowSchema rowSchema = op.getSchema();
        Utilities.setColumnNameList(jobConf, rowSchema, excludeVCs);
    }

    public static void setColumnTypeList(JobConf jobConf, RowSchema rowSchema) {
        Utilities.setColumnTypeList(jobConf, rowSchema, false);
    }

    public static void setColumnTypeList(JobConf jobConf, RowSchema rowSchema, boolean excludeVCs) {
        if (rowSchema == null) {
            return;
        }
        StringBuilder columnTypes = new StringBuilder();
        for (ColumnInfo colInfo : rowSchema.getSignature()) {
            if (excludeVCs && colInfo.getIsVirtualCol()) continue;
            if (columnTypes.length() > 0) {
                columnTypes.append(',');
            }
            columnTypes.append(colInfo.getTypeName());
        }
        String columnTypesString = columnTypes.toString();
        jobConf.set("columns.types", columnTypesString);
    }

    public static void setColumnTypeList(JobConf jobConf, Operator op) {
        Utilities.setColumnTypeList(jobConf, op, false);
    }

    public static void setColumnTypeList(JobConf jobConf, Operator op, boolean excludeVCs) {
        RowSchema rowSchema = op.getSchema();
        Utilities.setColumnTypeList(jobConf, rowSchema, excludeVCs);
    }

    public static Path generatePath(Path basePath, String dumpFilePrefix, Byte tag, String bigBucketFileName) {
        return new Path(basePath, "MapJoin-" + dumpFilePrefix + tag + "-" + bigBucketFileName + suffix);
    }

    public static String generateFileName(Byte tag, String bigBucketFileName) {
        String fileName = new String("MapJoin-" + tag + "-" + bigBucketFileName + suffix);
        return fileName;
    }

    public static Path generateTmpPath(Path basePath, String id) {
        return new Path(basePath, "HashTable-" + id);
    }

    public static Path generateTarPath(Path basePath, String filename) {
        return new Path(basePath, filename + ".tar.gz");
    }

    public static String generateTarFileName(String name) {
        return name + ".tar.gz";
    }

    public static String generatePath(Path baseURI, String filename) {
        String path = new String(baseURI + "/" + filename);
        return path;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public static double showTime(long time) {
        double result = (double)time / 1000.0;
        return result;
    }

    public static void reworkMapRedWork(Task<? extends Serializable> task, boolean reworkMapredWork, HiveConf conf) throws SemanticException {
        if (reworkMapredWork && task instanceof MapRedTask) {
            try {
                MapredWork mapredWork = (MapredWork)((MapRedTask)task).getWork();
                HashSet<Class<? extends InputFormat>> reworkInputFormats = new HashSet<Class<? extends InputFormat>>();
                for (PartitionDesc partitionDesc : mapredWork.getMapWork().getPathToPartitionInfo().values()) {
                    Class<? extends InputFormat> inputFormatCls = partitionDesc.getInputFileFormatClass();
                    if (!ReworkMapredInputFormat.class.isAssignableFrom(inputFormatCls)) continue;
                    reworkInputFormats.add(inputFormatCls);
                }
                if (reworkInputFormats.size() > 0) {
                    for (Class clazz : reworkInputFormats) {
                        ReworkMapredInputFormat inst = (ReworkMapredInputFormat)ReflectionUtil.newInstance(clazz, null);
                        inst.rework(conf, mapredWork);
                    }
                }
            }
            catch (IOException e) {
                throw new SemanticException(e);
            }
        }
    }

    public static <T> T executeWithRetry(SQLCommand<T> cmd, PreparedStatement stmt, long baseWindow, int maxRetries) throws SQLException {
        T result = null;
        int failures = 0;
        while (true) {
            try {
                result = cmd.run(stmt);
                return result;
            }
            catch (SQLTransientException e) {
                LOG.warn("Failure and retry # {}", (Object)failures, (Object)e);
                if (failures >= maxRetries) {
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(baseWindow, failures, randGen);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static Connection connectWithRetry(String connectionString, long waitWindow, int maxRetries) throws SQLException {
        int failures = 0;
        while (true) {
            try {
                Connection conn = DriverManager.getConnection(connectionString);
                return conn;
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error("Error during JDBC connection.", (Throwable)e);
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, randGen);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static PreparedStatement prepareWithRetry(Connection conn, String stmt, long waitWindow, int maxRetries) throws SQLException {
        int failures = 0;
        while (true) {
            try {
                return conn.prepareStatement(stmt);
            }
            catch (SQLTransientException e) {
                if (failures >= maxRetries) {
                    LOG.error("Error preparing JDBC Statement {}", (Object)stmt, (Object)e);
                    throw e;
                }
                long waitTime = Utilities.getRandomWaitTime(waitWindow, failures, randGen);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (SQLException e) {
                throw e;
            }
            ++failures;
        }
    }

    public static void setQueryTimeout(Statement stmt, int timeout) throws SQLException {
        if (timeout < 0) {
            LOG.info("Invalid query timeout {}", (Object)timeout);
            return;
        }
        try {
            stmt.setQueryTimeout(timeout);
        }
        catch (SQLException e) {
            String message;
            String string = message = e.getMessage() == null ? null : e.getMessage().toLowerCase();
            if (e instanceof SQLFeatureNotSupportedException || message != null && (message.contains("implemented") || message.contains("supported"))) {
                LOG.info("setQueryTimeout is not supported");
                return;
            }
            throw e;
        }
    }

    public static long getRandomWaitTime(long baseWindow, int failures, Random r) {
        return (long)((double)(baseWindow * (long)failures) + (double)(baseWindow * (long)(failures + 1)) * r.nextDouble());
    }

    public static String escapeSqlLike(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        for (char c : key.toCharArray()) {
            switch (c) {
                case '%': 
                case '\\': 
                case '_': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String formatMsecToStr(long msec) {
        long day = -1L;
        long hour = -1L;
        long minute = -1L;
        long second = -1L;
        long ms = msec % 1000L;
        long timeLeft = msec / 1000L;
        if (timeLeft > 0L) {
            second = timeLeft % 60L;
            if ((timeLeft /= 60L) > 0L) {
                minute = timeLeft % 60L;
                if ((timeLeft /= 60L) > 0L) {
                    hour = timeLeft % 24L;
                    day = timeLeft / 24L;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (day != -1L) {
            sb.append(day + " days ");
        }
        if (hour != -1L) {
            sb.append(hour + " hours ");
        }
        if (minute != -1L) {
            sb.append(minute + " minutes ");
        }
        if (second != -1L) {
            sb.append(second + " seconds ");
        }
        sb.append(ms + " msec");
        return sb.toString();
    }

    public static int estimateNumberOfReducers(HiveConf conf, ContentSummary inputSummary, MapWork work, boolean finalMapRed) throws IOException {
        long bytesPerReducer = conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
        double samplePercentage = Utilities.getHighestSamplePercentage(work);
        long totalInputFileSize = Utilities.getTotalInputFileSize(inputSummary, work, samplePercentage);
        if (totalInputFileSize != inputSummary.getLength()) {
            LOG.info("BytesPerReducer={} maxReducers={} estimated totalInputFileSize={}", new Object[]{bytesPerReducer, maxReducers, totalInputFileSize});
        } else {
            LOG.info("BytesPerReducer={} maxReducers={} totalInputFileSize={}", new Object[]{bytesPerReducer, maxReducers, totalInputFileSize});
        }
        boolean powersOfTwo = conf.getBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT_NUM_BUCKETS_POWER_TWO) && finalMapRed && !work.getBucketedColsByDirectory().isEmpty();
        return Utilities.estimateReducers(totalInputFileSize, bytesPerReducer, maxReducers, powersOfTwo);
    }

    public static int estimateReducers(long totalInputFileSize, long bytesPerReducer, int maxReducers, boolean powersOfTwo) {
        double bytes = Math.max(totalInputFileSize, bytesPerReducer);
        int reducers = (int)Math.ceil(bytes / (double)bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        int reducersLog = (int)(Math.log(reducers) / Math.log(2.0)) + 1;
        int reducersPowerTwo = (int)Math.pow(2.0, reducersLog);
        if (powersOfTwo && reducersPowerTwo / 2 != reducers) {
            reducers = reducersPowerTwo > maxReducers ? reducersPowerTwo / 2 : reducersPowerTwo;
        }
        return reducers;
    }

    public static long getTotalInputFileSize(ContentSummary inputSummary, MapWork work, double highestSamplePercentage) {
        long totalInputFileSize = inputSummary.getLength();
        if (MapUtils.isEmpty(work.getNameToSplitSample())) {
            return totalInputFileSize;
        }
        if (highestSamplePercentage >= 0.0) {
            totalInputFileSize = Math.min((long)((double)totalInputFileSize * (highestSamplePercentage / 100.0)), totalInputFileSize);
        }
        return totalInputFileSize;
    }

    public static long getTotalInputNumFiles(ContentSummary inputSummary, MapWork work, double highestSamplePercentage) {
        long totalInputNumFiles = inputSummary.getFileCount();
        if (MapUtils.isEmpty(work.getNameToSplitSample())) {
            return totalInputNumFiles;
        }
        if (highestSamplePercentage >= 0.0) {
            totalInputNumFiles = Math.min((long)((double)totalInputNumFiles * (highestSamplePercentage / 100.0)), totalInputNumFiles);
        }
        return totalInputNumFiles;
    }

    public static double getHighestSamplePercentage(MapWork work) {
        double highestSamplePercentage = 0.0;
        for (String alias : work.getAliasToWork().keySet()) {
            if (work.getNameToSplitSample().containsKey(alias)) {
                Double rate = work.getNameToSplitSample().get(alias).getPercent();
                if (rate == null || !(rate > highestSamplePercentage)) continue;
                highestSamplePercentage = rate;
                continue;
            }
            highestSamplePercentage = -1.0;
            break;
        }
        return highestSamplePercentage;
    }

    public static List<Path> getInputPathsTez(JobConf job, MapWork work) throws Exception {
        String scratchDir = job.get("_hive_tez_tmp_dir");
        List<Path> paths = Utilities.getInputPaths(job, work, new Path(scratchDir), null, true);
        return paths;
    }

    public static String getVertexCounterName(String counter, String vertexName) {
        if (vertexName != null && !((String)vertexName).isEmpty()) {
            vertexName = "_" + ((String)vertexName).replace(" ", "_");
        }
        return counter + (String)vertexName;
    }

    public static List<Path> getInputPaths(JobConf job, MapWork work, Path hiveScratchDir, Context ctx, boolean skipDummy) throws Exception {
        HashSet<Path> pathsProcessed = new HashSet<Path>();
        LinkedList<Path> pathsToAdd = new LinkedList<Path>();
        Driver.LockedDriverState lDrvStat = Driver.LockedDriverState.getLockedDriverState();
        Collection<String> aliasToWork = work.getAliasToWork().keySet();
        if (!skipDummy) {
            aliasToWork = new ArrayList<String>(aliasToWork);
        }
        for (String alias : aliasToWork) {
            LOG.info("Processing alias {}", (Object)alias);
            Collection<Map.Entry<Path, ArrayList<String>>> pathToAliases = work.getPathToAliases().entrySet();
            if (!skipDummy) {
                pathToAliases = new ArrayList<Map.Entry<Path, ArrayList<String>>>(pathToAliases);
            }
            boolean isEmptyTable = true;
            boolean hasLogged = false;
            for (Map.Entry<Path, ArrayList<String>> e : pathToAliases) {
                if (lDrvStat != null && lDrvStat.isAborted()) {
                    throw new IOException("Operation is Canceled.");
                }
                Path file = e.getKey();
                List aliases = e.getValue();
                if (!aliases.contains(alias)) continue;
                if (file == null) {
                    LOG.warn("Found a null path for alias {}", (Object)alias);
                    continue;
                }
                isEmptyTable = false;
                if (pathsProcessed.contains(file)) continue;
                StringInternUtils.internUriStringsInPath(file);
                pathsProcessed.add(file);
                LOG.debug("Adding input file {}", (Object)file);
                if (!hasLogged) {
                    hasLogged = true;
                    LOG.info("Adding {} inputs; the first input is {}", (Object)work.getPathToAliases().size(), (Object)file);
                }
                pathsToAdd.add(file);
            }
            if (!isEmptyTable || skipDummy) continue;
            pathsToAdd.add(Utilities.createDummyFileForEmptyTable(job, work, hiveScratchDir, alias));
        }
        LinkedList<Path> finalPathsToAdd = new LinkedList<Path>();
        int numExecutors = Utilities.getMaxExecutorsForInputListing((Configuration)job, pathsToAdd.size());
        if (numExecutors > 1) {
            ExecutorService pool = Executors.newFixedThreadPool(numExecutors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Get-Input-Paths-%d").build());
            finalPathsToAdd.addAll(Utilities.getInputPathsWithPool(job, work, hiveScratchDir, ctx, skipDummy, pathsToAdd, pool));
        } else {
            for (Path path : pathsToAdd) {
                if (lDrvStat != null && lDrvStat.isAborted()) {
                    throw new IOException("Operation is Canceled.");
                }
                Path newPath = new GetInputPathsCallable(path, job, work, hiveScratchDir, ctx, skipDummy).call();
                Utilities.updatePathForMapWork(newPath, work, path);
                finalPathsToAdd.add(newPath);
            }
        }
        return finalPathsToAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static List<Path> getInputPathsWithPool(JobConf job, MapWork work, Path hiveScratchDir, Context ctx, boolean skipDummy, List<Path> pathsToAdd, ExecutorService pool) throws IOException, ExecutionException, InterruptedException {
        Driver.LockedDriverState lDrvStat = Driver.LockedDriverState.getLockedDriverState();
        ArrayList<Path> finalPathsToAdd = new ArrayList<Path>();
        try {
            LinkedHashMap<GetInputPathsCallable, Future<Path>> getPathsCallableToFuture = new LinkedHashMap<GetInputPathsCallable, Future<Path>>();
            for (Path path : pathsToAdd) {
                if (lDrvStat != null && lDrvStat.isAborted()) {
                    throw new IOException("Operation is Canceled.");
                }
                GetInputPathsCallable callable = new GetInputPathsCallable(path, job, work, hiveScratchDir, ctx, skipDummy);
                getPathsCallableToFuture.put(callable, pool.submit(callable));
            }
            pool.shutdown();
            for (Map.Entry entry : getPathsCallableToFuture.entrySet()) {
                if (lDrvStat != null && lDrvStat.isAborted()) {
                    throw new IOException("Operation is Canceled.");
                }
                Path newPath = (Path)((Future)entry.getValue()).get();
                Utilities.updatePathForMapWork(newPath, work, ((GetInputPathsCallable)entry.getKey()).path);
                finalPathsToAdd.add(newPath);
            }
        }
        finally {
            pool.shutdownNow();
        }
        return finalPathsToAdd;
    }

    private static Path createEmptyFile(Path hiveScratchDir, HiveOutputFormat outFileFormat, JobConf job, Properties props, boolean dummyRow) throws IOException, InstantiationException, IllegalAccessException {
        String newDir = hiveScratchDir + "/" + UUID.randomUUID().toString();
        Path newPath = new Path(newDir);
        FileSystem fs = newPath.getFileSystem((Configuration)job);
        fs.mkdirs(newPath);
        newPath = fs.makeQualified(newPath);
        String newFile = newDir + "/emptyFile";
        Path newFilePath = new Path(newFile);
        FileSinkOperator.RecordWriter recWriter = outFileFormat.getHiveRecordWriter(job, newFilePath, Text.class, false, props, null);
        if (dummyRow) {
            recWriter.write((Writable)new Text("empty"));
        }
        recWriter.close(false);
        return StringInternUtils.internUriStringsInPath(newPath);
    }

    private static Path createDummyFileForEmptyPartition(Path path, JobConf job, PartitionDesc partDesc, Path hiveScratchDir) throws Exception {
        String strPath = path.toString();
        if (partDesc.getTableDesc().isNonNative()) {
            return path;
        }
        Properties props = SerDeUtils.createOverlayedProperties(partDesc.getTableDesc().getProperties(), partDesc.getProperties());
        HiveOutputFormat<?, ?> outFileFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, partDesc);
        boolean oneRow = partDesc.getInputFileFormatClass() == OneNullRowInputFormat.class;
        Path newPath = Utilities.createEmptyFile(hiveScratchDir, outFileFormat, job, props, oneRow);
        LOG.info("Changed input file {} to empty file {} ({})", new Object[]{strPath, newPath, oneRow});
        return newPath;
    }

    private static void updatePathForMapWork(Path newPath, MapWork work, Path path) {
        if (!newPath.equals((Object)path)) {
            PartitionDesc partDesc = work.getPathToPartitionInfo().get(path);
            work.addPathToAlias(newPath, work.getPathToAliases().get(path));
            work.removePathToAlias(path);
            work.removePathToPartitionInfo(path);
            work.addPathToPartitionInfo(newPath, partDesc);
        }
    }

    private static Path createDummyFileForEmptyTable(JobConf job, MapWork work, Path hiveScratchDir, String alias) throws Exception {
        TableDesc tableDesc = work.getAliasToPartnInfo().get(alias).getTableDesc();
        if (tableDesc.isNonNative()) {
            return null;
        }
        Properties props = tableDesc.getProperties();
        HiveOutputFormat<?, ?> outFileFormat = HiveFileFormatUtils.getHiveOutputFormat((Configuration)job, tableDesc);
        Path newPath = Utilities.createEmptyFile(hiveScratchDir, outFileFormat, job, props, false);
        LOG.info("Changed input file for alias {} to newPath", (Object)alias, (Object)newPath);
        LinkedHashMap<Path, ArrayList<String>> pathToAliases = work.getPathToAliases();
        ArrayList<String> newList = new ArrayList<String>(1);
        newList.add(alias);
        pathToAliases.put(newPath, newList);
        work.setPathToAliases(pathToAliases);
        PartitionDesc pDesc = work.getAliasToPartnInfo().get(alias).clone();
        work.addPathToPartitionInfo(newPath, pDesc);
        return newPath;
    }

    public static void setInputPaths(JobConf job, List<Path> pathsToAdd) {
        Path[] addedPaths = FileInputFormat.getInputPaths((JobConf)job);
        if (addedPaths == null) {
            addedPaths = EMPTY_PATH;
        }
        Path[] combined = new Path[addedPaths.length + pathsToAdd.size()];
        System.arraycopy(addedPaths, 0, combined, 0, addedPaths.length);
        int i = 0;
        for (Path p : pathsToAdd) {
            combined[addedPaths.length + i++] = p;
        }
        FileInputFormat.setInputPaths((JobConf)job, (Path[])combined);
    }

    public static void setInputAttributes(Configuration conf, MapWork mWork) {
        HiveConf.ConfVars var;
        HiveConf.ConfVars confVars = var = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") ? HiveConf.ConfVars.HIVETEZINPUTFORMAT : HiveConf.ConfVars.HIVEINPUTFORMAT;
        if (mWork.getInputformat() != null) {
            HiveConf.setVar(conf, var, mWork.getInputformat());
        }
        conf.setBoolean("hive.input.format.sorted", mWork.isInputFormatSorted());
    }

    public static void createTmpDirs(Configuration conf, MapWork mWork) throws IOException {
        LinkedHashMap<Path, ArrayList<String>> pa = mWork.getPathToAliases();
        if (MapUtils.isNotEmpty(pa)) {
            HashSet<String> aliases = new HashSet<String>(1);
            ArrayList<Operator<? extends OperatorDesc>> ops = new ArrayList<Operator<? extends OperatorDesc>>();
            for (List ls : pa.values()) {
                for (String a : ls) {
                    aliases.add(a);
                }
            }
            for (String a : aliases) {
                ops.add(mWork.getAliasToWork().get(a));
            }
            Utilities.createTmpDirs(conf, ops);
        }
    }

    public static void createTmpDirs(Configuration conf, ReduceWork rWork) throws IOException {
        if (rWork == null) {
            return;
        }
        LinkedList<Operator<? extends OperatorDesc>> ops = new LinkedList<Operator<? extends OperatorDesc>>();
        ops.add(rWork.getReducer());
        Utilities.createTmpDirs(conf, ops);
    }

    private static void createTmpDirs(Configuration conf, List<Operator<? extends OperatorDesc>> ops) throws IOException {
        while (!ops.isEmpty()) {
            Operator<? extends OperatorDesc> op = ops.remove(0);
            if (op instanceof FileSinkOperator) {
                FileSinkDesc fdesc = (FileSinkDesc)((FileSinkOperator)op).getConf();
                if (fdesc.isMmTable()) continue;
                Path tempDir = fdesc.getDirName();
                if (tempDir != null) {
                    Path tempPath = Utilities.toTempPath(tempDir);
                    FileSystem fs = tempPath.getFileSystem(conf);
                    fs.mkdirs(tempPath);
                }
            }
            if (op.getChildOperators() == null) continue;
            ops.addAll(op.getChildOperators());
        }
    }

    public static boolean createDirsWithPermission(Configuration conf, Path mkdirPath, FsPermission fsPermission, boolean recursive) throws IOException {
        String origUmask = null;
        LOG.debug("Create dirs {} with permission {} recursive {}", new Object[]{mkdirPath, fsPermission, recursive});
        if (recursive) {
            origUmask = conf.get("fs.permissions.umask-mode");
            conf.set("fs.permissions.umask-mode", "000");
        }
        FileSystem fs = ShimLoader.getHadoopShims().getNonCachedFileSystem(mkdirPath.toUri(), conf);
        boolean retval = false;
        try {
            retval = fs.mkdirs(mkdirPath, fsPermission);
            Utilities.resetUmaskInConf(conf, recursive, origUmask);
        }
        catch (IOException ioe) {
            Utilities.resetUmaskInConf(conf, recursive, origUmask);
            throw ioe;
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
        }
        return retval;
    }

    private static void resetUmaskInConf(Configuration conf, boolean unsetUmask, String origUmask) {
        if (unsetUmask) {
            if (origUmask != null) {
                conf.set("fs.permissions.umask-mode", origUmask);
            } else {
                conf.unset("fs.permissions.umask-mode");
            }
        }
    }

    public static boolean getIsVectorized(Configuration conf) {
        if (conf.get(VECTOR_MODE) != null) {
            return conf.getBoolean(VECTOR_MODE, false);
        }
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && Utilities.getPlanPath(conf) != null) {
            MapWork mapWork = Utilities.getMapWork(conf);
            return mapWork.getVectorMode();
        }
        return false;
    }

    public static boolean getIsVectorized(Configuration conf, MapWork mapWork) {
        return HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && mapWork.getVectorMode();
    }

    public static VectorizedRowBatchCtx getVectorizedRowBatchCtx(Configuration conf) {
        MapWork mapWork;
        VectorizedRowBatchCtx result = null;
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && Utilities.getPlanPath(conf) != null && (mapWork = Utilities.getMapWork(conf)) != null && mapWork.getVectorMode()) {
            result = mapWork.getVectorizedRowBatchCtx();
        }
        return result;
    }

    public static void clearWorkMapForConf(Configuration conf) {
        Path mapPath = Utilities.getPlanPath(conf, MAP_PLAN_NAME);
        Path reducePath = Utilities.getPlanPath(conf, REDUCE_PLAN_NAME);
        if (mapPath != null) {
            gWorkMap.get(conf).remove(mapPath);
        }
        if (reducePath != null) {
            gWorkMap.get(conf).remove(reducePath);
        }
    }

    public static void clearWorkMap(Configuration conf) {
        gWorkMap.get(conf).clear();
    }

    public static File createTempDir(String baseDir) {
        int MAX_ATTEMPS = 30;
        for (int i = 0; i < 30; ++i) {
            String tempDirName = "tmp_" + (int)(100000.0 * Math.random());
            File tempDir = new File(baseDir, tempDirName);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create a temp dir under " + baseDir + " Giving up after 30 attempts");
    }

    public static boolean skipHeader(RecordReader<WritableComparable, Writable> currRecReader, int headerCount, WritableComparable key, Writable value) throws IOException {
        while (headerCount > 0) {
            if (!currRecReader.next((Object)key, (Object)value)) {
                return false;
            }
            --headerCount;
        }
        return true;
    }

    public static int getHeaderCount(TableDesc table) throws IOException {
        int headerCount;
        try {
            headerCount = Integer.parseInt(table.getProperties().getProperty("skip.header.line.count", "0"));
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
        return headerCount;
    }

    public static int getFooterCount(TableDesc table, JobConf job) throws IOException {
        int footerCount;
        try {
            footerCount = Integer.parseInt(table.getProperties().getProperty("skip.footer.line.count", "0"));
            if (footerCount > HiveConf.getIntVar((Configuration)job, HiveConf.ConfVars.HIVE_FILE_MAX_FOOTER)) {
                throw new IOException("footer number exceeds the limit defined in hive.file.max.footer");
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException(nfe);
        }
        return footerCount;
    }

    public static String getQualifiedPath(HiveConf conf, Path path) throws HiveException {
        if (path == null) {
            return null;
        }
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            return fs.makeQualified(path).toString();
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public static boolean isPerfOrAboveLogging(HiveConf conf) {
        String loggingLevel = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
        return conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED) && (loggingLevel.equalsIgnoreCase("PERFORMANCE") || loggingLevel.equalsIgnoreCase("VERBOSE"));
    }

    public static String jarFinderGetJar(Class klass) {
        Preconditions.checkNotNull(klass, "klass");
        ClassLoader loader = klass.getClassLoader();
        if (loader != null) {
            String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(class_file);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if (!"jar".equals(url.getProtocol())) continue;
                    path = URLDecoder.decode(path, "UTF-8");
                    return path.replaceAll("!.*$", NSTR);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static int getDPColOffset(FileSinkDesc conf) {
        if (conf.getWriteType() == AcidUtils.Operation.DELETE) {
            return 1;
        }
        if (conf.getWriteType() == AcidUtils.Operation.UPDATE) {
            return Utilities.getColumnNames(conf.getTableInfo().getProperties()).size() + 1;
        }
        return Utilities.getColumnNames(conf.getTableInfo().getProperties()).size();
    }

    public static List<String> getStatsTmpDirs(BaseWork work, Configuration conf) {
        ArrayList<String> statsTmpDirs = new ArrayList<String>();
        if (!StatsSetupConst.StatDB.fs.name().equalsIgnoreCase(HiveConf.getVar(conf, HiveConf.ConfVars.HIVESTATSDBCLASS))) {
            return statsTmpDirs;
        }
        Set<Operator<? extends OperatorDesc>> ops = work.getAllLeafOperators();
        if (work instanceof MapWork) {
            ops.addAll(work.getAllRootOperators());
        }
        for (Operator<? extends OperatorDesc> op : ops) {
            OperatorDesc desc = op.getConf();
            String statsTmpDir = null;
            if (desc instanceof IStatsGatherDesc) {
                statsTmpDir = ((IStatsGatherDesc)((Object)desc)).getTmpStatsDir();
            }
            if (statsTmpDir == null || statsTmpDir.isEmpty()) continue;
            statsTmpDirs.add(statsTmpDir);
        }
        return statsTmpDirs;
    }

    public static boolean isSchemaEvolutionEnabled(Configuration conf, boolean isAcid) {
        return isAcid || HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
    }

    public static boolean isInputFileFormatSelfDescribing(PartitionDesc pd) {
        Class<? extends InputFormat> inputFormatClass = pd.getInputFileFormatClass();
        return SelfDescribingInputFormatInterface.class.isAssignableFrom(inputFormatClass);
    }

    public static boolean isInputFileFormatVectorized(PartitionDesc pd) {
        Class<? extends InputFormat> inputFormatClass = pd.getInputFileFormatClass();
        return VectorizedInputFormatInterface.class.isAssignableFrom(inputFormatClass);
    }

    public static Collection<Class<?>> getClassNamesFromConfig(HiveConf hiveConf, HiveConf.ConfVars confVar) {
        String[] classNames = org.apache.hadoop.util.StringUtils.getStrings((String)HiveConf.getVar(hiveConf, confVar));
        if (classNames == null) {
            return new ArrayList(0);
        }
        ArrayList classList = new ArrayList(classNames.length);
        for (String className : classNames) {
            if (StringUtils.isEmpty(className)) continue;
            try {
                classList.add(Class.forName(className));
            }
            catch (Exception ex) {
                LOG.warn("Cannot create class {} for {} checks", (Object)className, (Object)confVar.varname);
            }
        }
        return classList;
    }

    public static void addSchemaEvolutionToTableScanOperator(Table table, TableScanOperator tableScanOp) {
        String colNames = MetaStoreUtils.getColumnNamesFromFieldSchema(table.getSd().getCols());
        String colTypes = MetaStoreUtils.getColumnTypesFromFieldSchema(table.getSd().getCols());
        tableScanOp.setSchemaEvolution(colNames, colTypes);
    }

    public static void addSchemaEvolutionToTableScanOperator(StructObjectInspector structOI, TableScanOperator tableScanOp) {
        String colNames = ObjectInspectorUtils.getFieldNames(structOI);
        String colTypes = ObjectInspectorUtils.getFieldTypes(structOI);
        tableScanOp.setSchemaEvolution(colNames, colTypes);
    }

    public static void unsetSchemaEvolution(Configuration conf) {
        conf.unset("schema.evolution.columns");
        conf.unset("schema.evolution.columns.types");
    }

    public static void addTableSchemaToConf(Configuration conf, TableScanOperator tableScanOp) {
        String schemaEvolutionColumns = tableScanOp.getSchemaEvolutionColumns();
        if (schemaEvolutionColumns != null) {
            conf.set("schema.evolution.columns", tableScanOp.getSchemaEvolutionColumns());
            conf.set("schema.evolution.columns.types", tableScanOp.getSchemaEvolutionColumnsTypes());
        } else {
            LOG.info("schema.evolution.columns and schema.evolution.columns.types not available");
        }
    }

    public static StandardStructObjectInspector constructVectorizedReduceRowOI(StructObjectInspector keyInspector, StructObjectInspector valueInspector) throws HiveException {
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
        List<? extends StructField> fields = keyInspector.getAllStructFieldRefs();
        for (StructField structField : fields) {
            colNames.add(ReduceField.KEY.toString() + "." + structField.getFieldName());
            ois.add(structField.getFieldObjectInspector());
        }
        fields = valueInspector.getAllStructFieldRefs();
        for (StructField structField : fields) {
            colNames.add(ReduceField.VALUE.toString() + "." + structField.getFieldName());
            ois.add(structField.getFieldObjectInspector());
        }
        StandardStructObjectInspector rowObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
        return rowObjectInspector;
    }

    public static String humanReadableByteCount(long bytes) {
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String suffix = NSTR + "KMGTPE".charAt(exp - 1);
        return String.format("%.2f%sB", (double)bytes / Math.pow(unit, exp), suffix);
    }

    private static void tryDelete(FileSystem fs, Path path) {
        try {
            fs.delete(path, true);
        }
        catch (IOException ex) {
            LOG.error("Failed to delete {}", (Object)path, (Object)ex);
        }
    }

    public static Path[] getMmDirectoryCandidates(FileSystem fs, Path path, int dpLevels, PathFilter filter, long writeId, int stmtId, Configuration conf, Boolean isBaseDir) throws IOException {
        int skipLevels = dpLevels;
        if (filter == null) {
            filter = new AcidUtils.IdPathFilter(writeId, stmtId);
        }
        if (skipLevels == 0) {
            return Utilities.statusToPath(fs.listStatus(path, filter));
        }
        if (stmtId < 0 || isBaseDir == null || HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_MM_AVOID_GLOBSTATUS_ON_S3) && Utilities.isS3(fs)) {
            return Utilities.getMmDirectoryCandidatesRecursive(fs, path, skipLevels, filter);
        }
        return Utilities.getMmDirectoryCandidatesGlobStatus(fs, path, skipLevels, filter, writeId, stmtId, isBaseDir);
    }

    private static boolean isS3(FileSystem fs) {
        try {
            return "s3a".equalsIgnoreCase(fs.getScheme());
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private static Path[] statusToPath(FileStatus[] statuses) {
        if (statuses == null) {
            return null;
        }
        Path[] paths = new Path[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            paths[i] = statuses[i].getPath();
        }
        return paths;
    }

    private static Path[] getMmDirectoryCandidatesRecursive(FileSystem fs, Path path, int skipLevels, PathFilter filter) throws IOException {
        String lastRelDir = null;
        HashSet<Path> results = new HashSet<Path>();
        Object relRoot = Path.getPathWithoutSchemeAndAuthority((Path)path).toString();
        if (!((String)relRoot).endsWith("/")) {
            relRoot = (String)relRoot + "/";
        }
        RemoteIterator allFiles = fs.listFiles(path, true);
        while (allFiles.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)allFiles.next();
            Path lfsPath = lfs.getPath();
            Path dirPath = Path.getPathWithoutSchemeAndAuthority((Path)lfsPath);
            String dir = dirPath.toString();
            if (!dir.startsWith((String)relRoot)) {
                throw new IOException("Path " + lfsPath + " is not under " + (String)relRoot + " (when shortened to " + dir + ")");
            }
            String subDir = dir.substring(((String)relRoot).length());
            FILE_OP_LOGGER.trace("Looking at {} from {}", (Object)subDir, (Object)lfsPath);
            if (lastRelDir != null && subDir.startsWith(lastRelDir)) continue;
            int startIx = skipLevels > 0 ? -1 : 0;
            for (int i = 0; i < skipLevels; ++i) {
                if ((startIx = subDir.indexOf(47, startIx + 1)) != -1) continue;
                FILE_OP_LOGGER.info("Expected level of nesting ({}) is not  present in {} (from {})", new Object[]{skipLevels, subDir, lfsPath});
                break;
            }
            if (startIx == -1) continue;
            int endIx = subDir.indexOf(47, startIx + 1);
            if (endIx == -1) {
                FILE_OP_LOGGER.info("Expected level of nesting ({}) is not present in {} (from {})", new Object[]{skipLevels + 1, subDir, lfsPath});
                continue;
            }
            lastRelDir = subDir = subDir.substring(0, endIx);
            Path candidate = new Path((String)relRoot, subDir);
            if (!filter.accept(candidate)) continue;
            results.add(fs.makeQualified(candidate));
        }
        return results.toArray(new Path[results.size()]);
    }

    private static Path[] getMmDirectoryCandidatesGlobStatus(FileSystem fs, Path path, int skipLevels, PathFilter filter, long writeId, int stmtId, boolean isBaseDir) throws IOException {
        StringBuilder sb = new StringBuilder(path.toUri().getPath());
        for (int i = 0; i < skipLevels; ++i) {
            sb.append("/").append('*');
        }
        if (stmtId < 0) {
            throw new AssertionError((Object)"GlobStatus should not be called without a statement ID");
        }
        sb.append("/").append(AcidUtils.baseOrDeltaSubdir(isBaseDir, writeId, writeId, stmtId));
        Path pathPattern = new Path(path, sb.toString());
        return Utilities.statusToPath(fs.globStatus(pathPattern, filter));
    }

    private static void tryDeleteAllMmFiles(FileSystem fs, Path specPath, Path manifestDir, int dpLevels, int lbLevels, AcidUtils.IdPathFilter filter, long writeId, int stmtId, Configuration conf) throws IOException {
        Path[] files = Utilities.getMmDirectoryCandidates(fs, specPath, dpLevels, filter, writeId, stmtId, conf, null);
        if (files != null) {
            for (Path path : files) {
                FILE_OP_LOGGER.info("Deleting {} on failure", (Object)path);
                Utilities.tryDelete(fs, path);
            }
        }
        FILE_OP_LOGGER.info("Deleting {} on failure", (Object)manifestDir);
        fs.delete(manifestDir, true);
    }

    public static void writeMmCommitManifest(List<Path> commitPaths, Path specPath, FileSystem fs, String taskId, Long writeId, int stmtId, String unionSuffix, boolean isInsertOverwrite) throws HiveException {
        if (commitPaths.isEmpty()) {
            return;
        }
        Path manifestPath = Utilities.getManifestDir(specPath, writeId, stmtId, unionSuffix, isInsertOverwrite);
        manifestPath = new Path(manifestPath, taskId + MANIFEST_EXTENSION);
        FILE_OP_LOGGER.info("Writing manifest to {} with {}", (Object)manifestPath, commitPaths);
        try (FSDataOutputStream out = fs.create(manifestPath, false);){
            if (out == null) {
                throw new HiveException("Failed to create manifest at " + manifestPath);
            }
            out.writeInt(commitPaths.size());
            for (Path path : commitPaths) {
                out.writeUTF(path.toString());
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private static Path getManifestDir(Path specPath, long writeId, int stmtId, String unionSuffix, boolean isInsertOverwrite) {
        Path manifestPath = new Path(specPath, tmpPrefix + AcidUtils.baseOrDeltaSubdir(isInsertOverwrite, writeId, writeId, stmtId));
        return unionSuffix == null ? manifestPath : new Path(manifestPath, unionSuffix);
    }

    public static void handleMmTableFinalPath(Path specPath, String unionSuffix, Configuration hconf, boolean success, int dpLevels, int lbLevels, MissingBucketsContext mbc, long writeId, int stmtId, Reporter reporter, boolean isMmTable, boolean isMmCtas, boolean isInsertOverwrite) throws IOException, HiveException {
        FileSystem fs = specPath.getFileSystem(hconf);
        Path manifestDir = Utilities.getManifestDir(specPath, writeId, stmtId, unionSuffix, isInsertOverwrite);
        if (!success) {
            AcidUtils.IdPathFilter filter = new AcidUtils.IdPathFilter(writeId, stmtId);
            Utilities.tryDeleteAllMmFiles(fs, specPath, manifestDir, dpLevels, lbLevels, filter, writeId, stmtId, hconf);
            return;
        }
        FILE_OP_LOGGER.debug("Looking for manifests in: {} ({})", (Object)manifestDir, (Object)writeId);
        ArrayList<Path> manifests = new ArrayList<Path>();
        if (fs.exists(manifestDir)) {
            FileStatus[] manifestFiles = fs.listStatus(manifestDir);
            if (manifestFiles != null) {
                for (FileStatus status : manifestFiles) {
                    Path path = status.getPath();
                    if (!path.getName().endsWith(MANIFEST_EXTENSION)) continue;
                    FILE_OP_LOGGER.info("Reading manifest {}", (Object)path);
                    manifests.add(path);
                }
            }
        } else {
            FILE_OP_LOGGER.info("No manifests found - query produced no output");
            manifestDir = null;
        }
        FILE_OP_LOGGER.debug("Looking for files in: {}", (Object)specPath);
        AcidUtils.IdPathFilter filter = new AcidUtils.IdPathFilter(writeId, stmtId);
        if (isMmCtas && !fs.exists(specPath)) {
            FILE_OP_LOGGER.info("Creating table directory for CTAS with no output at {}", (Object)specPath);
            FileUtils.mkdir(fs, specPath, hconf);
        }
        Path[] files = Utilities.getMmDirectoryCandidates(fs, specPath, dpLevels, filter, writeId, stmtId, hconf, isInsertOverwrite);
        ArrayList<Path> mmDirectories = new ArrayList<Path>();
        if (files != null) {
            for (Path path : files) {
                FILE_OP_LOGGER.trace("Looking at path: {}", (Object)path);
                mmDirectories.add(path);
            }
        }
        HashSet<String> committed = new HashSet<String>();
        for (Path mfp : manifests) {
            FSDataInputStream mdis = fs.open(mfp);
            try {
                int fileCount = mdis.readInt();
                for (int i = 0; i < fileCount; ++i) {
                    String nextFile = mdis.readUTF();
                    FILE_OP_LOGGER.trace("Looking at committed file: {}", (Object)nextFile);
                    if (committed.add(nextFile)) continue;
                    throw new HiveException(nextFile + " was specified in multiple manifests");
                }
            }
            finally {
                if (mdis == null) continue;
                mdis.close();
            }
        }
        if (manifestDir != null) {
            FileStatus[] remainingFiles;
            FILE_OP_LOGGER.info("Deleting manifest directory {}", (Object)manifestDir);
            Utilities.tryDelete(fs, manifestDir);
            if (unionSuffix != null && ((remainingFiles = fs.listStatus(manifestDir = manifestDir.getParent())) == null || remainingFiles.length == 0)) {
                FILE_OP_LOGGER.info("Deleting manifest directory {}", (Object)manifestDir);
                Utilities.tryDelete(fs, manifestDir);
            }
        }
        for (Path path : mmDirectories) {
            Utilities.cleanMmDirectory(path, fs, unionSuffix, lbLevels, committed);
        }
        if (!committed.isEmpty()) {
            throw new HiveException("The following files were committed but not found: " + committed);
        }
        if (mmDirectories.isEmpty()) {
            return;
        }
        if (lbLevels != 0) {
            return;
        }
        FileStatus[] finalResults = new FileStatus[mmDirectories.size()];
        for (int i = 0; i < mmDirectories.size(); ++i) {
            finalResults[i] = new PathOnlyFileStatus((Path)mmDirectories.get(i));
        }
        List<Path> emptyBuckets = Utilities.removeTempOrDuplicateFiles(fs, finalResults, unionSuffix, dpLevels, mbc == null ? 0 : mbc.numBuckets, hconf, writeId, stmtId, isMmTable, null, isInsertOverwrite);
        if (!emptyBuckets.isEmpty()) {
            assert (mbc != null);
            Utilities.createEmptyBuckets(hconf, emptyBuckets, mbc.isCompressed, mbc.tableInfo, reporter);
        }
    }

    private static void cleanMmDirectory(Path dir, FileSystem fs, String unionSuffix, int lbLevels, HashSet<String> committed) throws IOException, HiveException {
        for (FileStatus child : fs.listStatus(dir)) {
            Path childPath = child.getPath();
            if (lbLevels > 0) {
                if (child.isDirectory()) {
                    FILE_OP_LOGGER.trace("Recursion into LB directory {}; levels remaining ", (Object)childPath, (Object)(lbLevels - 1));
                    Utilities.cleanMmDirectory(childPath, fs, unionSuffix, lbLevels - 1, committed);
                    continue;
                }
                if (committed.contains(childPath.toString())) {
                    throw new HiveException("LB FSOP has commited " + childPath + " outside of LB directory levels " + lbLevels);
                }
                Utilities.deleteUncommitedFile(childPath, fs);
                continue;
            }
            if (unionSuffix == null) {
                if (committed.remove(childPath.toString())) continue;
                Utilities.deleteUncommitedFile(childPath, fs);
                continue;
            }
            if (!child.isDirectory()) {
                if (committed.contains(childPath.toString())) {
                    throw new HiveException("Union FSOP has commited " + childPath + " outside of union directory " + unionSuffix);
                }
                Utilities.deleteUncommitedFile(childPath, fs);
                continue;
            }
            if (childPath.getName().equals(unionSuffix)) {
                Utilities.cleanMmDirectory(childPath, fs, null, 0, committed);
                continue;
            }
            String childName = childPath.getName();
            if (!(childName.startsWith("HIVE_UNION_SUBDIR_") || childName.startsWith(".") || childName.startsWith("_"))) {
                throw new HiveException("Union FSOP has an unknown directory " + childPath + " outside of union directory " + unionSuffix);
            }
            FILE_OP_LOGGER.trace("FSOP for {} is ignoring the other side of the union {}", (Object)unionSuffix, (Object)childPath);
        }
    }

    private static void deleteUncommitedFile(Path childPath, FileSystem fs) throws IOException, HiveException {
        FILE_OP_LOGGER.info("Deleting {} that was not committed", (Object)childPath);
        if (!fs.delete(childPath, true)) {
            throw new HiveException("Failed to delete an uncommitted path " + childPath);
        }
    }

    public static List<Path> getValidMmDirectoriesFromTableOrPart(Path path, Configuration conf, ValidWriteIdList validWriteIdList) throws IOException {
        FILE_OP_LOGGER.trace("Looking for valid MM paths under {}", (Object)path);
        ArrayList<Path> result = null;
        FileSystem fs = path.getFileSystem(conf);
        FileStatus[] children = fs.listStatus(path);
        for (int i = 0; i < children.length; ++i) {
            FileStatus file = children[i];
            Path childPath = file.getPath();
            Long writeId = AcidUtils.extractWriteId(childPath);
            if (!file.isDirectory() || writeId == null || !validWriteIdList.isWriteIdValid(writeId)) {
                FILE_OP_LOGGER.debug("Skipping path {}", (Object)childPath);
                if (result != null) continue;
                result = new ArrayList<Path>(children.length - 1);
                for (int j = 0; j < i; ++j) {
                    result.add(children[j].getPath());
                }
                continue;
            }
            if (result == null) continue;
            result.add(childPath);
        }
        return result;
    }

    public static String getAclStringWithHiveModification(Configuration tezConf, String propertyName, boolean addHs2User, String user, String hs2User) throws IOException {
        ACLConfigurationParser aclConf = new ACLConfigurationParser(tezConf, propertyName);
        aclConf.addAllowedUser(user);
        if (addHs2User && hs2User != null) {
            aclConf.addAllowedUser(hs2User);
        }
        return aclConf.toAclString();
    }

    public static boolean isHiveManagedFile(Path path) {
        return AcidUtils.ORIGINAL_PATTERN.matcher(path.getName()).matches() || AcidUtils.ORIGINAL_PATTERN_COPY.matcher(path.getName()).matches();
    }

    public static void ensurePathIsWritable(Path rootHDFSDirPath, HiveConf conf) throws IOException {
        FsPermission writableHDFSDirPermission = new FsPermission(475);
        FileSystem fs = rootHDFSDirPath.getFileSystem((Configuration)conf);
        if (!fs.exists(rootHDFSDirPath)) {
            Utilities.createDirsWithPermission(conf, rootHDFSDirPath, writableHDFSDirPermission, true);
        }
        FsPermission currentHDFSDirPermission = fs.getFileStatus(rootHDFSDirPath).getPermission();
        if (rootHDFSDirPath != null && rootHDFSDirPath.toUri() != null) {
            String schema = rootHDFSDirPath.toUri().getScheme();
            LOG.debug("HDFS dir: " + rootHDFSDirPath + " with schema " + schema + ", permission: " + currentHDFSDirPermission);
        } else {
            LOG.debug("HDFS dir: " + rootHDFSDirPath + ", permission: " + currentHDFSDirPermission);
        }
        if ((currentHDFSDirPermission.toShort() & writableHDFSDirPermission.toShort()) != writableHDFSDirPermission.toShort()) {
            throw new RuntimeException("The dir: " + rootHDFSDirPath + " on HDFS should be writable. Current permissions are: " + currentHDFSDirPermission);
        }
    }

    public static int getBucketingVersion(String versionStr) {
        int bucketingVersion = 1;
        if (versionStr != null) {
            try {
                bucketingVersion = Integer.parseInt(versionStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bucketingVersion;
    }

    public static void tryLoggingClassPaths(JobConf job, Logger logger) {
        if (logger != null && logger.isInfoEnabled()) {
            Utilities.tryToLogClassPath("conf", job.getClassLoader(), logger);
            Utilities.tryToLogClassPath("thread", Thread.currentThread().getContextClassLoader(), logger);
        }
    }

    private static void tryToLogClassPath(String prefix, ClassLoader loader, Logger logger) {
        if (loader instanceof URLClassLoader) {
            logger.info("{} class path = {}", (Object)prefix, (Object)Arrays.asList(((URLClassLoader)loader).getURLs()).toString());
        } else {
            logger.info("{} class path = unavailable for {}", (Object)prefix, (Object)(loader == null ? "null" : loader.getClass().getSimpleName()));
        }
    }

    static {
        for (ReduceField r : ReduceField.values()) {
            reduceFieldNameList.add(r.toString());
        }
        gWorkMap = new GlobalWorkMapFactory();
        CLASS_NAME = Utilities.class.getName();
        LOG = LoggerFactory.getLogger((String)CLASS_NAME);
        defaultTd = new TableDesc(TextInputFormat.class, IgnoreKeyTextOutputFormat.class, Utilities.makeProperties("serialization.format", "1", "serialization.lib", MetadataTypedColumnsetSerDe.class.getName()));
        FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^.*?([0-9]+)(_[0-9]{1,6})?(\\..*)?$");
        COPY_FILE_NAME_TO_TASK_ID_REGEX = Pattern.compile("^.*?([0-9]+)(_)([0-9]{1,6})?((_)(\\Bcopy\\B)(_)([0-9]{1,6})$)?(\\..*)?$");
        FILE_NAME_PREFIXED_TASK_ID_REGEX = Pattern.compile("^.*?((\\(.*\\))?[0-9]+)(_[0-9]{1,6})?(\\..*)?$");
        PREFIXED_TASK_ID_REGEX = Pattern.compile("^(.*?\\(.*\\))?([0-9]+)$");
        PREFIXED_BUCKET_ID_REGEX = Pattern.compile("^(0*([0-9]+))_([0-9]+).*");
        INPUT_SUMMARY_LOCK = new Object();
        EMPTY_PATH = new Path[0];
    }

    private static final class PathOnlyFileStatus
    extends FileStatus {
        public PathOnlyFileStatus(Path path) {
            super(0L, true, 0, 0L, 0L, path);
        }
    }

    public static final class MissingBucketsContext {
        public final TableDesc tableInfo;
        public final int numBuckets;
        public final boolean isCompressed;

        public MissingBucketsContext(TableDesc tableInfo, int numBuckets, boolean isCompressed) {
            this.tableInfo = tableInfo;
            this.numBuckets = numBuckets;
            this.isCompressed = isCompressed;
        }
    }

    private static class GetInputPathsCallable
    implements Callable<Path> {
        private final Path path;
        private final JobConf job;
        private final MapWork work;
        private final Path hiveScratchDir;
        private final Context ctx;
        private final boolean skipDummy;

        private GetInputPathsCallable(Path path, JobConf job, MapWork work, Path hiveScratchDir, Context ctx, boolean skipDummy) {
            this.path = path;
            this.job = job;
            this.work = work;
            this.hiveScratchDir = hiveScratchDir;
            this.ctx = ctx;
            this.skipDummy = skipDummy;
        }

        @Override
        public Path call() throws Exception {
            if (!this.skipDummy && Utilities.isEmptyPath(this.job, this.path, this.ctx)) {
                return Utilities.createDummyFileForEmptyPartition(this.path, this.job, this.work.getPathToPartitionInfo().get(this.path), this.hiveScratchDir);
            }
            return this.path;
        }
    }

    public static class SQLCommand<T> {
        public T run(PreparedStatement stmt) throws SQLException {
            return null;
        }
    }

    static class TaskFilterFunction<T>
    implements DAGTraversal.Function {
        private Set<Task<? extends Serializable>> visited = new HashSet<Task<? extends Serializable>>();
        private Class<T> requiredType;
        private List<T> typeSpecificTasks = new ArrayList<T>();

        TaskFilterFunction(Class<T> requiredType) {
            this.requiredType = requiredType;
        }

        @Override
        public void process(Task<? extends Serializable> task) {
            if (this.requiredType.isInstance(task) && !this.typeSpecificTasks.contains(task)) {
                this.typeSpecificTasks.add(task);
            }
            this.visited.add(task);
        }

        List<T> getTasks() {
            return this.typeSpecificTasks;
        }

        @Override
        public boolean skipProcessing(Task<? extends Serializable> task) {
            return this.visited.contains(task);
        }
    }

    public static enum StreamStatus {
        EOF,
        TERMINATED;

    }

    public static class CollectionPersistenceDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", null);
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Iterator ite = ((Collection)oldInstance).iterator();
            while (ite.hasNext()) {
                out.writeStatement(new java.beans.Statement(oldInstance, "add", new Object[]{ite.next()}));
            }
        }
    }

    public static enum ReduceField {
        KEY,
        VALUE;

    }
}

